/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.displayejs;

import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.swing.ControlDrawable;
import org.colos.ejs.library.control.swing.ControlDrawablesParent;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.IntegerValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionEvent;
import org.opensourcephysics.displayejs.InteractionListener;
import org.opensourcephysics.displayejs.InteractionSource;
import org.opensourcephysics.displayejs.InteractionTarget;
import org.opensourcephysics.displayejs.Point3D;

public class ControlDrawingPanel3D
extends ControlDrawablesParent
implements InteractionListener {
    private static final int DP3D_ADDED = 37;
    public static final double TO_RAD = Math.PI / 180;
    protected static final int[] posIndexes = new int[]{9, 10, 11};
    protected static final int[] angleIndexes = new int[]{15, 16};
    protected static final int ZOOM_INDEX = 17;
    protected static final int[] panIndexes = new int[]{18, 19};
    private static final int KEY_INDEX = 31;
    protected DrawingPanel3D drawingPanel3D;
    protected boolean reportDrag = false;
    protected boolean reportViewPoint = false;
    protected double minZ;
    protected double maxZ;
    protected DoubleValue zoomValue;
    protected DoubleValue[] angleValues;
    protected IntegerValue[] panValues;
    protected DoubleValue[] posValues = new DoubleValue[]{new DoubleValue(0.0), new DoubleValue(0.0), new DoubleValue(0.0)};
    private IntegerValue keyPressedValue = new IntegerValue(-1);
    private static ArrayList infoList = null;
    private ControlDrawable selectedDrawable = null;
    private InteractionSource sourceLingered = null;

    protected Component createVisual() {
        this.drawingPanel3D = new DrawingPanel3D();
        this.minX = this.drawingPanel3D.getXMin();
        this.maxX = this.drawingPanel3D.getXMax();
        this.minY = this.drawingPanel3D.getYMin();
        this.maxY = this.drawingPanel3D.getYMax();
        this.minZ = this.drawingPanel3D.getZMin();
        this.maxZ = this.drawingPanel3D.getZMax();
        this.angleValues = new DoubleValue[2];
        this.angleValues[0] = new DoubleValue(this.drawingPanel3D.getAlpha());
        this.angleValues[1] = new DoubleValue(this.drawingPanel3D.getBeta());
        this.zoomValue = new DoubleValue(this.drawingPanel3D.getZoom());
        this.panValues = new IntegerValue[2];
        this.panValues[0] = new IntegerValue(this.drawingPanel3D.getPan().x);
        this.panValues[1] = new IntegerValue(this.drawingPanel3D.getPan().y);
        this.drawingPanel3D.setAllowQuickRedraw(true);
        this.drawingPanel3D.addListener(this);
        this.drawingPanel3D.setFocusable(true);
        this.drawingPanel3D.render();
        this.drawingPanel3D.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                ((ControlDrawingPanel3D)ControlDrawingPanel3D.this).keyPressedValue.value = keyEvent.getKeyCode();
                ControlDrawingPanel3D.this.variableChanged(31, ControlDrawingPanel3D.this.keyPressedValue);
                ControlDrawingPanel3D.this.invokeActions(30);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ((ControlDrawingPanel3D)ControlDrawingPanel3D.this).keyPressedValue.value = -1;
                ControlDrawingPanel3D.this.variableChanged(31, ControlDrawingPanel3D.this.keyPressedValue);
            }
        });
        return this.drawingPanel3D;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("autoscaleX");
            infoList.add("autoscaleY");
            infoList.add("autoscaleZ");
            infoList.add("minimumX");
            infoList.add("maximumX");
            infoList.add("minimumY");
            infoList.add("maximumY");
            infoList.add("minimumZ");
            infoList.add("maximumZ");
            infoList.add("x");
            infoList.add("y");
            infoList.add("z");
            infoList.add("pressaction");
            infoList.add("dragaction");
            infoList.add("action");
            infoList.add("alpha");
            infoList.add("beta");
            infoList.add("zoom");
            infoList.add("panx");
            infoList.add("pany");
            infoList.add("displayMode");
            infoList.add("decoration");
            infoList.add("square");
            infoList.add("cursorMode");
            infoList.add("showCoordinates");
            infoList.add("hideLines");
            infoList.add("quickRedraw");
            infoList.add("xFormat");
            infoList.add("yFormat");
            infoList.add("zFormat");
            infoList.add("keyAction");
            infoList.add("keyPressed");
            infoList.add("enteredAction");
            infoList.add("exitedAction");
            infoList.add("printTarget");
            infoList.add("colorDepth");
            infoList.add("axesLabels");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("angle")) {
            return "rotationAngle";
        }
        if (string.equals("displayMode")) {
            return "projectionMode";
        }
        if (string.equals("hideLines")) {
            return "removeHiddenLines";
        }
        if (string.equals("quickRedraw")) {
            return "allowQuickRedraw";
        }
        if (string.equals("colorDepth")) {
            return "useColorDepth";
        }
        if (string.equals("decoration")) {
            return "decorationType";
        }
        if (string.equals("cursorMode")) {
            return "cursorType";
        }
        if (string.equals("quickRedraw")) {
            return "allowQuickRedraw";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("autoscaleX")) {
            return "boolean DEPRECATED";
        }
        if (string.equals("autoscaleY")) {
            return "boolean";
        }
        if (string.equals("autoscaleZ")) {
            return "boolean";
        }
        if (string.equals("minimumX")) {
            return "int|double DEPRECATED";
        }
        if (string.equals("maximumX")) {
            return "int|double";
        }
        if (string.equals("minimumY")) {
            return "int|double";
        }
        if (string.equals("maximumY")) {
            return "int|double";
        }
        if (string.equals("minimumZ")) {
            return "int|double";
        }
        if (string.equals("maximumZ")) {
            return "int|double";
        }
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("z")) {
            return "int|double";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("dragaction")) {
            return "Action CONSTANT";
        }
        if (string.equals("alpha")) {
            return "int|double";
        }
        if (string.equals("beta")) {
            return "int|double";
        }
        if (string.equals("zoom")) {
            return "int|double";
        }
        if (string.equals("panx")) {
            return "int|double";
        }
        if (string.equals("pany")) {
            return "int|double";
        }
        if (string.equals("displayMode")) {
            return "int|DisplayMode";
        }
        if (string.equals("decoration")) {
            return "int|Decoration";
        }
        if (string.equals("square")) {
            return "boolean";
        }
        if (string.equals("cursorMode")) {
            return "int|CursorMode";
        }
        if (string.equals("showCoordinates")) {
            return "boolean";
        }
        if (string.equals("hideLines")) {
            return "boolean";
        }
        if (string.equals("quickRedraw")) {
            return "boolean";
        }
        if (string.equals("xFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("yFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("zFormat")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("keyAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("keyPressed")) {
            return "int";
        }
        if (string.equals("enteredAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("exitedAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("printTarget")) {
            return "String";
        }
        if (string.equals("colorDepth")) {
            return "boolean";
        }
        if (string.equals("axesLabels")) {
            return "String TRANSLATABLE";
        }
        if (string.equals("name")) {
            return "String DEPRECATED CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("x") || string.equals("y") || string.equals("z") || string.equals("dragaction")) {
            if (string2 != null) {
                Value value = Value.parseConstant(string2, true);
                if (!this.reportDrag) {
                    this.reportDrag = value == null;
                }
            }
        } else if ((string.equals("alpha") || string.equals("beta") || string.equals("zoom")) && string2 != null) {
            Value value = Value.parseConstant(string2, true);
            if (!this.reportViewPoint) {
                this.reportViewPoint = value == null;
            }
        }
        return super.setProperty(string, string2);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("DisplayMode") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("perspective")) {
                return new IntegerValue(10);
            }
            if (string2.equals("no_perspective")) {
                return new IntegerValue(12);
            }
            if (string2.equals("planar_xy")) {
                return new IntegerValue(0);
            }
            if (string2.equals("planar_xz")) {
                return new IntegerValue(1);
            }
            if (string2.equals("planar_yz")) {
                return new IntegerValue(2);
            }
        }
        if (string.indexOf("Decoration") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (string2.equals("cube")) {
                return new IntegerValue(2);
            }
            if (string2.equals("axes")) {
                return new IntegerValue(1);
            }
        }
        if (string.indexOf("CursorMode") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("none")) {
                return new IntegerValue(0);
            }
            if (string2.equals("cube")) {
                return new IntegerValue(2);
            }
            if (string2.equals("crosshair")) {
                return new IntegerValue(3);
            }
            if (string2.equals("xyz")) {
                return new IntegerValue(1);
            }
        }
        return super.parseConstant(string, string2);
    }

    private void setAxesLabels(String string) {
        String[] stringArray = new String[]{"X", "Y", "Z"};
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",;");
            if (stringTokenizer.hasMoreTokens()) {
                stringArray[0] = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringArray[1] = stringTokenizer.nextToken();
            }
            if (stringTokenizer.hasMoreTokens()) {
                stringArray[2] = stringTokenizer.nextToken();
            }
        }
        this.drawingPanel3D.setAxesLabels(stringArray);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (!value.getBoolean()) {
                    this.drawingPanel3D.setAutoscaleX(false);
                    this.drawingPanel3D.setPreferredMinMaxX(this.minX, this.maxX);
                    break;
                }
                this.drawingPanel3D.setAutoscaleX(true);
                break;
            }
            case 1: {
                if (!value.getBoolean()) {
                    this.drawingPanel3D.setAutoscaleY(false);
                    this.drawingPanel3D.setPreferredMinMaxY(this.minY, this.maxY);
                    break;
                }
                this.drawingPanel3D.setAutoscaleY(true);
                break;
            }
            case 2: {
                if (!value.getBoolean()) {
                    this.drawingPanel3D.setAutoscaleZ(false);
                    this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, this.maxZ);
                    break;
                }
                this.drawingPanel3D.setAutoscaleZ(true);
                break;
            }
            case 3: {
                if (value.getDouble() == this.minX) break;
                this.minX = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxX(this.minX, this.maxX);
                break;
            }
            case 4: {
                if (value.getDouble() == this.maxX) break;
                this.maxX = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxX(this.minX, this.maxX);
                break;
            }
            case 5: {
                if (value.getDouble() == this.minY) break;
                this.minY = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxY(this.minY, this.maxY);
                break;
            }
            case 6: {
                if (value.getDouble() == this.maxY) break;
                this.maxY = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxY(this.minY, this.maxY);
                break;
            }
            case 7: {
                if (value.getDouble() == this.minZ) break;
                this.minZ = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, this.maxZ);
                break;
            }
            case 8: {
                if (value.getDouble() == this.maxZ) break;
                this.maxZ = value.getDouble();
                this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, this.maxZ);
                break;
            }
            case 9: {
                this.posValues[0].value = value.getDouble();
                break;
            }
            case 10: {
                this.posValues[1].value = value.getDouble();
                break;
            }
            case 11: {
                this.posValues[2].value = value.getDouble();
                break;
            }
            case 12: {
                this.removeAction(10, this.getProperty("pressaction"));
                this.addAction(10, value.getString());
                break;
            }
            case 13: {
                this.removeAction(1, this.getProperty("dragaction"));
                this.addAction(1, value.getString());
                break;
            }
            case 14: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 15: {
                double d = value instanceof IntegerValue ? (double)value.getInteger() * (Math.PI / 180) : value.getDouble();
                if (d == this.angleValues[0].value) break;
                this.angleValues[0].value = d;
                this.drawingPanel3D.setAlpha(this.angleValues[0].value);
                break;
            }
            case 16: {
                double d = value instanceof IntegerValue ? (double)value.getInteger() * (Math.PI / 180) : value.getDouble();
                if (d == this.angleValues[1].value) break;
                this.angleValues[1].value = d;
                this.drawingPanel3D.setBeta(this.angleValues[1].value);
                break;
            }
            case 17: {
                if (value.getDouble() == this.zoomValue.value) break;
                this.zoomValue.value = value.getDouble();
                this.drawingPanel3D.setZoom(this.zoomValue.value);
                break;
            }
            case 18: {
                if (value.getInteger() == this.panValues[0].value) break;
                this.panValues[0].value = value.getInteger();
                this.drawingPanel3D.setPan(this.panValues[0].value, this.panValues[1].value);
                break;
            }
            case 19: {
                if (value.getInteger() == this.panValues[1].value) break;
                this.panValues[1].value = value.getInteger();
                this.drawingPanel3D.setPan(this.panValues[0].value, this.panValues[1].value);
                break;
            }
            case 20: {
                if (value.getInteger() == this.drawingPanel3D.getDisplayMode()) break;
                this.drawingPanel3D.setDisplayMode(value.getInteger());
                break;
            }
            case 21: {
                if (value.getInteger() == this.drawingPanel3D.getDecorationType()) break;
                this.drawingPanel3D.setDecorationType(value.getInteger());
                break;
            }
            case 22: {
                if (value.getBoolean() == this.drawingPanel3D.isSquareAspect()) break;
                this.drawingPanel3D.setSquareAspect(value.getBoolean());
                break;
            }
            case 23: {
                if (value.getInteger() == this.drawingPanel3D.getCursorMode()) break;
                this.drawingPanel3D.setCursorMode(value.getInteger());
                break;
            }
            case 24: {
                this.drawingPanel3D.setShowCoordinates(value.getBoolean());
                break;
            }
            case 25: {
                this.drawingPanel3D.setRemoveHiddenLines(value.getBoolean());
                break;
            }
            case 26: {
                this.drawingPanel3D.setAllowQuickRedraw(value.getBoolean());
                break;
            }
            case 27: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.drawingPanel3D.setXFormat((DecimalFormat)value.getObject());
                    break;
                }
                this.drawingPanel3D.setXFormat((DecimalFormat)ConstantParser.formatConstant(value.getString()).getObject());
                break;
            }
            case 28: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.drawingPanel3D.setYFormat((DecimalFormat)value.getObject());
                    break;
                }
                this.drawingPanel3D.setYFormat((DecimalFormat)ConstantParser.formatConstant(value.getString()).getObject());
                break;
            }
            case 29: {
                if (value.getObject() instanceof DecimalFormat) {
                    this.drawingPanel3D.setZFormat((DecimalFormat)value.getObject());
                    break;
                }
                this.drawingPanel3D.setZFormat((DecimalFormat)ConstantParser.formatConstant(value.getString()).getObject());
                break;
            }
            case 30: {
                this.removeAction(30, this.getProperty("keyAction"));
                this.addAction(30, value.getString());
                break;
            }
            case 31: {
                this.keyPressedValue.value = value.getInteger();
                break;
            }
            case 32: {
                this.removeAction(31, this.getProperty("enteredAction"));
                this.addAction(31, value.getString());
                break;
            }
            case 33: {
                this.removeAction(32, this.getProperty("exitedAction"));
                this.addAction(32, value.getString());
                break;
            }
            case 34: {
                this.setPrintTarget(value.getString());
                break;
            }
            case 35: {
                this.drawingPanel3D.setUseColorDepth(value.getBoolean());
                break;
            }
            case 36: {
                this.setAxesLabels(value.toString());
                break;
            }
            default: {
                super.setValue(n - 37, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.drawingPanel3D.setAutoscaleX(false);
                this.drawingPanel3D.setPreferredMinMaxX(this.minX, this.maxX);
                break;
            }
            case 1: {
                this.drawingPanel3D.setAutoscaleY(false);
                this.drawingPanel3D.setPreferredMinMaxY(this.minY, this.maxY);
                break;
            }
            case 2: {
                this.drawingPanel3D.setAutoscaleZ(false);
                this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, this.maxZ);
                break;
            }
            case 3: {
                this.minX = 0.0;
                this.drawingPanel3D.setPreferredMinMaxX(0.0, this.maxX);
                break;
            }
            case 4: {
                this.maxX = 1.0;
                this.drawingPanel3D.setPreferredMinMaxX(this.minX, 1.0);
                break;
            }
            case 5: {
                this.minY = 0.0;
                this.drawingPanel3D.setPreferredMinMaxY(0.0, this.maxY);
                break;
            }
            case 6: {
                this.maxY = 1.0;
                this.drawingPanel3D.setPreferredMinMaxY(this.minY, 1.0);
                break;
            }
            case 7: {
                this.minZ = 0.0;
                this.drawingPanel3D.setPreferredMinMaxZ(0.0, this.maxZ);
                break;
            }
            case 8: {
                this.maxZ = 1.0;
                this.drawingPanel3D.setPreferredMinMaxZ(this.minZ, 1.0);
                break;
            }
            case 9: {
                this.posValues[0].value = (this.minX + this.maxX) / 2.0;
                break;
            }
            case 10: {
                this.posValues[1].value = (this.minY + this.maxY) / 2.0;
                break;
            }
            case 11: {
                this.posValues[2].value = (this.minZ + this.maxZ) / 2.0;
                break;
            }
            case 12: {
                this.removeAction(10, this.getProperty("pressaction"));
                break;
            }
            case 13: {
                this.removeAction(1, this.getProperty("dragaction"));
                break;
            }
            case 14: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 15: {
                this.angleValues[0].value = 0.0;
                this.drawingPanel3D.setAlpha(0.0);
                break;
            }
            case 16: {
                this.angleValues[1].value = 0.0;
                this.drawingPanel3D.setBeta(0.0);
                break;
            }
            case 17: {
                this.zoomValue.value = 1.0;
                this.drawingPanel3D.setZoom(1.0);
                break;
            }
            case 18: {
                this.panValues[0].value = 0;
                this.drawingPanel3D.setPan(0, this.panValues[1].value);
                break;
            }
            case 19: {
                this.panValues[1].value = 0;
                this.drawingPanel3D.setPan(this.panValues[0].value, 0);
                break;
            }
            case 20: {
                this.drawingPanel3D.setDisplayMode(10);
                break;
            }
            case 21: {
                this.drawingPanel3D.setDecorationType(2);
                break;
            }
            case 22: {
                this.drawingPanel3D.setSquareAspect(true);
                break;
            }
            case 23: {
                this.drawingPanel3D.setCursorMode(3);
                break;
            }
            case 24: {
                this.drawingPanel3D.setShowCoordinates(true);
                break;
            }
            case 25: {
                this.drawingPanel3D.setRemoveHiddenLines(true);
                break;
            }
            case 26: {
                this.drawingPanel3D.setAllowQuickRedraw(true);
                break;
            }
            case 27: {
                this.drawingPanel3D.setXFormat(new DecimalFormat("x=0.000;x=-0.000"));
                break;
            }
            case 28: {
                this.drawingPanel3D.setYFormat(new DecimalFormat("y=0.000;y=-0.000"));
                break;
            }
            case 29: {
                this.drawingPanel3D.setZFormat(new DecimalFormat("z=0.000;z=-0.000"));
                break;
            }
            case 30: {
                this.removeAction(30, this.getProperty("keyAction"));
                break;
            }
            case 31: {
                this.keyPressedValue.value = -1;
                break;
            }
            case 32: {
                this.removeAction(31, this.getProperty("enteredAction"));
                break;
            }
            case 33: {
                this.removeAction(32, this.getProperty("exitedAction"));
                break;
            }
            case 34: {
                this.setPrintTarget(null);
                break;
            }
            case 35: {
                this.drawingPanel3D.setUseColorDepth(true);
                break;
            }
            case 36: {
                this.setAxesLabels(null);
                break;
            }
            default: {
                super.setDefaultValue(n - 37);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 14: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                return null;
            }
            case 9: {
                return this.posValues[0];
            }
            case 10: {
                return this.posValues[1];
            }
            case 11: {
                return this.posValues[2];
            }
            case 15: {
                return this.angleValues[0];
            }
            case 16: {
                return this.angleValues[1];
            }
            case 17: {
                return this.zoomValue;
            }
            case 18: {
                return this.panValues[0];
            }
            case 19: {
                return this.panValues[1];
            }
            case 31: {
                return this.keyPressedValue;
            }
        }
        return super.getValue(n - 37);
    }

    public ControlDrawable getSelectedDrawable() {
        return this.selectedDrawable;
    }

    public void setSelectedDrawable(ControlDrawable controlDrawable) {
        this.selectedDrawable = controlDrawable;
    }

    public void interactionPerformed(InteractionEvent interactionEvent) {
        if (interactionEvent.getTarget() == null) {
            if (interactionEvent.getID() == 2003) {
                this.invokeActions(31);
            } else if (interactionEvent.getID() == 2004) {
                this.invokeActions(32);
                if (this.sourceLingered != null) {
                    this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                }
                this.sourceLingered = null;
            } else if (interactionEvent.getID() == 2005) {
                Interactive interactive = this.drawingPanel3D.getInteractive();
                if (interactive != null) {
                    if (interactive instanceof InteractionTarget && this.sourceLingered != ((InteractionTarget)interactive).getSource()) {
                        if (this.sourceLingered != null) {
                            this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                        }
                        this.sourceLingered = ((InteractionTarget)interactive).getSource();
                        this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2003, null, interactive));
                    }
                } else {
                    if (this.sourceLingered != null) {
                        this.sourceLingered.invokeActions(new InteractionEvent((Object)this.sourceLingered, 2004, null, this.sourceLingered));
                    }
                    this.sourceLingered = null;
                }
            } else if (interactionEvent.getID() == 2000) {
                this.invokeActions(10);
            } else if (interactionEvent.getID() == 2002) {
                this.invokeActions(0);
            } else if (interactionEvent.getID() == 2001) {
                if (this.angleValues[0].value != this.drawingPanel3D.getAlpha() || this.angleValues[1].value != this.drawingPanel3D.getBeta()) {
                    this.angleValues[0].value = this.drawingPanel3D.getAlpha();
                    this.angleValues[1].value = this.drawingPanel3D.getBeta();
                    if (this.reportViewPoint) {
                        this.variablesChanged(angleIndexes, this.angleValues);
                    }
                    if (this.isUnderEjs) {
                        this.setFieldListValues(angleIndexes, this.angleValues);
                    }
                }
                if (this.zoomValue.value != this.drawingPanel3D.getZoom()) {
                    this.zoomValue.value = this.drawingPanel3D.getZoom();
                    if (this.reportViewPoint) {
                        this.variableChanged(17, this.zoomValue);
                    }
                    if (this.isUnderEjs) {
                        this.setFieldListValue(17, this.zoomValue);
                    }
                }
                if (this.panValues[0].value != this.drawingPanel3D.getPan().x || this.panValues[1].value != this.drawingPanel3D.getPan().y) {
                    this.panValues[0].value = this.drawingPanel3D.getPan().x;
                    this.panValues[1].value = this.drawingPanel3D.getPan().y;
                    if (this.reportViewPoint) {
                        this.variablesChanged(panIndexes, this.panValues);
                    }
                    if (this.isUnderEjs) {
                        this.setFieldListValues(panIndexes, this.panValues);
                    }
                }
            }
            return;
        }
        if (!(interactionEvent.getTarget() instanceof Point3D)) {
            return;
        }
        Point3D point3D = (Point3D)interactionEvent.getTarget();
        switch (interactionEvent.getID()) {
            case 2000: {
                this.drawingPanel3D.requestFocus();
                this.invokeActions(10);
            }
            case 2001: {
                this.posValues[0].value = point3D.x;
                this.posValues[1].value = point3D.y;
                this.posValues[2].value = point3D.z;
                if (this.reportDrag) {
                    this.variablesChanged(posIndexes, this.posValues);
                }
                if (!this.isUnderEjs) break;
                this.setFieldListValues(posIndexes, this.posValues);
                break;
            }
            case 2002: {
                this.invokeActions(0);
            }
        }
    }
}

