/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control;

import java.awt.Color;
import java.awt.Font;
import java.awt.Rectangle;
import java.text.DecimalFormat;
import java.util.StringTokenizer;
import org.colos.ejs.library.control.ConstantParserUtil;
import org.colos.ejs.library.control.value.BooleanValue;
import org.colos.ejs.library.control.value.ObjectValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.GUIUtils;

public class ConstantParser {
    public static Value fontConstant(Font font, String string) {
        Font font2 = ConstantParserUtil.fontConstant(font, string);
        if (font2 == null) {
            return null;
        }
        return new ObjectValue(font2);
    }

    public static Value booleanConstant(String string) {
        if (string.equals("true")) {
            return new BooleanValue(true);
        }
        if (string.equals("false")) {
            return new BooleanValue(false);
        }
        return null;
    }

    public static Value colorConstant(String string) {
        Color color = ConstantParserUtil.colorConstant(string);
        if (color == null) {
            return null;
        }
        return new ObjectValue(color);
    }

    public static Value formatConstant(String string) {
        if (string == null || "null".equals(string)) {
            return new ObjectValue(null);
        }
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        if ((string = GUIUtils.parseTeX(string)).indexOf(";") == -1) {
            int n = string.indexOf("0");
            int n2 = string.indexOf("#");
            int n3 = -1;
            if (n > 0 && n2 > 0) {
                n3 = n < n2 ? n : n2;
            } else if (n > 0) {
                n3 = n;
            } else if (n2 > 0) {
                n3 = n2;
            }
            if (n3 > 0) {
                string = String.valueOf(string) + ";" + string.substring(0, n3) + "-" + string.substring(n3);
            }
        }
        try {
            return new ObjectValue(new DecimalFormat(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Value rectangleConstant(String string) {
        if (string.indexOf(44) < 0) {
            return null;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            int n = Integer.parseInt(stringTokenizer.nextToken());
            int n2 = Integer.parseInt(stringTokenizer.nextToken());
            int n3 = 0;
            int n4 = 0;
            if (stringTokenizer.hasMoreTokens()) {
                n3 = Integer.parseInt(stringTokenizer.nextToken());
            }
            if (stringTokenizer.hasMoreTokens()) {
                n4 = Integer.parseInt(stringTokenizer.nextToken());
            }
            return new ObjectValue(new Rectangle(n, n2, n3, n4));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

