/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.LineNumberReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.text.DecimalFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.filechooser.FileSystemView;
import javax.swing.text.JTextComponent;
import org.colos.ejs.library.Animation;
import org.colos.ejs.library.EmersionLink;
import org.colos.ejs.library.Experiment;
import org.colos.ejs.library.Input;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.control.ControlElement;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.MethodWithOneParameter;
import org.colos.ejs.library.control.SpecialRender;
import org.colos.ejs.library.utils.GIFEncoder;
import org.opensourcephysics.controls.OSPLog;
import org.opensourcephysics.controls.XMLControlElement;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.display.PrintUtils;
import org.opensourcephysics.display.dialogs.DialogsRes;
import org.opensourcephysics.media.core.VideoGrabber;
import org.opensourcephysics.tools.EjsTool;
import org.opensourcephysics.tools.FontSizer;
import org.opensourcephysics.tools.Resource;
import org.opensourcephysics.tools.ResourceLoader;
import org.opensourcephysics.tools.SnapshotTool;
import org.opensourcephysics.tools.ToolsRes;
import org.opensourcephysics.tools.TranslatorTool;
import org.opensourcephysics.tools.VideoCaptureTool;

public abstract class Simulation
extends Animation {
    static ResourceBundle launcherRes = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.launcher", Locale.getDefault());
    static ResourceBundle ejsRes = ResourceBundle.getBundle("org.opensourcephysics.resources.ejs.ejs_res", Locale.getDefault());
    private static String pathToLibrary = "";
    private static AWTEventListener focusListener = null;
    private static ArrayList resourcesExtracted = new ArrayList();
    private static String homeDir = null;
    private static String userDir = null;
    private boolean isUnderEjs = false;
    private Component parentComponent = null;
    private String parentComponentName = null;
    private URL codebase = null;
    private ArrayList<String> stateVariablesList = null;
    private String resetFile = null;
    protected VideoCaptureTool videoTool = null;
    protected Component videoComponent;
    protected BufferedImage videoImage = null;
    protected SpecialRender videoSpecialRender = null;
    private JFrame descriptionDialog = null;
    private JTabbedPane descriptionPanel = null;
    private static final String dummy = "";
    private static final Class strClass = "".getClass();
    private static Hashtable memory = new Hashtable();
    private EmersionLink eMersion = null;
    private MethodWithOneParameter _init_ = null;
    private LauncherApplet javascriptControledApplet = null;
    private JPopupMenu popupMenu = null;
    private JMenu langMenu = null;
    private JMenu elementsMenu = null;
    private AbstractList popupMenuExtraEntries = null;
    private Component popupTriggeredBy = null;
    private Experiment currentExperiment = null;

    public static String getEjsString(String string) {
        return ejsRes.getString(string);
    }

    public static String getPathToLibrary() {
        return pathToLibrary;
    }

    public static void setPathToLibrary(String string) {
        try {
            File file = new File(String.valueOf(string) + "_library");
            if (file.exists() && file.isDirectory()) {
                pathToLibrary = string;
            }
        }
        catch (Exception exception) {}
    }

    public static String getUserDir() {
        if (userDir == null) {
            try {
                userDir = System.getProperty("user.dir").replace('\\', '/');
                if (!userDir.endsWith("/")) {
                    userDir = String.valueOf(userDir) + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return userDir;
    }

    public static String getHomeDir() {
        if (homeDir == null) {
            try {
                homeDir = System.getProperty("user.home").replace('\\', '/');
                if (!homeDir.endsWith("/")) {
                    homeDir = String.valueOf(homeDir) + "/";
                }
            }
            catch (Exception exception) {
                return dummy;
            }
        }
        return homeDir;
    }

    public static String getTemporaryDir() {
        try {
            return String.valueOf(Simulation.getHomeDir()) + "Ejs.tmp/";
        }
        catch (Exception exception) {
            return dummy;
        }
    }

    public static File requiresResourceFile(String string) {
        return Simulation.requiresResourceFile(string, string);
    }

    public static File requiresResourceFile(String string, String string2) {
        File file = null;
        Resource resource = ResourceLoader.getResource(string);
        if (resource != null) {
            file = resource.getFile();
        }
        if (file != null && file.exists()) {
            return file;
        }
        return Simulation.extractResource(string, String.valueOf(Simulation.getTemporaryDir()) + string2);
    }

    public static File extractResource(String string, String string2) {
        File file = new File(string2);
        try {
            int n;
            InputStream inputStream = ResourceLoader.openInputStream(string);
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            while ((n = bufferedInputStream.read()) != -1) {
                fileOutputStream.write(n);
            }
            bufferedInputStream.close();
            fileOutputStream.close();
            resourcesExtracted.add(file);
            System.out.println("Ejs simulation: resource " + string + " extracted into " + string2);
            return file;
        }
        catch (Exception exception) {
            System.out.println("Ejs simulation: resource " + string + " could NOT be extracted into " + string2);
            exception.printStackTrace();
            return null;
        }
    }

    private static void cleanExtractedResources() {
        if (resourcesExtracted.size() <= 0) {
            return;
        }
        System.out.println("Ejs simulation: Cleaning extracted files.");
        for (File file : resourcesExtracted) {
            System.out.println("Ejs simulation: wants to delete " + file.getPath());
            if (!file.exists()) continue;
            System.out.println("Ejs simulation: Removing extracted resource " + file.getPath());
            file.delete();
        }
        resourcesExtracted.clear();
        Simulation.removeEmptyDirs(new File(Simulation.getTemporaryDir()), true);
    }

    public static void removeEmptyDirs(File file, boolean bl) {
        if (!file.isDirectory() || !file.exists()) {
            return;
        }
        FileSystemView fileSystemView = FileSystemView.getFileSystemView();
        if (bl) {
            Simulation.recursiveRemoveEmptyDirs(file, fileSystemView);
        } else {
            File[] fileArray = fileSystemView.getFiles(file, false);
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isDirectory()) {
                    Simulation.recursiveRemoveEmptyDirs(fileArray[n], fileSystemView);
                }
                ++n;
            }
        }
    }

    private static void recursiveRemoveEmptyDirs(File file, FileSystemView fileSystemView) {
        File[] fileArray = fileSystemView.getFiles(file, false);
        if (fileArray.length == 0) {
            file.delete();
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n].isDirectory()) {
                Simulation.recursiveRemoveEmptyDirs(fileArray[n], fileSystemView);
            }
            ++n;
        }
        fileArray = fileSystemView.getFiles(file, false);
        if (fileArray.length == 0) {
            file.delete();
        }
    }

    protected void userDefinedReset() {
        if (this.resetFile != null) {
            this.justReadVariables(this.resetFile, null, this.stateVariablesList);
        }
    }

    protected void userDefinedViewUpdate() {
        if (this.videoImage != null) {
            this.captureVideoImage();
        }
    }

    private String getClassname() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private String getModelClassname() {
        String string = this.model.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    private void errorMessage(String string) {
        System.err.println(String.valueOf(this.getClassname()) + ": " + string);
    }

    private void errorMessage(Exception exception) {
        System.err.println(String.valueOf(this.getClassname()) + ": Exception caught! Text follows:");
        exception.printStackTrace(System.err);
    }

    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    public void setParentComponent(String string) {
        this.parentComponentName = string;
        this.parentComponent = null;
    }

    public Component getParentComponent() {
        if (this.parentComponent == null && this.view != null) {
            this.parentComponent = this.view.getComponent(this.parentComponentName);
        }
        return this.parentComponent;
    }

    public void setCodebase(URL uRL) {
        this.codebase = uRL;
    }

    public URL getCodebase() {
        return this.codebase;
    }

    public void translate() {
        TranslatorTool translatorTool = TranslatorTool.getTool();
        translatorTool.showProperties(this.model.getClass());
        translatorTool.setKeepHidden(false);
        translatorTool.setVisible(true);
    }

    public String translateString(String string, String string2) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return TranslatorTool.getTool().getProperty(this.model.getClass(), string, string2);
    }

    public String translateString(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            string = string.substring(1, string.length() - 1);
        }
        return TranslatorTool.getTool().getProperty(this.model.getClass(), string);
    }

    public void setLocale(String string) {
        Locale locale = new Locale(string);
        TranslatorTool.getTool().setLocale(locale);
        ToolsRes.setLocale(locale);
        DisplayRes.setLocale(locale);
        DialogsRes.setLocale(locale);
        launcherRes = ResourceBundle.getBundle("org.opensourcephysics.resources.tools.launcher", locale);
        ejsRes = ResourceBundle.getBundle("org.opensourcephysics.resources.ejs.ejs_res", locale);
        this.setViewLocale();
        this.popupMenu = null;
    }

    protected void setViewLocale() {
        this.elementsMenu = null;
        this.popupMenuExtraEntries = null;
        if (this.view instanceof EjsControl) {
            ((EjsControl)((Object)this.view)).addElementsMenuEntries();
        }
    }

    public void onExit() {
        Simulation.cleanExtractedResources();
        super.onExit();
    }

    public void addDescriptionPage(String string, String string2) {
        Object object;
        Object object2;
        if (this.isUnderEjs) {
            return;
        }
        if (this.descriptionDialog == null) {
            object2 = String.valueOf(Input.getResource("DescriptionFor")) + " " + this.getModelClassname();
            ((EjsControl)((Object)this.view)).getOwnerFrame();
            this.descriptionDialog = new JFrame((String)object2);
            this.descriptionPanel = new JTabbedPane();
            this.descriptionPanel.setPreferredSize(new Dimension(570, 410));
            this.descriptionDialog.getContentPane().add((Component)this.descriptionPanel, "Center");
            this.descriptionDialog.pack();
            object = Toolkit.getDefaultToolkit().getScreenSize();
            this.descriptionDialog.setLocation((((Dimension)object).width - this.descriptionDialog.getSize().width) / 2, (((Dimension)object).height - this.descriptionDialog.getSize().height) / 2);
        }
        object2 = new JEditorPane();
        ((JTextComponent)object2).setEditable(false);
        object = ResourceLoader.getResource(string2);
        if (object != null) {
            try {
                ((JEditorPane)object2).setPage(((Resource)object).getURL());
                JScrollPane jScrollPane = new JScrollPane((Component)object2);
                this.descriptionPanel.add(string, jScrollPane);
            }
            catch (IOException iOException) {
                System.err.println("Attempted to read a bad URL: " + ((Resource)object).getURL());
            }
        } else {
            System.err.println("Couldn't find description file: " + string2);
        }
    }

    public void showDescription() {
        if (this.descriptionDialog != null) {
            this.descriptionDialog.setVisible(true);
        }
    }

    public String getVariable(String string) {
        return this.getVariable(string, ",");
    }

    public String getVariable(String string, String string2) {
        if (this.model == null) {
            return null;
        }
        try {
            Field field = this.model.getClass().getField(string);
            if (field.getType().isArray()) {
                String string3 = dummy;
                Object object = field.get(this.model);
                int n = Array.getLength(object);
                int n2 = 0;
                while (n2 < n) {
                    string3 = n2 > 0 ? String.valueOf(string3) + string2 + Array.get(object, n2).toString() : String.valueOf(string3) + Array.get(object, n2).toString();
                    ++n2;
                }
                return string3;
            }
            return field.get(this.model).toString();
        }
        catch (Exception exception) {
            this.errorMessage(exception);
            return null;
        }
    }

    public boolean setVariable(String string, String string2) {
        return this.setVariable(string, string2, ",");
    }

    public boolean setVariable(String string, String string2, String string3) {
        if (this.model == null) {
            return false;
        }
        try {
            Field field = this.model.getClass().getField(string);
            if (field.getType().isArray()) {
                boolean bl = true;
                Object object = field.get(this.model);
                int n = 0;
                int n2 = Array.getLength(object);
                Class<?> clazz = field.getType().getComponentType();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
                if (n2 < stringTokenizer.countTokens()) {
                    this.errorMessage("Warning: there are less elements in the array than values provided!");
                } else if (n2 > stringTokenizer.countTokens()) {
                    this.errorMessage("Warning: there are more elements in the array than values provided!");
                }
                while (stringTokenizer.hasMoreTokens() && n < n2) {
                    String string4 = stringTokenizer.nextToken();
                    if (clazz.equals(Double.TYPE)) {
                        Array.setDouble(object, n, Double.parseDouble(string4));
                    } else if (clazz.equals(Float.TYPE)) {
                        Array.setFloat(object, n, Float.parseFloat(string4));
                    } else if (clazz.equals(Byte.TYPE)) {
                        Array.setByte(object, n, Byte.parseByte(string4));
                    } else if (clazz.equals(Short.TYPE)) {
                        Array.setShort(object, n, Short.parseShort(string4));
                    } else if (clazz.equals(Integer.TYPE)) {
                        Array.setInt(object, n, Integer.parseInt(string4));
                    } else if (clazz.equals(Long.TYPE)) {
                        Array.setLong(object, n, Long.parseLong(string4));
                    } else if (clazz.equals(Boolean.TYPE)) {
                        if (string4.trim().toLowerCase().equals("true")) {
                            Array.setBoolean(object, n, true);
                        } else {
                            Array.setBoolean(object, n, false);
                        }
                    } else if (clazz.equals(Character.TYPE)) {
                        Array.setChar(object, n, string4.charAt(0));
                    } else if (clazz.equals(strClass)) {
                        Array.set(object, n, string4);
                    } else {
                        bl = false;
                    }
                    ++n;
                }
                return bl;
            }
            Class<?> clazz = field.getType();
            if (clazz.equals(Double.TYPE)) {
                field.setDouble(this.model, Double.parseDouble(string2));
            } else if (clazz.equals(Float.TYPE)) {
                field.setFloat(this.model, Float.parseFloat(string2));
            } else if (clazz.equals(Byte.TYPE)) {
                field.setByte(this.model, Byte.parseByte(string2));
            } else if (clazz.equals(Short.TYPE)) {
                field.setShort(this.model, Short.parseShort(string2));
            } else if (clazz.equals(Integer.TYPE)) {
                field.setInt(this.model, Integer.parseInt(string2));
            } else if (clazz.equals(Long.TYPE)) {
                field.setLong(this.model, Long.parseLong(string2));
            } else if (clazz.equals(Boolean.TYPE)) {
                if (string2.trim().toLowerCase().equals("true")) {
                    field.setBoolean(this.model, true);
                } else {
                    field.setBoolean(this.model, false);
                }
            } else if (clazz.equals(Character.TYPE)) {
                field.setChar(this.model, string2.charAt(0));
            } else if (clazz.equals(strClass)) {
                field.set(this.model, string2);
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage(exception);
            return false;
        }
    }

    public boolean setVariables(String string) {
        return this.setVariables(string, ";", ",");
    }

    public boolean setVariables(String string, String string2, String string3) {
        boolean bl = true;
        String string4 = dummy;
        String string5 = dummy;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string6 = stringTokenizer.nextToken();
            int n = string6.indexOf(61);
            if (n < 0) {
                bl = false;
                continue;
            }
            string4 = string6.substring(0, n).trim();
            boolean bl2 = this.setVariable(string4, string5 = string6.substring(n + 1).trim(), string3);
            if (bl2) continue;
            bl = false;
        }
        this.update();
        return bl;
    }

    public void initEmersion() {
        LauncherApplet launcherApplet = this.model._getApplet();
        if (launcherApplet == null) {
            return;
        }
        try {
            String string = launcherApplet.getParameter("init");
            if (string != null) {
                this._init_ = new MethodWithOneParameter(0, launcherApplet._model, string, null, null, launcherApplet);
                this._init_.invoke(0, launcherApplet);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (launcherApplet.getParameter("eMersionURL") == null) {
            return;
        }
        this.eMersion = new EmersionLink(launcherApplet, this);
    }

    public boolean isEmersionConnected() {
        if (this.eMersion == null) {
            return false;
        }
        return this.eMersion.isConnected();
    }

    private boolean javascriptControlMode() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isImageFormatSupported(String string) {
        try {
            String[] stringArray = ImageIO.getWriterFormatNames();
            int n = 0;
            while (true) {
                if (n >= stringArray.length) {
                    return false;
                }
                if (stringArray[n].equalsIgnoreCase(string)) {
                    return true;
                }
                ++n;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected void setUnderEjs(boolean bl) {
        this.isUnderEjs = bl;
    }

    public AbstractList getExperiments() {
        return null;
    }

    public Experiment createExperiment(String string) {
        return null;
    }

    public void runExperiment(Experiment experiment) {
        if (experiment == null) {
            return;
        }
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = experiment;
        experiment._runExperiment();
    }

    public void runExperiment(String string) {
        this.runExperiment(this.createExperiment(string));
    }

    public void killExperiment() {
        if (this.currentExperiment != null) {
            this.currentExperiment._abortExperiment();
        }
        this.currentExperiment = null;
    }

    public void addMenuEntries(AbstractList abstractList) {
        if (this.popupMenuExtraEntries == null) {
            this.popupMenuExtraEntries = new ArrayList();
        }
        this.popupMenuExtraEntries.addAll(abstractList);
        this.popupMenu = null;
    }

    public void addElementMenuEntries(String string, AbstractList abstractList) {
        Serializable serializable;
        if (this.elementsMenu == null) {
            this.elementsMenu = new JMenu(this.getMenuText("ejs_res:MenuItem.Elements"));
            serializable = new ArrayList();
            ((ArrayList)serializable).add(this.elementsMenu);
            this.addMenuEntries((AbstractList)((Object)serializable));
        }
        serializable = new JMenu(string);
        Iterator iterator = abstractList.iterator();
        while (iterator.hasNext()) {
            this.addMenuItem((JComponent)serializable, iterator.next());
        }
        this.addMenuItem(this.elementsMenu, serializable);
    }

    public Component getTopLevelComponent(Component component) {
        Component component2 = component;
        while (component2.getParent() != null) {
            component2 = component2.getParent();
        }
        return component2;
    }

    public void getPopupMenu(Component component, String string) {
        this.getPopupMenu(component, -1, -1, string);
    }

    public void getPopupMenu(final Component component, int n, int n2, final String string) {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2 = bl = this.model._getApplet() != null;
        if (this.popupMenu == null) {
            Object object3;
            boolean bl3 = true;
            try {
                System.getProperty("user.home");
            }
            catch (Exception exception) {
                bl3 = false;
            }
            this.popupMenu = new JPopupMenu();
            object2 = this.getExperiments();
            if (object2 != null) {
                object3 = new JMenu(this.getMenuText("tools_res:MenuItem.Experiments"));
                object = ((AbstractList)object2).iterator();
                while (object.hasNext()) {
                    final Experiment experiment = (Experiment)object.next();
                    String string2 = this.translateString(experiment._getName());
                    String string3 = this.translateString(experiment._getDescription());
                    AbstractAction abstractAction = new AbstractAction(string2){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Simulation.this.runExperiment(experiment);
                        }
                    };
                    abstractAction.putValue("ShortDescription", string3);
                    ((JMenu)object3).add(abstractAction);
                }
                this.popupMenu.add((JMenuItem)object3);
                object = new JMenuItem(this.getMenuText("tools_res:MenuItem.KillExperiment"));
                ((AbstractButton)object).addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.killExperiment();
                    }
                });
                this.popupMenu.add((JMenuItem)object);
                this.popupMenu.addSeparator();
            }
            if (this.popupMenuExtraEntries != null && this.popupMenuExtraEntries.size() > 0) {
                object3 = this.popupMenuExtraEntries.iterator();
                while (object3.hasNext()) {
                    this.addMenuItem(this.popupMenu, object3.next());
                }
                this.popupMenu.addSeparator();
            }
            if (bl3) {
                object3 = new JMenu(this.getMenuText("ejs_res:MenuItem.SnapshotTools"));
                ((JMenu)object3).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Snapshot")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = Simulation.this.isPlaying();
                        if (bl) {
                            Simulation.this.pause();
                        }
                        Simulation.this.saveImageAs(string);
                        if (bl) {
                            Simulation.this.play();
                        }
                    }
                });
                ((JMenu)object3).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshot")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            PrintUtils.saveComponentAsEPS(Simulation.this.getTopLevelComponent(component));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                });
                ((JMenu)object3).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.TakeEPSSnapshotWindow")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        focusListener = new AWTEventListener(){

                            public void eventDispatched(AWTEvent aWTEvent) {
                                WindowEvent windowEvent = (WindowEvent)aWTEvent;
                                if (windowEvent.getID() == 207) {
                                    Toolkit.getDefaultToolkit().removeAWTEventListener(focusListener);
                                    try {
                                        PrintUtils.saveComponentAsEPS(windowEvent.getWindow());
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                            }
                        };
                        System.out.println("Put the focus on the window you want to capture");
                        Toolkit.getDefaultToolkit().addAWTEventListener(focusListener, 64L);
                    }
                });
                ((JMenu)object3).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.Video")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.startVideoTool(string);
                    }
                });
                this.popupMenu.add((JMenuItem)object3);
                object = new JMenu(this.getMenuText("ejs_res:MenuItem.StateIO"));
                ((JMenu)object).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.SaveState")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.saveState(null);
                    }
                });
                ((JMenu)object).add(new AbstractAction(this.getMenuText("tools_res:MenuItem.ReadState")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.updateView = false;
                        Simulation.this.readState(null);
                        Simulation.this.updateView = true;
                        Simulation.this.updateAfterModelAction();
                    }
                });
                ((JMenu)object).add(new AbstractAction(this.getMenuText("ejs_res:MenuItem.DefaultResetState")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.resetFile = null;
                        Simulation.this.reset();
                    }
                });
                this.popupMenu.add((JMenuItem)object);
            }
            object3 = new JMenu(this.getMenuText("ejs_res:MenuItem.GUI"));
            if (!bl) {
                this.langMenu = new JMenu(this.getMenuText("tools_res:TranslatorTool.Label.Description"));
                ((JMenu)object3).add(this.langMenu);
                if (bl3) {
                    ((JMenu)object3).add(new AbstractAction(this.getMenuText("tools_res:TranslatorTool.Title")){

                        public void actionPerformed(ActionEvent actionEvent) {
                            Simulation.this.translate();
                        }
                    });
                }
            }
            object = new JMenu(this.getMenuText("display_res:DrawingFrame.Font_menu_title"));
            ((JMenu)object).add(new AbstractAction(this.getMenuText("display_res:DrawingFrame.IncreaseFontSize_menu_item")){

                public void actionPerformed(ActionEvent actionEvent) {
                    FontSizer.levelUp();
                    Iterator iterator = Simulation.this.getWindowsList().iterator();
                    while (iterator.hasNext()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent((String)iterator.next()), FontSizer.getLevel());
                    }
                }
            });
            ((JMenu)object).add(new AbstractAction(this.getMenuText("display_res:DrawingFrame.DecreaseFontSize_menu_item")){

                public void actionPerformed(ActionEvent actionEvent) {
                    FontSizer.levelDown();
                    Iterator iterator = Simulation.this.getWindowsList().iterator();
                    while (iterator.hasNext()) {
                        FontSizer.setFonts(Simulation.this.getView().getComponent((String)iterator.next()), FontSizer.getLevel());
                    }
                }
            });
            ((JMenu)object3).add((JMenuItem)object);
            this.popupMenu.add((JMenuItem)object3);
            this.popupMenu.addSeparator();
            if (this.descriptionDialog != null) {
                this.popupMenu.add(new AbstractAction(Input.getResource("ShowDescription")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.descriptionDialog.setVisible(true);
                    }
                });
            }
            if (bl3 && EjsTool.hasEjsModel(this.getModel().getClass())) {
                this.popupMenu.add(new AbstractAction(launcherRes.getString("Popup.MenuItem.EjsModel")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        boolean bl = EjsTool.runEjs(Simulation.this.getModel().getClass());
                        if (bl) {
                            System.exit(1);
                        }
                    }
                });
            }
            if (!this.isUnderEjs && bl3) {
                this.popupMenu.add(new AbstractAction(Input.getResource("CreateHTMLPage")){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Simulation.this.createHTMLpage();
                    }
                });
            }
            this.popupMenu.add(new AbstractAction("OSP " + ToolsRes.getString("MenuItem.Log")){

                public void actionPerformed(ActionEvent actionEvent) {
                    OSPLog.getOSPLog().setLocationRelativeTo(Simulation.this.parentComponent);
                    OSPLog.showLog();
                }
            });
        }
        if (this.langMenu != null) {
            this.langMenu.removeAll();
            Locale[] localeArray = TranslatorTool.getTool().getTranslatedLocales(this.model.getClass());
            object2 = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    Simulation.this.setLocale(actionEvent.getActionCommand());
                }
            };
            int n3 = 0;
            while (n3 < localeArray.length) {
                object = new JMenuItem(localeArray[n3].getDisplayLanguage(localeArray[n3]));
                ((AbstractButton)object).setActionCommand(localeArray[n3].getLanguage());
                ((AbstractButton)object).addActionListener((ActionListener)object2);
                this.langMenu.add((JMenuItem)object);
                ++n3;
            }
        }
        this.popupTriggeredBy = component;
        if (n >= 0 && n2 >= 0) {
            this.popupMenu.show(component, n, n2);
        } else {
            this.popupMenu.show(component, (component.getWidth() - this.popupMenu.getWidth()) / 2, (component.getHeight() - this.popupMenu.getHeight()) / 2);
        }
    }

    private String getMenuText(String string) {
        String string2 = string.startsWith("ejs_res:") ? ejsRes.getString(string.substring(string.indexOf(58) + 1)) : (string.startsWith("tools_res:") ? ToolsRes.getString(string.substring(string.indexOf(58) + 1)) : (string.startsWith("display_res:") ? DisplayRes.getString(string.substring(string.indexOf(58) + 1)) : ToolsRes.getString(string)));
        if (string2.startsWith("!") && string2.endsWith("!")) {
            string2 = DisplayRes.getString(string);
        }
        if (string2.startsWith("!") && string2.endsWith("!")) {
            string2 = string;
        }
        return string2;
    }

    private void processMenuTexts(Object object) {
        if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            jMenu.setText(this.getMenuText(jMenu.getActionCommand()));
            int n = 0;
            int n2 = jMenu.getItemCount();
            while (n < n2) {
                this.processMenuTexts(jMenu.getItem(n));
                ++n;
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            jMenuItem.setText(this.getMenuText(jMenuItem.getActionCommand()));
        }
    }

    private void addMenuItem(JComponent jComponent, Object object) {
        if (object instanceof Action) {
            final Action action2 = (Action)object;
            String string = (String)action2.getValue("Name");
            String string2 = this.getMenuText(string);
            AbstractAction abstractAction = new AbstractAction(string2){

                public void actionPerformed(ActionEvent actionEvent) {
                    action2.actionPerformed(actionEvent);
                }
            };
            abstractAction.putValue("ShortDescription", string2);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(abstractAction);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(abstractAction);
            }
        } else if (object instanceof JMenu) {
            JMenu jMenu = (JMenu)object;
            this.processMenuTexts(jMenu);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(jMenu);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(jMenu);
            }
        } else if (object instanceof JMenuItem) {
            JMenuItem jMenuItem = (JMenuItem)object;
            this.processMenuTexts(jMenuItem);
            if (jComponent instanceof JMenu) {
                ((JMenu)jComponent).add(jMenuItem);
            } else if (jComponent instanceof JPopupMenu) {
                ((JPopupMenu)jComponent).add(jMenuItem);
            }
        }
    }

    public ArrayList getWindowsList() {
        return new ArrayList();
    }

    public String getMainWindow() {
        return null;
    }

    public String getJarName() {
        URL uRL = this.getClass().getResource(String.valueOf(this.getClass().getSimpleName()) + ".class");
        if (uRL != null) {
            try {
                URLConnection uRLConnection = uRL.openConnection();
                if (uRLConnection instanceof JarURLConnection) {
                    JarURLConnection jarURLConnection = (JarURLConnection)uRLConnection;
                    String string = jarURLConnection.getJarFileURL().getPath();
                    int n = string.lastIndexOf(47);
                    if (n >= 0) {
                        string = string.substring(n + 1);
                    }
                    return string;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return null;
    }

    public void createHTMLpage() {
        String string;
        JFileChooser jFileChooser = OSPRuntime.createChooser("HTML", new String[]{"html"});
        jFileChooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + ".html"));
        String string2 = OSPRuntime.chooseFilename(jFileChooser, this.popupTriggeredBy, true);
        if (string2 == null) {
            return;
        }
        if (string2.lastIndexOf(46) < 0) {
            string2 = String.valueOf(string2) + ".html";
        }
        Component component = this.getView().getComponent(this.getMainWindow());
        Dimension dimension = new Dimension(100, 100);
        if (component != null) {
            dimension = component.getSize();
        }
        if ((string = this.getClass().getName()).endsWith("Simulation")) {
            string = string.substring(0, string.length() - 10);
        }
        string = String.valueOf(string) + "Applet.class";
        String string3 = this.getJarName();
        String string4 = this.getModelClassname();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html>\n");
        stringBuffer.append("  <head>\n");
        stringBuffer.append("    <title>" + string4 + " HTML</title>\n");
        stringBuffer.append("  </head>\n");
        stringBuffer.append("  <body >\n");
        stringBuffer.append("    <applet code=\"" + string + "\"\n");
        stringBuffer.append("            codebase=\".\" archive=\"" + string3 + "\"\n");
        stringBuffer.append("            name=\"" + string4 + "\"  id=\"" + string4 + "\"\n");
        stringBuffer.append("            width=\"" + dimension.width + "\" height=\"" + dimension.height + "\">\n");
        stringBuffer.append("  </applet>\n");
        stringBuffer.append("  </body>\n");
        stringBuffer.append("</html>\n");
        try {
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write(stringBuffer.toString());
            fileWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.popupTriggeredBy, "Error saving file: " + string2, "File Error", 0);
        }
    }

    public boolean saveImage(String string) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        DecimalFormat decimalFormat = new DecimalFormat("00");
        String string2 = String.valueOf(gregorianCalendar.get(1)) + decimalFormat.format(gregorianCalendar.get(2)) + decimalFormat.format(gregorianCalendar.get(5)) + "_" + decimalFormat.format(gregorianCalendar.get(11)) + decimalFormat.format(gregorianCalendar.get(12)) + decimalFormat.format(gregorianCalendar.get(13));
        return this.saveImage(String.valueOf(this.getClassname()) + "_" + string2 + ".jpg", string);
    }

    public boolean saveImageAs(String string) {
        return this.saveImage(null, string);
    }

    public boolean saveImage(String string, String string2) {
        if (this.view == null) {
            return false;
        }
        ControlElement controlElement = this.view.getElement(string2);
        if (controlElement == null) {
            System.err.println("Component not found: " + string2);
            return false;
        }
        Component component = controlElement.getComponent();
        if (this.isEmersionConnected() || this.javascriptControlMode()) {
            OutputStream outputStream;
            block24: {
                boolean bl;
                Object object;
                BufferedImage bufferedImage;
                block23: {
                    if (component instanceof JFrame) {
                        component = ((JFrame)component).getContentPane();
                    } else if (component instanceof JDialog) {
                        component = ((JDialog)component).getContentPane();
                    }
                    bufferedImage = new BufferedImage(component.getWidth(), component.getHeight(), 5);
                    if (controlElement instanceof SpecialRender) {
                        ((SpecialRender)((Object)controlElement)).render(bufferedImage);
                    } else {
                        object = bufferedImage.getGraphics();
                        component.paint((Graphics)object);
                        ((Graphics)object).dispose();
                    }
                    if (string == null) {
                        string = "default.gif";
                    }
                    if (this.isEmersionConnected()) {
                        return this.eMersion.saveImage(string, "GIF image", bufferedImage) != null;
                    }
                    try {
                        object = "jpg";
                        int n = string.lastIndexOf(46);
                        if (n >= 0) {
                            object = string.substring(n + 1).toLowerCase();
                        } else {
                            string = String.valueOf(string) + "." + (String)object;
                        }
                        bl = Simulation.isImageFormatSupported((String)object);
                        if (bl || "gif".equalsIgnoreCase((String)object)) break block23;
                        System.err.println("Format not supported : " + (String)object);
                        return false;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        return false;
                    }
                }
                outputStream = null;
                outputStream = this.javascriptControlMode() || string.startsWith("ejs:") ? new ByteArrayOutputStream() : new FileOutputStream(string);
                boolean bl2 = true;
                if (bl) {
                    bl2 = ImageIO.write((RenderedImage)bufferedImage, (String)object, outputStream);
                } else {
                    try {
                        GIFEncoder gIFEncoder = new GIFEncoder(bufferedImage);
                        gIFEncoder.Write(outputStream);
                    }
                    catch (Exception exception) {
                        bl2 = false;
                        exception.printStackTrace();
                    }
                }
                outputStream.close();
                if (bl2) break block24;
                return false;
            }
            if (string.startsWith("ejs:")) {
                memory.put(string, ((ByteArrayOutputStream)outputStream).toByteArray());
            } else if (this.javascriptControlMode()) {
                this.javascriptControledApplet.setImageByteArray(((ByteArrayOutputStream)outputStream).toByteArray());
            }
            return true;
        }
        return SnapshotTool.getTool().saveImage(string, component, null);
    }

    public final boolean startVideoTool(String string) {
        this.videoImage = null;
        this.videoComponent = null;
        this.videoSpecialRender = null;
        if (this.view == null) {
            return false;
        }
        Component component = this.view.getComponent(string);
        if (component == null) {
            System.err.println("Component not found: " + string);
            return false;
        }
        if (component instanceof JFrame) {
            component = ((JFrame)component).getContentPane();
        } else if (component instanceof JDialog) {
            component = ((JDialog)component).getContentPane();
        }
        this.videoImage = new BufferedImage(component.getWidth(), component.getHeight(), 1);
        this.videoComponent = component;
        ControlElement controlElement = this.view.getElement(string);
        if (controlElement instanceof SpecialRender) {
            this.videoSpecialRender = (SpecialRender)((Object)controlElement);
        }
        if (this.videoTool == null) {
            this.videoTool = VideoGrabber.getTool();
        }
        this.videoTool.setVisible(true);
        this.videoTool.clear();
        return true;
    }

    private final void captureVideoImage() {
        if (this.videoSpecialRender != null) {
            this.videoSpecialRender.render(this.videoImage);
        } else {
            Graphics graphics = this.videoImage.getGraphics();
            this.videoComponent.paint(graphics);
            graphics.dispose();
        }
        this.videoTool.addFrame(this.videoImage);
    }

    public void processArguments(String[] stringArray) {
        LauncherApplet launcherApplet = this.model._getApplet();
        if (launcherApplet == null) {
            int n;
            if (stringArray != null && stringArray.length > 0) {
                n = 0;
                while (n < stringArray.length) {
                    if (stringArray[n].toLowerCase().endsWith(".xml")) {
                        this.readState(stringArray[n]);
                    }
                    ++n;
                }
            }
            int n2 = n = this.isUnderEjs ? 0 : 1;
            if (OSPRuntime.isLauncherMode()) {
                n = 0;
            } else {
                try {
                    if ("true".equals(System.getProperty("osp_launcher"))) {
                        n = 0;
                    }
                }
                catch (Exception exception) {}
            }
            if (n != 0) {
                this.showDescription();
            }
        }
    }

    public static ArrayList toArrayList(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ;,");
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public ArrayList getStateVariablesList() {
        return this.stateVariablesList;
    }

    public void setStateVariablesList(ArrayList arrayList) {
        this.stateVariablesList = arrayList;
    }

    public void setStateVariablesList(String string) {
        this.stateVariablesList = Simulation.toArrayList(string);
    }

    public boolean saveState(String string) {
        return this.saveVariables(string, this.stateVariablesList);
    }

    public boolean readState(String string) {
        return this.readVariables(string, null, this.stateVariablesList);
    }

    public boolean readState(String string, URL uRL) {
        return this.readVariables(string, uRL, this.stateVariablesList);
    }

    public boolean saveVariables(String string, String string2) {
        return this.saveVariables(string, Simulation.toArrayList(string2));
    }

    public boolean readVariables(String string, URL uRL, String string2) {
        return this.readVariables(string, uRL, Simulation.toArrayList(string2));
    }

    public boolean saveVariables(String string, ArrayList arrayList) {
        Object object;
        if (this.model == null) {
            return false;
        }
        if (string == null) {
            object = OSPRuntime.createChooser("XML", new String[]{"xml"});
            ((JFileChooser)object).setSelectedFile(new File(String.valueOf(this.getModelClassname()) + "_Variables.xml"));
            string = OSPRuntime.chooseFilename((JFileChooser)object, this.popupTriggeredBy, true);
            if (string == null) {
                return false;
            }
            if (string.lastIndexOf(46) < string.length() - 5) {
                string = String.valueOf(string) + ".xml";
            }
        }
        try {
            int n;
            Object object2;
            object = null;
            OutputStream outputStream = null;
            ObjectOutputStream objectOutputStream = null;
            if (string.toLowerCase().endsWith(".xml")) {
                object = new XMLControlElement(this.getClass());
            } else {
                outputStream = this.javascriptControlMode() || string.startsWith("ejs:") || this.isEmersionConnected() ? new ByteArrayOutputStream() : new FileOutputStream(string);
                object2 = new BufferedOutputStream(outputStream);
                objectOutputStream = new ObjectOutputStream((OutputStream)object2);
            }
            object2 = this.model.getClass().getFields();
            if (arrayList == null) {
                n = 0;
                while (n < ((Field[])object2).length) {
                    if (object2[n].get(this.model) instanceof Serializable) {
                        if (object != null) {
                            ((XMLControlElement)object).setValue(object2[n].getName(), object2[n].get(this.model));
                        } else {
                            objectOutputStream.writeObject(object2[n].get(this.model));
                        }
                    }
                    ++n;
                }
            } else {
                n = 0;
                int n2 = arrayList.size();
                while (n < n2) {
                    String string2 = ((String)arrayList.get(n)).trim();
                    int n3 = 0;
                    while (n3 < ((Field[])object2).length) {
                        if (object2[n3].get(this.model) instanceof Serializable && object2[n3].getName().equals(string2)) {
                            if (object != null) {
                                ((XMLControlElement)object).setValue(object2[n3].getName(), object2[n3].get(this.model));
                                break;
                            }
                            objectOutputStream.writeObject(object2[n3].get(this.model));
                            break;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
            if (object != null) {
                Writer writer;
                if (string.startsWith("ejs:")) {
                    writer = new CharArrayWriter();
                } else {
                    if (this.isEmersionConnected()) {
                        return this.eMersion.saveXML(string, "XML file", ((XMLControlElement)object).toXML()) != null;
                    }
                    writer = new FileWriter(string);
                }
                ((XMLControlElement)object).write(writer);
                if (string.startsWith("ejs:")) {
                    memory.put(string, ((CharArrayWriter)writer).toCharArray());
                }
            } else {
                objectOutputStream.close();
                if (string.startsWith("ejs:")) {
                    memory.put(string, ((ByteArrayOutputStream)outputStream).toByteArray());
                } else {
                    if (this.isEmersionConnected()) {
                        return this.eMersion.saveBinary(string, "Binary data", ((ByteArrayOutputStream)outputStream).toByteArray()) != null;
                    }
                    if (this.javascriptControlMode()) {
                        this.javascriptControledApplet.setStateByteArray(((ByteArrayOutputStream)outputStream).toByteArray());
                    }
                }
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to save " + string);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean readVariables(String string, URL uRL, ArrayList arrayList) {
        boolean bl;
        if (this.model == null) {
            return false;
        }
        if (string == null) {
            JFileChooser jFileChooser = OSPRuntime.createChooser("XML", new String[]{"xml"});
            jFileChooser.setSelectedFile(new File(String.valueOf(this.getModelClassname()) + "_Variables.xml"));
            string = OSPRuntime.chooseFilename(jFileChooser, this.popupTriggeredBy, false);
            if (string == null) {
                return false;
            }
        }
        if (uRL == null && arrayList == this.stateVariablesList) {
            this.resetFile = string;
        }
        if (bl = this.justReadVariables(string, uRL, arrayList)) {
            if (this.view != null) {
                this.view.initialize();
            }
            this.updateAfterModelAction();
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive exception aggregation
     */
    protected boolean justReadVariables(String string, URL uRL, List list) {
        try {
            Object object;
            Object object2;
            Object object3;
            boolean bl = true;
            URLConnection uRLConnection = null;
            Reader reader = null;
            if (string.startsWith("ejs:")) {
                bl = memory.get(string) != null;
            } else if (!this.isEmersionConnected()) {
                if (string.startsWith("url:")) {
                    object3 = string.substring(4);
                    if (uRL != null && !((String)object3).startsWith("http:")) {
                        object3 = uRL + (String)object3;
                    }
                    try {
                        uRLConnection = new URL((String)object3).openConnection();
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                } else {
                    reader = ResourceLoader.openReader(string);
                    boolean bl2 = bl = reader != null;
                }
            }
            if (!bl) {
                return false;
            }
            object3 = null;
            ObjectInputStream objectInputStream = null;
            if (string.toLowerCase().endsWith(".xml")) {
                void var9_15;
                Object var9_10 = null;
                if (uRLConnection != null) {
                    String string2 = (String)uRLConnection.getContent();
                } else {
                    object2 = null;
                    if (string.startsWith("ejs:")) {
                        object2 = new CharArrayReader((char[])memory.get(string));
                    } else if (this.isEmersionConnected()) {
                        String string3 = this.eMersion.readXML(string);
                    } else {
                        object2 = reader;
                    }
                    if (object2 != null) {
                        object = new LineNumberReader((Reader)object2);
                        StringBuffer stringBuffer = new StringBuffer();
                        String string4 = ((LineNumberReader)object).readLine();
                        while (string4 != null) {
                            stringBuffer.append(String.valueOf(string4) + "\n");
                            string4 = ((LineNumberReader)object).readLine();
                        }
                        object2.close();
                        String string5 = stringBuffer.toString();
                    }
                }
                object3 = new XMLControlElement(this.getClass());
                if (!((XMLControlElement)object3).readXMLForClass((String)var9_15, this.getClass())) {
                    return true;
                }
            } else {
                void var9_20;
                if (uRLConnection != null) {
                    InputStream inputStream = uRLConnection.getInputStream();
                } else if (string.startsWith("ejs:")) {
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])memory.get(string));
                } else if (this.isEmersionConnected()) {
                    object2 = this.eMersion.readBinary(string);
                    if (object2 == null) {
                        return false;
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                } else {
                    FileInputStream fileInputStream = new FileInputStream(string);
                }
                if (var9_20 == null) {
                    return false;
                }
                objectInputStream = new ObjectInputStream(new BufferedInputStream((InputStream)var9_20));
            }
            Field[] fieldArray = this.model.getClass().getFields();
            if (list == null) {
                int n = 0;
                while (n < fieldArray.length) {
                    if (fieldArray[n].get(this.model) instanceof Serializable) {
                        if (object3 != null) {
                            object = ((XMLControlElement)object3).getObject(fieldArray[n].getName());
                            if (object != null) {
                                fieldArray[n].set(this.model, object);
                            }
                        } else {
                            fieldArray[n].set(this.model, objectInputStream.readObject());
                        }
                    }
                    ++n;
                }
            } else {
                int n = 0;
                int n2 = list.size();
                while (n < n2) {
                    String string6 = ((String)list.get(n)).trim();
                    int n3 = 0;
                    while (n3 < fieldArray.length) {
                        if (fieldArray[n3].get(this.model) instanceof Serializable) {
                            if (!fieldArray[n3].getName().equals(string6)) break;
                            if (object3 != null) {
                                Object object4 = ((XMLControlElement)object3).getObject(string6);
                                if (object4 == null) break;
                                fieldArray[n3].set(this.model, object4);
                                break;
                            }
                            fieldArray[n3].set(this.model, objectInputStream.readObject());
                            break;
                        }
                        ++n3;
                    }
                    ++n;
                }
            }
            if (objectInputStream != null) {
                objectInputStream.close();
            }
            return true;
        }
        catch (Exception exception) {
            this.errorMessage("Error when trying to read " + string);
            exception.printStackTrace(System.err);
            JOptionPane.showMessageDialog(this.getParentComponent(), exception.getLocalizedMessage());
            return false;
        }
    }

    public boolean saveText(String string, String string2) {
        try {
            Writer writer;
            if (string.startsWith("ejs:")) {
                writer = new CharArrayWriter();
            } else {
                if (this.isEmersionConnected()) {
                    if (string.toLowerCase().endsWith(".xml")) {
                        return this.eMersion.saveXML(string, "XML file", string2) != null;
                    }
                    return this.eMersion.saveText(string, "Text file", string2) != null;
                }
                writer = new FileWriter(string);
            }
            BufferedWriter bufferedWriter = new BufferedWriter(writer);
            bufferedWriter.write(string2);
            bufferedWriter.close();
            if (string.startsWith("ejs:")) {
                memory.put(string, ((CharArrayWriter)writer).toCharArray());
            }
            return true;
        }
        catch (Exception exception) {
            System.err.println("Error when trying to save" + string);
            exception.printStackTrace(System.err);
            return false;
        }
    }

    public boolean saveText(String string, StringBuffer stringBuffer) {
        return this.saveText(string, stringBuffer.toString());
    }

    public String readText(String string) {
        return this.readText(string, null);
    }

    public String readText(String string, URL uRL) {
        if (string.startsWith("url:")) {
            String string2 = string.substring(4);
            if (uRL != null && !string2.startsWith("http:")) {
                string2 = uRL + string2;
            }
            try {
                return (String)new URL(string2).getContent();
            }
            catch (Exception exception) {
                System.err.println("Error when trying to read " + string);
                exception.printStackTrace(System.err);
                return null;
            }
        }
        try {
            Reader reader;
            if (string.startsWith("ejs:")) {
                reader = new CharArrayReader((char[])memory.get(string));
            } else {
                if (this.isEmersionConnected()) {
                    if (string.toLowerCase().endsWith(".xml")) {
                        return this.eMersion.readXML(string);
                    }
                    return this.eMersion.readText(string);
                }
                reader = new FileReader(string);
            }
            LineNumberReader lineNumberReader = new LineNumberReader(reader);
            StringBuffer stringBuffer = new StringBuffer();
            String string3 = lineNumberReader.readLine();
            while (string3 != null) {
                stringBuffer.append(String.valueOf(string3) + "\n");
                string3 = lineNumberReader.readLine();
            }
            reader.close();
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            System.err.println("Error when trying to read " + string);
            exception.printStackTrace(System.err);
            return null;
        }
    }
}

