var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Clock/Clock.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./Clock/lookangphoto.png"]="data:image/png;base64,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";
__base64Images["./Clock/01authorfu-kwun.hwang.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/close.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAh3ALEJFMhqBQAAK1gNXIiNFQArgVixCmQFgMKFVhIybLjCysCCGxdqxKaRFq2FJhsCwEZRoMmT2F4KXBFoZMyXKQXWtIhS5seDF136JIgwKM6cLGl6vAnTJ02SCpHeVEnQJsOCQTMG/djxKsKIEw1uXVjwoFVsAQEAOw==";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["./full_screen.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAPySURBVHjatJZdiFVVFMd/+9w9dz7u3KuJNjIm0tiAgz1NoFn2QYHWgxCUDxoR9dKnD/pURvQSGfQxECXlQ+BXiEjREL1YkTDYkDPWi9aEMTCJd+51mlHvnXvvOWfvtXo4Zyz0OqjkgnXgHNZe/73X+v/XPkZVuZVm5wCMMVQqlWdVdW367YaRjTEBcLpQKHymqhEAIoKIMDEx8YGIxPo/WKlUOgwYEUke5XJpsKtr6aZj52ocGatCxmAw13+GNFS98NAdHWzu7aRarZzJ5Tp7zejo6P39/f1Dh8YusuXz8SQ6lmRhWwDZYP7kTqCWxtsARHntiW52rb+d4eHhrXZBPr8ZYNvRc2A8PSvzbLwzRzYTcHS8yulzNWi5BogIXUuybF29kIZTRoo1ToxVePfHIrvWL2ZBofNRi+oigCiMYLbOF4/1snZ5AYBVv5+CSgMK2eYAdUfJeT58uC95DWM63hiFwKJO8SItgRdxABnnIXa0WnN5/XdbeiCjEMUQN/Ew5Pune/6lZAYQB84BgnqVlKaCcTEYz76TJQ7b87yzsYf9v5ShEQIWTLP6O/aNTvJIz0LeOzZBJfSgHpwiaV6rooCiLoYWYeDbcYiET4eLzEzWIGfBx81L1KLs/WGCwVNTzJRqKTEyIAGiiopiVSXRVOzAeWiz0JphZqoKrQbEg8zDovaAmb9nk9ggSHJ4j6qgKtjkKIqZq2vmP+T3gPfXp4W5WJfsRgVEmQOQBDm6AuBmLBYwIOoRFSySJnRR4g2fQM9G0J5NxNa0w+m4igWqaWzGpCPMoJL0IFCjoAreQS2iI2vAO3a/1E97u4FLjYR2zbwWQSPmkxf7yXUEtGUEwhicQzXJa0UFECRyMF1h8K0HeaB3EdlcgWfWLCP//FfQEMgEV6mYaszIwOPcc1c3z61bRvFCyMoXBqHDIppQNfCiCUviGOoRgpDNdYDUeWXfKFTrSfOuFJnz4GO27z2JNCq0d7bRagOohxC6ZEqrEgAWgagegjpGzkxBHILz/HH2UlqOJip2MYhn7OwMtVjQMOLnP6cgjiBqEHsPBmtnpi/8hoX+FQsYOlVk50dD7Nx9POG0NWCBMLp6dJukyeXiRfJP7QWnEHuoRSxaVmBxvpVfZ2vnTV9f320nhoemK3XHmu1f89dYGYKUNUEAwTx3m0kYjqRKFKV9aYHj729i9YqFvLrj9bvNZKnMnj17ntyx7eUjuTbLePESfh5icm3CYlCWL8mDgUNffvPmxg0b3jaTpTKqyn3r7l05MDCws7u7a5U1GYu58TtZVHVqanp8/8GDHx88cOCnyVJZr9xoG9BJUpibMQVmgdrlKt7q35Z/BgD4LZFsdEtqqgAAAABJRU5ErkJggg==";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./Clock/2016-08-31_1657s.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
