var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./VernierCaliper/VernierCaliper.PNG"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["./VernierCaliper/Vernier_icon.png"]="data:image/png;base64,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";
__base64Images["./VernierCaliper/2014-11-27_2315s.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/stepback.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM4WLrcPCIOUEYQ1NlZb3YVBWGgMpjD2VgXZ5Ga4Hplbd+oGATfws4w006iC/qIHeMD2HNkAFCcIwEAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
