var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Vectors4/2015-07-31_1303_002s.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAUAAAAC0CAYAAADl5PURAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAEZMSURBVHhe7Z0HfBVF28VPctMrPfTee68CIk1AUBFFURRQFAsiCmJ91VflUxQQUakqTXrv0pEO0nvoJfQkhPT+PWd2FwJvIO0GkjD//Ca7O7t3y+zs2eeZneKQKECj0WhyKJGRkYiJiYGDg4MZcwtHc6rRaDQ5HhcXF9hsNnNJC6BGo3kIoPUXFxeH+fPn49SpUzdFULvAGo0mR0MXODY2FpQ6Cl98fDwcHR3VcqoE8PTpUwgIuKB+dC+4Pjg4kHPw9PSU4IWrVy8jT558chLhiI+LR3wClBInJtrg6vq/Pnl6cHBIlItKkP3KzqH1PPviKC6Kg9xPm+QPM0qjSZZEODnZ0KzZo+by3YmKikJ0dPRtZYCUPepVqgRw7PgZaNK8K+JizYi7IO411q9fjdKlKmDYD4Pww/C/8MqLLbBo+Vr88vMo9Hz1TezdEwR3p7x44gnzR3Zi9eoyaNnyuBJXTfaDmTM83IYTJxxQq5YZqdHcgyVLIM98ItzczIi7kJCQgFmzZsHDw8OMMYywSpUqpa4M0NXVWUxHpBhIyZKlcf36ZQwZPhlbNq/A/MVrMXPabPTs9SYS4o19USjtjbNzbjV1cnLSIRsGuibMFyk4GRrNTSTbyIvTXEgBd3d3JYBWoIfKPJf67JYKl0Rca5QoUQrVa9SBTXJy80fb4MYNoH3HLoiJodkpG/Gfua+zZ4G1a435pUuBiAggKIg+uxG3bBkQEgJxo4ENG4w4bjdunDGflFQYsposjsoa5m0cOhRYtw5YsADivgDz5hnx69dD5anx4yEWo7FMNm828g7zh8XRo8DBg8Z2//wDXLgA+PsD+/YZ1sOpU8COHcD588DOnUb88ePGb8VgUPnws8+A4GDjXJi/reOsXm3sl3mW/PqrMf35Z2M6f74x5fldvAi8+66xPGMGrQ/jONaxmMf79zfmDx0C9u8Hli83znnSJOO8Pv3UON9Ll4xz4T62bTO2JXyOxowxzo1wO3LmDDB7NrBqFbBpExAWBuzdCxw+bKQFl1esMLb9/HPg5EkjnXjNM2ca8UwbptGaNcCVK8Z59OplrOP0+nVjH7xP77xjbD9qlLGe6XXsmHFft2wRb3KsEW8P0vLI36kP1rLd37fMJLw53H+s6TLHivglxcE8KjO1n5+RWLlyAcOHGwnJjLt4Ma1FY37IEODyZeDrr0VM2wMBAcbvNTkP643erp0xX7QoMHEi8PTTwPTpUC/SH38E8uY1RGb3buCnn4BChYBdu+juGMJFYeLy6NHG75o1A0aMMPLkokVAhw5AqVLAkSOG0PCB54NKYaO4PvssMGEC0L07sHEjULiwIRBVqgBbtxrHoOtleVWc//tvoG9f4M036QkZolanjiEMPD4FqmtXYNgwQ6jLljV+y9/QmqEgRUUZYsWXPn9DkZ061RAWPi979hjX+s03xu8tw+Dff4E33gA++ADYvt0QSTJ3LtCli5FufIZoPJQubQgnz4eC3KaNIUzFihm/pZjOmQM89xywcCFw7pyRdnzuChQw9l23rvGMPvooMHkyxKICpkwBnnnGSC+mQZMmQOPGxjn+8QfQqFHaROt+YPtSMOfvyt59h1G0WCWVuTIC3ZvAwGj4eH2nEpWJxsxRo4aRAatVM8Tz9Gkjjm8W3iyxXlGmjBHHG8RMxUyQlLNn84v1KamuybZQnK5f/0q9FGm5cZkPEC0oPnw1axp5gvmkYEFDhFj00qABULGiYdnwAeN6Csm1a4ZIVKgAeHvTOzEsGV9foFIl45gUPYoShYyWZYsWxkucL17mPeY7WmrMuzwG90fRZZ7keVrlTxRkHrtIEePFzXzN/dLqohjSImP+pVDVrw/Uqwd4eRnW0ttvsyzL8Ih4zjQGypc3hIbnWa6ccSxeA8+R8Dy4DYWteHHjHJlOAwYA334LDBpkbMdrp6BRYHkMnneePEY68lwptFY6depkpBvj+WzyHlDoaCVyP4zni4D3hc8g05HXzXQJDDSElNdZubKx/PLLhhjyvjF9+cLitdoLWrfFi3+pru1e0Nrzl7cL6wBasFwwd+7cqfsIMnHyXDRo3FmJU0ZgZj19+jrOnyorJ15AEj1R7ZPCygzGM+GUb37Gc56ZkRfIKWEct+eNt7DZYiQx6slbXV71OYx4nEHMhmfg2nSRmOt3qH4Og/f8778riVAlyD13VPmADxvzLe85A/MQ8wkD55kfuA3zAx9uYgmjs7ORl5h3GKztGcdtCH9DsWK8lc+4HeExeE7W8Qm35W+4jse18qV1LJ6HJYrWvrgPrueylX8Zksbzt0nPj+s5z+MQbmutT3ouPDcekwLDdRQ7Wo4UMv6W12QJBM+X++Dx+Dvuky4trWzOc721LfdFrGsgPC6Pxd9y3zxPC27PffD33M46b/7WuhbOM92t888Irq6OWLbsJPr1i7x5rneDYrdIzH4vvnFM+BGktLzh7qsA8kQDAi7COfECHm0hrxDNvWGGe9sTYaMi4CAWsoM8LB4ukyQDil+m0TzkfPvtL/j003fMpbtzLwFMQTvtT6L8xcfL06xJGae8iMsn4iezDmJ1OO3Mjej4EfKm/sdYr9E8xDg4mOUBGeC+C6AmDTjGwemtH+DgLyb/yiqIaRgML/dN4jaJj6PRaDKMFsCsTFwIXLY2hptY+e65V8KGAgi5nkKtT41Gk2q0AGZ1vMLhtpLTYPi4XlYFyKGh1Y11Go0mQ2SKALq5G1UBXCRwyq9inOdHEEcHR5km+XykSR2J0aos0MdnHWJi9iMqKsXaSxqNJgXsLoDePsCkP0djxfJFWLZ4Ltas/ht/TR6PZUvmITw8CsFBVxEUHIyQkOtIxQdozR04OTWHh0c/RER8hfj4f81YjUaTHuwqgLT0xo7+FVu3rMalS+fR5bnO+GXEf/DBwNcQJMJ3szcG0T2jHpG2BNODu/tPIoQlcONGPTNGo9GkB7sKICtf9n79bbw/8Hu0efxZzJ41H9NnbxNRnIWnO/eEp6crcufJjzx5ciMXq7tr0o2Pz2k1vXGjqJpqNJq0Y3cXmM1mSpQojbz58qFd+6dUbfEnOj0LZ2dnVas8ITEBCQna9bUHPj4HEBcXIO5wbzNGo9GkBbsLIFFCJ4HNZvjVklNd3Gd/bLYq8PD4EZGR4xEbm6QbFI1GkyoyRQA19w83tw/g6tocoaEd5CUTbcZqNJrUoAUwB+DltU5VMbpx41ZbR41GkzJaAHMIvr7BiI+PQ3h4OzNGo9GkhBbAHIKDQy6xBGcgKmo5oqPt2O2uRpOD0QKYg3BxeQ5ubl3FCnxDrEGjmoxGo7k7WgBzGJ6e02Gz5UFoaCkzRqPR3A0tgDkQH59LqtpRaGg1M0aj0SSH3QWQXWKzAwR29c0OEDhlEzlnF5ZTcQvd/C2zcXBwVl+GY2IO6E4TNJp7YFcBpPjt3fMvFi2Yhf379mDhvBnw9z+CSRNGY+M/q5UYGjWida3ozMbZmZ0mfIDw8K8QF7fDjNVoNEmxqwCyBUj1GnWRN58fZkz9DW+81RXvvvU0Pv6sD86cPoZz5y7izBl/nDl7FseOHRMt1EKYmbi7/yhCWFpc4fo6rTWaZLC7Bbh542oRwnj0fG0gfvtlKqbN3CrTmWjX/nkULVYIpctURulSpVGuXDlx1bQ7nNn4+JxQ09DQYmqq0WhuYVcB5LB6jzRriSaPtBChK4enn+kG31y+6NjpOZnmUgOks7IuBVJz//DxOWx2mvCaGaPRaIjdP4JQBBk4hGZMtOEWW50iaB4MNltFeHoOR2Tk73JvFpmxGo3G7gKoyZq4ur4noYW4wp2QmBhuxmo0DzdaAB8ivLzWmJ0m+JoxGs3DjRbAhwxf3xtiAcYjKqqtGaPRPLxoAXzIcHDwFvH7Hfv3r8C0aQ5o166+ih87dix27LhVX7BDhw7mnMGmTZvw559/mksps2jRIjzzzDMYMGCA+m1MTAyee+459O7dW60jXNenTx+89957atniwoULeOGFF/Daa69hzZo1Ku7NN99U23766adqWaOxB1oAswuqFrl9WLFiFjw8oMKFCzuwbdt0dOz4FObOnavWjxkzBm+//TbCw8Nx6NAhFRcREYGgoCA1T2JjY/Hf//4XP/74I4YMGYKtW7eaawzef/99NGzYUH3xb9KkCXLnzo2ZM2di3Lhx6jfDhw9H69atMXr0aOTJk0fOYZv5Sw6pUELEeRrGjx+P//znP0oge/bsqbblOZw9e9bcUqPJGFoAswGswrxgzx41HxYWhjfeeEOJAqchISFYunRpmio6P/bYj+IKA2vXsjwQaNDgeUyfPl0FsmLFCtSrV0+J4IIFC/Dtt9/C29sbbmzTKHz88ceYMGECmjdvjurVqyN//vwYNWoUrly5otYTWosDBw7EU089hZo1a95muSUkJGDQoEHYsmULvv76ayWMVatWVeumTp2KH374Qc1TgIsXL44NGzao8+E+1q9fr+IIxXHYsGFqPin79+/HK6+8clO8+fvff/9dzWs0SdECmA1grclf5CEmXbp0URbaTz/9pKY1atTAlClTbqtbSTHkMoUmuTqXrq6F8f3332LVqtJ49FF39OjhIHHFxMh0VpXTv/zySzz55JNKZCm4FDnC/dKS+7//+z9VkZ2W3w1R0KtXryrBq1KlitqOrq31m/79++PDDz+8aT3WqVMHnp6eqFChgjoORfTgwYMqjhQqVEgdk3CbiRMnKmuTrnOtWrVw+PBhtY5iTAu0ZcuWav8WI0eOxNChQ9Xv6DYTTpcsWYJTp06pZY3Gwu4CaLOxXzqjVQinXGbnCFzWpA+2l/FgYgp7xBL84IMPlBDSAqQlRmFK2qpm8+bNGDx4sLKkKBKXL1821wBz5szB4sXzRSg+EfHoLK6nB5YvB557bgl8fEpj7969SvwobnSJaQ127NhR7qMNffv2xb59+9R+oqOjlWvL83j66afRtGlTdVxCF5eWI3/z1VdfoVu3bnj88ceVGO7cuVOJYaNGjdQ59+jRQx0nNDQU69atU8JJcePxP/nkE+XuUnBXr16NFi1aKMF7/fXX1XkRXvv169fVPOH1Mk0IxZnwnPmyKFVKdxGmuR27CiDF7vDhfVi2ZJ5k3DNYMG+ayuxT/xqPvXt2wM2d2zjB5iQbatIErTO6mPw4QAtn0qRJ6mPBo48+qsrnkhIZGYnAwEAEBweraRxrpZv89ddfOHnypLLEqKklS7YVd9QT+fL9jhIlIlCmTDU4OjrikUceUQJbtmxZ9buSJUuqabFiRpO6Xr16oXv37soiozU4b948sSq/V+sIhS4qKkqJJ2nVqpUq96PLXr58efXRheJVunRpJaB0sXktPN8zZ86ofHP06FFcu3ZNiSetxZ9//lnti4LXrFkzNd+5c+eb8cRyj3mN3Cfh9dBN12juxEEyYYqFRxMnz0WDxp1V646UoLX3z/o1OLB/O7774SOULVEGh4+dwHeDf8WjLTrh+PGjcEw4oR6wSpUq32a5aJJh5UrEt2mDbuJWdhWriVYMXUHCB5/pSGtvxowZyuJKLSyfs8raXn/9U7HovsNjjyXglVcSxSrchc8+G6SORaHivik0tCQ///xzJVy0QqtVq4YvvvgCly5dUiLLcjZOKU7cN8vw6M526tRJPADDBaC15+vrqyw5wjI/ruMX4rtBa5LCTZd+9uzZ6ngsh2TeefXVV5UlyiIBuuz8ULJr1y61jlafJufCfE8vISWYb1jzwMvr1qBhzKd8+dpVAFlGPn7cCHFjGsq8O/bv24ZGjdtg//5tqFmrsVgRRXH6zBXY4g/K276F+SvNPREBjBMB7PTmm1j6229m5O20b98eCxcuvCky6SU62kFCfnGFb33M0GiyKvYQQLu6wOLx4LXe/VCnbgNUqVod3V7qjeIlSqjOEAoXLioPl9kZQpzuDCEtUNaW9utnLCQDvwJnVPyIk9NRyRhXxaXuYcZoNDkbu38EoQhaHSJQ8Gg1sjOEZD5GatLCHeV8mYHNVt7sNIFfXheYsRpNzkVXg9Hcxq1OE55CYmLmi65G8yDRAqj5H9hpAr+nhIQYdfM0mpyKFkBNsvj43EBCAltjtDFjNJqchxZATbKw0wRv7zmIilqJ6OhfzFiNJmehBVBzV5ydO8Pd/WWxAvsiPv64GavR5By0AGruiYfHRNhsfggNLWfGaDQ5By2AmhTx8QkAq8uHhlYwYzSanEGmCCDr5LKFG9uasgt2q1METfbEwcEGb+/NiInxR1SU7pBUk3OwuwBS8PbsNnoWXjh/BqKjY7BowUycOH5UtRPWnSFkT5ycGok7/DHCwwcjLm6TGavRZG/sKoC08o75H8Lu3ZuweNFU9H6jK7q/0ATPv/gctm1djVMnz+LY0b3w9/dXfcClohmyJgvh7j4Yzs7lxRV+RO6dbtqjyf7YVQBZb6x4ibKoVKkW/PyKYOSICRgw6EfMnjkPdes1R+kyxVGuQg3VHRI7z9Q9wWQ/fHyOquKNGzcKmTEaTfbFrgJIg87FxQWNGjdH4ybN0fWFHmrarv3TqFCximonrDtDyP54e/vLfWSnCa+YMRpN9sTuZYAUQXaEwA4Q2BkCpwwpdaWlyT7YbOXg6fkrIiMnyb2eZ8ZqNNkPuwug5uHA1fUtCa0QGtpZXnqhZqxGk73QAqhJN15eK+Ho6ICQEB8zRqPJXmgB1GQIX1+j04SwsFZmjEaTfdACqMkQDg5e8PZegOjo1RJGmLEaTfZAC6Amwzg7d4K7ew+Eh78n1uBRM1ajyfpoAdTYBQ+PP0UICyI0tKIZkzwcqJ3De1pwSE8OlZleOAQoR5+zWLNmjTlnwOExkw6IvnXrVnNOo9ECqLEj3t4X4OMD/PtvaTPmFufOnVPTgIAANXylBQc7TzpaV1r49ddf1W89PT3VUJkcs5jzjz32mFrfunVrrFy5Ug2rySFEObbwoUOH1PjDGg1JlwCmtQEHt2cbYU3ORbRG7rMDChc+g3r1TiI42FwhcOjCAwcOqHkOXM7B1MnIkSOVKHEQ9NWrV+PPP/9U8RYcaP3DDz/ERx99hAEDBpixBmxKWaZMGbRr104tFyxYUIlsgwYN1JCHHG+4YsWKanB3Cu78+fNvCiBFUaMhaZYlillISLDq2MDZ2Yy8B9w+Utyca9eumr3C6M4QchpffAEUKgQUKQKxxIqruL17+T9WCdA333xzU6hIjRo1lBu8bNkyFZ8/f37JH9duc1VTgk0p3d3d0abNrS77//jjD/Ts2RP//PMPlixZghEjjI8yPXr0UAO6kx9//FHybSoyruahIF0CyIGGV61chg3/rIKXt7niLlAoly6dhjWr5uHM6fM47r8fx44dEyvgkO4MIRUk5smDAM7kzauWsyJffQU88gjdW4jlZcQdOLBQrLH6SgBp3e3cudNYIdAF9fPzU+MZE7rFdF137dqlli0GDRqEIUOG4LvvvlPCdScUuC5duqj5hg0b4vXXX0eFChXkfL5SFmP37t2V9Wez2ZSrrdHciYOIUIoqNHHyXDRo3Fk1Z1M9vhw7jIDzp8XdKY7duzbhxe6vq2ZvyeHmBkyeNEbeui7o/nJPHDt+Gbb4g5IhjXIazd25dOYMwkqWBDujL+3tjXwXLiDPHeVlLNSfNWsWhg4dqpZZ7sXlXLlyqeX0MHDgQLmf0diwYQN2796tXNVt27bBw8NDWWzeci4TJ05U099++w379wPVqwPvvktRAqZPB55/3tyZRpNJDB48WBWvpAQNtkWLFt1W1sxiktKlS6fdAuQA5+XKVULLVu1UBwf3Ej/CdsH167fAEx27IzKSJxOPhPgEc63mXmz47DPI+wOBElxDQ7Fp+HAVP2HChJvlZbR8LOuKbl+nTp2U+E2aNEnFJYVuIMWNwXIJ72T79u0ICwtTHw3efvttdZwZM2ZgypQpGDt2rPpdy5Yt4evrKyL3jPoNxU/ykhI/osVPk11I16cJiqDVwcG9xI9w29JlyosF6KRaDGhST/s/JyCweiWw75yIdq3QUcTnnb59UatWLVXWZcEeeMgXX3yBvrKeULD4lktKgQIF1McCBs5bHD9+XIkiXc369etj7969yj196623lLhaYvvXX3/hqaeeUh87fvnlFzRr1hIlSqhVOHHCmGo02Yk0u8AZgV+CzwdcgC3ukFiQuulUaliO7WiHBph7Yw3++WgRhv82zFxzi379+mH27NmqLM2CZV782unE8QlMotgfWRLcWD4h0EWgy8uPChS5WDHbd+zYgapVq4q1X05Zlm3btkWvXr1wQdxwC9FHjBoFHDkCVNDDhWjuMw/EBdbcX2yxIUAYcHn/UTzftav6crpw4UJVNmcxXFzjOysA02pLKn6Egpc0WDjKm4niR1588UWVMWhJvvnmm2glLypWRcmdO/dt4sfvFxS/77/X4qfJvmgBzA7EAE2bNEWD5g3URwiW89ENtqCA8etnUkqWLGnOpZ1mzZqpOnQWhQoVUvXrLMJEkDt0ABo1goijGanRZEO0AGYTYuJEBbMI+fMb082bjalGk13RAqhJE7T8WJSYxBvWaLItWgA1qYYfg1n2N2WK0fJDo8nuaAHUpIrz54FevYBnnuGHEjNSo8nmaAHUpIpixYxmjbNnmxEaTQ7ArgLIWhdWJwmse8OaFWw7bLU9t8l63RlC9qNePWMaqsc+0uQw7CaAFLsjhw9g+NAvceb0afyzfjEmThiNJYunYfq0cfDwAPyPHMGxo3vh7++vujPSnSFkfb7+mv37saPR1PX+o9FkJ+wigHwwli5eiJq1q6JosVLYvHkl2nXohK2bV+OFbi8gJiZaNYMrX7EiylWogfLly6vujNikSpN1YZdW//kP0L8/W5aYkRpNDsIuAsgOD9o83gkR4UDDRq3xTJfXsGLZUoyfMAuzZ83BKz3eUVUn4uPYNjhOpmzdqsnq1KwJlCkDDPvf1ncaTY7Abi4wRZBWXsGChdVYsY+1ao8bIUD7J55RHSdoshdWNZfj7ItLo8mh2PUjCKEIsmiPgkhitfhlO3r3Zs/OwFE9wJsmh2N3AdRkb1jRefx4YMgQoHx5M1KjyaFoAdTchKNLWp0cDBxoRmo0ORgtgJqbWL3o604ONA8LWgA1iscfN3r4vnjRjNBoHgK0AGrwxx/A338bnRwULGhGajQPAVoAH3LOnQNefRV49lndyYHm4UML4ENNHIoXB7y9gZkzzSiN5iHCrgLIMYNdXI0OEazAoSc4tdarzhA4o3lgXL16FX5+J+DgsEqWHsWNG8DYsSOxZcsWYwOhefPm5pzB+vXrMWbMGHMpZebOnYsnn3xSjTbH/QYHB6sR5ThQOofZJJznyHMceyQpbCv+rJikHOicg9mQl19+WW37wQcfqGWNxh7YTQCNzhD2Y/nS+Vi0cDYWzJ+BFX8vwrSpf2Le3Glq/YkTx3Hy+CGcOHlCZXLdGULKeDl7SeLK1On2AdEzQrduq3DlCns2YG31MBGk7Xj++RfVyHKEg51ziMyIiAhs2rRJxXGApUgO7Gxy/fp1vP/++/jvf/+Lzz77TI0cl5T+/fur8YMDAwPRqFEjFC1aFPPnz1ciyiE1v/76ayWIPJafn58aeN2Co9FxcHeOQzxkyJCbwsdtw8PDcfbsWXNLjSZj2EUA2RnC8mWLUbhISeTN64eQkEC82L0rZkwbjZ6v9pTlINU6pGTJsihRqrwasIcdIujOEFIgDvjvrv8CU4HBXw5WURy2MikUk6SsXr0aly9fNpeSp0ePpvKfgzT7wssrDl271seoUWPVaHOEA6Jv3rxZCWCRIkWUIFEQ4znIswlHkevcubO6h7To69Spo+IpXBxRjuL17rvvqn2VKVMGX331lVpPfHx8lIXIAZ4IxyCuVq2amudodj/99JOap3gyr9D6rFGjhorbsGGDuO3it2s0dsAuAshmb+06PIE9uzeLlRCOJ554ETOnz8OosUswa8Yc1TkCB1C/qXfa8EsVvWb1wnLn5UAUMGHFBIzePRo7t+wUS9oYhXzChAnwYD9jSaCYJB2+kuP9Xrt2DUFBQfIiusYYvPRSUVSqVFxeSs3kRRSPwYO/xfDhP6FJkyZqHGBa5rS4aMHVrl0bX375pQjkKAwYMMDYqeDq6oqmTZuK5fg8OnbsqKzBPn36KDGkmHEMYUIxHDdunBp8nVDQpk6devO8hw0bhsqVK6tljtVaqVIltS37k2SPQZMnT1bHIh999JE6lkZjL+zmArMnmEdbtEXTZq3g6eWFdu2fVoLX4YlnVAamBag93rTRp14f8X1lhiNcSlo+VfUpvNzrZSUgZNKkSUpoTp06hdatW6s4pnXSMtZz586p7efMmY3ly6fKPTmn4g8dcsTWrRvEFb6OTz75FGXLllUCaIkcrT0KJ91TWnp0eZPyww8/KCuOgkn3lu7xyZMn1bYsuwsNDVVWIC3Jxx57DK+99ppyl0+fPg1fX1/lWnO5cePGSsivXLki57MVDRs2VGWH3P8lNkgW/v33X+Vmc8xiWqIajb2w60cQWoJWrzDsAcaaauFLH/XL1sf63OsBb2BgkYEo6FwQNWvXVG7u008/fXMw9FKlSimxSg4K0bFjx8T6O4733jvGGFk21s2evUB9bGjbtq0aNf/ixYt4nDWiBbq0FCRaYRx3+MiRI+Iqd1XrCMvsLBf2kUceUS4uXV2yYMECdOvWTQmhRd26dfEfdi6YBC5T8EiBAgXUfgg/wAwaNEjNEx7/m2++uekmazT2wq4CqLE/Mb7yBqkhFnZ0hBnDcXnzo3v37uaSgTVwOV3HpB+XOID6yJEjUb/+ELGoRoqrW0usPWPdjz/+qFzQFi1aiHW4XAkShYzW2tChQ1GsWDHlBvfu3Rs7d+7E9OnTsW7dOiWo/JLLr7evvvqqKpesXr26EmJuS4tt9OjRxkE0miyMgzwsKdpnEyfPRYPGnVVTqYwgL3KcD7gAW9whtGzVyozV3IuV8SvRJqgN+r3dDz/NND4O3IvPP/9cWXUUJIuQEKOdb9OmwD//mJEaTTZn8ODB+OSTT8ylu0OjYN68ecrLsWB5M4t9tAWY1eHHWmegz8w+xnIKsHpJUvEjefMaUy1+mocRih2LcuihWIHilydPHi2A2QIRwci4W3Xw0gK/jbD2Sgo1YzSaHAs/6PFDXeHChW8GVu9yc3PTApiTYcONVauA6dP5kcGM1GgeQiiCdIWTBpb+aQHMoZw+LW6zeM38cJvk461Go0mCFsAcSqlSgKenYf1pNJrksasAsv6ti4vRNI6V99XUzYgj/Ars4OAIB0fdBC4zqV3bmLKTA41Gc3fsJoDs7ODQob1Yvmw+9uz+F3NmTcG+fbsx/a8/sGrlEiWIN26EIfRGsIQbqlF7KmrgaNLI558Du3cbX3z5wtFoNHfHLo8ILb1lSxehQoUaKFmyPMaOGYy+/V7CkP97H71e64WAgNPqYYyOjjJDDCIjb1Xs1diHHTuAb74xBjRinT+NRnNv7CKAbP7WvkNHsTw24dKl8/j40xEY9esMjPx1PmbOmIO2bZ9VnSHkz58P+QsUVi0Z8uXLr3oS0diP+vWBihWNIS01Gk3K2M1JihCDrl69Jmjeog2KFi2GTk91hW8uX9UZQr78BZCQYLQNTkgwPkdr7IufnzE9fNiYajSalLFrKRGbysXGGFN2gsAKuFanCJrMgz1PXbkCnDxpRmg0mlRhVwHU3H/mzWMnosCIEUbVF41Gk3q0AGZj2MlB587sPgp4910zUqPRpBotgNkY9vBC1q0zphqNJm1oAcymtGxpTK9eNaYajSbtaAHMhrCTA3YGPWsWkC+fGanRaNKMFsBsxpkztzo56NLFjNRoNOlCC2A2wdnJmJYsCXh7604ONBp7YHcBdJIH1eoMgfNWpwia9OEkfxwRjt35NahpxN0xQJtGo0kndhNAihw7RDh8aD+2b9uEObP/woWAAMyeORnbtm5U623yLNvkn83p1rCNmrtTIbQCnB0k4XIDPT6Jx/a9HBhcbpq22zUau2CXR4nitmb1Mhw6eAQzp4/B+fMn0Lffi/igf1d0e6k7/I/uVdv4Hz2CYzLv7++PgwcP6t5gUsA/3h9NE5oCq+th2f/VRZn+s2COHHkTjscbIC8ai8uXL+NGOvvBCgwMVGP9JoWjv1lwkPVDhw6ZSxpN9scuAsjOENq0bSeWnROKFS+N4iXK4+efJuP7H6Zg7pw5aNSkjeoMoXyFiihXoQbKly+vBinRnSHcm/BcocagSK22w6XCcRwf1sxYIVhCxOmQJL0fdOjQAT4+PuZS6tm1a5caDpMDoX/00UdqnGEOHMNhNa2xezm2Lwcz5xCZGk1OwK7DYlodosbFi7KKtrEtMN01Tq15PSxm2ghDMApfKY8bua+KqW3EvfHGG+jTp48SJ1K7dm0lYB9++CFefvll5MqVSw2ezlGvOnbsqLYhX3zxBaKiotQ8B4ThGMAWHHz8999/x6xZszBlyhRUrlwZly5dUuteeuklNU5wREQEtmzZogY912geNKkdFpNeUkxMTLIGl11LkyhycizVIQItvqSdImjShxdy40YBQ/wuXryIt956C2PGjLkpfoQjXgUFBeHcuXOoWrWqWm7dujUWLVpkbpEy/F3Pnj1VpuJg6Vy24GDotAw5nKAWP01OQg+Mnk0YN24cpk6dqtxdlvNxWD9LBEeMGIH33nvvZpkqt5s0aZISyhIlSqi4lOjduzdC2LhYmDlzJgYOHKjenEePHlWWYfHixdU6jSarYA8LUAugRqPJlmQ5F1ij0WjuFw4OHuZc+tEWoEajyTRWrRoIP79YJCTY19Zyc3PG1Kmr8dVX/5oxd0e7wBqN5oGwfr2D6q8yM2CHIE2aJKrWZvdCu8AajeYBYbT6YvNNswbW/7BnD7B8ubkgbNlidPpBFi40psnBGiYZRQugRqPJdD76iG4rEBQELF0KrF1rrhCGDgWKFDHmV6wAqlQxOvmdONHo7ZyNkyiEe/ca21gkY9ClGbsKIF1cVoS2plbFaHaK8KBIhYdvN+7nsYi+Nvugr81+3O14tWsb0ztXHzgATJ58SxCPHAHYkClvXkM72Pa9YEGgcOFbVqGFPS7NbgLItr5BQdewcsVi8bmjsHDBDIRcD8HyZQtw8OBeJYLsDMHR0QZnl/vTGUJ0dCSOHztqLmU+mzbJ3bqP7N2725zLfDZtvL/XtmtXyoXb9uJ+X9uOHdvMucxn8+aN5tz94c7jubgYrSCsHswpbO3bAy1aGMusb79SrD6OacMm7JxygP8nnjBEk9PGjQ3LsVMn4zcWJ04YxlZGsMtHEJ5EwPmz2Ld3K/IXKIRVK+bi59+G44nH22HM78sw7a/f0OvVt3Bg/yEljsf9d4gg2iQxCsgZyA4y4SXl6OiA8PAwBAcHolixUojP5OYozvIG2L9/J6pVq4NYNo7ORFiYGxcXi3NnT6Jsucoyn8GvUylgXNsuubba9+HagATJkidPHEWFClUz/dqc5NoOyLVVlWuLuw/Xxn/Hjh5ExUrV78u1HTywS1zKWoiLl2NlwnN2E7k29vR06OBuVKlqpKXN5obLl1fC2ztB5h3vqh/8iGElPdWIxhKXaVTxsWUcrUG2LrNwcXHC0iXrMX/eZjPm7mT6V2AK4KVLFyTTGg30Q0ND5AJixGwtgWvXLqFQ4eKoUaOuuhCeAy1BzicmZM49sVzw4KA4XA++hpKlChrHkxCbCXmOyerhAWzduheNm9RARPitm5hg5wvktTFjyD2V9D6GSpXLGe+QTLo2tulmWu74dx8aNqyOKDluZl0b4bXES744cfwYqtcop64zs2CvbEzP3XsOoG5dEVu5JubPGPNhtCc8FvM9C+6PHDqMatUrqWPxmeL12hvu290N2PnvQdSqXUUJSaZemwTmwf37DqF6zcrqwbb0wp75hPmD+dFFRHPCH9PxyYddzdi7c1+qwTAj8QbzENZxrD1zYPR7/dae8EZER8Vi44ZlqN/wMezYthY1ajXG0SN7kStXHnk71bTrufBaPT0hrv5ylK9QHWtXL0C7Di9g5471eKRZO7lZLjfTIaPw2lissG3bGjzStB3C5EWTO09+7Nq5Ud6yvnJtNex6bbyncXEJCAg4BTdXdxw9ug916jbF1s2r0LR5e2UZ2uvaksIM/u+OrSKysWjYqKkSW3vDl8i5s2eRr0Bh7N+7DT6+uUXsHeSFfVleYo/a9Zi8b0fF6rsQcBrtn+iAvXsOoUSJcli/bjFq1mwkXlNB9YzYC+ZJHnPXzq1yD21w9/CU59JB3MgraNS4ud2v7dy5M/IypqjXEy9wO+o3aIEtm1eiRs2G4uXlt/u1rVu7WPbrp/L9kP/rb665O/elGgwvkp0g8A1HU5WB8wz3S/x4fRHhkZgwYSi8RBDOnzuBSlXqYNzowShTphL27dumrBd7ERMTrXpXWbRwgWSCEyggDxOtXYqRq6sbTp/2VyJiD3htQYGB8uC6iGtYA4sXTsGff/yAa4GXxO34Vyzwc3Y7FqEFHx4ejlnTRyNCTNq1axfhRkgQVq6Ygzx5C2DPni12TUsLpmlISIQIRHkRo4vquu0N0+nqlWsYP+47EfAEnBDPJVCEb9PGFRJ/AaIZdoXPRpkylXH40G6x/k5i9ap5kj+dUbRoaXERA+x636z0Gj/2Rxzz3y/u/XZ1bQcO7MC2rWuU8NsTftmd9OcwyZuXkTt3XmVkjBn1NdzdPeQFc8Ku10boLkdGhIlxUw+7d20wY9OPnU/vwcLEvihCULJkecnYiZKxD6s3U916zbFj+3qULl3Jbj3TMKPFxETh6tWLuHr5gtxwT5Wx27XvgLVrFoowRqJgwaJ2e/vx2oKCrmLHjnU4deoIHmv1JGqKZcs3vF+BIvDw9LKbNcZr4/mH3rgOv0JFxUqpDl+xkFwk9zEN169bgkaNmtndMjPSNFqu8zJ+HfkfsTabZUpPQrwnhQrnU/kiWl5guXPlUw9srtwyFWuJRTP2hBbtwvkTJV+WQ4lSpVGjRiOsXrFcHuBNqFWnjt2t9lMnj8rLKxSFi5ZCvnyFVN6IioxAqdIV7Z6e3F+ZcpXh45MbM6aNEa/kBho1aS3x8fD2yWV3DyE8PE5E0F0MjqticBQ1Y9PPfW0Jcj+gSU7LhFfFB8qaEmWl2vGh5X6Z4ay3KvdPi5cZnvBY9swAvDZaJ7wcZjxeJ+8Jp5lxbQzcN6/Jqm3P4/B6IyKMZXtjpakY0CJOxnVmFlbhu5NcD0WP6WvdQ3tjpR/3zePxHvI671Y5OCPwOng89svJ4/CarDyS9EOCvaAVaD1nPIYF711m3D8+X0y7TRvW4pWX2MxEFu7BQ9UShAluud9Jpwz2tlh403k8ZmIG68HhlMGe4kd4LKuYwbpOa5oZ15ZUDJKmYWaJH7HSlB+SOM1MeD3qGs3rSnoP7Y2Vfrw+6x5mhvgRlX5yj3hd1j3jxyTOZwa8Du7bSj8rZNb9s/YdzQvMIDlOADUajSa1aAHUZDmUCywuHF05jSYz0QKoyVJQ/C5fvoBZMyfh9OkTWgQ1mYoWQE2WggLIunj8asmK9EkL1TUae6MFUJOl4FftatVq4eUefeDk5GT3D0kaTVK0AGqyHBRBflHU4qfJbFIpgA7KNbHqhumggw46PNBAPVK1HDNGqipCjxrzF2rU7oy4+EyqSKTRaDRpwNnJFRs3LMLA/s/K0r2FMMOdIYSG3sDVq5dhc7SJ8mZcdTXZG2aZxDR08eHpZXzcyImEhUl6ZOBDjZeDl10smayA5ApEOKS9lrwtUXQljWkQkxgDdw8P+PkVMmPuToYF0IK9cwSzZ8JkdqR5OGB28fPzkTl3IyIV/PGH0TKB2YbNpu4GWyuEJ3l+XJyN3oGzKhS/fv3MhXQyJn4MbPKXHUUw1BaKaMSYS4lwhgv6hbyL0MRQMy5lXBxcEOwbDMc0fI6IQyyKIfUD9dtNAI8fP46yZcuaS5qHle+/P47p08vCXTSQuYfCxf4Q2eTqzt5G2AaVPfcWkhc1q7Tsvkcn1k0aHsIrrzgosXRxccCRwzfw82/1zbVZlAB5qLxlSiuQdRb5jFnNEuXa5Wk14vmUJWcppt6QzlrItfU83A31vesjWqwxNwdXTLwxESuL/QOPQsZ4vUkFh50j2MxKnVZHsPzKjwuynbNsx7Ti5mxHzzSxdDU5JB1P5jqJUrZSZsS9sVtbYEfTjzlw4IBk5gRs22Z07X3q1CncYH/WwtatW9X0Tvbs2YOLFy9ixYoV2L59u4qbPXs2jh07puYJl9evX28u3Z0LFy6obandBw8eVPNkzpw5OHz4sJq3zsOa7tu3T01Jcue4adMmLDeHplq4cCH2miOwcN+nT59W82Tu3LnYvPnuvdBev34dS5cuxaFDh3Dy5Mmb58apdQ7JpV9oqPHWTO7cduzYgWXLlql5nmNG0o/pc+3aNfj7+2PBggUqLXlvFi1apNbPmzdPveiSQsuf52tl3AsXHNVIXhy9i6fboIExTwHkNGngmA68NOb1lIZHrFEjFr37lEC/94vjzXdKoNOT2cBvtrFlvkxZPM7RF3hraOXyRbBDgqcEZp9ACTSa2SkCH3YL/jabhrbObdCnTD/0K/0B3ij7LhrLHwWMQsP8zLz877//4u+//1bixzzMvEvhYzhy5AjOnDpjpBW1kS+O+RKYhtRQphWPxSnTjuJoHtvJIWkipp907YUPT6VKlZRINJDcT/GoUaMGqlWrpuIaNmyoRICC2aRJEyUGGzduRJUqVdCqVSuxHqZj//79ePXVV/Hrr7+iXLlyar9MJIpBcHCwWAyF1L53i8lw5coVeHp64pFHHlHbUYTeeecdfPzxx2jRogW6dOkiVsn3KF++vFgPhg/F3/E8rPPhfgMDA1G5cmUlQEnP8dFHH5WHdYs6j59//hnvvvsuJk2apG4ez/GXX35RxyPsBJQ3lufI3z7++ONqu6CgIJQoUUL9/vnnn1fb7ty5E88++6z6vZ+f381zuzP9eOzixYsr6zq5c1u3bp1KW+7nrbfewtSpU++afhRrBh6vTZs2SnQvX74Mb29vdazffvsNI0eOVMtFixbFlClTUKFCBXTs2BFjx4697TwtKOQVK1ZU8UbmNVcIr73G3sAh+zAaqMvtVh3EBgRAXk7GNhRANpZ/5hngp58S0b1bCCIib38bR0c7oVzZWMRGR+L0qYvIly+3coHbtg6Hl5chvFkJ2gLhx3yxNEqeXFqAtFhOSaAQMn2GS3hBwnkJlyXwAV8hgQ85vbeKEiS9CiTkR+uYFohSP8w+hNvC5bK9cSPkGi4HXkIJv1KIc4gTy91V5W++qPm8RsuNb9y4Mfr164cRI0aoPFa/vliNEs/837V9VyPNKG4UQk45FGY+CWIdgmOJrJYQbsbVkXAv6zCNpEsALVOWD8Pvv/+uHsSZM2eqh4QCYcH1tJZofp4/f14yspeK48VbuNOPEmiF0MqgMPCB5IPJB9bC1dUVq1atQv78+dU2fJCLFCmijjl+/HgMGjTI3NKAxyE8Vyb666+/rkSY1g97abbgditXrsSAAQPU1LLEeM6Wxevr66umtF7z5MmjxIiCTxGiOFvbqR6MRbxq166NGTNmqG3mz5+Pnj17KgG3SC79AkQxaH3lypVLrSNcz2MOHDhQvTkvidLwWPdKP6YHXwQnxO/ki4IvHcJ1PK61TMuZ11W1alX1UrDSKDl4P5geSe+tBaM4ZCEHsqlXDyLY5ookdOsmGiEi8dRT3D4Rw364KPfBSAOLxESbWM/hiAwXhUiIR2xMHHy9ozF0yCXYHDOpW5EMwOx1ZpsHlkYY9165bwxlJDArfiGBD+0qCSUl/K/3pSgbXwY/hn2L6w6GB5VdSLDFIzo2GjFxUep+xceKiynxgYHXlIHA/Me8SsNhwoQJqFu3rvqdlXf5UubL9mYRAK28iRL4yDPd5IWKpRLaSshMWAaYWsQ1UlN5sBLDwsLUfEhIiJqK66emo0aNUtM7ET9cTcXVUlOyePFiNZ08ebKaiquXKAKk5q9evaqmySEWV6K4fmpeRChRElPNkyVLliSKdZYoD7Ralgf/5rG5TqyjxHHjxqnlpKxZsyZRHnI1L660mhIRIDUVQVNTEdFEcQUTw8PDE8VVvnndFlzm+RGe49mzZ9U8EUtPxfF3d6YfjyMW1s3zTgqPaaVLSunH/cbHxyeK8Kq4O5EXgJqK+6vSg4ilqtIstbz33nHJtiz9S0zMk8eYensb04yEnt33JAZdOpC4YvGcRP8DWxPnz9qc7HZZKlwSRQ+Xx/ichEkS4iUclxAmIVBCgIS/JeyUECMhQkKohGAzXJcQkg2DXMf47T8nntq3X92vi0eOJ/bd/FpieGCEyiPiEanp+vXrb+ZdK0+eO3dOTfksnNpwKhFBsj+mQ5yEeRKYLky/YxJuSGD6Mt0Yx3Wy/dn4W89VSvC54nPJZ+3OkKaPILTiaEXQGrPKhajySae0SFjoeCfWelpftCYI57kf7o9dy9PCYGFp0v0lhzEWhaRXXJyykjhvjfrGfTKe++R5WAWf3IZx3I6/v/McGcffWdvxTcXfWvGcMs5attZZ6WDB82YaMf7Oc+P2XLbWJ71Onje34zS5c7PSJTXpx2NwXVJL0cI6Hn9DuC+ep7X/lKAl9+WXYpkNpVljX959awtG/JoLsREcOlWMpxWn0bpDG3NtFuWiWOBetIJkno4Fk5xGIW+5ZRXSGeH6Oz15rkv102dneI63G+FpQyz/aTsn4vkS3cSrl+ci0R3vn+qHr6sNg6fv/3oKd+W6JAOfUX4ISZTANGQ6Mb14fjEyc2e2lDQ77XMaJWwlzIh7w+eJ+dzSgqSkSQA1mvRQUrQyOJiuvxmRDMyFTk4x4k3Jq545UvKqk5OzZFxPEW1jm6wGrymRxaVGKUS68ArxEi1xTvbhzDTYjEJenAgStztdhWCiSdSqSEfEUaAE3rI4N3GBoy8i0FFM31TICq+ZL/DiJWsaEXf+hC+RvBIymDRaADUaze0s2QU8wS8KWRyrmkEGyFQBnBYzDZ9Ff6a+CKWGeMcEhMTS4TcO6+hgg6/NB46JD/41H+4YjneC30EPWw+EJ7IkNmXYIqJI7iJGdYdk2L5ZXrZyqel5wbMS8Asv0G1N3+8fNDQyQkPpkhvLEeLaTp9+HrVr28Q9TznbMcO6uETiu+9Ki3uf+jQQ7x9//y33U27hg0g3Xi+/pcXGGkUfPAdvb3Hr0+AZJiUwkDpwUixid8THpy7dOHB+sWIFZOkuNc/XrARaZvHiBbJLhLpWLXMhfWSqAP4U9RP6R/aXPZkR90JcoNxnfBDkFIwIl+tyQo5wveoEWxERTy9Zn6EzsQMiNH0D+uLnSj+bEanD4ZBcvGigKqtgfqOW0zXKLcGBX5V5cQ8fbR7bhb9XeyDiRiKcnG3Yv+cUNu+sgr7vpGU0ryuST/LINJ2+2gPi9LElKFSkHOJEBD18HNC2ZQRWrKltrk07ly6dhJ9faXMpNYRLurEsmXVH/pfEjSKAjyQvgKf694fNywuuotjcQ4kvv4RDkvJhFtFtkdBULWUymSyAGTa7bGLBqb2kMtywiSAUdIRTYVcV4CeRPC+WD92x7YMItEgtWCeP1VA2bNigKiOzsrBVeZnVX2bNmoULuy+gkGsh4/esvDlFwncSLM1zvbU/WnM1awJFzee/d29jSl55xZzJQYSF80NLMdici4sAFpP3Q36xgmwIDr6IN954Q1WXYDUppisrdLMa0JIlS1S9Q7JLMv/Zs/4ydysN33pLDJeWQOm0aMEDICGhgLpmXjvTwEiL9OPm5ip5b4uqCsY6rnemFeNYgX/NmjVqmdaEu/utB/6zz4Bn2W+ABfNrMlDmrnzzDdw+/hiDrl7F+latEJQksa0mAWwByOqNJEhCgIQoCTyb6xJYhe+ihGAJhJV8uMxqkfxOdEqCVXWSGM0O7j8ZtgC/jvkGvpdcUTWxMuJVqeU9kEQPDghE5yrP49zlM+qrpYfNE+tCVquKuQ/aArSJRbo+egdejnoZxy8cVwW0rKu0ePFiVbfuxRdfxOjRo9GnTx+MGTNGPcS8+wUDC+JyQTM7cMK7z+IVusVuYgpGG6Xkr74K/P67WEby4i0iFuP06UDbtsDq1UYduY0bAdZplpcV1q1TP1Hs2noc1wKzlwXEen2RESfxxFO1cfb0eXj7euP0yWvYubegXGu0pGsJ/Pnnn+oLdPfu3fHBBx+o9GQ6s0ULK7cbaf2yvLn5adC4fnkeERICdOoEuS+Gu0sNYPVG1s1byrpjJgtnn4GHZ4KIUWrcE/sRHe2IChWvIlduP4SJL1y8ZFEsnr8L7h6l5VpSeEbuwFPOv9/7fli5OhqffPIJOnZ8Un2tL1WqlKq/aaUVK8S//fbbSSrth8HDI1qsH35FAOrXB44eNdKOJG4WC7Bx8hbgAn9/fNKtG95//308Jm9tt2LFUOj8eUjWVY1d3pPwhATJsqBtxvrdrBPA+U8k0H/6XkI7Ca9JID0llJdAp4jfbn+QQNv0GwkdJbwtobIEub23k9Vd4O9jvsf2wE0oJUkgWc2MTZ4EmxwqIAFDCn+HlZuWyg3yQI0ydfCZw5dw9XKVk7m/GfVO4iVzugX74PtKvH1QlZhZgZktPNiqw83NTVUkLlmypLIE2fwvX0I+dKnWBefzyruNl29akspPYP3pJAJIvRTdxIgRklEkp5QpY1g0oqfoKTmEopecAP7n0ysIDb3LKzuLEhfnhEIFj+Cdt/2wfu0WFCpcSF4o7jh4vBzy5V0lLz9vVcGaldNVPqhRQ7UYYtO8V8QcZrqzcn2TJsXEYm4oe3QA64jTUmYLEzGEMGkSMHQou9BPXgD7vhkIZ5fEm2WQ94vQMGd80O8AwsJicOniRTRv0Qi//HoZFy9VlHNMW6sWV9dE/P5nLhw5GoTly1eKoeAr1m9pZTEnTSsKIas2MW+yov6dAngn9xLAHeLy+uTNK+57LEIk1P/0UzjFxalWarTg/CTwCWkhgU49G2/y9fSRBDpArMO8X0JrCZbT/4cEeb+jl4QlEuTooCP0pQQ2mOkhgSWWFMrbyOoCODJ6JN6NfPeuJvVtyDae59wQ5h2CC5FnVH24vJF54JxH3gtZpAywf0B/DKswzIxIHV5HvBBeONwQwKSwUYcDP6YYjcPZUoItJpLjXuuyK82bHsC69T4IOHMDHu5u8D92ETv3l8Zbb7LANLVclYxLuyF7WcDHD61DnjxFEREZhSIlfPBo8xtYv6GquTbtXLlyCvnzp67xv0GEpBtL8O4igJtEgprojyAZFsChUUMxIHIAX9ApIwLjctmGhcEzEeZqfGV1ve6MjhXkHUAjKQsI4GunXsOoYqNwPYElGSnjHueOAeEDEFc0Do4Jd7wF3GUf70wWC1D8NFlFy44uW3Ikt46lArRwsivVqhzGD9+FiSVkg6OjA06cEFPNubhYvfkREXFvb4Gw0nZkZAA+/rgy3N1vlQOmBFsdDmdb3AfIn2OXwde3oLirifDyisfAj7yw/2Alc23aOXJkF/z8SoplnXK68UF3dAzFoEGsmZFXlo14i+BoYGYvEcDmWgAzLIBb4rZgVuwsuDukrjZonGMcgh1FGMyj8qTyxOfOEtVgIhMj8ZzLc2gof3GJqXNVeP60ZDOLDz80XLtk7l2WJ0oetNAkTVwlH2LIEHaNFScPshmZAhRBhrTCF8fVq7hn5evMhN1mmg2AFN4+gFs6v4Ow3O6XX4wWRal9WlPMl6tFAFtpAcywAGo0mmzIkiXAE/yUkcVh128sH8oAWgA1DxXsAow93dyZtW2ObhDnUObEmkqMlfVp+yBhT/ix4oFy8SLAPiDN3oSyJHQZunQB8rAeaPrRAqjJNOiWsYuxOzMXl5PLWrlz51Z9KVokt13SOHYPFiI+YNJtrPXJ/ZZVq9g3Y7FixdS5EVa4Z/3Oi+FrEBEVCDen3PD2KAhfp5qIR9Q9j29hrzi6pVb/ipr7gxbALAJvxNmzZ5O1TrIjrMPHysrstJV1Jq0H3cODPdrQwrpdpNhDDTt67dChw82eatzc2KNOvCrni4293SLj9qzYy051rczL7Vxd2ZsOe6i2BM44BsWFPV77+PioDnUpgA4OzmLzOWH9mR4IjwhEcIQ/nMQS9HYrjHqlPkF+t+ZiDbLZTqKq5sT98Hfs8cfatxUIr9nqySc98PzZq5IWwPuHFsAsAjtb5YNFKyinwEriLVu2VKJA3N1d8NNPi9GvX3sREraHNboYY+ajoLFlTdu2bVX3Xdx22rSNaNq0Ii5fDkGjRhUkjaKUuFjbs4v/Ro0aqX1TPNzcbPj55zWoWjUv2rRpIOkZIxk8Rv2G1h+7WWe9OApgYoKIKq4gNiEM2898CVdbXjg48sOAiFxCNDxdC6Bm4Q/Vdr4+eTB27Bglnuxwl71s8xx4v9gRLUWR4seWK61bt1Yd4/K6uN7qTowCbMXxXHhOjLe6YaPo8xpYf4/H0Nwf7iWAti8Fc16TyVAk+HCw4u+wYcNw7tw55Q5ySAF2I86a/Z9++qmKDwsLU3Gcf+DlRUlgiwP21G1lm6NHjyp3k9fFB97FxRGzZu2XsAEVKhQQsfeUdUYfhYQ9BfN6mBa05EaMWCcCWgWjRq3H/v0nULt2SdlPotoX4VAGhQsXNkU0AX36jJP9eWDy5MWYPn0jrl+PkN+UkLgEtc3Vq1eVcHp6eimxmb2vobzmE3D22j+Iig1CWFSAhAsqOIhluPfCCHh758Ki6QfwQrfnUKtWLbUPihW7bGdzPbYGYo/dkydPVsMwMJ7ljOwRnNdNkeax165dq35LAWaTNd5bCiVbtHCsGA55QCFkBfoCBVjtV3M/4D1iuicngA++7slDBh9KvpHY5ItvJVoDL7zwgnKLfvjhB3z77bfKYuCARbQU2dV9VoLNrSgAFpaVQ0EzQpxyay9eDBH3+IzahhnQEn9rW86zxxJHx0QRm1gRDVexro4hKChctrm1PfdvzdNVHj78JZkGixC/IyIzGKdPX8e8eTtUdRdr//xNQjzPKw4uNh8ldE42Nwmu5tSYtzk6izvsAWebswjzceWe06KlkFG4OIgXj8224GwNxKEJOPAWX0y8h3Tl2SqD4sa24vny5VMuOO8jBY7CyPbiHK7BGqyL52i9DDQPHm0B3kdoVTDz86Fi0y9aThwrgWORdOvWTY3PwXKoMmXKqIeLgy2xqVNWQ43lYMLmaxxcyRIrZ2dHsZTWiVC9jPr1S4lLG2EIkgS+gfkBgGLCNJB3AXbuPIsmTSpI/BmxinuIaFHsbvVOzTLTggULyhyFMgZ//LFeju8pgnVFLOd9YiEG4umn60q6Gb1v37IAPUX4nHEhYhnye1dDwPXNIoae4vqKKyR/CYlxcHX2hod7HuRxr40CPlXRtFkT1caWRRUcwYxtlHldHIeGZXYsj6TrzoGu2FEGBZL3tGnTpqhTp46yCnltvJd8cdF1pyjyowzX8/p5juHh4beloSZzsV6MTHuruMKyBnUZ4H2EDw9dWn4E4U2gNcgHnQ8sBYE3hcuM521hvPWxICvCci6WiVHErfOnULm7u6nlmJg4dS2E10PLlmWALEPjesZ5e7M7f5aZ2VRZHnOjJRRWGSAHmmL5GtNsy5bjkomNCr7cf/PmlZT1x48iPBatM1pvFJh4sQLdnfMjJvE89l37BheCd6Kgb11cjzihrL8y+TqhjE9fREZfg6MTLUzjwwePy+PxfvGBITxfxvPcaLlznufI+8XzIlYcHzirDJBwam3Lc+RX8+rVq6t1msyH1jrvH5+lvn374qWXXlKjU6pyQbkxWgA16YaCzmoq1hv1XnAbior1tTUluD0zLYXFWKbo3moTzOWYmFvli9b+KTS0Gm++6RNtYhH6YOp+P3SreQTbLn4AT1tZVPD4QsTxivo9t7OmJLPiGDg8a032i6a5L1gfQfjy4ciUzFNcJloANTkO9jDD4gXL8qLL6+DghFin03CNL41Yx8uwObgjIdZd4o3sbwmUNc2sOD6E/DjCjy2a+8PdvwID/w/3keoGz+D9fQAAAABJRU5ErkJggg==";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./Vectors4/reset2.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///8DAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAEAANgALAAAAAAQABAAAAhmALEJHEhGh44CAxMSNKgDG4qHCgUWRDiwAESBDA1aLEDR4oCBDDeiGPjwY0UdKCwmRDHAZEWVEWNSTNgwZsSDMwVyzIlyY8KdIFMKnQkUG06hLV0W1dlSJkdsFlna1Mlx5NSrAgMCADs=";
__base64Images["/org/opensourcephysics/resources/controls/images/window.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAP///8zM/7S02rSz2rO02rOz2rOz2bGx17Cw1a+v1a2t06ys0qqq0KenzaOkyaGgx52cw5qawZqawJqav5mZv5iYvpaWvJOTupOTuZKSuJGRt4+PtY+OtYyMs4yMsomJr4eGrIaGrISEqoCApn19o3p6oHR0mnNzmWZmmTMzZgAAAMDAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAPJbhxNsRBwAAAAAAAAAAhIa0PKcBRIbtAAAygAAAAAAAAAAAhIbdPKPsvKiihNsJBIeYAACCCQUMCOFkPJbhxNsNBwAAAAAAAAAAhIbIPKcBRIcBAAAygAAAAAAAAAAAhIbxPKPsvKiihNslBIesAACCCQUMCOFkBxzTCQUMAAAAAAAAswAyv38AOyYNAAAZQAAygAAygAAAAAAAP38ABIc7ggAyhIcJBAAAP38ygAAAwAAAAAAAAAAAEpgQAAAygAAAAAAABNslBIbLAAAABIl3OyYNAAAABIesBIeNPKezyQUOBIcJAAAyiQUMPKdjAAACAAAUUpgQMsAAMsAAAAAogAAUQAAAAAAAAAAURIc/AAAUcsAAEpgQBIc/PKK8PKLLBNrrMsAAAAAAMsEBMsBSAAAAEpbOMsAAAAAogAAUVBTUFBTUExn2AAAogAACMsAAAAAABIdWPKGQMsBMPKGHxNqCAAAAMsAAEpbQEpgSAAAAkxn2GEAaHMAbwAAAFBTUMslsMslsMsAAMslsMsBSAAACMslsAAAAgAAAgACQQABQwAAohIdAAAAAwAAAwABQwABwQABwQCwAAAAwwAAIjphWDphWAAAEQAAAAABQ8smDAABANtFiBIfbAAACUZJRxBhOdUAEP//AP/MzLTatLSz2tqzs7HZs7Cw19Wvr6zTraqq0s2np6HJpJydx8GamprAmpmZv76YmCH5BAEAACsAIf5QQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgAALAAAAAAQABAAAAhEAFcIHEiwoMGDBj8pXMjwU8FPeiJKlAiRYMWDFwVmfKjHYkeMHzWG5OgR4caNJQeiVDlypUiLDRuOXDGxZkSEOHMeDAgAOw==";
__base64Images["./Vectors4/01authorfu-kwun.hwang.png"]="data:image/png;base64,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";
__base64Images["./Vectors4/lookangphoto.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAGAAAABgCAIAAABt+uBvAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAgY0hSTQAAeiYAAICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAAA50RVh0QXV0aG9yAHVua25vd25DnDVuAAAAGnRFWHRTb2Z0d2FyZQBQYWludC5ORVQgdjMuNS4xMUfzQjcAAFlSSURBVHhejb0FWBzn+j78jqwvLO7u7rC4u7u7LiyLLu7uBAshJARC3D2NNu5pXBpv2tTdeyqn3zNsyi+np+e7/nM91zIss7Mz99yPv+8Ltmu/DkIkiTExjPj191/++OO33/5Ev//+x7ff/+vX38if/mB9+cMfn3zxwy+///u339GPP/7EpuN//Er88TMD/cJ5fPfDzz76lYbTCIL87fd/w/bHH3/A659/IgxDOI5jGPbnnyB/IoTgVbLB/tKGEwQBXwfHwFEcDufXX3/9E/0hxeX9/vvv//rXv+BU8Ac42++//xvH4eOIIHD4lOR4nEB0OkFnkH/8jhnZ/svFl8NiE7///h2O/cbC5b/75kviT+L192D//usbl776N+rl33/i//4D/9dv6F+/oF//Bbf25xc//vnzz+iHn9C/4CgSI5kEnU7C96IjJw0PHjE6cNj84GHrfQcsdu412bjdaM2izsQarcHVGi1jasIe5fgq6YA8lk+OdIhAxTOFG5Sh4RKiIaeOpGUIRQWeDI/N5dDhdCSJg8AOk0n9Sp0dwV1RG4AlweuvawX4SLhbGg3AJRgMmpQUR15elsViwD58Fl7hVHAG2JeV5cH7kjOz2eyl8yAmi1RUklZWkVFW5ZJM5BXCrRuSrhtBdf3M2i5U2YLVtdEkUt9BgjS2400dBEhNAwIRN2BVdURZFVkoJHMK8YwcPCwF843GHAIwUy/MyBszCcDNQmjmoXR05ITmW8d0j50wP3rMat9B0x17jDbvNFm/1XhiXqNnWqluWDGnSTqxUi6kQCZCoBoj1PVP1DPhSytoMNgcwIDBwOksoBAOJPw/aAiCggJuD95cRkcC0JsYAaIAJEAmLc0FgHg8KXjlcFgSrOEk8CcAEH5VVJTnctmAGmxcLhfeQXB+AskrcKXYBJclR6OjrFKZphFG4yC9tgNVAgTNRE0LJfWteEMb1tiBmjqx5i6sthGB1DXhtU1EdT1ZVkWUiMiiEiIxnxaeSnMLp1n5EgCQgQ+m74Pp+uDo7TMaR49rHDmqc+SIwf5DOqBxG3ZqzmxQ7V8jVTPIEXYo5jZqJFYox5QoxxTqhmXomjlo0KUQi0sjMJKBM9k0FptOAJvhfuBmgDsgS7SgoFiSf97g5uEPy/ABR9hsJnwQUAC84CRwBniFwwCOJe4wl3gEvKM+qKAgB0+IK8VQlpVXlFGQkSKVlFFprVLrMNbcQ69rJqsaseomvG4JIECnpRNr7UZtPVhTC2puRa3tGEhLG17XRIjryEoxkV/KSMqlB8aR/GDS0g839kF6npiOO47OntM8fkL18BHVg4dUd+yTXdwpNb2RNbgaFw+SlT0KefWaadWaMcXyySIdz3B1FR0mncPgyUrDVUqx6LJSbB6HCQAxqWdL3ZsEHeCOhEGwL9GpZZAkuiZREwmOknuW6BrsAIMkZKRosvSrROkIkuIjHLYEGR0+bmllqqOrIcvhqCrRVBRJFTkFSwtUUc9s7KI3tTOXGEQ2tNFArdq6ye4+sneA7BukdXXjPX143wAI1teHdXfjHW1kazMN1C1PQMakkL6RuEsIbheIAZXMvUh0/KTc4bdkDxyS27VfenE7bWYjPjKHOqZQZZ9abp1KWqVWerV+fLGGnQ9TVgl4zaLROWA+6DRMjseE58YgEezzpKRlZGTAfrw2vzjoHgNug7Iif22AkQQaiVUCaEBrAFCJOZegA8cAChJwgS+gdBKLRuFIQ0AiOBLM0DJGFpYmctKEuiqposDk0HETXeWwMF5zF6+6HlU1EjWNeH0r2dxBdPaQPf3EwBA5OEyOjdLGx8jJCXzlJD45ho0Nk8P9xHA3rbGOrBCR2Vl4XBIeGoMFROA+waRXAA0dO8ndc4C+bSdj43bm/Dbmyo2s3hmybhDlN6ilV6unVhj6J2tauMmxpBHQgo44ABJsbLh6aTbssphgLGVpDMqaUBaCBk+b2mDnTXQkNy8BAiizZH0okVgcCYZ0OhPMNkCzbOOBVQCiRHOlpFkAk7S09NJpqfNI6KmmxIZHpamqpKejwGOTTjZqhQKFmkayvA4BTLXNeFM73tGN9fZjg0PE8AixdhVjbjU5v4ZcWEPMrcJmJ4jpEXJygNbbTLRUk2WFRG4Glp6MEuOx2Cg8KgxHx06x9x9mbN/L3LCDvXojc3gts3WMXd5Ny6xVSCiT94rn6VhLUwYGSbNpXCmwCeBZGLi8rBybyZHiSMPzJGiIxqRuHnBhsVhMJvMNOry++b8BRGkKeKIlgyXxbEs6CLpJ+T54B3gkcWQgACIYb1Ax4JSEgwAvfGQJZ5zEkJaqtrqykoervZmRmgwHRYdrFJaBncYlDGrtooF+DQ7TRlfQxsYZG+YYG+cZmxfITfPYxjX4wjSxZoxYPUQfbad115H1QqI0FytIRzlJKCMWpUYhAEjq6AnlXXuVt+yWm1zEGkZQZa+UsF03Ll/LLUTB3l1bTVMBrgI2MDQQiMCrFJctLcWRlZEGHrHAo4P1oZPy8vLweJe1THLP8PqXQv39p0QHASnqLv8zAli23xI+wpEAOuAFKiYx5MsWbYl5JJtDAwWUk5e2dzBSlmca6TFSUpUqGugNbURzM2ptQ119aGAYGxvBF2bRhjm0dQHt3Eju3sjYNc/cvIo+P0Ks7sOGarGBaqK7HG8VELU5ZHkaTZBAL4xjoMPH6QeO8vYcVF27SXpgFdk+JSvqVI8qkI/LMwyMNVDVZZEMBCYHqEHChVE6RedyWAAQwMQBG8KgwTuAlMTKSp7wsiWCT/0jQBK6SQCSfOpN9/8m3eAAAAjOA64NMJKEDoCp5PilDxKADhV2EQhsoK+no5WpvL8/U9woDfFOewfe3UUODqHRFcSqcdr8arRpFm2dI3Ys0AGd7bOMxXHamj58ZTsarsEGqlCXCDUXYjUZhCiJLIqh5UfS0J63sE270Na9vIl13JZhTnGzbEAy3SGE6eQrZ2LHo3ERjYFLy/AkHlcCDbwCOjTwKWBQqdhWYpde29olQ0vCLYH2wb0tA7TsvyQ7Eu7A9o8ALekRKTFqkg20DFRMEhwtf5fkYUg4BRfB4RC2VqYWRkoWZkgoYtfVo7Ym1N9FgGFeNcWaGsE2zKCtM7Tts/Qdaxg7VjO2TDHWD5Ez7fhkEzZagw1V4l1CrDEXr0rGSmKwvDAiOxhHW/ehhe1o1QZiZK1UeQcnvogTnqvml6zpFWgoJUdZHMp1sVgSS0E9TzoJuEjYJBHQO/hVEvm8aYne5NTf0HnDl72mzzKD3mSTJFCSKJrEVEtItKyD1Jcu4QUH0pasmQyXY2elb20hVSxQam5k9XfR+trw0T58rB9bO8ZcP4EtjqGNE/iWCWLzOLk4TKztwqca0YoaNFiB9QpRWx4SpyBhNJYbhDJ8UYo3Qpt2E/PbyfF5vGOCVgYAFUv7Jcl5xaorqbEov0VFKxQLJGGLxC6+4bslsQkVAUkuWqIRktBm+VFL0PlfEeOb7y9/SgLN63Bg6Qj4UklgJYmnl0++BBB8HQnJB0SPEHBYmOopyCIfD1RXzWutQZ21aKidHGpHo21oth9f04PW9qK5Pkpmu7CpZrRCjIYqUJcAa8lHNakYoJMTiJK9ULwrinFGaG4rObVIDs4STSNEZQ83W6zoGspVM0IYDioN10G5DMqzUNdHEX/ZykieucSdS9wWvMKjltyVRHckqP33tgzEm4hIDvtf9khCYUl2RiVsf2EE5KbhHCq/xKlASUFOXlaaoabCtTIl8jJorWKirZLeW0vrqELDTbQVTfhkK5pqQyvbsak2fLyJGK4h+sqJbiHZnMeozaSXxTPywmipvmSsOxHlTEbyCTQ2j0bWEq1jqGGUVtJKFNSqxWWYS8ki0COI/pd0DIEVBBNIXR9EQm9sEkQkpIKL/ssivCbR8t3+p9P5b3Beq4zkMMmf//EjgA5QeclOUxj99QAoG4BjDIKOIGgCjJSUpOVlOM622jlpvOZKZouI01RMtJSi9jJ8rFFqUEwbFJMgA9VkdznZVkw25tHrshiVaUxhAisvnJnix4hxZ4TxaSEOtCBHGpragA/P0nqmuRXdCABKKpDSNkTwkFgMJgS0EI5Q1IAwn0YRBLCS2BoJQcA2LacIkswTfv1vf/S3d/4Rob+x7J9RXGLQ0uOgHptEo0GbIZJn0LmIAG9L4ctkIogbtVXk+HaoJAfVFbKrsjBxLqrOpjwUeHGQliKsvgCJs7GyFCSIRQWRKDeKyAjBE3zwcGciwAbztkKelpinJUJDM+yOCXr1EFbay0qpUDHny2Ik9R1vbm9ePQAB+bTEykhUSaJoEsiWj5QY13/0Yq9VibJvr838X04QHgjsMuBdOoP6K5yDgFoGoLGU0EiOhmSHjZhsgs3isCnj8xfjJJq+HMrrq2nybcjkaFSaRYjSGMVJRGEiKstkFaYzClPpRcmMvDhaVhSZFExE+hFh3ribJXK1Qi4WyNkSOYJYYPYWyN4CR33TjLoBVNFHFHfI2gchWzcdeBQczv8Vbv72bIHEEr+7nFgvq9iyui1bEwmCy5vEPL32aG8AtEQHih2AMLEUJcPXw70DY+FtOoMFP6ivWwIIlIyBQZaxZPj+SvUk6iz5OglGXJztwZdPiCATQ1BqMMqKoKWFoYQgFBeCxQej2AAU5YOCPZCPE3KzRXxrZG2MrIwwEAsj3MwIMzXETSghUc9KVD9ICtukfZNQTLahkZUyXCX48v9lXyGoXbbEywolgeb/bv6Na10OZJajntcwvQ6elimwpD5QM6FTdQIZBlNNhge2lwUCPEI0MH84JDV/YfRXleA/GLSMEXwXG+fpadADPeiJwawEX0aUFxHtQ4/wYfi6IB9nzMsRudjiQBBzY9xAn9TVwTU1MU1NAkRNgwRR0aCBKGvQUPcMqhtkJxXT88QGsTlGUkpAHw74hX/0PvCmJEdfNs/LrH4z0nnzSf4dl+XjlgzxG16MiqfoOCYnTdNVVlSk0azUFR105ay1uBrSNCmKUOD4wRCSQB0MzA0VeYGTfa1jy5z9vwgLMXTUpKOD9UM8WH5OmJ8T7sMn/dzYjra4gw1hY0mamJC6BjQ1HToU/2TVGNLK+JKQHGWCrYSzFUmWEslUJFDLODBIJk+skFNpZOfJ5clTfp3F4P4NoP+7r9dZImUqAaylLInKlZb17s3g+G+O7D88ILaUXvxlh6g4C9JXHNeQYxor8UxkWR56vGw//VRvdR8Tto0aTYmJJB4UOAYALekjRIkQHf7zBgYdio0udip+rjwXa+RkjeytkQufYW6BTMyRrjGmqo/JapFcNYKuTKMpQdUSlwihgIHg8ghTwJA8QjWDWHWvTGWnnkswg6sIj4dBUt7p/771b0EwXCJFsaUwBHYkRWL4wJv0/l8JxP8/QEAfNoarMZGDJs9VnS7w1+vJsmtJMhHHGibxZdx1qMcJGJE0iGBfZzegd2/C85+ehQJfXgo520s5WCO+A+LzaebWyMgK6ZgjVRNMVg+xtXBSHUMqOFLGkNJfoogQiMJf0jyFV3YpBsfL6Zky4ZQYBnSGBPJ1+ea/UwRJkgmUkRgjibVeVpZljZO8L/nTP7p5sLV/YxA4LgBIh4n8TeQKfbVmy3xmBM5rSz0nCvn9GTaiQHV3LboSFJ4wcHNwfRQay4HrP3wFDTHoHHiMpgZ0N1fS1haZ2iBLR9zQjtSxJlXNCWkjnKlLkFoErkEJpkQgRVwCEwboAHck0rOAEgV4fJr7UkxIY7N4S+mnJG7+h42qqi9twB0JcSTP7U0vKwmOJBe9fIq/IfUfAC3lNAAQB8M9dOVTXDXbk8y3NwVtqw7Y1xi3VRy+vsp/PNcqx0PTTFEGqk+gjgwmAbEr5ISS8/8DQJR1YsEhKgrI3Z3twMdtnBnmjoS+A0PbjqZkQZM2oTH1SUIHx7RwQhMHgAglAlfEQUC5JPqFQTbaMcnqmLTWtWHJqKqAo1gq08H1UqGN5M6BKcsq8+YNSy7rH7f/oDqDDp5Z8sApg0M9fFAUFrinpfQEbAllaqVYSJmJvI3lKwL0akIMZsuCDvZlHBnIONyTerAjcU9zzPoqz6ZYO299dSngD7APTrPkySRGDGz2clEB3qTSxqXnTD02hJxs1X29pVw8ka0LMnHCdO0xBXOk6MCRsmCTRjRMB0PKiNBEhDqGq2C4IoUOCOwQSjjqnKTHFSBHX2gyyQFA8CSp0udfbT9ZWSiKc6ASJqkE/78A9B/oUL9Ql7pEkdc3IznNEmRQ9WADXmySrs7G3XQ42Z56AxlOI7nO21viDvYkHR1IOd5Pyb6WyFkBvzrIwEGRAIZTuelSGg+1Orh/aYgLYAeg/qsTtxSnLUXb8BaGVDXpTl5sp0CauQ9h4YabuNKVbJCUBU4zJpEOohvSgUdAoiWAlkgkD0b6NUaodxoX98qEJGopaMhSJRUupFRU3ROwl9Th30w7/1tl/ptBfwOI8sigCgji8yVMJDgtBcfwHeC46Ighh3BTDkqxVe5JsVsvDl1fE3x0MP3YcNqR/qTdzWF7WyN21AUtFHs3hurFWvMctdkaPDpUfKGhwmES8tJMBR6HzcChuSKpUsElQYlN8hSoJBtDugY8nxAllxC2pQ/dyps0dMU0nGlcG5I0wZEeRjNiUAABOmqgX0vQyEG4AbLkyPqnUPOQdFSaqqK6lIycFIdNZ9Kps/N4PEVFRbAykt4efKskSF3W+WVoJIj8oyWmdOh1QLzUBQPDDdk+nAOiGQYEMpgUgYNZNKajDAetvjSnWaHHnvbEA92pp8dyT49lX1qZ/86akrvzFddnig83g6JFdadZJ7uq2KgzNaToPBKpyzOVpEh1OZaxjpKmqgzABEVOwJ8JqQgVZ1OPAvppUP3w9pL18mXxvTl2ATQtJ6TtwZBxYhCmOGFEo+kzcG0CU8UwZcr64DIYxsNBqB05HI1M0Zv6GHFZytr6ClDW5HKg8kwCM5WVlSX2WBL4Uqryhlf6Gzr/pVb/94aE9ks6RSKCDpkEnJ9BkFI4UmEgcwW6mzo9yUa2M9F2VYn3vp7EXU2JJ4fzr6wU3VhTcXVl8a015bfWVL4zU3a6O+tIZ/y6Mg9wZ2EWMoYcpMND1no8WwN5E02OpYG8mjyhociR4dC4TAYUqYBNr78XvLYCcnJhewRz+YE8K2/cxJvU9GRJO9CQIcIMSFKPztClAzqUeQbiADpS4MyhTUEhhaCdVlaHAiJIKR4GHWAGHYc7YIIz4/EkYZ4EneXtf8Yd/wMkSrWotArsNKVUwEY5klBjklYyNBtZFGejUOip1h5nOiv0WqwO2dkcf2qo8OKE8MKY4M5cNeByY3X5tSnRjVUVV0Zzj3XGLZS4NYVq5zjJp7mqx/A1XAwYnpbygU4aVjp0OyNpQw2OPAdJs2jQzOdBvZcyqRRtlTXofD9Z2yCGiT/LwAnZhchqenCk7OgAENggoA9NQ4IOohDhQmEJo4RLIYV6e7nQHvENRkZGGlDcWDJqCCryS91LDGyzJDsFNi2r0v8Kbf4ZIok7WWpDcwikycFslWjemqwES/lSP8OORPuOeMsZgfeuhtg9DQmH2zPPjhTcXlt1e23Fu4viu3Pld9ZW3Jotu7W64tZ04YXBzEONsYtC38lcflW4dqanYrKnqo8ZM8FHK5Sv5O+oZGsopaVIKnBwHoOU5VK6Bkkl3ImGIh4cqBQVq2rpgCzd6GaeHDU+i21Nx41pSAfDVBGhvOTRZZeIA9CwlmQJI9Tewi0Xo/BYGD5AxRfAFjaLxpWm4Fj2XJI7lxig/3fleg3o0pgV2KfjSEOacNZkxppL59jLNkQYtcVZtcXZjKS7zZWE7RAn7K9Ludhbcn265PYa0c3VJe8uVj/aWHVnrQhgeryx9uZM7vXxghMtqXuqI+eF7qN5NrXxBlVxxlmBWjGusgm+al7WHEdjtqkWW0WaVJXhUL0gaKWRmAzCHFS461qTX51f+fXNzUFxuioWSM6aoCy0PgSmJFJBdBUKIMroUADh1FgggFeCUU0VJiphhYVIMyEThKK3FBMalRwaRG3/vAFjqfCMCjyovHHJTSyJJJ1cqqK/zkGXRvMAHaFvLEUgQxkUaMzOdFUS+mtWhel1xtutLAqYKfTbWB6xoybmSGfmuZGi6zOVAAcAdGdt2YOFqnfnq+6tKbs7K7q/tvzh2orbq4qvT+Se7k081B65UOaxIsemLcFQFKxRHKyZE6AZ6yYXbCfFN2IbqDAh45VjITkaIhkwjIAVbck7PRL/fKP444ni+zsa5A2RlDmNDnVBQzpEQAAQkkYSu4NB5xha65BpAUb0pYitqgxPT0GB/iwdTTYoGItJSIGv/OdSMgWZpHguGbbxHzpF1R+pehVV9FiyN5B5goXnEqQiE9eHnEgNB2Nc7qfTFmM5lMafyvNdrIrcUBa+oybuRHfOxdHiq1Nl99bV35+vfri++tGGGmDNs411zzdT8nRjzb3ZUgDo9qqiy2MZZ0fS9raGra/2mRLwh3IdmlMtGlKt8oI1U7xV/G14Zup0JS5SV2ArsUAjKB9c6Kx0fSjuenf8oAl2rNiuWehF1yQAF1wDISVEaiNC4bVhBoCANRjUCyGfgU9CsFxSgHIzaaHBHAtznrIyT0aWC11widv+xw3unopQl2Q59nsd4Ejq9iSDiZPwRQo4UqcTRjzMQZnmr8dKtuZVemv3xFhMZritEwRuqo7eXhO3rynpUEvquYH8ywDQhOjeXO2dNVUP1wM69YDRs021L7c1vtxW/2yT+OGc6M6M4ObKvIujaedXpB0fiH+rP35/d/R8te9EicuKEo+2LJvaBLPiCCN/azlLDaaiHEtXgVTmcTVZ+Fyu6/3+6Kt1Yatt2Tsd0aNVBbp6ckidS7l2TTqujmhKEHG8ZtAyQBQ6IEXZtPQkWmyMrL4O0tSSUVNXgjgF9Oh/AfQfdR8MajN/yesAEIOwWJZOqtGRqRTmpEiPNOUm2fByneTLvZQ7I40nUh3nCny3lEceaEnZVRN7uifvbG/umZ6cs70518aFt1dV3psTv7u+HgACBgF33tsKAkhV3V8jvL268PZs/rWpzGvT2efHU8+Np58eTXl7OOmtgaSdndGbWyMmSt2GSzyy/LRc9UkNVRlFFtKQY1krkttFPmdrvM5W+j9uTdjnzHoidlnfVYzJ03B1OlKnIRlEuTCI0JcUDXEpElGVOijHg6QlkjCMISaa5+ElY2GlAgyiQaqxlM3/jzxL4repni/VvPoLIDZGshEhTRKqbJqRDM1eGQ/WZ6Za84rc5cr8VOpDNHsSjKdz+OuKfdYLAzaXhR1pTzvYmHBpqOjqcNGVocIrQ/k3p0rvzVY939L6bHPL863NL3e0vNrZAvQBgF5uq328WPlwvuzhfOmN1Xk3ZnMuT6Vdmcq8PJlxZjTpwnTu8bGMtyez9/bE7ulLHCzySHJT0FTiasux1HlElKPG7sawHcWOJ+rDHo7mvNuWdCVF+cViNUcGIQ02AMRSgbyUoHy8xJHx/oIJ6s6AVFQE7u+P/AMIL1+Onv5S3RdKLoz/yaC/1IuyyeD2wJgzCQSiQJKqDEJXigQv7qVNjzFjFbjIVQWoN4Zpt8cY9iaajGXbzZd6bYVgpy5qb2P8Wy3Jx9tSgTiXBvJvT5beni67s0r07rz4ycamdxdrgUHPtza+t7XhyQYxQPN0YzWoG+w8WC96Zyb32qrMixMpFJWmICxIurQy9/x0/rmVeafGM46tSN/UEVMebWCuztHgIiMleryr6sHuuDNdsVcH0y/0xtwcK7pXZnW7yy/K3wipssFIc4FHSjgVRlOx4lKmuoTUUkiNABoUGsH09EF+wUxLK+6SWaGDlv0vBklR+QEmTeIyNEyBgYEBVmZiIFocZCqHu2nSQo3o6TYcoadiY5huR6xJd7TpijT71YVui+X+u+rD9zXHHmyJP9KReqAhDtCB+Phif86tieLb06U3VpaAz7q9hvJi4Mvuz1eCF3s4X/FgXTkI5cjmK8Dx310Q3pkrAmiuT2ZeH8u8NJV1diLn4kzREkY5p6ayDq3IHCh2DXNQtNVgGMujpjS7Y/0Jl7sTrnfGHBLZ7ylzutsSeqPFsyHHA4iDVBFTi4U0MUhWcY2ldAxEhZAE1iDIP4Tu6Yd5BaCAUKaLm8JSuZ7qhf0vgNQ4JIgml9SSounyaPo80kCGZixLwqW4auPRFsxcR261t2JHpH5/kvVgqsNossNsvvemcoo4+5sodI61J5/pyzrUlHB5uOjCYO710aLLI3lXVxRcmyh4Z1XxjZkSCToSgJ5uqAWBHSDXo4Xqp1tq7i+KHqwXgjG6Nyu4v7ro9pzw/FT+pTWlV9cKL87kX54TnFkr2NgdlxegHWav7GFAa0gwPDec2GiBVnnx1gVLzUWyLtRFX6r3Hq+IoCkzaBqIBgBBK0cHx7UxqJ8tpfWEBCYQ5OzN4Htjrv7IOYhu4yujasQF9wZNcFAhyJ2oxBVaLhStKO3TUGCYKhBQtXFUx21VkaUyMlVAtiq4tTxKtCUz+OxCN+kqP8WOGP2RVOupbOfVAq/NVX4gWyr9dlQF7K4JPVAfeaQx5lhz3PGW+BNtcWd7Uq4OZV8bzrk8kHltOPv2ROGdlYKHs2VPFmofL9S/2NTyaLHh0Ya6B4vg+6veXagELbs/V3pvbfHdWQA049aq3KvT+Zencm+tLXmwWHV7Xfmt9dU3F+svz1WvLA/LD9aN5Ev35bserAur1UczXor7km2255rc6Y6/3BA5XxIMpVWGPptugCMDDNJ6TI9A+gRkZyCEAQOSWBDk4EtaeSD3MKZtIM0qQMrUQ4UuuxQEUpBQfTwKLSoOBN+GzLV5rnrMMBt5X0MiwITuaUj3M+P6G7PCzdn53jIif6XqENW2GJ3RNIvpPKe1xZ6gVlvFAVAY3C4O3CUO2lcbfqgxGtA50ZpwpCkKds50pV4ezLk6nHdpIPvKUO6NsaKbsxVgpwGad+dq7qwqf7im9v6amnfX1d9ZV3t9puLShOD0UNaFFdnXp/KujWcBQJDoX1tVdHe+/NGmmgcbxPc319/b1npjY+Nbw8VdeR6iGLMpkf+uMr8OK3KCzzmUYnNS6PdoJP1sY/COxnQIgmimNEIfIW0GboDhBoAOgRmRuCElpCGdiiTNA5BdMMMumGkVzLAO51oGKauZgd+jUgv6EmuWPBrE2AwIIB2NeJF2UlBCj7UhkhyZiXxOmptcKl+qyFuxNlKzOVanM9FwKM1sptBxndB9sdx7izgIoJGgs6c2BOhzuCkG0Hm7PenttvhT7Ulnu9MAoCujhdfGBDcny+7Niq/O1T7b2f3ets6n6+oerhY/nWu8OSU+018yX504muNbF2Is9tWczHQ61BZ3dSz30Xz5zbWQ7pc/3CB+uq3x8fbGp7vanuzteri789p8467B/J4Cr7nqMLBxV5sjpz1k5/1V3i4KudGTfLE7+tJEFUePhkwQpKxssBFGGGGM4SbLArkISVXUzEKRTQTHKkjKPJhpFka3DOMZOMtDLADDAZhQ65L4dAowFgBko03L9lbO85Ev8OAWeXFFQUoCX/myQMWGSPW2RL2eVOPBdLPxHJs1xc4Lpe6LZZ6bq3xBs0B2VQXuEQcDg95qoBh0si3xREssAHSxLxNs0K2p8jsz1ffX1D5Y1/Rwc8+Tzd0vtwBADYDOnVV1h9vzR7MC8jxM4s0Vky3ks23ly9xV5wU+N6eLn6yvvj1Xc3ed+NHG+mfbW57vbn++v+vFwb5nB/sf7+0/v77p2Kz49Gz1w8X6jxeqjhe7rPKR25vKfzxRemMw5aMtzQa2dI4dnTRFUpZMujmiWVBCWCDcHAMhzShBhqGAEcvQl2nkT9cPQkYhNBNfeRl9BgGVaGDP694cVfqDEb9GSqg4RKc2xqAmTLUhQqMjwUgcqtYRp9ebpN+XYjicaTaWbb2ywGFdqdt6kceiyG1Thef2cj+QHRX+e6oC94vDDtVFHm2KBQN0qjXxdEfy2c508GLXVpTcmxE/mm98ur7t+Yaeh7NNj9c03p6oPN1TsLUmeSgrMN/LMNJUOcZcJcNevSrAZEWG+8HWZPB6t6dLoB4ChZH7C+LHm+te7Gx5sbfz+YHeF4f7P3h74tnxlQ+Prry8uePBjnbIUa52Rb1d6XG2OvTZTNnVjshvtzYFBqlLWSKuPWJZIpYNxrTG6TY4aY1h1gi3pATAQpqBSCeIrulF6PiTWkGYVhBhBOUSV2m2MkQ5f0XHVFzIgF+1ZIgsP/WmFIvWeIPuZNOeFLO2OKOhDIuRDIvxLIvpfFuoHAM6m6p9t1T7bany3lHtu7syQCJ7q4MO1LxmEGgZAHS2I+V8d+blfjA9wvurqh7M1gJM9yarb62ovDYsOtqSM5LkVu5jnGavGmkmE2MsW+xlPJDms74qfn97xpnh/MsThWf6086N5FyZLLg+Lbi9phQwerqz9cmeTiDRy1MTn1xceH5q4d7hqVs7Oi5M5p7vib43lPjF+sZzLSHHK/ifb25z8VRSdUY8J8SwAphIlj3BsMdJOwy3wzFbCiYQpB7OUQ2g64QyVQJw5RBSPZIj54erB7HlzWGiAQAksdaSbgSSYdICrekQhrWlmLUnGnUkGXcmmY3m2o7nWc/k280V89eXe26u9t/ZELq7MXRvfdC+huCDNaESOVwXDv6LgqYjmbLNfTkgF7ozz3WmX+rLubmi+Pa48Mao4Ep/7oXevF3ixMEk9yxrlRANWpAmmWgh3xhmvb4idn9Hzls9uScHco/1pBztSTzRC6lc5Mme+DMDyZfHsu6tK3+8pf7pjvYPDvZ/fHrVl5c2vDqz6eML2+7uHQTvdqjO/2JL6BcbGs80BT+bzXt3cwfHAMk6IWU3JONM5zrROY40hiNJcyRwBwyzpzBCNjAQO1pBL1FBLZymEk4qR3Okgkl2AMbxQxruHCkVaG9QvczXDfClMq+dNsryV+zIMG+I0gSAutPNJwROK4vs1xQ6gN3ZVOm7rTZkb0v0gZaoA03hh5vDjzREghxtjDreHPN2W+LpzpTzvRkX+7Mu9WaDnO/KACqdaU++0pN5uTvjXFvysabo3eLI/jiHFFO5EA1GoDKRaaXcEeU0Jwg+0Jp+vC/3eF/2ka6Ug+0x+1oiKBtX6XWwMfhIa/iZvoQ7s8WPNtU+2d726tDQ52dWf3Jy7pPTWz4+t+3ZW5OPd7QdFPvf7Ij+bLHqg7VVX+/tvrKzHZkiBS85JT4u60xI8RlcZwbTiUZ3IglHHHcgkB1GiVaCnFqMtHKklFKklFwoi+WPM3wR0w9jeSBZRxbkb0sWmsr/oa0CtQsFFs3HmlUSLtORqA/R4ECi8XCq8WS2+boS54Vy/mKl05Ya1x31Prtr/Q40BJ3qijjbnXWiPe1MT/aFgXx4Pd+fB/EhxNDXu3LPtSadaY490xrzdmv0iebogzXh20sCZ/PcOyJtBe766fbyBS5K5e6aAwk203kOe2oi9tbHbSqNXCgJXlvktabAaYPQdafYb3e12756n9MDcbfWFEOs9GCh8smm2g/3tL/a0/ftufnPL299cXbj46MzT/YNXZ8svL0i45NN9R9uKfvpSN/FLf3QCyOdGRw+zrRChC1C1ohwJOnODGSBSAcSXglQMY1oadVoKeVIjnwoSzqQxvUnWD44zRtxXZCSDxfMO5XXUq4MujdUgQy0zEoLpXrQAKDBFKvBJJORVMOVuZZrBc5bxF47G4BBkHD57Kj0OVQfAhnQhd6McxJfPpR7FjgCTBmEqCf3fGvq2w2xx+rCj9eHHa4N3lcVtFXgO5fh0h1kXuokU+LGE7gplHlot4ZZQclxusRvvMC3OsQm3lLDU5XhoYii9FCWKeoIkB1N0NkkcoUKEaADNgiKJE83132wo/nF9s5Pjk99dHbh+el1Dw6Ov7uz5/aM8PFM4ftbmn452PXDnt5NwyLMEOHOdFkXGh2MMYg5wmxwmhMDtydxW4JmTyOtoWQTzdWM4QFGciFMXgCDF8Di+jMYXjjPGbE9EemK2JYwQhGxl6qxUIWEUTqa0ijcBtVHqa/Ish3PsprMNp3Kohi0Vey7pylsb3P43sawfXUhhxvCT7ZFX+pLO9ORcLoj8XxP6rnuFMALXPvZrtTjddGHqoL3VwXuqwzYUeq9scB9dYrjULh5rZNmjZt8pYeU2FulzlenKdS0JtI23lbLUJpqlKvQcS8Lw5r04Fgr6Xwb5nCU3tYqv7PDmaBZL7a3PtncCFnuk8UacP+PNzW82NP33rGVz47P3N41cH9rB+Qrz+ZELzf2fbd76MqKkmAvFcIM0axwjjmJWTMBHWSBIbMlpKxwwoYBgqAsqxTBAvoohnNkApnS/kwpPxbHm8n0oEm7Mkh3xPBHLGecCYkJpP5sahwgkEmOjvzMsPJQ+RFAJ8dmpsBiKstyQeS8pcYfWlfQKT7UHr+vKWJvTQg49QPikN3l/iCwc6g24nAdmKToY02x+yuDdov8dpX57hT5bir0WJPhNBZj1R1gUOemLHKUKXdRrPZQhgZGobuCsypNFh4NzoLAVUVayt5Qba5H2J3hvqkicn9tPNTzn2xu/mB378ud3S+2t7+/s/3VtpYXG+vf3VD37raWZ4dHHh0eu7mt+/7WNkhZ7k4JPoAuwEz1k6MLO7fPqVjoQm9HzpSHbAjMGCeBCqbQpYMBDxhmBhVrKoZEvGAS1Irjh7N9CZYXjeaKE86IdCEIFwbhgVMYOSNFvhxTjQv9IMrd05hQ6vc0IsvCZPszTAbTjFfmm87k2a4R2W2o9lusCl0jDJou9J7Kc53OdZvJ91oQBMzmes1kuszleS4W+qwv9NxQ4Lml2Hu70HtzsceWEmp/fZ77bDp/PNa2L9i4LVi3OcCozldP6CordJfzUkbGbJxvYES1A6mSFgq31l1Xm364N/fKpOjCiOD+urp3F5qebm5/uaPnoz39n+7p+2hHx/ubGqAp8mhry/MDAw/2Dtzc1vlwR/e7G5tP9WddbEvY3JSytqfmytsnvvn2+/0H3kIcBjKSYRhymEZspI1wXYTpI9wA4UY4BNOIE0hn+OI0L5zhQzI8SdwFIT4iXAnMg0W6kbgjYnuQDBc6x0oKElhIYwEgDs5wN6QLw7ntyZo9ydpjuQYT2dZTJTZjBa5NUQ65rrpZzuqFXjpF3voFboZ5DjoCZ71yD4NaP6Mmf8NGX+2eMMOZTKc12U6rMx3gFeqhs5kuM+n8qWSH0Vib1iCT9jBTkbtskQsz01rWjoacleUKolxjA22s1VglAe7rKwtO9VXcWln9zlTx3TWlTxeanq1vgcj7412AzuCH27rf39jy3mIDFLYfb2l+uqfnzo7OW9u7Huzpv7+t83Bv5kS6f1tyUFtGjDg1ZLin+vmzJ1989ouZkz9DTUnHwdzcw9rA1RByNEIDsQxoNEhfGf5Muh+D7kun+dAIAMgdx9wwEHgHc8LZrmzSDZcOYSn4SUlrEVSzEsdYiOmiSxNFcpoSlDuTtQYytAZSTGqiNbKcld2VGUYkMmEiCx6CdrsR5IAIGWPIikQ+Cli8ISfDjFPiINMWpDcUYzoQZTwSazaeYDORaLsyxQEwmk51nExyawvVEnnSCxxYYUqkC4k85fGaOMueHI+R/MBdLYVHO0puTtTcHC+F/Pbh6oqXgM76lg82dny0vffjHX2vtnYBQCD311a+u6Hh4fb2G1tab+7svrdv6MHeoeOT5aJg8xJ/vjgwsDzUJzPMvbWk+OWtB5999aWyli2iKyGcqWNqEJsZ7RbKB7oytaB270Mj/Zk0XwbywBFAA7M03TDkjAg3RHejkc5MgIzmh6S8kLW/ZnpyBKT2dDBtqqgqUaotRa05Xrk1Qb4vxaTYXyXEkGNKx6nSColBNwVGIalRj4Gti+F6CDlwUbg2O1afkWpCE/Jl2gK0W/21OoP1+iKMh6LMAKPVGc5ApfFY675YrXJPermrSrKWjMhOry3UfCIXPHrcgabUw+3pe+qjIDh8uyPh5orSOyvET8GgzIqfzTW8XGz7YEvX+5s731tsgUQX6pP35mvubWq6trHp1q6eO3sHHx4aO7/Ylu1pmOZgmePolO5mIQh3Enq71iUnPv/00Ycf/kngehiuhONc8Ni+4X65ZdlURRG54sgVIXcMeWCYJ47/JdSboG7uiElZboa6J903Sq2i1B3GqVAjAjAkjDRqy9Hty7UcTjEbSNMUenPcNZlGMridIuEkQ3NTIsJM2HHmclH6zGhjTpgBLdqMnmzDTbFkR2ujOC2U68TId6BXuEq3+6oOhetvyHXfVuy3uyx0c3HofI77WKxpvYd8rZfKSILd2mz3LQW+WwUBO0uDD4qjT7alXuzPuzpaDDVsKNQ+WFv37rqGJ+ubXm4C89zxwabWJ3O196ZF70wVQXPt1lzFxVnRpYWa27t77x9acfPAaG2iTypfP95aI83JINPVKsPNJdnFq6Og8rc/fnn23qdLQPBgRAr0i6ydDQvFBUjCGolQ+8vihHA+onuQ3ECObBBHyRM392YER6k66bFA0WRxWqSD6kCxzaTQZiLfZkW+rchPPcGO62+AIi2lc/lGDSH2gxnuXRku/elefZne9TEOleG2wkDTDAeVWENmuCaK1MUTDMhie16jp+p4nMUuUdDxluS329KPNme83Zp6tDFmbaYjWKv+CPPpJAcA6GB55FtVMScak893Zl8bKLy5QnhnouzeVMVjsNALzS82tIJyfbytcwkg8f1p0Y2VAgDo9rrKq2vKry3W3t3b//Ct8TsHx95e1VgWYhViKBVsKBdqph1sahxh5RBkan/u0Pk///j5vfc+oWH2NBrcH3CHw/c2RxRlPAjABXfBMWcM7A5yxCAZYfAZNEcaBN3g8mUDGGr+NDN/mnuoVHaoupU01c7WoqP+AreZcuu1YpdJgWdbkkNtmEqxJ6sm0rgt1rY/zn40w6siwjrL1dhfV9pJgQlDIK2lSB91uTBd+WBNKT95mr8sSjVg1riqzGbxjzQnXRsvhdLP1aHSd0ZKbo4KII891JCwqyp6V2n4/rKwQ2XRR6viT9WnXuzIfqe/6O6o6OFE5aOp6ueLrSDvb2x7tbnjwy3tLzc0P5qtvDNZAnHzrdnSm2tFV2ZLr66vubu7++GhFfcOjt7b3rm7N7c9xTVQj+2jLR9gpO+rbxJoYpcXkvvnz9//+88vX332q4FhDI0tDSEfT14OER4E5a34BGFP4DY4Zg0WFSIlSLqYmA2JLBFpj+R9CMNQhks0NyRBviRZrchRzQ5GHhFYno/huMh2dZ3rQkXoikLXzgSN7niDrkTL/kyrljjLAF1Z6F8yYRYBQcVP0gxpHsm21taGIaQArocUFiCH0o2ZDb7qG4p9Lo8Knix2P1rfe2+q/u54+YMJ0YOV5XenKt8Zq7w+JLw1VHKlu+hqT+E7/cW3hkrvjpY/GK94d7IKAHox3/xivgnkJWjZ+qanc+J7K0vfGS24vCL36lThtVWCi6uKL89V3Nzeenf/wJ39Q4/29709VbKvN31FnnegBuGqxDaXlrFU0lJE2g9uPvjlz0+++PHfT9//yt4+BfrpdLYiovFJyDsgpsbNCdyEAOePGSMorFGlNkscqiRyzkgvgGYXxvCJZEZEs7ISZLqjdbN02eE6ykEGMn0Cl7XNfttrwkZybLrT9KEAMprlCEMvLBWpmEVPhquhrgrowMhLKZxto6lfGh3hqiLtxEOFDuoCR6Uqd6WhWMMNJR4Xhgqfbuj9aNfqF4s9T9c0PVklfrK69t3V9benau5OiB9MVcHr3Ql4/UsmK+5NVYI8X9vwbE09yPO5OpDHqytvTxRDkfvScPaVsbzLUwUXpwspgLa23N3be2/fwM3dPaemS04Mphzvip0t8PBXw9QQ0pXiyTAMmpuGfvvzjy+/+/Gr775/9PRDO7tkhPOgJoTDQCsox0JNH8Z7YloQKWEEeB19xLTE1Zzppr5MfjjLJ5IeHkkkxdBSY9mtSQpiPrPGw8CBjdqynNc1BkJxY6LQpSVRuyNZpzlSM0CLMv8y4AlNVLPiAuyM1KATrclGmX52jYmeA+kes4KAlWCJ0+yHYo3XZtntrgi6tkL4fLH35Zbxj3eseH99x9OZGrjnFwtt765pfXd14/0p4IX47lT1ncmqu5MVIADN/ZVVD6ar4cjH09WPpyufrKoCdB5Ol90eK7w2mH1xKOvSaM7FibwLKwuuzJXd2tJ0b0/X/f399/YPX19fe2Es/e2O0IP1/pO5rol2alCbh+YEHel+9dVX33//21dfffH5F98eefuGvkUEBQeAAl1qGCVMdYJUqA4RoYMxjZGKNWHMpzv7MfwjGaExRHwclpXMyI5ni5JZ7XEyXf6qoYoo30VpHgrPbaEzFV6dSQYtkUpCdxkHFgKEYyw1K8PtelN8Jwoi+9P91ouTNtckQLt5Y6HPVJzlVKoDRNXbS/z3VQQfrom63F/wdL7zxYa+j3ePf7Sl//naxhdzTS8WOh7PdwCnAKlHq2sfrlqi0nj5nTHRvTHR/fGyBxPld0eEd4ZLbg8V3RktvjdWfGtFEaBzqTf9TG8qlNNOD6efGc+5sLrk2qL41rbWe3t6wAadmSg80Z94qDXwcFvIjrqAnkSzEk9lT20OJDSndt/64/dfP/roqw8+/uzc9ftN3RsQpg4pIE6NCeZRA2QojNQQqYUpm2J6loStI+HlTQaH46ERKCoKpcKMojTp/ExmYwavL1iuxkkqw5iYK/OfqfMZL3MYSjFpDVRMMiYSTVR74tzXFPjM5YWtLwnfUhF7oDVzszhqoTRoXaHPulzPxTzvw3XxG/N9NuZ6H66MPlmfdKAy5spg8bP1bR/uHvto2+DL9a0fbGh/tan36fquR+va76ysvdSZc7Ez60JH5sX2zEsdWdc6c2705N7qy4edy52ZIFe7s69D9bYPakwpp9sSjrXFHe2IPdqTcGIg9fREzoVZ0dWNdaBoULq+NiOE8bOHeuJ3Nwdtr/Gay7fsCZVrCFR1leW15g/9+e8/P/jo81ef/fTwvU9Xrt2NqFH4YDapZis1sJythuR1cDVDwtYGd3YifD2IMH8UE4SSwlF6DJadQBPEIZCadG4zBIohnDZ/7mSmyeamwN1N0bsaw7bU+29rCtnXnnBmpPDiWOn+xqSDDVGQtULRfkel31ah14ZCV0i+dleEHKgK31setKvU/4g44kR93KnGlEvdRS/XdX22b/rDbSPvb+p9takbMAJFuzNSer4t83xn7pHKmM0ZrgsJVjsz+YcFPkeFAccrQs40Rp9tioHKCZQH3m5MON2WdKo1/mhj5Ftt0WBljvXEHeuNf3s45dxk7tU1onub6u5sboBGI3T0zw7FHW0P29/gv6XCeSJdpzlcvcndrMAl9MfPfvv6269efvbh9Ufvr1m/h1IuEGghMtRIaS1SWY/UNaYZmpJOdrinMxniTYsJwhNDURrMyYslC5PogkS8JJUmSmO1ZMj1JCuOZ+h2RatubfCDGujh7rh9HdEHu+P3tybuqouD+taemqh91aFQkN4Jdfsyn63FnpsK3baV+OytCD1YEXagPPRQZehb1eEXOtLPtmde6Cy4NVL1auvYNwdnP989/nKx6735NvBWN/tLnkzVvruq7sZwyaHK8GF/rXZnmdFArclIw7lk293FXnuFvvtEgZRUBB+sDoPy7gFx8P7GkCPtUUe6Yo50x54cSj49lgXt6ZsLVTcWa6BVfXokEQA63hlxuCV4h9h9JteoI0qjN9g228Hn+e0Pfv7XLy8+fAkALWx5C9EhHVDHIM9S0GVoGtCMjGmWpoSdGeHthAW5k7H+tNQQIjMc5USjwgRaSQqrOAkrz+YIUsiKNHZrusJwpk5PrOraYru3uuJODaWdGko/N5p/aVx0bkhwrD0VWj1Q3DhUGwa1DuqiK4P2VQTCPRytjz1RG3ukKhJuGGA635l1tb/wnSHhw6m6j3dMfntg9vMdYy/WdT5d3Xx/rPreSOWr2TZQOrBBe8vCRsKNBoJ1Ov3UKuxYlfbcvkCN0QjD1am2UFEC6KFIsK3Ue7vIe3uVD1TED7SGHu6KhN78ieE0ULRLMyVX11UCWADQueH4t3uij3WE723wWSix6k/QWRHrmO/odnr/OVjz6r2PXl25+2z7vnNIXg9T1Eca+riBIQ1ml9mbYa7mMF0ThbqiWG88NYjIDifyI/GCWKIkiVmWxq1IY1bmcEuz2cJ0ljhDdqbaeihVuzmAd6At4sxI2uWJ/OtT5fdWN9yaFMOIlkuDaRe60891Jp9pTzzTGneqOfbtpphTTfFnWpJPVEfvLw5cSHVak+SwuzTknaHiO2MVT1Y3vL9+6Iudk1/umHy1vu/Jyqb7I+In47WfrOsCm31toGhzvs/adOe1mS6Q3A7HWlQ5y5XZc6r4vFY/9dE405kM+9ks+9lsu7k8RyjIUj2VhoD9baGHu2Pe6ks8OpR6aiz34qzw9HgGjMgDgE73xZ7oijzQ7L+5wmE0RX9FnFWpu+veNTt//OFfH37++cXrj/cdvY7MbJlm1nQrCwKm38GMTR9rFGyHwhxQjAdK8kXZIURBFFEE6CSQpSnssgwpcGGidG5ZrowwW6YyR6kuU322ynFHgz+4AyDzuZGsdyZFD1Y3PlhVS/WRJ3NuDOa9M5h9pTf9fAdgFH+6KRbsBdDncGnI+mTHgQC9Ng+1VQn2oGIQDd5bUXZ/ov6Due4P53s/mOt6tbbr2XQjAPTB6uZ7I6Kj4jg4cj7Tc6cofENRwGyWx2CUZa23WpmLbKkjt8ZLvjNEYzBWf0WSyWSaxbpCx81lbtvE3rsaA/a1he7vjDnYmwCj98+tKjw9nnZqOO7sUOyZ/riT3VEA0LYql8lU/eF4Q7Evf+vYwqeffPXpl19deefR3uPvIFdnhpsjzcMe97FFAbYo1B5F81GsC0r2QZlBWH4kIYgjAR2gjyhduiJbrixTvjRdtrJAtVqkXSrQEuZqVqZpH5zM2N0UDlp2YUXOrZWid1fXPlglvjkuuD1VAH73Fgze6Ms4154A9DlRBylV2P7S4I1pziNB+utS+TuKgw5Vx4AjO92YfLkt80pb7u2+ksdjNe9NN70/0/JoQnyjr+hyR86GDLceb+3RCMudosg94vitoqi5Av/xFOfOWItaf+0SF5kyN+mmIJX+WP2xVPPpTOu1+bYbhM6bKty31njvbAzY3Ra2vzsWSHRyIuvkaPLJoehT/VFn+mMkAO2scV+VZjwUr9UQ6LixZ+X7Lz/++PPP7tx5vuvYNeTnjPvzUTAfRTijaFcU74YneGCJnnhGIMqLIIvjGECZ0lRmaQa3LEe+Il8lJ1VOVKBZVqQtKNHOL9fPLTXMyNBsFbtcmhYe7oo/0hkH4dndlWV3psqvjeTfGKcAujGSB4HJ6ZbY4/WRR2vDwZpuK/BeFWPZ7q68SxgMUd/1QQF4qMPCsLO18Zfqk86JE87VJV3vyL0zUAxOfXuhz0SksciSVctXmEpx2Voes68x/XBH7u6GFBg83Jfm3BJtWumrIvLg1QcoDSQYTmVbQYVzrsBusYS/KOJvqHDZWuuzozl4X1cMMOjQYNKRgZijfeEnesIlAEFAtK/RZ1229UCsWmuow0RVxwfvf/bZF5/fv/d017GrKMQFRYC58SRSfGjp/vSMAAZIagA9J5QsjKaVJrLB7lCalS1bUaBUKVAvFGgLBbolJXoFIoPoArUYgU50lkZyps6+zuRtDWFgicC5nutNvTFWDAIDf64P5UHkBrHJ8aaoIzVhh6tDdpf4bcx2GwrQFdtw5rPcrw8Xn2rJOFwetTvXd1+O90lh4MXqmBOi8GNlkadqEzbluLe4K5RZEu3+2gMxFvPFQbub0o8NFJ+bEJ8cLt3XmjWa592VZFfpr17gxCxxZbWEqaxIM12ZY72u0B4AWl/qtL6Mv6naE2afAUDHR9L3dMcc7Ik41BV8rCsUAAI7fbgt6GCL/6YCx55IxZ4ofkdW+ccfffXl11/cvfPurpNXwdAQsBJDuh/0lPHcACIvEOUHo4IQlBOGiuOQOEumsVCzvthALDSpEJmVlZsXlJhlF5uki0yTysyiSgwjBIbhBfrBOdoFpSbV2YarK1zBGB1qCDrbGgWDus52x13tTbnen3ahPfFsS/zJBqjVh0FNeizWsjtAVWSF1/Ol1qbZb833mo61nIwwX0hxWcy33Sbw3lcWsyU/dCrGQWTFSVRDde5qUyn8eUHI/rbs85NVF1aKrk6Xwcjhg/WJ/dlBRR7GhZ7qhR6MqgB2a7j6QJzxeIrRdJ7VgpBi0JzAbrHcdbPYb2tD2LaW6H2dkXta/Xc3exxo9wGMjneGHWoO2FvjtqGQPxSv0RPsWB+c/NMXP7768rMr77y7c98FlO5PZgbQcgLIvEC8IBgvDEVF4agoEpw6Kk2lV+cp1pboiEXG5WXmpZVWJdU2BWWW2aUWGRVWyZWW0SKzSKFpeLFxaL5+UK52fJ5eban1XL3fzirvt2oCzjVHXmlPON0ccb497mRD+FFxKPR5dpT4rs3k94TqtYVo1ngrifiyeVbceF08WotINOJlWqlUOMt3hRsOxVnVe+nFqpB+TFRoJT+V6byhMvzUoADGwUBUfXGwcF9d1MpMfkuQvosWx4iGXOWQwIUj9mF3RWh1RGgOJmlN5VisLbKfL4GWLLR8XTdUeu9ojtzSFLmjIXBrncfWWpedjW77W/1Bv/ZAI6/CcSHfridGZSDCsdg18tfvf3386sPb99/bue8Syg6i5QXTCkMIQThREoWXxqDSOCRMQKIcTkWBfFWxRqXIAIhTXGVdWGNXVOeUX+WQVWWXKbZPqXWIrbKOKreKLLMMLTF3zdZ3L9CPyNfpqHRcX+W+u8rzcG3gqdqwQ9U+x+qD36r23yfy3lXivbnIczrZus1fo9FbrcFLrdZLp9hJPUydZkNDsMqBDRM5QiGTRM50xKdBrQX5SWHd4fa7a+P2d2Yeas3aLoici3NtcVISmjMyTfCGMGNrdRlIltLtNXviLdqDlYfj9fvidAfSdKDZC+3M1YW2awT2a0v4ME1oe1PExvqQzWKfDVUAtwNgtLvRZ28DDH1z2yC0WZVp3BGu1BNunWkV+OPX3z559fmdBy/2HLiOJMQpCsNKopAoHi+HCDCdVpHFqBaqVQnVK0r1SkWmheUWgEtOjVNuvXNuvWtmrXN6g0tqo1tsrVNUtWNklUNomY2PwNa50Mg1VyMrX3e0wm6h3HFrpduWMpetxQ57y9x3l7pvLXDeVOCykMeHgKXeU6nBU6nRW7010LDR36SYr5NiphJroBiuIx8iS3qxSUccc2XREvTVWgKcxmIDBoM8u4Is2zyMRQayWQooTwsbirKEQTDjhYGxNga+6mwY9bFQGjCVaT2ebgad3tEMw4lMi/EMczBGM4X204WO85Xei2K/DXXBixUe82VO8yK7jVV8SMQgDthQ6rCmwHQ4QbMpWB56KokmAZ9/+OHzj769/eDpgbfuoJwgyugURaCSeFjpg16Rzaks4FUJ5MVlesAdYalJocgsr9w2q9Ixs9o5o8Yls9Ejtd49rdEzqckzutYlosYlrJofVG7vUWLrKjDxLNINzVGtKTJaJbCZL7ReXWg5m2G8Lsd8PsdqTYbVbIbNVIp1e4hOKV+q2IUFNWmRp1xXnPl4jsd0QcBEXsBolt9QvGNnqG2dtwVIo7dJo4duI1+zwUazXF8xgYOi2Gg2PaCCr7ZQFrGzJasvxSfHSGE4znm7OHpDhR+MbJstspnOsRxJNprMsgSMoK85lW8/WeCwvtp3usRlsTYA2DRbbDtbZLVOaLe+zAXs1HSO+UiKZmuobLUPt8ZbJ87A/+MPXj16+cXDp+/vP3wT5YVTa58I4nBhCqMsS7qsULG8WLOsVLdMZFYiMisQmueW2WRWOGRU8dOqXVKqnFMbPBPq3BIbvOIaPCPEbqHVLoGVLr4iR0ehJb/AmJ+j65qsEh+n1p1uOp5kOJaiPxynMRKvOZZoMJZotCLRtD/WCMbA5toyM62Q0I3TGWswW+i5szb6YHMaDEwYjnOs9bQuc9TNMpQqMpevttOqslGrtuIJDNBYsMva1NDpjJDLq1v2deft7sza2ZgVqYyviXMFw7+7OmhnfQikysBcuOHV2fYwHGcq1xqGuwE6k0VOayu8xmFkV7U3ALRaQHWDAcq1AqdVebbDSbqdkXIVHvC0mEW2yikWIe89eXn/vY+evvx476ErCILA4iSaECKdbGlhvoKwWFtYalZcZpVfbplbZpVZZpNe6ZQmdk2tdUuqcYmvcoqr9YwRu0fXekTVeoVUuQaWufiVOXsKHTyKLdyLrL0KbX0zLYOidPJjjBpj9DsitNrC5JoCZTrCVbojtbuj9JuCNfMduMnmeI4VUe2lPJ7hvCiKWJUV2ORrlW2sFKlAd2Yhbx7mz0VRCvQERW4wE2XqyK5I8DjQLdjckL6rt+jK5vYHe3oPD+SuKwgaCXfaXRp7oCbyYGP4rrqwnbVBGyqdFkrtN5Z5w1gBINRknj1Mu58udZ8s5q8s4a8qdQGAZgptV+VbzhTYrMqzH0u36IxSqQtgFznihS54qpFsgUvsvRuPn33y2YMnL/e9dQmVZ3DKM7kVOdKiAgWhQL24xKhIZJ0vckgvs0krt0mucABckhs9QRLqXGOqnaJq3COq3COrPcKr3QEdX5Gzl9DJrcguOM/KI8PcPtZE30VRDqZ96KF4P2VxmHaVD0vkSoi9pRsDlRqD1ESeCklmWKQeijNFBW6KZYH6GfZqrrLUoAFTGF6BU91w2IGBS8HSXLGLaa23QUOw8VuDxSc3Nt0+MrZlKO/S1sZzs6ViHyXoU5+sy1xfnri/NWkv1DeaEo+3x0NMvKXGGZz6hnKoW/KBPlMCl9XlXkM51msqPMYL7VcX2IPxnsgyWTJSlv3xBg2BPJEbyrfD0q1RioFCsVfC1Yv3P/rum5v3Hh84egFVClQrBJqlAu3iYv1CgXFOsWW20DZTaJ8otspscsts8kus8okp84yt8k6o9UhqcE+uD4yp9g4UOfuX8oMr3EA8C2zskw1sXLR0LJR4mjIsFVmusixMO9ZTYxQmeuR7KOR6olQ7VO4i3+KhW+stF2uGAs3wEGMUYMTQ41JTj9iIBasW2ctJBSpLwSCLBDM1GItY7Ku/2Jy8pSN9S1fW2XXNFw633Tzaf2Cs5HB3cZ2LQYOjzglx+tFyqKtAIBNztDX2reboI02Rh2DQRG3g1gqvzTUea0X81UL+KqFrV4rpcLbtSI7dQIYVgDKaajKeaTqRbd6bpFsfoijy4BbwaUmWjHgDlG2rLQjMuXX31U/ffHPm5tNDJ24ggUCnqEi7QKCfV2KcJbRMF9qkihxTypwSxZ7JdZ6pDR7xdfyoKrtoMR80K7zMLbTSLkBkGyhyChF5eGU5mfobKlrISemw5dTZ0qoctqIUQ1aGIUWtaMqlIyczjbIQzXQHLNcBFTrRxX7qDSGGIi/NNEtuhr1UqD7dhAF9cAQFbChaw6j2eL5tfoBpfZrbdEvCaH3IntWC3dOFR+Yq3potOz1fe2SirD2G70GgXj+78y3CkzUZu4vCtouDDzRGQP3wWHvs8Y644x0xh1sj9tQFSgCaLXXuSzPrTTcbyrIayLDoTzUdAbCSjUbSTIZSDFqjVMUBssVurCxbFG9GJpuQmdbaFVElDx998v3X37x9/REFUHqBQXqRYWqxSXKJRVKpbUKZQ2y5Y2w5P7zcMa7WPbbGLbyKHyl2iapxBQHDHFblFlDiZBdnpOogz9XjyGjJyijJsaV5DJjdz2XDqsawHB2TRS3ATTUzYLKMs1JJsH6GFVlgRyty5tZH6Pcn27WF6Bd4yQC5MpyUneQRNbsNoyqamogmiLGuTnFqy3FbaEnaPZQHY53XNCXUpzq0+FlHyqJOT9sjFfk3e+r3FiesSXTZVhSwszb4cEv0yZ7E070wwyHpdH/Ssc6ofc3BG8Se8xXuE/l2jZGagFFfumlPqmFXgm5fgkF/oj5IW7QaoCPyksp3oiWagcoT6VbsDHOdpkzxi5dfff7pV8evPDhy6jaKyzOIzTeKFZjECC2iRNZRZXYR5fYRZY6h1bZB5TahFY5hFa6BQn6g0BnEK9/WwNNQ3lyersGAyTRyWnI8JR6Ls7TKiZQMU0qGw5WWLL8EyzcsrSVFDW8MdjHI9VbPs2YXQ4nLg9OTYDiW6dKcbCSO1K4J0xX4aiY5KIUZ8yL05QOU2V50FKHASTfSyDHXjVaUytZV80MohSc96Gp7RJD1Tov4TGXhpuTAtQku0/G2MLQYBkMe70k8P5xxYSTz/HDaWchFu6J2NwWur/Ser/Rqi9OD4cpdyYZdyfo9ybptsapdcXodMTpt0Rp1oFxenHwXegbQxwQlmZO5DjIZ5gZdJS0ff/rji+cfnbzy8OT5eygiRy8y3yCiyCi8xCxUZAkSIrQKLrEMLnMMKXcIEFoFldgEChzt4yyU7FTputI8NSVZDRUZVSUpWGEdljyA9Q+kWCS1irI0rL0N86hgqB41nx8WD2ByEMGA9SJg4F6Qs22GEz/fwrLATKPWR685yqQ30Qqkwk+1MlijPESt2Fuu2IkltKOVOyj1BpgOeBit8rHZGuWzOzH0UG78jpSwLVF+uxJCJj1s5sJdxoMsenw05rLt99T4HWqLebs/9fJYzpXx3EsrMs8Mp0IJEepT6yq8pgodxcHKwKAWQCRetyNeszVKuTNWtzFcDdCpDJQtcmdlOuCpNijJAmXYsmH+Vq6F2YC46+uvf75998W560/OXX2MwnP1wgoMQouNgoWmQULzgGJT30IT33zjYKFtcLFDUJGzc7yViq0CoULDFFl0ZSlqlVJYqxRWOADmgCqxOaBWGIuDwURXyfTvpcU7YdQexSBYBppamY5jbOZ28/y9tqzaOD3fLDP3AgfLWk/1lgAdcEYV/oriKPWqUOUSd06ZM7vOTrbTQ2s+yXNbZsjWlOAt8f7b43xXe9uMeZoMuRms8DFrd1Lt9dWGGutCodNOsc/+5ugTvalQY4E24cWxHOjzHOiI3FznNy3gt8bqVwUq14So1YdrtkRpQVm+OUK1JUpTHKhQ5idT6iOd60xPt8NTbYlUW1qekxSMZhPYOoy1D3773c9X33l66fazC+88RsEFhsGFRoElZv4icx+huWehiVuOkVumgW+WqXWotqqNEk9HiaelzlGWp8sx6fK4lDyPI8MFgKiFgJkMgsGkFm3ncqn1UGDuCzXNbgkpahE2aiUKBoLlHZQgM/7yu8+/+uzTY5vPVkc3xpmF5jtbC1xMq7x0BHyu0FuqLkK9Mcqwwluj2IVZ7iJVZcdbEWA24GYw5m+xOtZhwF+/0V6+1Jhe6yDX5KbSFaS3Ms1+vtANJhEdgIkNMO5xDArhBedHs4/1Je9oCp0r9+hNMgXoy/2USn0UqgJV60PU64JUG4NUakKVAZ1iT06+GyPDHkuzIzMcmKn2TACoyENR5OQ2u2Llt9/9dOmdZ1duPz9//REKKjIJFJj7CS28Sy09hJYuBWZOWcaOqQYaNgo8fTZDhclU5LIUZNiwOLIMlyvLoVbIY7NgkSpAB5ZYorSKRcJ60jDdGdZ5XZoRTS1BAX1tOsmCxZBgzbrF+a3/+uG377/7+esffv3gw+9ePvpo38LW3GBRKj8sw8aswF6m0AHVBPPaY3Vao/RrAxUr3WWq+fJ5emSWKiozkS42oJWaMUusWBUOvFp35fZA3Z4Ik/EUhy0VIQdbEt9qTzo9kH15XAAAwUSgQ51xMBIQlKs2VF3ko1DiKVvsKV/moywOUK/xV63xVSz3lwXuFHqwMh2xZBvIcmmZzhwAKMeBU+CpWMH3XFy97rvvfrh04z0A6MyVB8i/1CZIZBNSYe1doueSr+mea2rkrSmjBf+kQBoEFo4GnWLCih5AGVj4hE3hAkBQa97SadQ6HDSYC04J1X9/vf4hNal+aWonLLUsExYWB/+1Ap7Jp599AWW6H378+Ysvv/3iy++ePH6xuHJzqndYnpe1wBMesnJ9mG57ghlM3myJ0C7zlM53IAvtyVJnVrE9I8cc5VjShI68el+t7kiLsWT+2nwYaRx+sDEeBmGfG8g7P1L49kAO9OYWKgOgCV4XppXDpxW6c4E+MGNW6K0IMAk8ZASe0kWuRI4T6BQRZ4HFmGHxZniSBZ5mRWY48VrCbIR2Ljs3H/zhi0+PXnv48sOvjh2/ibyKjb0LzYOKHAMKwHmb8CxZLG02S4laU1uCzjJAFDqwKsMSOn8DCCABlYIxNbB2g2RNKmp1MWrVAeWHD1/88OOvH338OQD03fc/fvvdD599/vXnX3zz3Q/fv3r2at/C9oa0tAIf00IvhaYY3Y5E875E84FE0+4Yg+YQDbGXfKW7XJWbgthDqdpTCYKDFSmOM7ne6woDNpaG7K+HqCcNSAQTPPc1x2+riZgr9RvL57fHGxe4SgFABW6cEi85QEfgIVfgystzBp/FzXZgpNnQEsyJSCM83ACLMsBijVC8KRJ4qjQEmmebWr995Pw3n3x05u6LDz774dCRa8hHaApOytRHV0pHiqkmzVTl0WEZLJ7036CBZbVByCX6SLizTB/JQgywpims0QkmZ8m1s+B3AGhocPvvfwB9fv7+h1++/+EnAOjjTz778qvvvvr6+29/+u758+eHdh0Zax3uFhZVJ9iXBqu0JZiPptmATGTZrUi1WpFq0xdr1htt0RVhPhhvBWWzhZLATeVhMGl6S3n4TnHU/saEnfUxe5ri11cETRW4DWU6tMWbivxVwLJkOdIAkUI3mUI32Vy+VKY9M8OOkWFHSzJnxpnQowzIUF0iVBcAwqkQ0YJW5qtZ622UZWZ34/I9KHe88/yTZx9+cxDaPu7ZNjxTOoxVkVaQg38IwZCVI7nSTCnZN9VKAg0szE6tzf5f0MBaOtRCT9QQamARLBG5NBuPVHCyzvv2+69+/e3Pb779CUABefn+q6++/hYwAh69+uTjB4+fzc/vGO2fnhkcrEzzb05zro+2HEi2nsiB2YrucwL3NYWuq3JdpzJdV6Q6r8xymcn1XFvou07gDzJfHACyUOK/rixwQ3XYVJFnd5JVc4wRBA257rw0R4CDlu3IzOVzsx056TasZEsCVCnJAovUJyL08HAd6jXGiEy2YmY5ArOkYdGDOh9DoXvgzev3P/ng48cffXfz0QdHT99BCjDxFFYZY9EUlBS5slI4QCEtzeTyYIUc8FMSVyVhzbK5kexQlmYJGgodym1R84IgDlqarQjLz5nceOfJ77/9+fU3P4B88+2PYHo+/eyrTz798seffvns8y8/+/r7k+durlyzbdXsfE9nS0lKjCDcszberTXeYjTPZZXAfV2Z50yB0zqh98p8t/Es18ks14lMl7F0/ki6AyVpTisynCHgHMxwGsoEtbKsDNIU+akWeMqnOrKS7emp1mS6LT3TnpVmzYQgMM4YxZlQqhRugML0UYQeijGE8AfPcmAVeUiJ/GSrfXVbgy3qIpJuvXPvg/c/fvXFz+Dmj527B5kiHVwSRDTwTyzYMnQYrU2yYO1vWIiK8SY0rxc0gaXn/tr+thSVZGUxamgfDkNtmJsXz/3w3Z8//fQLgALo/PjTb2CYP/n0q59/+Z2yRN9/9+Gn363beHBx6+HZhYWKcmGDSBTv5Z4f7CoIMqmKtGhLtu1Ns1mRbTeRx5/Mdx3NcR7NdB7J4A+m2nXGmjWE69eG6NSHGUDAWRdmUBWoXeylnMPn5bjK5rjykuzocVZ4ggVKsiRSrBmQhUIaEW2EYgAjUyzWnCokAFJJ5ijTGit0ZpR68yoD5VvCLWCKUUdG0Z3bD957+dEXX/165dZ7FIMojtBgRRhw2FxqPjgseMmkwf9CedMMS8giWbDjzQVr/3MhIYih4b9HwNId3OrK1T//9gX49Y9egcP6+qeffwMt+/qbH+EVzDPQ5/sff3j45OP9h89u2XF409Z9QkF5XWlVekRoZqhPpINhlL0WrPYm8NWqDdWvCFBvijbqSLBqj7VqizVviDSoCtIo8VLId5XJc5GFgonAXTnTQTrdjg1YJNsy0xw4idZkjBmKBb6Y4YkWdDAxMUYUQLEmONhmME9pNkS6DZZrRxbxWeVeshAfNYVr9aU4j6S6TdW237lz79WrL778/JerN98/c/HR6zXGmDQuTuMSUjB2mtIUKSZ32da8iY5kdbw3ubO8AAzl6Cntkg8KLAA0fvvj9x9//P5fP4GKfQcW+tPPvv7qa1C0n0DRwAwBg06duXH63OVde9+aWbm1RtRZmJFbkpEUH+gR5mTrZazuocWGxanSHWSzHHmpNuxcPkQ0qkVuCnkuvBxnLkQuGU6cFDtWog0LFjEAgoApSbQgAZQ4CyLWHI82RUuIUDl6nAkNAAKBfWBTFp+e7UTPd2QUu3CqvOSggNcdY9SfZDWa7TWa4bFlZObmrTsff/b9px99e/na8xu3X/1//MF/JNVoqGUAAAAASUVORK5CYII=";
__base64Images["/org/opensourcephysics/resources/controls/images/close.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAh3ALEJFMhqBQAAK1gNXIiNFQArgVixCmQFgMKFVhIybLjCysCCGxdqxKaRFq2FJhsCwEZRoMmT2F4KXBFoZMyXKQXWtIhS5seDF136JIgwKM6cLGl6vAnTJ02SCpHeVEnQJsOCQTMG/djxKsKIEw1uXVjwoFVsAQEAOw==";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["./Vectors4/Vectors4.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./Vectors4/Updated Picture.PNG"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
