/*
 * Requires Polynomial.js
 * Polynomial implements a mathematical polynomial:
 * c[0] + c[1] * x + c[2] * x^2 + ....
*/



/**
 * Calculates the logarithm of the Gamma function using the Lanczos
 * approximation.
 * 
 * @param x double
 * @return double
 */
function gammaln(x) {
  let cof = [76.18009172947146, -86.50532032941677, 24.01409824083091, -1.231739572450155,
    0.1208650973866179e-2, -0.5395239384953e-5
  ];
  y = x, tmp = x + 5.5;
  tmp -= (x + 0.5) * Math.log(tmp);
  sum = 1.000000000190015;
  for (let j = 0; j <= 5; j++) {
    sum += cof[j] / ++y;
  }
  return -tmp + Math.log(2.5066282746310005 * sum / x);
}

function LegendreP() {

}


/**
 * Evaluates the associated Legendre function of the first kind, LegendreP.
 */
LegendreP.prototype.eval = function(l, m, x){
  var f=new Factorials();
  let xsq, oneMxsq, xsqrt, fm, SnM2m, SnM1m, tiM1, M1Root, Root;
  let Snm = 0.0;
  let nMm, m2, i;
  if(m<0) {
    m = -m;
  }
  if(m>l) {
    return 0.0;
  }
  if(l==0) {
    return 1.0;
  }
  nMm = l-m;
  if(x<0) {
    x = -x;
    if(nMm>2*(nMm/2)) {
      return -legendreP(l, m, x);
    }
    return legendreP(l, m, x);
  }
  //Now l >= m >0 and x >= 0;
  xsq = x*x;
  oneMxsq = 1.0-xsq;
  xsqrt = Math.sqrt(oneMxsq);
  if(l==1) {
    if(m==0) {
      return x;
    }
    if(m==1) {
      return xsqrt;
    }
  }
  if(l==2) {
    if(m==0) {
      return 1.5*xsq-0.5;
    }
    if(m==1) {
      return 3.0*x*xsqrt;
    }
    if(m==2) {
      return 3.0*oneMxsq;
    }
  }
  //Now l>2, so use iteration.
  m2 = m*m;
  fm = m;
  if(l==m) {
    return Math.exp(gammaln(2.0*fm+1)-fm*ln2-gammaln(fm+1))*Math.pow(xsqrt, fm);
  }
  ln2 = 0.693147180560; 
  SnM2m = 0.0;
  SnM1m = Math.exp(0.5*gammaln(2.0*fm+1)-fm*ln2-gammaln(fm+1))*Math.pow(xsqrt, fm);
  tiM1 = 2*m+1;
  M1Root = 0.0;
  Root = Math.sqrt(tiM1);
  for(i = m+1; i<=l; i++) {
    Snm = (tiM1*x*SnM1m-M1Root*SnM2m)/Root;
    tiM1 += 2.0;
    M1Root = Root;
    Root = Math.sqrt(((i+1)*(i+1)-m2));
    SnM2m = SnM1m;
    SnM1m = Snm;
  }
  return(Math.exp(0.5*(gammaln((l+m+1))-gammaln((l-m+1))))*Snm);
}