const cof = [76.18009172947146, -86.50532032941677, 24.01409824083091, -1.231739572450155,
  0.1208650973866179e-2, -0.5395239384953e-5
];

/**
 * Calculates the logarithm of the Gamma function using the Lanczos
 * approximation.
 * 
 * @param x double
 * @return double
 */
function gammaln(x) {
  y = x, tmp = x + 5.5;
  tmp -= (x + 0.5) * Math.log(tmp);
  sum = 1.000000000190015;
  for (let j = 0; j <= 5; j++) {
    sum += cof[j] / ++y;
  }
  return -tmp + Math.log(2.5066282746310005 * sum / x);
}

/**
 * Compute the factorial of an integer and functions closely related to factorials.
 */
function Factorials() {
  var val = 1;
  var maxN = 1;
  while (maxN < 21) {
    val = val * maxN;
    maxN++;
    //console.log("val="+ val);
  }
  this.fac = new Array(maxN); // maxN should be ~21
  this.fac[0] = 1;
  for (var i = 1; i < maxN; i++) {
    this.fac[i] = this.fac[i - 1] * i;
  }
}


Factorials.prototype.factorial = function (n) {
  if (n < 0) return null;
  if (n < 21) {
    return this.fac[n];
  }
  return Math.exp(gammaln(n + 1.0));
}