/* _inputParameters: an object with different values for the model parameters */
function MatchingGame18cardschoose3(_topFrame,_libraryPath,_codebasePath, _inputParameters) {
  var _model = EJSS_CORE.createAnimationLMS();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog,
    downloadText: EJSS_TOOLS.File.downloadText,
    uploadText: function(action) { EJSS_TOOLS.File.uploadText(_model,action); } 
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var n; // EjsS Model.Variables.EditableVariable.n
  var countdown; // EjsS Model.Variables.EditableVariable.countdown
  var icon; // EjsS Model.Variables.EditableVariable.icon
  var desc; // EjsS Model.Variables.EditableVariable.desc
  var desc2; // EjsS Model.Variables.EditableVariable.desc2
  var mode; // EjsS Model.Variables.EditableVariable.mode
  var diagram; // EjsS Model.Variables.EditableVariable.diagram

  var card_id; // EjsS Model.Variables.Var Table.card_id
  var card_type; // EjsS Model.Variables.Var Table.card_type
  var card_width; // EjsS Model.Variables.Var Table.card_width
  var card_height; // EjsS Model.Variables.Var Table.card_height
  var x; // EjsS Model.Variables.Var Table.x
  var y; // EjsS Model.Variables.Var Table.y
  var margin_x; // EjsS Model.Variables.Var Table.margin_x
  var margin_y; // EjsS Model.Variables.Var Table.margin_y
  var prev_id; // EjsS Model.Variables.Var Table.prev_id
  var prev_id2; // EjsS Model.Variables.Var Table.prev_id2
  var interact; // EjsS Model.Variables.Var Table.interact
  var prev_interact; // EjsS Model.Variables.Var Table.prev_interact
  var back_display; // EjsS Model.Variables.Var Table.back_display
  var score; // EjsS Model.Variables.Var Table.score
  var game_over; // EjsS Model.Variables.Var Table.game_over
  var game_start; // EjsS Model.Variables.Var Table.game_start

  var select_color; // EjsS Model.Variables.Back Colors.select_color
  var correct_color; // EjsS Model.Variables.Back Colors.correct_color
  var transparent_color; // EjsS Model.Variables.Back Colors.transparent_color
  var opaque_color; // EjsS Model.Variables.Back Colors.opaque_color
  var back_color; // EjsS Model.Variables.Back Colors.back_color

  var t; // EjsS Model.Variables.Timings.t
  var dt; // EjsS Model.Variables.Timings.dt
  var time_display; // EjsS Model.Variables.Timings.time_display
  var card_delay; // EjsS Model.Variables.Timings.card_delay
  var delay_interact1; // EjsS Model.Variables.Timings.delay_interact1
  var delay_interact2; // EjsS Model.Variables.Timings.delay_interact2
  var delay_interact3; // EjsS Model.Variables.Timings.delay_interact3

  var card_icon; // EjsS Model.Variables.Card Icons.card_icon

  var font; // EjsS Model.Variables.lookang.font
  var hint; // EjsS Model.Variables.lookang.hint

  _model.getOdes = function() { return []; };

  _model.removeEvents = function(){
  };

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      n : n,
      countdown : countdown,
      icon : icon,
      desc : desc,
      desc2 : desc2,
      mode : mode,
      diagram : diagram,
      card_id : card_id,
      card_type : card_type,
      card_width : card_width,
      card_height : card_height,
      x : x,
      y : y,
      margin_x : margin_x,
      margin_y : margin_y,
      prev_id : prev_id,
      prev_id2 : prev_id2,
      interact : interact,
      prev_interact : prev_interact,
      back_display : back_display,
      score : score,
      game_over : game_over,
      game_start : game_start,
      select_color : select_color,
      correct_color : correct_color,
      transparent_color : transparent_color,
      opaque_color : opaque_color,
      back_color : back_color,
      t : t,
      dt : dt,
      time_display : time_display,
      card_delay : card_delay,
      delay_interact1 : delay_interact1,
      delay_interact2 : delay_interact2,
      delay_interact3 : delay_interact3,
      card_icon : card_icon,
      font : font,
      hint : hint
    };
  };

  function _serializePublic() { return _model.serializePublic(); }

  _model._userSerializePublic = function() {
    return {
      n : n,
      countdown : countdown,
      icon : icon,
      desc : desc,
      desc2 : desc2,
      mode : mode,
      diagram : diagram,
      card_id : card_id,
      card_type : card_type,
      card_width : card_width,
      card_height : card_height,
      x : x,
      y : y,
      margin_x : margin_x,
      margin_y : margin_y,
      prev_id : prev_id,
      prev_id2 : prev_id2,
      interact : interact,
      prev_interact : prev_interact,
      back_display : back_display,
      score : score,
      game_over : game_over,
      game_start : game_start,
      select_color : select_color,
      correct_color : correct_color,
      transparent_color : transparent_color,
      opaque_color : opaque_color,
      back_color : back_color,
      t : t,
      dt : dt,
      time_display : time_display,
      card_delay : card_delay,
      delay_interact1 : delay_interact1,
      delay_interact2 : delay_interact2,
      delay_interact3 : delay_interact3,
      card_icon : card_icon,
      font : font,
      hint : hint
    };
  };

  _model._readParameters = function(json) {
    if(typeof json.n != "undefined") n = json.n;
    if(typeof json.countdown != "undefined") countdown = json.countdown;
    if(typeof json.icon != "undefined") icon = json.icon;
    if(typeof json.desc != "undefined") desc = json.desc;
    if(typeof json.desc2 != "undefined") desc2 = json.desc2;
    if(typeof json.mode != "undefined") mode = json.mode;
    if(typeof json.diagram != "undefined") diagram = json.diagram;
    if(typeof json.card_id != "undefined") card_id = json.card_id;
    if(typeof json.card_type != "undefined") card_type = json.card_type;
    if(typeof json.card_width != "undefined") card_width = json.card_width;
    if(typeof json.card_height != "undefined") card_height = json.card_height;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.margin_x != "undefined") margin_x = json.margin_x;
    if(typeof json.margin_y != "undefined") margin_y = json.margin_y;
    if(typeof json.prev_id != "undefined") prev_id = json.prev_id;
    if(typeof json.prev_id2 != "undefined") prev_id2 = json.prev_id2;
    if(typeof json.interact != "undefined") interact = json.interact;
    if(typeof json.prev_interact != "undefined") prev_interact = json.prev_interact;
    if(typeof json.back_display != "undefined") back_display = json.back_display;
    if(typeof json.score != "undefined") score = json.score;
    if(typeof json.game_over != "undefined") game_over = json.game_over;
    if(typeof json.game_start != "undefined") game_start = json.game_start;
    if(typeof json.select_color != "undefined") select_color = json.select_color;
    if(typeof json.correct_color != "undefined") correct_color = json.correct_color;
    if(typeof json.transparent_color != "undefined") transparent_color = json.transparent_color;
    if(typeof json.opaque_color != "undefined") opaque_color = json.opaque_color;
    if(typeof json.back_color != "undefined") back_color = json.back_color;
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.time_display != "undefined") time_display = json.time_display;
    if(typeof json.card_delay != "undefined") card_delay = json.card_delay;
    if(typeof json.delay_interact1 != "undefined") delay_interact1 = json.delay_interact1;
    if(typeof json.delay_interact2 != "undefined") delay_interact2 = json.delay_interact2;
    if(typeof json.delay_interact3 != "undefined") delay_interact3 = json.delay_interact3;
    if(typeof json.card_icon != "undefined") card_icon = json.card_icon;
    if(typeof json.font != "undefined") font = json.font;
    if(typeof json.hint != "undefined") hint = json.hint;
  };

  _model._readParametersPublic = function(json) {
    if(typeof json.n != "undefined") n = json.n;
    if(typeof json.countdown != "undefined") countdown = json.countdown;
    if(typeof json.icon != "undefined") icon = json.icon;
    if(typeof json.desc != "undefined") desc = json.desc;
    if(typeof json.desc2 != "undefined") desc2 = json.desc2;
    if(typeof json.mode != "undefined") mode = json.mode;
    if(typeof json.diagram != "undefined") diagram = json.diagram;
    if(typeof json.card_id != "undefined") card_id = json.card_id;
    if(typeof json.card_type != "undefined") card_type = json.card_type;
    if(typeof json.card_width != "undefined") card_width = json.card_width;
    if(typeof json.card_height != "undefined") card_height = json.card_height;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.margin_x != "undefined") margin_x = json.margin_x;
    if(typeof json.margin_y != "undefined") margin_y = json.margin_y;
    if(typeof json.prev_id != "undefined") prev_id = json.prev_id;
    if(typeof json.prev_id2 != "undefined") prev_id2 = json.prev_id2;
    if(typeof json.interact != "undefined") interact = json.interact;
    if(typeof json.prev_interact != "undefined") prev_interact = json.prev_interact;
    if(typeof json.back_display != "undefined") back_display = json.back_display;
    if(typeof json.score != "undefined") score = json.score;
    if(typeof json.game_over != "undefined") game_over = json.game_over;
    if(typeof json.game_start != "undefined") game_start = json.game_start;
    if(typeof json.select_color != "undefined") select_color = json.select_color;
    if(typeof json.correct_color != "undefined") correct_color = json.correct_color;
    if(typeof json.transparent_color != "undefined") transparent_color = json.transparent_color;
    if(typeof json.opaque_color != "undefined") opaque_color = json.opaque_color;
    if(typeof json.back_color != "undefined") back_color = json.back_color;
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.time_display != "undefined") time_display = json.time_display;
    if(typeof json.card_delay != "undefined") card_delay = json.card_delay;
    if(typeof json.delay_interact1 != "undefined") delay_interact1 = json.delay_interact1;
    if(typeof json.delay_interact2 != "undefined") delay_interact2 = json.delay_interact2;
    if(typeof json.delay_interact3 != "undefined") delay_interact3 = json.delay_interact3;
    if(typeof json.card_icon != "undefined") card_icon = json.card_icon;
    if(typeof json.font != "undefined") font = json.font;
    if(typeof json.hint != "undefined") hint = json.hint;
  };

  function _unserializePublic(json) { return _model.unserializePublic(json); }

  _model._userUnserializePublic = function(json) {
    _model._readParametersPublic(json);
   _resetSolvers();
   _model.update();
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    _model._readParameters(json);
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Init Page"] = true;
    __pagesEnabled["message"] = true;
    __pagesEnabled["debug"] = true;
    __pagesEnabled["Evol Page"] = true;
    __pagesEnabled["FixRel Page"] = true;
  });

  _model.addToReset(function() {
    n = 18; // EjsS Model.Variables.EditableVariable.n
    countdown = 2; // EjsS Model.Variables.EditableVariable.countdown
    icon = [   "./cardMatching/Picture1.png",   "./cardMatching/Picture2.png",   "./cardMatching/Picture3.png",   "./cardMatching/Picture4.png",   "./cardMatching/Picture5.png",   "./cardMatching/Picture6.png" ]; // EjsS Model.Variables.EditableVariable.icon
    desc = [   "./cardMatching/Picture7.png",   "./cardMatching/Picture8.png",   "./cardMatching/Picture9.png",   "./cardMatching/Picture10.png",   "./cardMatching/Picture11.png",   "./cardMatching/Picture12.png" ]; // EjsS Model.Variables.EditableVariable.desc
    desc2 = [   "./cardMatching/Picture13.png",   "./cardMatching/Picture14.png",   "./cardMatching/Picture15.png",   "./cardMatching/Picture16.png",   "./cardMatching/Picture17.png",   "./cardMatching/Picture18.png" ]; // EjsS Model.Variables.EditableVariable.desc2
    mode = 1; // EjsS Model.Variables.EditableVariable.mode
    diagram = ["./cardMatching/Picture13.png", "./cardMatching/Picture14.png", "./cardMatching/Picture15.png", "./cardMatching/Picture16.png", "./cardMatching/Picture17.png", "./cardMatching/Picture18.png" ];; // EjsS Model.Variables.EditableVariable.diagram
  });

  _model.addToReset(function() {
    card_id = new Array(n); // EjsS Model.Variables.Var Table.card_id
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Var Table.card_id
        card_id[_i0] = 0;  // EjsS Model.Variables.Var Table.card_id
      }
    }());
    card_type = new Array(n); // EjsS Model.Variables.Var Table.card_type
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Var Table.card_type
        card_type[_i0] = 0;  // EjsS Model.Variables.Var Table.card_type
      }
    }());
    card_width = 1; // EjsS Model.Variables.Var Table.card_width
    card_height = 1; // EjsS Model.Variables.Var Table.card_height
    x = new Array(n); // EjsS Model.Variables.Var Table.x
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Var Table.x
        x[_i0] = 0;  // EjsS Model.Variables.Var Table.x
      }
    }());
    y = new Array(n); // EjsS Model.Variables.Var Table.y
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Var Table.y
        y[_i0] = 0;  // EjsS Model.Variables.Var Table.y
      }
    }());
    margin_x = 0.3; // EjsS Model.Variables.Var Table.margin_x
    margin_y = 0.3; // EjsS Model.Variables.Var Table.margin_y
    prev_id = -1; // EjsS Model.Variables.Var Table.prev_id
    prev_id2 = -1; // EjsS Model.Variables.Var Table.prev_id2
    interact = -1; // EjsS Model.Variables.Var Table.interact
    prev_interact = -1; // EjsS Model.Variables.Var Table.prev_interact
    back_display = new Array(n); // EjsS Model.Variables.Var Table.back_display
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Var Table.back_display
        back_display[_i0] = 1;  // EjsS Model.Variables.Var Table.back_display
      }
    }());
    score = 0; // EjsS Model.Variables.Var Table.score
    game_over = 0; // EjsS Model.Variables.Var Table.game_over
    game_start = 0; // EjsS Model.Variables.Var Table.game_start
  });

  _model.addToReset(function() {
    select_color = "rgba(255,255,0,0.1)"; // EjsS Model.Variables.Back Colors.select_color
    correct_color = "rgba(0,255,0,0.1)"; // EjsS Model.Variables.Back Colors.correct_color
    transparent_color = "rgba(0, 0, 0, 0)"; // EjsS Model.Variables.Back Colors.transparent_color
    opaque_color = "black"; // EjsS Model.Variables.Back Colors.opaque_color
    back_color = new Array(n); // EjsS Model.Variables.Back Colors.back_color
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Back Colors.back_color
        back_color[_i0] = opaque_color;  // EjsS Model.Variables.Back Colors.back_color
      }
    }());
  });

  _model.addToReset(function() {
    t = 0; // EjsS Model.Variables.Timings.t
    dt = 0.05; // EjsS Model.Variables.Timings.dt
    time_display = ""; // EjsS Model.Variables.Timings.time_display
    card_delay = -1; // EjsS Model.Variables.Timings.card_delay
  });

  _model.addToReset(function() {
    card_icon = new Array(n); // EjsS Model.Variables.Card Icons.card_icon
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Card Icons.card_icon
        card_icon[_i0] = "";  // EjsS Model.Variables.Card Icons.card_icon
      }
    }());
  });

  _model.addToReset(function() {
    font = "normal normal 2vw "; // EjsS Model.Variables.lookang.font
    hint = ""; // EjsS Model.Variables.lookang.hint
  });

  if (_inputParameters) {
    _inputParameters = _model.parseInputParameters(_inputParameters);
    if (_inputParameters) _model.addToReset(function() { _model._readParameters(_inputParameters); });
  }

  _model.addToReset(function() {
    _model.setAutoplay(true);
    _model.setPauseOnPageExit(true);
    _model.setFPS(20);
    _model.setStepsPerDisplay(1);
  });

  function randomisePos() {  // > CustomCode.randomisePos:1
    // card_type : 0 is symbol, 1 is description  // > CustomCode.randomisePos:2
    // card_id : 0 to 8, each number represents one set of symbol / description  // > CustomCode.randomisePos:3
    var id_arr = [];  // > CustomCode.randomisePos:4
    for(var i = 0; i < n; i++){  // > CustomCode.randomisePos:5
      // creates an array that looks like [[0, 0], [0, 1], [1, 0], [1, 1], [2, 0], [2, 1] ...]  // > CustomCode.randomisePos:6
      id_arr.push([Math.floor(i / 2), i % 2]);  // > CustomCode.randomisePos:7
    }  // > CustomCode.randomisePos:8
    for(var i = 0; i < n; i++){  // > CustomCode.randomisePos:9
      // randomly get an idx  // > CustomCode.randomisePos:10
      var idx = Math.floor(Math.random() * id_arr.length);  // > CustomCode.randomisePos:11
        // > CustomCode.randomisePos:12
      // assign the id and the type  // > CustomCode.randomisePos:13
      card_id[i] = id_arr[idx][0];  // > CustomCode.randomisePos:14
      card_type[i] = id_arr[idx][1];  // > CustomCode.randomisePos:15
        // > CustomCode.randomisePos:16
      // change the image based on the card type  // > CustomCode.randomisePos:17
      if(card_type[i] == 0){  // > CustomCode.randomisePos:18
        card_icon[i] = icon[card_id[i]];  // > CustomCode.randomisePos:19
      }  // > CustomCode.randomisePos:20
      else{  // > CustomCode.randomisePos:21
        card_icon[i] = desc[card_id[i]];  // > CustomCode.randomisePos:22
      }  // > CustomCode.randomisePos:23
      // remove the element from the array to prevent repetition  // > CustomCode.randomisePos:24
      id_arr.splice(idx, 1);  // > CustomCode.randomisePos:25
    }  // > CustomCode.randomisePos:26
  }  // > CustomCode.randomisePos:27

  function randomisePos2() {  // > CustomCode.randomisePos2:1
    // card_type : 0 is symbol, 1 is description, 2 is diagram  // > CustomCode.randomisePos2:2
    // card_id : 0 to 5, each number represents one set of symbol / description / diagram  // > CustomCode.randomisePos2:3
    var id_arr = [];  // > CustomCode.randomisePos2:4
    for(var i = 0; i < n; i++){  // > CustomCode.randomisePos2:5
      // creates an array that looks like [[0, 0], [0, 1], [0, 2], [1, 0], [1, 1], [1, 2], [2, 0], [2, 1] ...]  // > CustomCode.randomisePos2:6
      id_arr.push([Math.floor(i / 3), i % 3]);  // > CustomCode.randomisePos2:7
    }  // > CustomCode.randomisePos2:8
    for(var i = 0; i < n; i++){  // > CustomCode.randomisePos2:9
      // randomly get an idx  // > CustomCode.randomisePos2:10
      var idx = Math.floor(Math.random() * id_arr.length);  // > CustomCode.randomisePos2:11
        // > CustomCode.randomisePos2:12
      // assign the id and the type  // > CustomCode.randomisePos2:13
      card_id[i] = id_arr[idx][0];  // > CustomCode.randomisePos2:14
      card_type[i] = id_arr[idx][1];  // > CustomCode.randomisePos2:15
        // > CustomCode.randomisePos2:16
      // change the image based on the card type  // > CustomCode.randomisePos2:17
      if(card_type[i] == 0){  // > CustomCode.randomisePos2:18
        card_icon[i] = icon[card_id[i]];  // > CustomCode.randomisePos2:19
      }  // > CustomCode.randomisePos2:20
      else if(card_type[i] == 1){  // > CustomCode.randomisePos2:21
        card_icon[i] = desc[card_id[i]];  // > CustomCode.randomisePos2:22
      }  // > CustomCode.randomisePos2:23
      else{  // > CustomCode.randomisePos2:24
        card_icon[i] = diagram[card_id[i]];  // > CustomCode.randomisePos2:25
      }  // > CustomCode.randomisePos2:26
      // remove the element from the array to prevent repetition  // > CustomCode.randomisePos2:27
      id_arr.splice(idx, 1);  // > CustomCode.randomisePos2:28
    }  // > CustomCode.randomisePos2:29
  }  // > CustomCode.randomisePos2:30

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Init Page"]) return;
    // initialising img_url  // > Initialization.Init Page:1
    // put in variables to allow editing on https://ejss-browser-editor.herokuapp.com/  // > Initialization.Init Page:2
    // teachers need to replace their own Picture1.png Picture2.png with their own pictures  // > Initialization.Init Page:3
    // teachers need to replace their own Picture10.png Picture11.png with their own pictures  // > Initialization.Init Page:4
    // Picture1.png match Picture10.png etc the match order cannot be changed  // > Initialization.Init Page:5
    // lookang  // > Initialization.Init Page:6
    /*  // > Initialization.Init Page:7
    icon = [  // > Initialization.Init Page:8
    "./cardMatching/Picture1.png",  // > Initialization.Init Page:9
    "./cardMatching/Picture2.png",  // > Initialization.Init Page:10
    "./cardMatching/Picture3.png",  // > Initialization.Init Page:11
    "./cardMatching/Picture4.png",  // > Initialization.Init Page:12
    "./cardMatching/Picture5.png",  // > Initialization.Init Page:13
    "./cardMatching/Picture6.png",  // > Initialization.Init Page:14
    "./cardMatching/Picture7.png",  // > Initialization.Init Page:15
    "./cardMatching/Picture8.png",  // > Initialization.Init Page:16
    "./cardMatching/Picture9.png"  // > Initialization.Init Page:17
    ];  // > Initialization.Init Page:18
    desc = [  // > Initialization.Init Page:19
    "./cardMatching/Picture10.png",  // > Initialization.Init Page:20
    "./cardMatching/Picture11.png",  // > Initialization.Init Page:21
    "./cardMatching/Picture12.png",  // > Initialization.Init Page:22
    "./cardMatching/Picture13.png",  // > Initialization.Init Page:23
    "./cardMatching/Picture14.png",  // > Initialization.Init Page:24
    "./cardMatching/Picture15.png",  // > Initialization.Init Page:25
    "./cardMatching/Picture16.png",  // > Initialization.Init Page:26
    "./cardMatching/Picture17.png",  // > Initialization.Init Page:27
    "./cardMatching/Picture18.png"  // > Initialization.Init Page:28
    ];  // > Initialization.Init Page:29
    */  // > Initialization.Init Page:30
    // initialising x and y position  // > Initialization.Init Page:31
    for(var i = 0; i < n; i++){  // > Initialization.Init Page:32
      x[i] = card_width * (i % 6);  // > Initialization.Init Page:33
      if(i % 6)  // > Initialization.Init Page:34
        x[i] += margin_x * (i % 6);// margin_x=0.3 spacing between cards  // > Initialization.Init Page:35
          // > Initialization.Init Page:36
      y[i] = card_height * Math.floor(i / 6);  // > Initialization.Init Page:37
      if(Math.floor(i / 6))  // > Initialization.Init Page:38
        y[i] += margin_y * Math.floor(i / 6);  // > Initialization.Init Page:39
    }  // > Initialization.Init Page:40
    //console.log(x, y);  // > Initialization.Init Page:41
    // randomise cards  // > Initialization.Init Page:42
    //randomisePos();  // > Initialization.Init Page:43
    randomisePos2(); // 3 now  // > Initialization.Init Page:44
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["message"]) return;
    if (_isMobile){  // > Initialization.message:1
      //do nothing  // > Initialization.message:2
      }  // > Initialization.message:3
        // > Initialization.message:4
      else{  // > Initialization.message:5
        // copy this into the initialization  // > Initialization.message:6
    // make the font bigger  // > Initialization.message:7
    _view.cardDisplay.getMessageDecoration("TL").getFont().setFontSize("1vw");  // > Initialization.message:8
    _view.cardDisplay.getMessageDecoration("TR").getFont().setFontSize("1vw");  // > Initialization.message:9
    _view.cardDisplay.getMessageDecoration("BL").getFont().setFontSize("1vw");  // > Initialization.message:10
    _view.cardDisplay.getMessageDecoration("BR").getFont().setFontSize("1vw");  // > Initialization.message:11
        }  // > Initialization.message:12
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["debug"]) return;
    // copy paste into TL message to see the values  // > Initialization.debug:1
    //"back_color="+back_color+"\ninteract="+interact+"\nprev_interact="+prev_interact+"mode="+mode  // > Initialization.debug:2
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Evol Page"]) return;
    if(game_start && !game_over)  // > Evolution.Evol Page:1
      t += dt;  // > Evolution.Evol Page:2
    if(card_delay != -1 && t - card_delay >= 1){  // > Evolution.Evol Page:3
      // _tools.showOkDialog("Card doesn't match!");  // > Evolution.Evol Page:4
      hint= "Card doesn't match!"; // lookang change to hint to ease clicking fast  // > Evolution.Evol Page:5
      _view.audio2.play() // play wrongsound  // > Evolution.Evol Page:6
        // > Evolution.Evol Page:7
      // change the colors of the cards back based on the game mode  // > Evolution.Evol Page:8
      if(mode == 1){  // > Evolution.Evol Page:9
        back_color[delay_interact1] = transparent_color;  // > Evolution.Evol Page:10
        back_color[delay_interact2] = transparent_color;  // > Evolution.Evol Page:11
        back_color[delay_interact3] = transparent_color; //lookang  // > Evolution.Evol Page:12
      }  // > Evolution.Evol Page:13
      else if(mode == 2){ // memory game  // > Evolution.Evol Page:14
        back_color[delay_interact1] = opaque_color;  // > Evolution.Evol Page:15
        back_color[delay_interact2] = opaque_color;  // > Evolution.Evol Page:16
        back_color[delay_interact3] = opaque_color; //lookang  // > Evolution.Evol Page:17
      }  // > Evolution.Evol Page:18
      // deactiate card_delay  // > Evolution.Evol Page:19
      card_delay = -1;  // > Evolution.Evol Page:20
    }  // > Evolution.Evol Page:21
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["FixRel Page"]) return;
    if(game_over == true || game_start == false)  // > FixedRelations.FixRel Page:1
      return; // do ntg  // > FixedRelations.FixRel Page:2
        // > FixedRelations.FixRel Page:3
    var cur_time = t;  // > FixedRelations.FixRel Page:4
    var min = Math.floor(cur_time / 60), sec = Math.floor(cur_time % 60);  // > FixedRelations.FixRel Page:5
    if(min < 10)  // > FixedRelations.FixRel Page:6
      min = "0" + min;  // > FixedRelations.FixRel Page:7
    if(sec < 10)  // > FixedRelations.FixRel Page:8
      sec = "0" + sec;  // > FixedRelations.FixRel Page:9
      // dont control css style here  // > FixedRelations.FixRel Page:10
    //time_display = `<h2 style='text-align: center'>Timer: ${min}:${sec}</h2>`;  // > FixedRelations.FixRel Page:11
    time_display = "⌛Timer: "+min+":"+sec;  // > FixedRelations.FixRel Page:12
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView", width : 800, height : 600 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new MatchingGame18cardschoose3_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.topPanel.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView linking property 'Font' for element 'topPanel'
          _view.modeLabel.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView linking property 'Font' for element 'modeLabel'
          _view.modeSelect.linkProperty("Options",  function() { return ["1","2"]; } ); // HtmlView linking property 'Options' for element 'modeSelect'
          _view.modeSelect.setAction("OnChange", function(_data,_info) {
  var opts = _view.modeSelect.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0)? opts[0]:""; // selected option 
  mode = option
  // changing the color based on the different mode
  //["training", "memory game"]
  //change from 1 and 2 for ease of reading
  for(var i = 0; i < n; i++){
    if(mode == 1||mode =="training"){ // added 2 ways to reach this if statement
   
      back_color[i] = opaque_color;  
    // back_color[i] = transparent_color // set to transparent to see cards turn black after start button is clicked
    }
    else if(mode == 2||mode == "memory game"){
      back_color[i] = transparent_color;
    }
  }
  // randomise the cards to prevent cheating
  //randomisePos();
  randomisePos2();

}); // HtmlView setting action 'OnChange' for element 'modeSelect'
          _view.modeSelect.linkProperty("Disabled",  function() { return game_start; }, function(_v) { game_start = _v; } ); // HtmlView linking property 'Disabled' for element 'modeSelect'
          _view.modeSelect.linkProperty("Font",  function() { return font; }, function(_v) { font = _v; } ); // HtmlView linking property 'Font' for element 'modeSelect'
          _view.timeDisplay.linkProperty("Text",  function() { return time_display; }, function(_v) { time_display = _v; } ); // HtmlView linking property 'Text' for element 'timeDisplay'
          _view.timeDisplay.linkProperty("Display",  function() { return game_start?"inline-block":"none"; } ); // HtmlView linking property 'Display' for element 'timeDisplay'
          _view.startBtn.setAction("OnClick", function(_data,_info) {
  game_over = 0;
  game_start = 1;
  for(var i = 0; i < n; i++){
    console.log(back_color[i]);
    if(mode == 1) // assume memory game?
      back_color[i] = transparent_color;
     // back_color[i] = opaque_color; //lookang
    else if(mode == 2) // assume training?
      back_color[i] = opaque_color;
    //  back_color[i] = transparent_color; //lookang
  }
  var msg="Start!"
  hint= msg;

}); // HtmlView setting action 'OnClick' for element 'startBtn'
          _view.startBtn.linkProperty("Display",  function() { return "" + `${game_start ? "none" : "inline_block"}`; } ); // HtmlView linking property 'Display' for element 'startBtn'
          _view.resetButton3.setAction("OnClick", function(_data,_info) {
  _reset();
  //speechzh ("你好");

}); // HtmlView setting action 'OnClick' for element 'resetButton3'
          _view.scoreDisplay.linkProperty("Text",  function() { return ""+ `<h2>Score: ${score}</h2>`; } ); // HtmlView linking property 'Text' for element 'scoreDisplay'
          _view.cardDisplay.linkProperty("Enabled",  function() { return game_start?true:false; } ); // HtmlView linking property 'Enabled' for element 'cardDisplay'
          _view.cardDisplay.linkProperty("MaximumY",  function() { return card_height * 3 + margin_y * 2; } ); // HtmlView linking property 'MaximumY' for element 'cardDisplay'
          _view.cardDisplay.linkProperty("MaximumX",  function() { return card_width * 6 + margin_x * 5; } ); // HtmlView linking property 'MaximumX' for element 'cardDisplay'
          _view.cardDisplay.linkProperty("TRMessage",  function() { return "Card Matching Game "+score+" / "+n/2; } ); // HtmlView linking property 'TRMessage' for element 'cardDisplay'
          _view.cardDisplay.linkProperty("BLMessage",  function() { return "card_id="+card_id[interact]; } ); // HtmlView linking property 'BLMessage' for element 'cardDisplay'
          _view.cardDisplay.linkProperty("TLMessage",  function() { return "hint="+hint; } ); // HtmlView linking property 'TLMessage' for element 'cardDisplay'
          _view.cardDisplay.linkProperty("BRMessage",  function() { return "interact="+interact; } ); // HtmlView linking property 'BRMessage' for element 'cardDisplay'
          _view.cardIcon.linkProperty("NumberOfElements",  function() { return n; }, function(_v) { n = _v; } ); // HtmlView linking property 'NumberOfElements' for element 'cardIcon'
          _view.cardIcon.linkProperty("SizeX",  function() { return card_width; }, function(_v) { card_width = _v; } ); // HtmlView linking property 'SizeX' for element 'cardIcon'
          _view.cardIcon.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView linking property 'X' for element 'cardIcon'
          _view.cardIcon.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView linking property 'Y' for element 'cardIcon'
          _view.cardIcon.linkProperty("ImageUrl",  function() { return card_icon; }, function(_v) { card_icon = _v; } ); // HtmlView linking property 'ImageUrl' for element 'cardIcon'
          _view.cardIcon.linkProperty("SizeY",  function() { return card_height; }, function(_v) { card_height = _v; } ); // HtmlView linking property 'SizeY' for element 'cardIcon'
          _view.cardSet.linkProperty("NumberOfElements",  function() { return n; }, function(_v) { n = _v; } ); // HtmlView linking property 'NumberOfElements' for element 'cardSet'
          _view.cardSet.linkProperty("FillColor",  function() { return back_color; }, function(_v) { back_color = _v; } ); // HtmlView linking property 'FillColor' for element 'cardSet'
          _view.cardSet.linkProperty("ElementInteracted",  function() { return interact; }, function(_v) { interact = _v; } ); // HtmlView linking property 'ElementInteracted' for element 'cardSet'
          _view.cardSet.linkProperty("SizeX",  function() { return card_width; }, function(_v) { card_width = _v; } ); // HtmlView linking property 'SizeX' for element 'cardSet'
          _view.cardSet.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView linking property 'X' for element 'cardSet'
          _view.cardSet.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView linking property 'Y' for element 'cardSet'
          _view.cardSet.setAction("OnPress", function(_data,_info) {
  // if card_delay is activated, don't run the rest of the code
  if (card_delay != -1)
    return;
  // if mode 1, if color is not transparent, don't run the rest of the code
  if (mode == 1 && back_color[interact] != transparent_color)
    return;
  // if mode 2, if color is not opaque, don't run the rest of the code
  if (mode == 2 && back_color[interact] != opaque_color)
    return;
  // turn colour to yellow
  back_color[interact] = select_color;
  // if the current card is the first card
  if (prev_id == -1) {
    prev_id = card_id[interact];
    prev_interact = interact;
    return;
  }
  // if the current card is the second card
  else if (prev_id2 == -1) {
    prev_id2 = card_id[interact];
    prev_interact2 = interact;
    return;
  }
  // if the current card is the third card
  else {
    var cur_id = card_id[interact];
    // check if the 3 cards match
    if (prev_id == prev_id2 && prev_id2 == cur_id) {
      score++;
      back_color[interact] = correct_color;
      back_color[prev_interact2] = correct_color; // 3 now
      back_color[prev_interact] = correct_color;
      // check for end of the game
      if (score == n / 3) { // corrected syntax
        game_over = true;
        var msg = "Game completed!"; // corrected syntax
        _view.audio3.play(); // play sound
        _tools.showOkDialog(msg);
        hint = msg;
      }
      // if the game has not ended yet
      else {
        // _tools.showOkDialog("Cards match!");
        hint = "Cards match!";
        _view.audio.play(); // play sound
      }
    } else {
      card_delay = t;
      // remember which trio of cards (necessary to prevent bugs)
      delay_interact1 = prev_interact;
      delay_interact2 = prev_interact2;
      delay_interact3 = interact; // 3 now
    }
    // preparing to select a new set of cards
    prev_id = -1;
    prev_id2 = -1;
  }

}); // HtmlView setting action 'OnPress' for element 'cardSet'
          _view.cardSet.linkProperty("SizeY",  function() { return card_height; }, function(_v) { card_height = _v; } ); // HtmlView linking property 'SizeY' for element 'cardSet'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(true);
  _model.setFPS(20);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function MatchingGame18cardschoose3_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = MatchingGame18cardschoose3_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);

  _view._addDescriptionPage('Desc Page','./MatchingGame18cardschoose3_Intro_1.html');

  return _view;
} // end of main function

function MatchingGame18cardschoose3_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"topPanel", _view._topFrame) // EJsS HtmlView.HtmlView: declaration of element 'topPanel'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView: setting property 'Display' for element 'topPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"title", _view.topPanel) // EJsS HtmlView.HtmlView: declaration of element 'title'
      .setProperty("Background","Cyan") // EJsS HtmlView.HtmlView: setting property 'Background' for element 'title'
      .setProperty("Text","<h1>Card Matching Game</h1>") // EJsS HtmlView.HtmlView: setting property 'Text' for element 'title'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView: setting property 'Display' for element 'title'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"modeLabel", _view.topPanel) // EJsS HtmlView.HtmlView: declaration of element 'modeLabel'
      .setProperty("Background","Orange") // EJsS HtmlView.HtmlView: setting property 'Background' for element 'modeLabel'
      .setProperty("Text","Mode:") // EJsS HtmlView.HtmlView: setting property 'Text' for element 'modeLabel'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"modeSelect", _view.topPanel) // EJsS HtmlView.HtmlView: declaration of element 'modeSelect'
      .setProperty("Background","Orange") // EJsS HtmlView.HtmlView: setting property 'Background' for element 'modeSelect'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"timeDisplay", _view.topPanel) // EJsS HtmlView.HtmlView: declaration of element 'timeDisplay'
      .setProperty("Background","Magenta") // EJsS HtmlView.HtmlView: setting property 'Background' for element 'timeDisplay'
      ;

    _view._addElement(EJSS_INTERFACE.button,"startBtn", _view.topPanel) // EJsS HtmlView.HtmlView: declaration of element 'startBtn'
      .setProperty("Width","30vw") // EJsS HtmlView.HtmlView: setting property 'Width' for element 'startBtn'
      .setProperty("Text","Start!") // EJsS HtmlView.HtmlView: setting property 'Text' for element 'startBtn'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton3", _view.topPanel) // EJsS HtmlView.HtmlView: declaration of element 'resetButton3'
      .setProperty("Width","10vw") // EJsS HtmlView.HtmlView: setting property 'Width' for element 'resetButton3'
      .setProperty("Text","↻Reset") // EJsS HtmlView.HtmlView: setting property 'Text' for element 'resetButton3'
      .setProperty("Font","normal normal 2vw ") // EJsS HtmlView.HtmlView: setting property 'Font' for element 'resetButton3'
      .setProperty("Display","inline-block") // EJsS HtmlView.HtmlView: setting property 'Display' for element 'resetButton3'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"scoreDisplay", _view.topPanel) // EJsS HtmlView.HtmlView: declaration of element 'scoreDisplay'
      .setProperty("Width","20vw") // EJsS HtmlView.HtmlView: setting property 'Width' for element 'scoreDisplay'
      .setProperty("Background","Yellow") // EJsS HtmlView.HtmlView: setting property 'Background' for element 'scoreDisplay'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView: setting property 'Display' for element 'scoreDisplay'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"audio", _view.topPanel) // EJsS HtmlView.HtmlView: declaration of element 'audio'
      .setProperty("AudioUrl","./cardMatching/Ding Sound Effect.m4a") // EJsS HtmlView.HtmlView: setting property 'AudioUrl' for element 'audio'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"audio2", _view.topPanel) // EJsS HtmlView.HtmlView: declaration of element 'audio2'
      .setProperty("AudioUrl","./cardMatching/Wrong-answer-sound-effect.mp3") // EJsS HtmlView.HtmlView: setting property 'AudioUrl' for element 'audio2'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"audio3", _view.topPanel) // EJsS HtmlView.HtmlView: declaration of element 'audio3'
      .setProperty("AudioUrl","./cardMatching/applause2.mp3") // EJsS HtmlView.HtmlView: setting property 'AudioUrl' for element 'audio3'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"mainPanel", _view._topFrame) // EJsS HtmlView.HtmlView: declaration of element 'mainPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.drawingPanel,"cardDisplay", _view.mainPanel) // EJsS HtmlView.HtmlView: declaration of element 'cardDisplay'
      .setProperty("Height","80vh") // EJsS HtmlView.HtmlView: setting property 'Height' for element 'cardDisplay'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView: setting property 'Width' for element 'cardDisplay'
      .setProperty("Background","LightGray") // EJsS HtmlView.HtmlView: setting property 'Background' for element 'cardDisplay'
      .setProperty("MinimumX",0) // EJsS HtmlView.HtmlView: setting property 'MinimumX' for element 'cardDisplay'
      .setProperty("MinimumY",0) // EJsS HtmlView.HtmlView: setting property 'MinimumY' for element 'cardDisplay'
      .setProperty("AutoScaleY",false) // EJsS HtmlView.HtmlView: setting property 'AutoScaleY' for element 'cardDisplay'
      .setProperty("AutoScaleX",false) // EJsS HtmlView.HtmlView: setting property 'AutoScaleX' for element 'cardDisplay'
      .setProperty("MarginX",5) // EJsS HtmlView.HtmlView: setting property 'MarginX' for element 'cardDisplay'
      .setProperty("MarginY",15) // EJsS HtmlView.HtmlView: setting property 'MarginY' for element 'cardDisplay'
      .setProperty("CursorTypeForMove","pointer") // EJsS HtmlView.HtmlView: setting property 'CursorTypeForMove' for element 'cardDisplay'
      .setProperty("LineWidth",0) // EJsS HtmlView.HtmlView: setting property 'LineWidth' for element 'cardDisplay'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"actual_answers_back_display_removed", _view.cardDisplay) // EJsS HtmlView.HtmlView: declaration of element 'actual_answers_back_display_removed'
      ;

    _view._addElement(EJSS_DRAWING2D.imageSet,"cardIcon", _view.actual_answers_back_display_removed) // EJsS HtmlView.HtmlView: declaration of element 'cardIcon'
      .setProperty("Sensitivity",0) // EJsS HtmlView.HtmlView: setting property 'Sensitivity' for element 'cardIcon'
      .setProperty("RelativePosition","SOUTH_WEST") // EJsS HtmlView.HtmlView: setting property 'RelativePosition' for element 'cardIcon'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"backof_cards", _view.cardDisplay) // EJsS HtmlView.HtmlView: declaration of element 'backof_cards'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"cardSet", _view.backof_cards) // EJsS HtmlView.HtmlView: declaration of element 'cardSet'
      .setProperty("RelativePosition","SOUTH_WEST") // EJsS HtmlView.HtmlView: setting property 'RelativePosition' for element 'cardSet'
      .setProperty("ShapeType","ROUND_RECTANGLE") // EJsS HtmlView.HtmlView: setting property 'ShapeType' for element 'cardSet'
      .setProperty("Sensitivity",0) // EJsS HtmlView.HtmlView: setting property 'Sensitivity' for element 'cardSet'
      .setProperty("LineWidth",0) // EJsS HtmlView.HtmlView: setting property 'LineWidth' for element 'cardSet'
      .setProperty("EnabledPosition","ENABLED_NO_MOVE") // EJsS HtmlView.HtmlView: setting property 'EnabledPosition' for element 'cardSet'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"instructionPanel", _view._topFrame) // EJsS HtmlView.HtmlView: declaration of element 'instructionPanel'
      .setProperty("Html","<h1 style=\"font-size: 2em !important; padding-left: 0;\">Card Matching Game</h1> <h2>Instructions</h2> <p>As part of the LSS Syllabus, Secondary 1 students are expected to learn  the following about the Globally Harmonised System (GHS). This application  aims to make learning about lab safety more enjoyable and interesting for  students. <br /><br /> This is a simple memory-match game. <br /> <ul style=\"text-align: left;\">   <li>     18 cards (9 symbol cards, 9 explanation cards) are faced down randomly      on the play-space   </li>   <li>     Students click on two cards and if they match, they get a point.   </li>   <li>     If they don’t match, the student has to try again to pick     a correct pair   </li>   <li>     They continue doing this until all 9 pairs are successfully match   </li> </ul> There are also <b>2 different modes</b> students can choose from: <ul style=\"text-align: left:\">   <li>      The first is the easy mode, where the cards are <b>covered initially</b>,      but when the game starts, the cards are shown throughout the duration of      the game   </li>   <li>     The second is the hard mode, where the cards are <b>shown initially</b>, but      when the game starts, the cards are covered throughout the duration the game    </li> </ul> Note that you are <b>not allowed</b> to change the mode during the game. </p>") // EJsS HtmlView.HtmlView: setting property 'Html' for element 'instructionPanel'
      ;

  };

  return _view;
}



      var _model;
      var _scorm;
      window.addEventListener('load',
        function () { 
          _model =  new MatchingGame18cardschoose3("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
