/* _inputParameters: an object with different values for the model parameters */
function clozepassageav2(_topFrame,_libraryPath,_codebasePath, _inputParameters) {
  var _model = EJSS_CORE.createAnimationLMS();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog,
    downloadText: EJSS_TOOLS.File.downloadText,
    uploadText: function(action) { EJSS_TOOLS.File.uploadText(_model,action); } 
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var t; // EjsS Model.Variables.Var Table.t
  var dt; // EjsS Model.Variables.Var Table.dt
  var pi; // EjsS Model.Variables.Var Table.pi
  var font; // EjsS Model.Variables.Var Table.font
  var close; // EjsS Model.Variables.Var Table.close
  var n; // EjsS Model.Variables.Var Table.n
  var correct; // EjsS Model.Variables.Var Table.correct
  var comboxoptions; // EjsS Model.Variables.Var Table.comboxoptions
  var comboxoption; // EjsS Model.Variables.Var Table.comboxoption
  var comboxoptiondisplay; // EjsS Model.Variables.Var Table.comboxoptiondisplay
  var comboxoptionforever; // EjsS Model.Variables.Var Table.comboxoptionforever
  var score; // EjsS Model.Variables.Var Table.score
  var lastitem; // EjsS Model.Variables.Var Table.lastitem
  var minutes; // EjsS Model.Variables.Var Table.minutes
  var seconds; // EjsS Model.Variables.Var Table.seconds
  var t2; // EjsS Model.Variables.Var Table.t2

  var iOS; // EjsS Model.Variables.layout.iOS
  var Android; // EjsS Model.Variables.layout.Android
  var iPad; // EjsS Model.Variables.layout.iPad
  var iPhone; // EjsS Model.Variables.layout.iPhone
  var Width; // EjsS Model.Variables.layout.Width
  var Height; // EjsS Model.Variables.layout.Height
  var Width1; // EjsS Model.Variables.layout.Width1
  var Width2; // EjsS Model.Variables.layout.Width2
  var world; // EjsS Model.Variables.layout.world
  var graph; // EjsS Model.Variables.layout.graph
  var disabledworld; // EjsS Model.Variables.layout.disabledworld
  var disabled; // EjsS Model.Variables.layout.disabled

  var xmin; // EjsS Model.Variables.cells.xmin
  var xmax; // EjsS Model.Variables.cells.xmax
  var ymin; // EjsS Model.Variables.cells.ymin
  var ymax; // EjsS Model.Variables.cells.ymax
  var xcell; // EjsS Model.Variables.cells.xcell
  var cellImageUrl; // EjsS Model.Variables.cells.cellImageUrl
  var cellUnicodeUrl; // EjsS Model.Variables.cells.cellUnicodeUrl
  var ycell; // EjsS Model.Variables.cells.ycell
  var cellsizex; // EjsS Model.Variables.cells.cellsizex
  var cellsizey; // EjsS Model.Variables.cells.cellsizey
  var text; // EjsS Model.Variables.cells.text
  var textanswer; // EjsS Model.Variables.cells.textanswer

  var _privateOdesList;
  var _ODEi_evolution1;
  var userEvents1=[];

  _model.getOdes = function() { return [_ODEi_evolution1]; };

  _model.removeEvents = function(){
    userEvents1=[];
  };

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      t : t,
      dt : dt,
      pi : pi,
      font : font,
      close : close,
      n : n,
      correct : correct,
      comboxoptions : comboxoptions,
      comboxoption : comboxoption,
      comboxoptiondisplay : comboxoptiondisplay,
      comboxoptionforever : comboxoptionforever,
      score : score,
      lastitem : lastitem,
      minutes : minutes,
      seconds : seconds,
      t2 : t2,
      iOS : iOS,
      Android : Android,
      iPad : iPad,
      iPhone : iPhone,
      Width : Width,
      Height : Height,
      Width1 : Width1,
      Width2 : Width2,
      world : world,
      graph : graph,
      disabledworld : disabledworld,
      disabled : disabled,
      xmin : xmin,
      xmax : xmax,
      ymin : ymin,
      ymax : ymax,
      xcell : xcell,
      cellImageUrl : cellImageUrl,
      cellUnicodeUrl : cellUnicodeUrl,
      ycell : ycell,
      cellsizex : cellsizex,
      cellsizey : cellsizey,
      text : text,
      textanswer : textanswer
    };
  };

  function _serializePublic() { return _model.serializePublic(); }

  _model._userSerializePublic = function() {
    return {
      t : t,
      dt : dt,
      pi : pi,
      font : font,
      close : close,
      n : n,
      correct : correct,
      comboxoptions : comboxoptions,
      comboxoption : comboxoption,
      comboxoptiondisplay : comboxoptiondisplay,
      comboxoptionforever : comboxoptionforever,
      score : score,
      lastitem : lastitem,
      minutes : minutes,
      seconds : seconds,
      t2 : t2,
      iOS : iOS,
      Android : Android,
      iPad : iPad,
      iPhone : iPhone,
      Width : Width,
      Height : Height,
      Width1 : Width1,
      Width2 : Width2,
      world : world,
      graph : graph,
      disabledworld : disabledworld,
      disabled : disabled,
      xmin : xmin,
      xmax : xmax,
      ymin : ymin,
      ymax : ymax,
      xcell : xcell,
      cellImageUrl : cellImageUrl,
      cellUnicodeUrl : cellUnicodeUrl,
      ycell : ycell,
      cellsizex : cellsizex,
      cellsizey : cellsizey,
      text : text,
      textanswer : textanswer
    };
  };

  _model._readParameters = function(json) {
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.pi != "undefined") pi = json.pi;
    if(typeof json.font != "undefined") font = json.font;
    if(typeof json.close != "undefined") close = json.close;
    if(typeof json.n != "undefined") n = json.n;
    if(typeof json.correct != "undefined") correct = json.correct;
    if(typeof json.comboxoptions != "undefined") comboxoptions = json.comboxoptions;
    if(typeof json.comboxoption != "undefined") comboxoption = json.comboxoption;
    if(typeof json.comboxoptiondisplay != "undefined") comboxoptiondisplay = json.comboxoptiondisplay;
    if(typeof json.comboxoptionforever != "undefined") comboxoptionforever = json.comboxoptionforever;
    if(typeof json.score != "undefined") score = json.score;
    if(typeof json.lastitem != "undefined") lastitem = json.lastitem;
    if(typeof json.minutes != "undefined") minutes = json.minutes;
    if(typeof json.seconds != "undefined") seconds = json.seconds;
    if(typeof json.t2 != "undefined") t2 = json.t2;
    if(typeof json.iOS != "undefined") iOS = json.iOS;
    if(typeof json.Android != "undefined") Android = json.Android;
    if(typeof json.iPad != "undefined") iPad = json.iPad;
    if(typeof json.iPhone != "undefined") iPhone = json.iPhone;
    if(typeof json.Width != "undefined") Width = json.Width;
    if(typeof json.Height != "undefined") Height = json.Height;
    if(typeof json.Width1 != "undefined") Width1 = json.Width1;
    if(typeof json.Width2 != "undefined") Width2 = json.Width2;
    if(typeof json.world != "undefined") world = json.world;
    if(typeof json.graph != "undefined") graph = json.graph;
    if(typeof json.disabledworld != "undefined") disabledworld = json.disabledworld;
    if(typeof json.disabled != "undefined") disabled = json.disabled;
    if(typeof json.xmin != "undefined") xmin = json.xmin;
    if(typeof json.xmax != "undefined") xmax = json.xmax;
    if(typeof json.ymin != "undefined") ymin = json.ymin;
    if(typeof json.ymax != "undefined") ymax = json.ymax;
    if(typeof json.xcell != "undefined") xcell = json.xcell;
    if(typeof json.cellImageUrl != "undefined") cellImageUrl = json.cellImageUrl;
    if(typeof json.cellUnicodeUrl != "undefined") cellUnicodeUrl = json.cellUnicodeUrl;
    if(typeof json.ycell != "undefined") ycell = json.ycell;
    if(typeof json.cellsizex != "undefined") cellsizex = json.cellsizex;
    if(typeof json.cellsizey != "undefined") cellsizey = json.cellsizey;
    if(typeof json.text != "undefined") text = json.text;
    if(typeof json.textanswer != "undefined") textanswer = json.textanswer;
  };

  _model._readParametersPublic = function(json) {
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.pi != "undefined") pi = json.pi;
    if(typeof json.font != "undefined") font = json.font;
    if(typeof json.close != "undefined") close = json.close;
    if(typeof json.n != "undefined") n = json.n;
    if(typeof json.correct != "undefined") correct = json.correct;
    if(typeof json.comboxoptions != "undefined") comboxoptions = json.comboxoptions;
    if(typeof json.comboxoption != "undefined") comboxoption = json.comboxoption;
    if(typeof json.comboxoptiondisplay != "undefined") comboxoptiondisplay = json.comboxoptiondisplay;
    if(typeof json.comboxoptionforever != "undefined") comboxoptionforever = json.comboxoptionforever;
    if(typeof json.score != "undefined") score = json.score;
    if(typeof json.lastitem != "undefined") lastitem = json.lastitem;
    if(typeof json.minutes != "undefined") minutes = json.minutes;
    if(typeof json.seconds != "undefined") seconds = json.seconds;
    if(typeof json.t2 != "undefined") t2 = json.t2;
    if(typeof json.iOS != "undefined") iOS = json.iOS;
    if(typeof json.Android != "undefined") Android = json.Android;
    if(typeof json.iPad != "undefined") iPad = json.iPad;
    if(typeof json.iPhone != "undefined") iPhone = json.iPhone;
    if(typeof json.Width != "undefined") Width = json.Width;
    if(typeof json.Height != "undefined") Height = json.Height;
    if(typeof json.Width1 != "undefined") Width1 = json.Width1;
    if(typeof json.Width2 != "undefined") Width2 = json.Width2;
    if(typeof json.world != "undefined") world = json.world;
    if(typeof json.graph != "undefined") graph = json.graph;
    if(typeof json.disabledworld != "undefined") disabledworld = json.disabledworld;
    if(typeof json.disabled != "undefined") disabled = json.disabled;
    if(typeof json.xmin != "undefined") xmin = json.xmin;
    if(typeof json.xmax != "undefined") xmax = json.xmax;
    if(typeof json.ymin != "undefined") ymin = json.ymin;
    if(typeof json.ymax != "undefined") ymax = json.ymax;
    if(typeof json.xcell != "undefined") xcell = json.xcell;
    if(typeof json.cellImageUrl != "undefined") cellImageUrl = json.cellImageUrl;
    if(typeof json.cellUnicodeUrl != "undefined") cellUnicodeUrl = json.cellUnicodeUrl;
    if(typeof json.ycell != "undefined") ycell = json.ycell;
    if(typeof json.cellsizex != "undefined") cellsizex = json.cellsizex;
    if(typeof json.cellsizey != "undefined") cellsizey = json.cellsizey;
    if(typeof json.text != "undefined") text = json.text;
    if(typeof json.textanswer != "undefined") textanswer = json.textanswer;
  };

  function _unserializePublic(json) { return _model.unserializePublic(json); }

  _model._userUnserializePublic = function(json) {
    _model._readParametersPublic(json);
   _resetSolvers();
   _model.update();
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    _model._readParameters(json);
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Init Page"] = true;
    __pagesEnabled["sort"] = true;
    __pagesEnabled["Evol Page"] = true;
    __pagesEnabled["FixRel Page"] = true;
  });

  _model.addToReset(function() {
    t = 0; // EjsS Model.Variables.Var Table.t
    dt = 0.05; // EjsS Model.Variables.Var Table.dt
    pi = Math.PI; // EjsS Model.Variables.Var Table.pi
    font = "normal normal 3vw "; // EjsS Model.Variables.Var Table.font
    n = 16; // EjsS Model.Variables.Var Table.n
    correct = new Array(n); // EjsS Model.Variables.Var Table.correct
    comboxoption = new Array(n); // EjsS Model.Variables.Var Table.comboxoption
    comboxoptiondisplay = new Array(n); // EjsS Model.Variables.Var Table.comboxoptiondisplay
    comboxoptionforever = 0; // EjsS Model.Variables.Var Table.comboxoptionforever
    score = 0; // EjsS Model.Variables.Var Table.score
    lastitem = ""; // EjsS Model.Variables.Var Table.lastitem
    minutes = 0; // EjsS Model.Variables.Var Table.minutes
    seconds = 0; // EjsS Model.Variables.Var Table.seconds
    t2 = 600-t; // EjsS Model.Variables.Var Table.t2
  });

  _model.addToReset(function() {
    iOS = /iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream; // EjsS Model.Variables.layout.iOS
    Android = /Android|android/i.test(navigator.userAgent); // EjsS Model.Variables.layout.Android
    iPad = /iPad/.test(navigator.userAgent) && !window.MSStream; // EjsS Model.Variables.layout.iPad
    iPhone = /iPhone|iPod/.test(navigator.userAgent) && !window.MSStream; // EjsS Model.Variables.layout.iPhone
    Width = (_isEPub)?"400":"100%"; // EjsS Model.Variables.layout.Width
    Height = (_isEPub)?"500":"100%"; // EjsS Model.Variables.layout.Height
    Width1 = "100%"; // EjsS Model.Variables.layout.Width1
    Width2 = "50%"; // EjsS Model.Variables.layout.Width2
    world = true; // EjsS Model.Variables.layout.world
    graph = true; // EjsS Model.Variables.layout.graph
    disabledworld = false; // EjsS Model.Variables.layout.disabledworld
    disabled = false; // EjsS Model.Variables.layout.disabled
  });

  _model.addToReset(function() {
    xmin = -10; // EjsS Model.Variables.cells.xmin
    xmax = 10; // EjsS Model.Variables.cells.xmax
    ymin = -10; // EjsS Model.Variables.cells.ymin
    ymax = 10; // EjsS Model.Variables.cells.ymax
    xcell = [-10,-8,-6,-4,-2,0,2,4,6,8,10]; // EjsS Model.Variables.cells.xcell
    cellImageUrl = new Array(n); // EjsS Model.Variables.cells.cellImageUrl
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.cells.cellImageUrl
        cellImageUrl[_i0] = "";  // EjsS Model.Variables.cells.cellImageUrl
      }
    }());
    cellUnicodeUrl = new Array(n); // EjsS Model.Variables.cells.cellUnicodeUrl
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.cells.cellUnicodeUrl
        cellUnicodeUrl[_i0] = "";  // EjsS Model.Variables.cells.cellUnicodeUrl
      }
    }());
    ycell = new Array(n); // EjsS Model.Variables.cells.ycell
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.cells.ycell
        ycell[_i0] = 7;  // EjsS Model.Variables.cells.ycell
      }
    }());
    cellsizex = (xmax-xmin)/(n); // EjsS Model.Variables.cells.cellsizex
    cellsizey = (ymax-ymin)/4; // EjsS Model.Variables.cells.cellsizey
    text = ["dc","dc","dc","dc","dc","ac","ac","ac","ac","ac","acdc"]; // EjsS Model.Variables.cells.text
    textanswer = ["dc","dc","dc","dc","dc","ac","ac","ac","ac","ac","acdc"]; // EjsS Model.Variables.cells.textanswer
  });

  if (_inputParameters) {
    _inputParameters = _model.parseInputParameters(_inputParameters);
    if (_inputParameters) _model.addToReset(function() { _model._readParameters(_inputParameters); });
  }

  _model.addToReset(function() {
    _privateOdesList=[];
    _ODEi_evolution1 = _ODE_evolution1();
    _privateOdesList.push(_ODEi_evolution1);
  });

  _model.addToReset(function() {
    _model.setAutoplay(true);
    _model.setPauseOnPageExit(true);
    _model.setFPS(20);
    _model.setStepsPerDisplay(1);
  });

  //https://developer.mozilla.org/en-US/docs/Web/Guide/API/DOM/Using_full_screen_mode  // > CustomCode.fullscreen:1
  // does not work for iOS   // > CustomCode.fullscreen:2
  /*jslint browser:true */  // > CustomCode.fullscreen:3
  function toggleFullScreen() {  // > CustomCode.fullscreen:4
    if (!document.fullscreenElement &&    // alternative standard method  // > CustomCode.fullscreen:5
        !document.mozFullScreenElement && !document.webkitFullscreenElement && !document.msFullscreenElement ) {  // current working methods  // > CustomCode.fullscreen:6
      if (document.documentElement.requestFullscreen) {  // > CustomCode.fullscreen:7
        document.documentElement.requestFullscreen();  // > CustomCode.fullscreen:8
      } else if (document.documentElement.msRequestFullscreen) {  // > CustomCode.fullscreen:9
        document.documentElement.msRequestFullscreen();  // > CustomCode.fullscreen:10
      } else if (document.documentElement.mozRequestFullScreen) {  // > CustomCode.fullscreen:11
        document.documentElement.mozRequestFullScreen();  // > CustomCode.fullscreen:12
      } else if (document.documentElement.webkitRequestFullscreen) {  // > CustomCode.fullscreen:13
        document.documentElement.webkitRequestFullscreen();  // > CustomCode.fullscreen:14
      }  // > CustomCode.fullscreen:15
    } else {  // > CustomCode.fullscreen:16
      if (document.exitFullscreen) {  // > CustomCode.fullscreen:17
        document.exitFullscreen();  // > CustomCode.fullscreen:18
      } else if (document.msExitFullscreen) {  // > CustomCode.fullscreen:19
        document.msExitFullscreen();  // > CustomCode.fullscreen:20
      } else if (document.mozCancelFullScreen) {  // > CustomCode.fullscreen:21
        document.mozCancelFullScreen();  // > CustomCode.fullscreen:22
      } else if (document.webkitExitFullscreen) {  // > CustomCode.fullscreen:23
        document.webkitExitFullscreen();  // > CustomCode.fullscreen:24
      }  // > CustomCode.fullscreen:25
    }  // > CustomCode.fullscreen:26
  }  // > CustomCode.fullscreen:27

  // code to be copied to EJSS source code under Custom and used in drawingPanel3D and plottingPanel2D  // > CustomCode.changeOrientation:1
  // address the problem is height difference is iOS app , epub, and Firefox  // > CustomCode.changeOrientation:2
  // user need to change only k and kepub  // > CustomCode.changeOrientation:3
  // copy %changeOrientation()% into the Height Field of drawingPanel3D and plottingPanel2D  // > CustomCode.changeOrientation:4
  function changeOrientation() {  // > CustomCode.changeOrientation:5
     // > CustomCode.changeOrientation:6
  var k =0.90 ; // k control height 1 is for full screen, 0.9 shorten etc  // > CustomCode.changeOrientation:7
  var kapple =0.90 // control apple app height  // > CustomCode.changeOrientation:8
  var kepub =0.90 ;  // > CustomCode.changeOrientation:9
  // check platform for Apps  // > CustomCode.changeOrientation:10
  try { // allow code to run in Student Learning Space   // > CustomCode.changeOrientation:11
    var iOSapp =  (typeof parent.device != 'undefined' && parent.device.platform == "iOS");  // > CustomCode.changeOrientation:12
    var Androidapp = (typeof parent.device != 'undefined' && parent.device.platform == "Android");  // > CustomCode.changeOrientation:13
  } catch(e) {  // > CustomCode.changeOrientation:14
    var iOSapp = false;  // > CustomCode.changeOrientation:15
    var Androidapp = false;  // > CustomCode.changeOrientation:16
  }  // > CustomCode.changeOrientation:17
  // check platform for web browsers  // > CustomCode.changeOrientation:18
  var iOS =/iPad|iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:19
  var iPad =/iPad/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:20
  var iPhone = /iPhone|iPod/.test(navigator.userAgent) && !window.MSStream;  // > CustomCode.changeOrientation:21
  var Android= /Android|android/i.test(navigator.userAgent);  // > CustomCode.changeOrientation:22
  //navigator  // > CustomCode.changeOrientation:23
  var Firefox = navigator.userAgent.indexOf("Firefox") != -1;  // > CustomCode.changeOrientation:24
     // > CustomCode.changeOrientation:25
  switch (window.orientation) { // using window.orientation as deciding factor  // > CustomCode.changeOrientation:26
    case 0:  // > CustomCode.changeOrientation:27
    case 180:  // > CustomCode.changeOrientation:28
      this.screenOrientation = 'portrait';  // > CustomCode.changeOrientation:29
      if (iOSapp){ // does not seems to work  // > CustomCode.changeOrientation:30
          // > CustomCode.changeOrientation:31
        return window.screen.height*kapple;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:32
        // > CustomCode.changeOrientation:33
      }  // > CustomCode.changeOrientation:34
      else if (_isEPub){ // does not seems to work  // > CustomCode.changeOrientation:35
        //   return Math.max(window.screen.width,window.screen.height)*0.9;  // > CustomCode.changeOrientation:36
        return window.innerHeight*kepub;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:37
        // return window.screen.height;  // > CustomCode.changeOrientation:38
        //  return window.innerHeight;  // > CustomCode.changeOrientation:39
        // return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:40
      }  // > CustomCode.changeOrientation:41
       // > CustomCode.changeOrientation:42
      else {  // > CustomCode.changeOrientation:43
         // > CustomCode.changeOrientation:44
        return 100*k+"vh";  // > CustomCode.changeOrientation:45
      }  // > CustomCode.changeOrientation:46
      break;  // > CustomCode.changeOrientation:47
    case 90:  // > CustomCode.changeOrientation:48
    case -90:  // > CustomCode.changeOrientation:49
      this.screenOrientation = 'landscape';  // > CustomCode.changeOrientation:50
     // > CustomCode.changeOrientation:51
      if (iOSapp){ // App  // > CustomCode.changeOrientation:52
        return window.screen.width*kapple;    // > CustomCode.changeOrientation:53
        // return window.screen.height;  // > CustomCode.changeOrientation:54
        //  return window.innerHeight;  // > CustomCode.changeOrientation:55
        //  return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:56
      }  // > CustomCode.changeOrientation:57
      else if (_isEPub){ // does not seems to work  // > CustomCode.changeOrientation:58
        //   return Math.max(window.screen.width,window.screen.height)*0.9;  // > CustomCode.changeOrientation:59
        return window.innerHeight*kepub;  //0.1 for app and 0.1 for nonfullscreenapp    // > CustomCode.changeOrientation:60
        // return window.screen.height;  // > CustomCode.changeOrientation:61
        //  return window.innerHeight;  // > CustomCode.changeOrientation:62
        // return document.documentElement.clientHeight;  // > CustomCode.changeOrientation:63
      }  // > CustomCode.changeOrientation:64
       // > CustomCode.changeOrientation:65
      else {  // > CustomCode.changeOrientation:66
        return 100*k+"vh";  // > CustomCode.changeOrientation:67
        }  // > CustomCode.changeOrientation:68
      break;  // > CustomCode.changeOrientation:69
    default:  // > CustomCode.changeOrientation:70
      this.screenOrientation = 'unknown';  // > CustomCode.changeOrientation:71
      //       return (iPad)?""+(window.screen.width+window.screen.height)*0.4:((iPhone)?""+window.screen.width:_view._format(window.innerHeight*0.9,"0"));  // > CustomCode.changeOrientation:72
       if (Firefox){  // > CustomCode.changeOrientation:73
        return window.innerHeight*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:74
        }  // > CustomCode.changeOrientation:75
     //   else if (iOS&&(window.orientation==0)||(window.orientation==180)){  // > CustomCode.changeOrientation:76
     //   return  window.screen.height*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:77
     //   }  // > CustomCode.changeOrientation:78
      //  else if (iOS&&(window.orientation==90)||(window.orientation==-90)){  // > CustomCode.changeOrientation:79
     //   return  window.screen.width*k;// number as of 20180831 Firefox does not support vh yet so need a separate line to handle  // > CustomCode.changeOrientation:80
     //   }  // > CustomCode.changeOrientation:81
        else {  // > CustomCode.changeOrientation:82
        //alert();  // > CustomCode.changeOrientation:83
        // return 100*k+"%"; // work on fullscreen works in EJSS6.0beta  // > CustomCode.changeOrientation:84
          //  works in EjsS_5.3_180131  // > CustomCode.changeOrientation:85
        return  window.innerHeight*k; // work on panel   // > CustomCode.changeOrientation:86
           // > CustomCode.changeOrientation:87
  }  // > CustomCode.changeOrientation:88
  }  // > CustomCode.changeOrientation:89
     // > CustomCode.changeOrientation:90
  }  // > CustomCode.changeOrientation:91

  // copy this custom function  // > CustomCode.speech:1
  // in iOS need to add speech to the play button as On iOS the API works but must be triggered by a user action callback, like a response to a tap event, to provide a better experience to users and avoid unexpected sounds out of your phone  // > CustomCode.speech:2
  function speech (option) {  // > CustomCode.speech:3
  // allow code to run in Student Learning Space   // > CustomCode.speech:4
  var isCordova = (!!this.parent.cordova || !!window.cordova);  // > CustomCode.speech:5
  if(isCordova) { // check it is running in Android or iOS  // > CustomCode.speech:6
          parent.TTS.speak(option);  // > CustomCode.speech:7
  } else {  // > CustomCode.speech:8
    var msg = new SpeechSynthesisUtterance(option);  // > CustomCode.speech:9
    //https://stackoverflow.com/questions/43983845/speechsynthesis-api-for-chinese-firefox  // > CustomCode.speech:10
    // Set the text.  // > CustomCode.speech:11
  	//msg.text = option;   // > CustomCode.speech:12
  	//https://forums.developer.apple.com/message/323564#323564  // > CustomCode.speech:13
  //msg.voice = speechSynthesis.getVoices().filter(function(voice) { return voice.name == 'Ting-Ting'; })[0];  // > CustomCode.speech:14
  //msg.lang = 'zh-CH'; // need for android?  // > CustomCode.speech:15
  //https://flaviocopes.com/speech-synthesis-api/  // > CustomCode.speech:16
  //debug  // > CustomCode.speech:17
  //console.log(`Voices #: ${speechSynthesis.getVoices().length}`)  // > CustomCode.speech:18
  //speechSynthesis.getVoices().forEach(voice => {  // > CustomCode.speech:19
  // console.log(voice.name, voice.lang)  // > CustomCode.speech:20
  //})  // > CustomCode.speech:21
  //debug  // > CustomCode.speech:22
  // Queue this utterance.  // > CustomCode.speech:23
  window.speechSynthesis.speak(msg);  // > CustomCode.speech:24
  }  // > CustomCode.speech:25
  }  // > CustomCode.speech:26

  // in initialization  // > CustomCode.shuffle:1
  // possible usage if x is the array  // > CustomCode.shuffle:2
  //shuffleArray(x);  // > CustomCode.shuffle:3
  //https://stackoverflow.com/questions/2450954/how-to-randomize-shuffle-a-javascript-array  // > CustomCode.shuffle:4
  /**  // > CustomCode.shuffle:5
   * Randomize array element order in-place.  // > CustomCode.shuffle:6
   * Using Durstenfeld shuffle algorithm.  // > CustomCode.shuffle:7
   */  // > CustomCode.shuffle:8
  function shuffleArray(array) {  // > CustomCode.shuffle:9
      for (var i = array.length - 1; i > 0; i--) {  // > CustomCode.shuffle:10
          var j = Math.floor(Math.random() * (i + 1));  // > CustomCode.shuffle:11
          var temp = array[i];  // > CustomCode.shuffle:12
          array[i] = array[j];  // > CustomCode.shuffle:13
          array[j] = temp;  // > CustomCode.shuffle:14
      }  // > CustomCode.shuffle:15
  }  // > CustomCode.shuffle:16

  //https://love2dev.com/blog/javascript-remove-from-array/  // > CustomCode.arrayRemove:1
  function arrayRemove(arr, value) {  // > CustomCode.arrayRemove:2
     return arr.filter(function(ele){  // > CustomCode.arrayRemove:3
         return ele != value;  // > CustomCode.arrayRemove:4
     });  // > CustomCode.arrayRemove:5
  }  // > CustomCode.arrayRemove:6
  //var result = arrayRemove(array, 6);  // > CustomCode.arrayRemove:7
  // result = [1, 2, 3, 4, 5, 7, 8, 9, 0]  // > CustomCode.arrayRemove:8

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Init Page"]) return;
    comboxoptions = ["","hate","anger","indifferent","cats","invaded","spared","rid","many","nose","resorted","friends","trampled","slammed","presented","forgotten"];  // > Initialization.Init Page:1
    comboxoptionsforever = ["","hate","anger","indifferent","cats","invaded","spared","rid","many","nose","resorted","friends","trampled","slammed","presented","forgotten"];  // > Initialization.Init Page:2
    for (var i=0; i<n  ; i++) {  // > Initialization.Init Page:3
      comboxoption[i] = comboxoptions;   // > Initialization.Init Page:4
      comboxoptiondisplay[i] = comboxoptions;   // > Initialization.Init Page:5
      }  // > Initialization.Init Page:6
     // alert("initialize()");  // > Initialization.Init Page:7
  });

  _model.addToInitialization(function() {
    if (!__pagesEnabled["sort"]) return;
     for (var i=0; i<n  ; i++) {  // > Initialization.sort:1
      comboxoptiondisplay[i] = comboxoptions.slice(); // from felix to copy and not just reference if without .slice()   // > Initialization.sort:2
     // shuffleArray(comboxoptiondisplay[i]);  // > Initialization.sort:3
    comboxoptiondisplay[i].sort();  // > Initialization.sort:4
    //comboxoption[i] = comboxoptions; // assign shorten list to all comboxoption  // > Initialization.sort:5
    //comboxoption[i] = comboxoption[i].splice(1,1,);   // > Initialization.sort:6
    }  // > Initialization.sort:7
    //comboxoption[1] =comboxoptionsforever; // put back original after loop  // > Initialization.sort:8
     //alert( comboxoption[1]);      // > Initialization.sort:9
            // > Initialization.sort:10
  });

  _model.addToInitialization(function() {
    _initializeSolvers();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Evol Page"]) return;
    _ODEi_evolution1.step();
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["FixRel Page"]) return;
    if (t.toFixed(0)>15*60){ // time is in sec, need *60 ?  // > FixedRelations.FixRel Page:1
                  // > FixedRelations.FixRel Page:2
      _tools.showOkDialog("Time is up. How many did you manage to answer correctly?");  // > FixedRelations.FixRel Page:3
      };  // > FixedRelations.FixRel Page:4
    t2=900-t  // > FixedRelations.FixRel Page:5
    minutes= Math.floor(t2 / 60);  // > FixedRelations.FixRel Page:6
    seconds= t2.toFixed(0) - minutes * 60;  // > FixedRelations.FixRel Page:7
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  function _initializeSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].initializeSolver();
  }

  function _automaticResetSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].automaticResetSolver();
  }

  _model.resetSolvers = function() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].resetSolver();
  };

  _getODE = function (_odeName) {
    if (_odeName=="Evol Page") return _ODEi_evolution1;
    return null;
  }

  function _getEventSolver(_odeName) {
    var ode = _getODE(_odeName);
    if (ode===null) return null;
    return ode.getEventSolver();
  }

  function _setSolverClass(_odeName, _engine) {
    var ode = _getODE(_odeName);
    if (ode===null) return;
    if (!_engine.setODE) {
      var classname = _engine.toLowerCase();
      if      (classname.indexOf("boga")>=0)   _engine = EJSS_ODE_SOLVERS.bogackiShampine23;
      else if (classname.indexOf("cash")>=0)   _engine = EJSS_ODE_SOLVERS.cashKarp45;
      else if (classname.indexOf("dopri5")>=0) _engine = EJSS_ODE_SOLVERS.dopri5;
      else if (classname.indexOf("dopri8")>=0) _engine = EJSS_ODE_SOLVERS.dopri853;
      else if (classname.indexOf("richa")>=0)  _engine = EJSS_ODE_SOLVERS.eulerRichardson;
      else if (classname.indexOf("euler")>=0)  _engine = EJSS_ODE_SOLVERS.euler;
      else if (classname.indexOf("fehlberg87")>=0) _engine = EJSS_ODE_SOLVERS.fehlberg87;
      else if (classname.indexOf("fehlberg8")>=0)  _engine = EJSS_ODE_SOLVERS.fehlberg8;
      else if (classname.indexOf("radau")>=0)   _engine = EJSS_ODE_SOLVERS.radau5;
      else if (classname.indexOf("runge")>=0)  _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("rk4")>=0)    _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("verlet")>=0) _engine = EJSS_ODE_SOLVERS.velocityVerlet;
    }
    if (_engine) ode.setSolverClass(_engine);
  }

  function _ODE_evolution1() {
    var __odeSelf = {};
    var __eventSolver;
    var __solverClass = EJSS_ODE_SOLVERS.euler;
    var __state=[];
    var __ignoreErrors=false;
    var __mustInitialize=true;
    var __isEnabled=true;
    var __mustUserReinitialize=false;
    var __mustReinitialize=true;


    __odeSelf._getOdeVars = function (){ return["t"]};

    __odeSelf.setSolverClass = function(__aSolverClass) {
      __solverClass = __aSolverClass;
      __instantiateSolver();
    };

    function __instantiateSolver() {
      __state=[];
      __pushState();
      __eventSolver = EJSS_ODE_SOLVERS.interpolatorEventSolver(__solverClass(),__odeSelf);
      __mustInitialize = true;
    }

    __odeSelf.setEnabled = function(_enabled) { __isEnabled = _enabled; };

    __odeSelf.getIndependentVariableValue = function() { return __eventSolver.getIndependentVariableValue(); };

    __odeSelf.getInternalStepSize = function() { return __eventSolver.getInternalStepSize(); };

    __odeSelf.isAccelerationIndependentOfVelocity = function() { return false; };

    __odeSelf.initializeSolver = function() {
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); return; }
      __pushState();
      __eventSolver.initialize(dt);
      __eventSolver.setBestInterpolation(false);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.removeAllEvents();
      for(k in userEvents1){__eventSolver.addEvent(userEvents1[k]);}
      __eventSolver.setEstimateFirstStep(false);
      __eventSolver.setEnableExceptions(false);
      __eventSolver.setTolerances(0.00001,0.00001);
      __mustReinitialize = true;
      __mustInitialize = false;
    };

    function __pushState() {
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        if (__state[__cIn]!=t) __mustReinitialize = true;
        __state[__cIn++] = t;
    }

    function __arraysChanged () {
      return false;
    }

    __odeSelf.getEventSolver = function() {
      return __eventSolver;
    };

    __odeSelf.resetSolver = function() {
      __mustUserReinitialize = true;
    };

    __odeSelf.automaticResetSolver = function() {
      __mustReinitialize = true;
    };

    function __errorAction () {
      if (__ignoreErrors) return;
      console.log (__eventSolver.getErrorMessage());
      _pause();
      // Make sure the solver is reinitialized;
      __mustReinitialize = true;
    }

    __odeSelf.step = function() { return __privateStep(false); };

    __odeSelf.solverStep = function() { return __privateStep(true); };

    function __privateStep(__takeMaximumStep) {
      if (!__isEnabled) return 0;
      if (dt===0) return 0;
      if (__mustInitialize) __odeSelf.initializeSolver();
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); }
      __eventSolver.setStepSize(dt);
      __eventSolver.setInternalStepSize(dt);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.setTolerances(0.00001,0.00001);
      __pushState();
      if (__mustUserReinitialize) { 
        __eventSolver.userReinitialize();
        __mustUserReinitialize = false;
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      else if (__mustReinitialize) { 
        __eventSolver.reinitialize();
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      var __stepTaken = __takeMaximumStep ? __eventSolver.maxStep() : __eventSolver.step();
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        t = __state[__cOut++];
      // Check for error
      if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      return __stepTaken;
    }

    __odeSelf.getState = function() { return __state; };

    __odeSelf.getRate = function(_aState,_aRate) {
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var t = _aState[__cOut++];
      // Compute the rate
        var __cRate=0;
        _aRate[__cRate++] = 1; // independent variable
        return _aRate;
    }; //end of getRate

    __odeSelf._addEvent = function(userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent){
    var User_Event = function (userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent) {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return eventType; };

      _eventSelf.getRootFindingMethod = function() { return eventMethod; };

      _eventSelf.getMaxIterations = function() { return maxIter; };

      _eventSelf.getTolerance = function() { return eventTolerance; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var t = _aState[__cOut++];
      return eval(userCondition);
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        t = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        __state[__cIn++] = t;
        return _returnValue;
      };

      function __userDefinedAction() {
        if (undefined != functions) eval(functions.toString());
        eval(userAction);
        return endAtEvent;
      }

      return _eventSelf;
    }; // End of event

   userEvents1.push(User_Event(userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent));
   }

    __instantiateSolver();

    return __odeSelf;
  }

    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 800, height : 600 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new clozepassageav2_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.fullscreen.linkProperty("Width",  function() { return Width; }, function(_v) { Width = _v; } ); // HtmlView Page linking property 'Width' for element 'fullscreen'
          _view.timer.linkProperty("Text",  function() { return "Time remaining = "+minutes+ " minutes "+seconds+ " seconds"; } ); // HtmlView Page linking property 'Text' for element 'timer'
          _view.resetButton3.setAction("OnClick", function(_data,_info) {
  _reset();

}); // HtmlView Page setting action 'OnClick' for element 'resetButton3'
          _view.label12.setAction("OnClick", function(_data,_info) {
  speech("“What do you think you are doing, letting  your  cats  out  of  the  house?” Mr Winston shouted at his  ");

}); // HtmlView Page setting action 'OnClick' for element 'label12'
          _view.label.setAction("OnClick", function(_data,_info) {
  speech("neighbour Madam Kate.  ");

}); // HtmlView Page setting action 'OnClick' for element 'label'
          _view.that.setAction("OnClick", function(_data,_info) {
  speech("“That  ");

}); // HtmlView Page setting action 'OnClick' for element 'that'
          _view.stench.setAction("OnClick", function(_data,_info) {
  speech("stench ");

}); // HtmlView Page setting action 'OnClick' for element 'stench'
          _view.label17.setAction("OnClick", function(_data,_info) {
  speech("from those  ");

}); // HtmlView Page setting action 'OnClick' for element 'label17'
          _view.label172.setAction("OnClick", function(_data,_info) {
  speech("critters!  ");

}); // HtmlView Page setting action 'OnClick' for element 'label172'
          _view.label1723.setAction("OnClick", function(_data,_info) {
  speech(" I am going to report the matter to the  ");

}); // HtmlView Page setting action 'OnClick' for element 'label1723'
          _view.label17232.setAction("OnClick", function(_data,_info) {
  speech("environment ");

}); // HtmlView Page setting action 'OnClick' for element 'label17232'
          _view.label1722.setAction("OnClick", function(_data,_info) {
  speech("officers!  How  I    ");

}); // HtmlView Page setting action 'OnClick' for element 'label1722'
          _view.comboBox1.linkProperty("Options",  function() { return !correct[1]?comboxoptiondisplay[1]:["hate"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox1'
          _view.comboBox1.linkProperty("Foreground",  function() { return correct[1]?"green":correct[1]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox1'
          _view.comboBox1.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox1.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "hate") {
      correct[1] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Remove "hate" from the comboxoptions array
      var index = comboxoptions.indexOf("hate");
      if (index !== -1) {
          comboxoptions.splice(index, 1); // remove the item at the found index
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[1] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox1'
          _view.comboBox1.linkProperty("Disabled",  function() { return correct[1]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox1'
          _view.label1.setAction("OnClick", function(_data,_info) {
  speech("the smell!  He raised his fists in ");

}); // HtmlView Page setting action 'OnClick' for element 'label1'
          _view.comboBox2.linkProperty("Options",  function() { return !correct[2]?comboxoptiondisplay[2]:["anger"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox2'
          _view.comboBox2.setAction("OnFocus", function(_data,_info) {
  //comboxoption[2].sort();
  //comboxoptiondisplay[2]=comboxoption[2];
  //comboxoptiondisplay[2].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox2'
          _view.comboBox2.linkProperty("Foreground",  function() { return correct[2]?"green":correct[2]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox2'
          _view.comboBox2.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox2.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "anger") {
      correct[2] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "anger" with "__" in comboxoptions
      var index = comboxoptions.indexOf("anger");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[2] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox2'
          _view.comboBox2.linkProperty("Disabled",  function() { return correct[2]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox2'
          _view.label2.setAction("OnClick", function(_data,_info) {
  speech("and stomped ");

}); // HtmlView Page setting action 'OnClick' for element 'label2'
          _view.label22.setAction("OnClick", function(_data,_info) {
  speech("his feet.  The old lady, on the other side of the fence, however, was  ");

}); // HtmlView Page setting action 'OnClick' for element 'label22'
          _view.comboBox3.linkProperty("Options",  function() { return !correct[3]?comboxoptiondisplay[3]:["indifferent"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox3'
          _view.comboBox3.setAction("OnFocus", function(_data,_info) {
  //comboxoption[3].sort();
  //comboxoptiondisplay[3]=comboxoption[3];
  //comboxoptiondisplay[3].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox3'
          _view.comboBox3.linkProperty("Foreground",  function() { return correct[3]?"green":correct[3]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox3'
          _view.comboBox3.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox3.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "indifferent") {
      correct[3] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "indifferent" with "__" in comboxoptions
      var index = comboxoptions.indexOf("indifferent");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[3] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox3'
          _view.comboBox3.linkProperty("Disabled",  function() { return correct[3]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox3'
          _view.label3.setAction("OnClick", function(_data,_info) {
  speech("to the shouting ");

}); // HtmlView Page setting action 'OnClick' for element 'label3'
          _view.label32.setAction("OnClick", function(_data,_info) {
  speech("and continued with her chores. ");

}); // HtmlView Page setting action 'OnClick' for element 'label32'
          _view.label322.setAction("OnClick", function(_data,_info) {
  speech("The ");

}); // HtmlView Page setting action 'OnClick' for element 'label322'
          _view.comboBox4.linkProperty("Options",  function() { return !correct[4]?comboxoptiondisplay[4]:["cats"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox4'
          _view.comboBox4.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox4'
          _view.comboBox4.linkProperty("Foreground",  function() { return correct[4]?"green":correct[4]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox4'
          _view.comboBox4.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox4.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "cats") {
      correct[4] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "cats" with "__" in comboxoptions
      var index = comboxoptions.indexOf("cats");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[4] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox4'
          _view.comboBox4.linkProperty("Disabled",  function() { return correct[4]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox4'
          _view.label42.setAction("OnClick", function(_data,_info) {
  speech("caused Mr Winston much ");

}); // HtmlView Page setting action 'OnClick' for element 'label42'
          _view.label43.setAction("OnClick", function(_data,_info) {
  speech("distress. ");

}); // HtmlView Page setting action 'OnClick' for element 'label43'
          _view.label4.setAction("OnClick", function(_data,_info) {
  speech("They often ");

}); // HtmlView Page setting action 'OnClick' for element 'label4'
          _view.comboBox5.linkProperty("Options",  function() { return !correct[5]?comboxoptiondisplay[5]:["invaded"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox5'
          _view.comboBox5.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox5'
          _view.comboBox5.linkProperty("Foreground",  function() { return correct[5]?"green":correct[5]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox5'
          _view.comboBox5.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox5.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "invaded") {
      correct[5] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "invaded" with "__" in comboxoptions
      var index = comboxoptions.indexOf("invaded");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[5] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox5'
          _view.comboBox5.linkProperty("Disabled",  function() { return correct[5]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox5'
          _view.label5.setAction("OnClick", function(_data,_info) {
  speech("his yard uninvited, squashing the flowers and creating a big mess.  Even his door was not ");

}); // HtmlView Page setting action 'OnClick' for element 'label5'
          _view.comboBox6.linkProperty("Options",  function() { return !correct[6]?comboxoptiondisplay[6]:["spared"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox6'
          _view.comboBox6.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox6'
          _view.comboBox6.linkProperty("Foreground",  function() { return correct[6]?"green":correct[6]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox6'
          _view.comboBox6.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox6.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "spared") {
      correct[6] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "spared" with "__" in comboxoptions
      var index = comboxoptions.indexOf("spared");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[6] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox6'
          _view.comboBox6.linkProperty("Disabled",  function() { return correct[6]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox6'
          _view.label6.setAction("OnClick", function(_data,_info) {
  speech(", with deep marks across after they had scratched it with their claws. The last straw  ");

}); // HtmlView Page setting action 'OnClick' for element 'label6'
          _view.label62.setAction("OnClick", function(_data,_info) {
  speech("came when they sneaked in the day before and ate his dinner while he was having his bath. He tried hard to");

}); // HtmlView Page setting action 'OnClick' for element 'label62'
          _view.label622.setAction("OnClick", function(_data,_info) {
  speech("get");

}); // HtmlView Page setting action 'OnClick' for element 'label622'
          _view.comboBox7.linkProperty("Options",  function() { return !correct[7]?comboxoptiondisplay[7]:["rid"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox7'
          _view.comboBox7.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox7'
          _view.comboBox7.linkProperty("Foreground",  function() { return correct[7]?"green":correct[7]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox7'
          _view.comboBox7.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox7.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "rid") {
      correct[7] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "rid" with "__" in comboxoptions
      var index = comboxoptions.indexOf("rid");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[7] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox7'
          _view.comboBox7.linkProperty("Disabled",  function() { return correct[7]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox7'
          _view.label7.setAction("OnClick", function(_data,_info) {
  speech("of the");

}); // HtmlView Page setting action 'OnClick' for element 'label7'
          _view.label73.setAction("OnClick", function(_data,_info) {
  speech("lingering ");

}); // HtmlView Page setting action 'OnClick' for element 'label73'
          _view.label74.setAction("OnClick", function(_data,_info) {
  speech("smell of those animals.  It did not go away no matter how");

}); // HtmlView Page setting action 'OnClick' for element 'label74'
          _view.comboBox8.linkProperty("Options",  function() { return !correct[8]?comboxoptiondisplay[8]:["many"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox8'
          _view.comboBox8.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox8'
          _view.comboBox8.linkProperty("Foreground",  function() { return correct[8]?"green":correct[8]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox8'
          _view.comboBox8.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox8.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "many") {
      correct[8] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "many" with "__" in comboxoptions
      var index = comboxoptions.indexOf("many");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[8] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox8'
          _view.comboBox8.linkProperty("Disabled",  function() { return correct[8]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox8'
          _view.label8.setAction("OnClick", function(_data,_info) {
  speech("times he sprayed the air-freshener.  At times, he was forced to go around his home ");

}); // HtmlView Page setting action 'OnClick' for element 'label8'
          _view.label82.setAction("OnClick", function(_data,_info) {
  speech("with a peg on his ");

}); // HtmlView Page setting action 'OnClick' for element 'label82'
          _view.comboBox9.linkProperty("Options",  function() { return !correct[9]?comboxoptiondisplay[9]:["nose"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox9'
          _view.comboBox9.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox9'
          _view.comboBox9.linkProperty("Foreground",  function() { return correct[9]?"green":correct[9]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox9'
          _view.comboBox9.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox9.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "nose") {
      correct[9] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "nose" with "__" in comboxoptions
      var index = comboxoptions.indexOf("nose");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[9] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox9'
          _view.comboBox9.linkProperty("Disabled",  function() { return correct[9]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox9'
          _view.label9.setAction("OnClick", function(_data,_info) {
  speech("Mr Winston even ");

}); // HtmlView Page setting action 'OnClick' for element 'label9'
          _view.comboBox10.linkProperty("Options",  function() { return !correct[10]?comboxoptiondisplay[10]:["resorted"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox10'
          _view.comboBox10.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox10'
          _view.comboBox10.linkProperty("Foreground",  function() { return correct[10]?"green":correct[10]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox10'
          _view.comboBox10.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox10.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "resorted") {
      correct[10] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "resorted" with "__" in comboxoptions
      var index = comboxoptions.indexOf("resorted");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[10] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox10'
          _view.comboBox10.linkProperty("Disabled",  function() { return correct[10]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox10'
          _view.label10.setAction("OnClick", function(_data,_info) {
  speech("to buying a fierce-looking dog, Skipper.  And what");

}); // HtmlView Page setting action 'OnClick' for element 'label10'
          _view.label102.setAction("OnClick", function(_data,_info) {
  speech("happened?  The cats made ");

}); // HtmlView Page setting action 'OnClick' for element 'label102'
          _view.comboBox11.linkProperty("Options",  function() { return !correct[11]?comboxoptiondisplay[11]:["friends"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox11'
          _view.comboBox11.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox11'
          _view.comboBox11.linkProperty("Foreground",  function() { return correct[11]?"green":correct[11]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox11'
          _view.comboBox11.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox11.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "friends") {
      correct[11] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "friends" with "__" in comboxoptions
      var index = comboxoptions.indexOf("friends");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[11] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox11'
          _view.comboBox11.linkProperty("Disabled",  function() { return correct[11]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox11'
          _view.label11.setAction("OnClick", function(_data,_info) {
  speech("with Skipper and now, like one of them, he played in");

}); // HtmlView Page setting action 'OnClick' for element 'label11'
          _view.label112.setAction("OnClick", function(_data,_info) {
  speech("the mud and ");

}); // HtmlView Page setting action 'OnClick' for element 'label112'
          _view.comboBox12.linkProperty("Options",  function() { return !correct[12]?comboxoptiondisplay[12]:["trampled"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox12'
          _view.comboBox12.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox12'
          _view.comboBox12.linkProperty("Foreground",  function() { return correct[12]?"green":correct[12]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox12'
          _view.comboBox12.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox12.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "trampled") {
      correct[12] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "trampled" with "__" in comboxoptions
      var index = comboxoptions.indexOf("trampled");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[12] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox12'
          _view.comboBox12.linkProperty("Disabled",  function() { return correct[12]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox12'
          _view.label13.setAction("OnClick", function(_data,_info) {
  speech("across his prized flowerbed.  He sighed as he ");

}); // HtmlView Page setting action 'OnClick' for element 'label13'
          _view.comboBox13.linkProperty("Options",  function() { return !correct[13]?comboxoptiondisplay[13]:["slammed"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox13'
          _view.comboBox13.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox13'
          _view.comboBox13.linkProperty("Foreground",  function() { return correct[13]?"green":correct[13]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox13'
          _view.comboBox13.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox13.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "slammed") {
      correct[13] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "slammed" with "__" in comboxoptions
      var index = comboxoptions.indexOf("slammed");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[13] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox13'
          _view.comboBox13.linkProperty("Disabled",  function() { return correct[13]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox13'
          _view.label14.setAction("OnClick", function(_data,_info) {
  speech("the door shut in anger.");

}); // HtmlView Page setting action 'OnClick' for element 'label14'
          _view.label142.setAction("OnClick", function(_data,_info) {
  speech("The doorbell rang and he raised his eyebrows.  Could it be the officers?  He pulled the door open and  ");

}); // HtmlView Page setting action 'OnClick' for element 'label142'
          _view.label1422.setAction("OnClick", function(_data,_info) {
  speech("here stood Madam Kate, smiling shyly.  Mr Winston looked at her in surprise as she");

}); // HtmlView Page setting action 'OnClick' for element 'label1422'
          _view.comboBox14.linkProperty("Options",  function() { return !correct[14]?comboxoptiondisplay[14]:["presented"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox14'
          _view.comboBox14.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox14'
          _view.comboBox14.linkProperty("Foreground",  function() { return correct[14]?"green":correct[14]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox14'
          _view.comboBox14.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox14.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "presented") {
      correct[14] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "presented" with "__" in comboxoptions
      var index = comboxoptions.indexOf("presented");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[14] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox14'
          _view.comboBox14.linkProperty("Disabled",  function() { return correct[14]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox14'
          _view.label15.setAction("OnClick", function(_data,_info) {
  speech("him with a large pie.  He leaned forward and caught   ");

}); // HtmlView Page setting action 'OnClick' for element 'label15'
          _view.label153.setAction("OnClick", function(_data,_info) {
  speech("a whiff of its aroma. ");

}); // HtmlView Page setting action 'OnClick' for element 'label153'
          _view.label1532.setAction("OnClick", function(_data,_info) {
  speech(" All the unhappiness he had ");

}); // HtmlView Page setting action 'OnClick' for element 'label1532'
          _view.label15322.setAction("OnClick", function(_data,_info) {
  speech("about her cats was ");

}); // HtmlView Page setting action 'OnClick' for element 'label15322'
          _view.label152.setAction("OnClick", function(_data,_info) {
  speech("momentarily ");

}); // HtmlView Page setting action 'OnClick' for element 'label152'
          _view.comboBox15.linkProperty("Options",  function() { return !correct[15]?comboxoptiondisplay[15]:["forgotten"]; } ); // HtmlView Page linking property 'Options' for element 'comboBox15'
          _view.comboBox15.setAction("OnFocus", function(_data,_info) {
  //comboxoption[4].sort();
  //comboxoptiondisplay[4]=comboxoption[4];
  //comboxoptiondisplay[4].sort();

}); // HtmlView Page setting action 'OnFocus' for element 'comboBox15'
          _view.comboBox15.linkProperty("Foreground",  function() { return correct[15]?"green":correct[15]==undefined?"":"red"; } ); // HtmlView Page linking property 'Foreground' for element 'comboBox15'
          _view.comboBox15.setAction("OnChange", function(_data,_info) {
  var opts = _view.comboBox15.getProperty("SelectedOptions");  // array of options
  var option = (opts.length > 0) ? opts[0] : ""; // selected option
  if (option === "forgotten") {
      correct[15] = true;
      _view.audio.play(); // play kids cheering sound clip
      // Replace "forgotten" with "__" in comboxoptions
      var index = comboxoptions.indexOf("forgotten");
      if (index !== -1) {
          comboxoptions.splice(index, 1, "__"); // replace the item at the found index with "__"
      }
      // Update the comboxoptiondisplay array with the modified comboxoptions
      for (var i = 0; i < n; i++) {
          comboxoptiondisplay[i] = comboxoptions.slice(); // create a copy of comboxoptions
          comboxoptiondisplay[i].sort(); // sort the array if needed
      }
  } else {
      correct[15] = false;
  }

}); // HtmlView Page setting action 'OnChange' for element 'comboBox15'
          _view.comboBox15.linkProperty("Disabled",  function() { return correct[15]==true; } ); // HtmlView Page linking property 'Disabled' for element 'comboBox15'
          _view.label16.setAction("OnClick", function(_data,_info) {
  speech(".  He shall enjoy the pie first.");

}); // HtmlView Page setting action 'OnClick' for element 'label16'
          _view.comboxoption_1_.linkProperty("Text",  function() { return "comboxoption[1]="+comboxoption[1]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_'
          _view.comboxoption_2_.linkProperty("Text",  function() { return "comboxoption[2]="+comboxoption[2]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_2_'
          _view.comboxoption_3_.linkProperty("Text",  function() { return "comboxoption[3]="+comboxoption[3]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_3_'
          _view.comboxoption_4_.linkProperty("Text",  function() { return "comboxoption[4]="+comboxoption[4]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_4_'
          _view.comboxoption_5_.linkProperty("Text",  function() { return "comboxoption[5]="+comboxoption[5]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_5_'
          _view.comboxoption_6_.linkProperty("Text",  function() { return "comboxoption[6]="+comboxoption[6]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_6_'
          _view.comboxoption_7_.linkProperty("Text",  function() { return "comboxoption[7]="+comboxoption[7]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_7_'
          _view.comboxoption_8_.linkProperty("Text",  function() { return "comboxoption[8]="+comboxoption[8]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_8_'
          _view.comboxoption_9_.linkProperty("Text",  function() { return "comboxoption[9]="+comboxoption[9]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_9_'
          _view.comboxoption_10_.linkProperty("Text",  function() { return "comboxoption[10]="+comboxoption[10]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_10_'
          _view.comboxoption_11_.linkProperty("Text",  function() { return "comboxoption[11]="+comboxoption[11]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_11_'
          _view.comboxoption_12_.linkProperty("Text",  function() { return "comboxoption[12]="+comboxoption[12]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_12_'
          _view.comboxoption_13_.linkProperty("Text",  function() { return "comboxoption[13]="+comboxoption[13]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_13_'
          _view.comboxoption_14_.linkProperty("Text",  function() { return "comboxoption[14]="+comboxoption[14]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_14_'
          _view.comboxoption_15_.linkProperty("Text",  function() { return "comboxoption[15]="+comboxoption[15]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_15_'
          _view.correct.linkProperty("Text",  function() { return "correct="+correct; } ); // HtmlView Page linking property 'Text' for element 'correct'
          _view.comboxoptions.linkProperty("Text",  function() { return "comboxoptions="+comboxoptions; } ); // HtmlView Page linking property 'Text' for element 'comboxoptions'
          _view.comboxoptionsforever.linkProperty("Text",  function() { return "comboxoptionsforever="+comboxoptionsforever; } ); // HtmlView Page linking property 'Text' for element 'comboxoptionsforever'
          _view.comboxoption_1_2.linkProperty("Text",  function() { return "comboxoptiondisplay[1]="+comboxoptiondisplay[1]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_2'
          _view.comboxoption_1_22.linkProperty("Text",  function() { return "comboxoptiondisplay[2]="+comboxoptiondisplay[2]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_22'
          _view.comboxoption_1_23.linkProperty("Text",  function() { return "comboxoptiondisplay[3]="+comboxoptiondisplay[3]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_23'
          _view.comboxoption_1_24.linkProperty("Text",  function() { return "comboxoptiondisplay[4]="+comboxoptiondisplay[4]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_24'
          _view.comboxoption_1_25.linkProperty("Text",  function() { return "comboxoption[5]="+comboxoption[5]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_25'
          _view.comboxoption_1_26.linkProperty("Text",  function() { return "comboxoption[6]="+comboxoption[6]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_26'
          _view.comboxoption_1_27.linkProperty("Text",  function() { return "comboxoption[7]="+comboxoption[7]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_27'
          _view.comboxoption_1_28.linkProperty("Text",  function() { return "comboxoption[8]="+comboxoption[8]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_28'
          _view.comboxoption_1_29.linkProperty("Text",  function() { return "comboxoption[9]="+comboxoption[9]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_29'
          _view.comboxoption_1_30.linkProperty("Text",  function() { return "comboxoption[10]="+comboxoption[10]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_30'
          _view.comboxoption_1_31.linkProperty("Text",  function() { return "comboxoption[11]="+comboxoption[11]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_31'
          _view.comboxoption_1_32.linkProperty("Text",  function() { return "comboxoption[12]="+comboxoption[12]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_32'
          _view.comboxoption_1_33.linkProperty("Text",  function() { return "comboxoption[13]="+comboxoption[13]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_33'
          _view.comboxoption_1_34.linkProperty("Text",  function() { return "comboxoption[14]="+comboxoption[14]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_34'
          _view.comboxoption_1_35.linkProperty("Text",  function() { return "comboxoption[15]="+comboxoption[15]; } ); // HtmlView Page linking property 'Text' for element 'comboxoption_1_35'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(true);
  _model.setFPS(20);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function clozepassageav2_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = clozepassageav2_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);


  return _view;
} // end of main function

function clozepassageav2_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"fullscreen", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'fullscreen'
      .setProperty("Background","rgba(192,255,255,1)") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'fullscreen'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"control", _view.fullscreen) // EJsS HtmlView.HtmlView Page: declaration of element 'control'
      .setProperty("BorderWidth",1) // EJsS HtmlView.HtmlView Page: setting property 'BorderWidth' for element 'control'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'control'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"panel", _view.control) // EJsS HtmlView.HtmlView Page: declaration of element 'panel'
      .setProperty("Font","normal normal 2vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'panel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"timer", _view.panel) // EJsS HtmlView.HtmlView Page: declaration of element 'timer'
      .setProperty("Font","normal bold 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'timer'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton3", _view.panel) // EJsS HtmlView.HtmlView Page: declaration of element 'resetButton3'
      .setProperty("Text","↻") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'resetButton3'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'resetButton3'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"closepassge", _view.control) // EJsS HtmlView.HtmlView Page: declaration of element 'closepassge'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'closepassge'
      .setProperty("CSS",{   "text-align":"left"      }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'closepassge'
      .setProperty("Font","normal normal 2vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'closepassge'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label122", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label122'
      .setProperty("TextAlign","left") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'label122'
      .setProperty("Text","FILL IN EACH BLANK WITH A SUITABLE WORD.") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label122'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label1232", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label1232'
      .setProperty("TextAlign","left") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'label1232'
      .setProperty("Text","                  ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label1232'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label1222", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label1222'
      .setProperty("TextAlign","left") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'label1222'
      .setProperty("Text","You can mouse over the words in") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label1222'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label12222", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label12222'
      .setProperty("TextAlign","left") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'label12222'
      .setProperty("Text","bold ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label12222'
      .setProperty("Font","italic bold 2vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'label12222'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label122232", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label122232'
      .setProperty("Text","if you are ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label122232'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label12223", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label12223'
      .setProperty("Text","unsure of their meaning.") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label12223'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label1223", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label1223'
      .setProperty("TextAlign","left") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'label1223'
      .setProperty("Text","You can also click on the sentences to have the computer read to you.") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label1223'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label123", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label123'
      .setProperty("TextAlign","left") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'label123'
      .setProperty("Text","_________________________________________________________________________") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label123'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"unicode", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'unicode'
      .setProperty("Tooltip","Fox") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'unicode'
      .setProperty("Text","😸") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'unicode'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label12", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label12'
      .setProperty("CSS",{          "margin-left":"30px"     }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'label12'
      .setProperty("TextAlign","left") // EJsS HtmlView.HtmlView Page: setting property 'TextAlign' for element 'label12'
      .setProperty("Text","“What do you think you are doing, letting  your  cats  out  of  the  house?” Mr Winston shouted at his  ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label12'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label'
      .setProperty("Text"," neighbour Madam Kate.   ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"that", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'that'
      .setProperty("Text","“That ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'that'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"stench", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'stench'
      .setProperty("Tooltip","stench(noun) - a strong, very unpleasant smell") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'stench'
      .setProperty("Text","stench ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'stench'
      .setProperty("Font","italic bold 2vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'stench'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label17", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label17'
      .setProperty("CSS",{   "text-align":"left"      }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'label17'
      .setProperty("Text","from those ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label17'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label172", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label172'
      .setProperty("CSS",{   "text-align":"left"      }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'label172'
      .setProperty("Tooltip","critters(noun) - animals") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'label172'
      .setProperty("Text","critters!") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label172'
      .setProperty("Font","italic bold 2vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'label172'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label1723", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label1723'
      .setProperty("CSS",{   "text-align":"left"      }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'label1723'
      .setProperty("Text"," I am going to report the matter to the") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label1723'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label17232", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label17232'
      .setProperty("CSS",{   "text-align":"left"      }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'label17232'
      .setProperty("Text","environment") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label17232'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label1722", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label1722'
      .setProperty("Text","officers!  How  I  ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label1722'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number'
      .setProperty("Text","(1)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox1", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox1'
      .setProperty("CSS",{          "margin-left":"15px"     }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'comboBox1'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox1'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label1", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label1'
      .setProperty("Text","the smell!”  He raised his fists in ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label1'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"numbers2", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'numbers2'
      .setProperty("Text","(2)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'numbers2'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox2", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox2'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox2'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label2", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label2'
      .setProperty("Text","and stomped") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label2'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label22", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label22'
      .setProperty("Text","his feet.  The old lady, on the other side of the fence, however, was") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label22'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"numbers3", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'numbers3'
      .setProperty("Text","(3)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'numbers3'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox3", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox3'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox3'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label3", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label3'
      .setProperty("Text","to the shouting") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label3'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label32", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label32'
      .setProperty("Text","and continued with her chores.") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label32'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label32222", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label32222'
      .setProperty("Text","                                ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label32222'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label3222", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label3222'
      .setProperty("Text","                                               ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label3222'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"unicode4", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'unicode4'
      .setProperty("Text","🐾") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'unicode4'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label322", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label322'
      .setProperty("CSS",{          "margin-left":"40px"     }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'label322'
      .setProperty("Text","The") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label322'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"numbers4", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'numbers4'
      .setProperty("Text","(4)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'numbers4'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox4", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox4'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox4'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label42", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label42'
      .setProperty("Text","caused Mr Winston much ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label42'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label43", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label43'
      .setProperty("Tooltip","distress(noun) - unhappiness") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'label43'
      .setProperty("Text","distress.") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label43'
      .setProperty("Font","italic bold 2vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'label43'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label4", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label4'
      .setProperty("Text","They often ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label4'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number5", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number5'
      .setProperty("Text","(5)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number5'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox5", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox5'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox5'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label5", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label5'
      .setProperty("Text","his yard uninvited, squashing the flowers and creating a big mess.  Even his door was not ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label5'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label52", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label52'
      .setProperty("Text","        ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label52'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number6", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number6'
      .setProperty("Text","(6)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number6'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox6", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox6'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox6'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label6", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label6'
      .setProperty("Text",", with deep marks across after they had scratched it with their claws. The last straw ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label6'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label62", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label62'
      .setProperty("Text","came when they sneaked in the day before and ate his dinner while he was having his bath. He tried hard to") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label62'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label622", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label622'
      .setProperty("Text","get") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label622'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number7", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number7'
      .setProperty("Text","(7)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number7'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox7", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox7'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox7'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label7", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label7'
      .setProperty("Text","of the ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label7'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label73", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label73'
      .setProperty("Tooltip"," lingering (adjective) - lasting for a long time") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'label73'
      .setProperty("Text","lingering") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label73'
      .setProperty("Font","italic bold 2vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'label73'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label74", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label74'
      .setProperty("Text","smell of those animals.  It did not go away no matter how") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label74'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label742", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label742'
      .setProperty("Text","  ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label742'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number8", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number8'
      .setProperty("Text","(8)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number8'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox8", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox8'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox8'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label8", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label8'
      .setProperty("Text","times he sprayed the air-freshener.  At times, he was forced to go around his home ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label8'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label82", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label82'
      .setProperty("Text"," with a peg on his ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label82'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number9", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number9'
      .setProperty("Text","(9)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number9'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox9", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox9'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox9'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label92", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label92'
      .setProperty("Text",".  ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label92'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label93", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label93'
      .setProperty("Text","                       ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label93'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label932", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label932'
      .setProperty("Text","                                                    ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label932'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"unicode3", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'unicode3'
      .setProperty("Text","🐕") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'unicode3'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label9", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label9'
      .setProperty("CSS",{          "margin-left":"40px"     }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'label9'
      .setProperty("Text","Mr Winston even ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label9'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number10", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number10'
      .setProperty("Text","(10)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number10'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox10", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox10'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox10'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label10", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label10'
      .setProperty("Text","to buying a fierce-looking dog, Skipper.  And what  ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label10'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label102", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label102'
      .setProperty("Text","happened?  The cats made ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label102'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number11", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number11'
      .setProperty("Text","(11)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number11'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox11", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox11'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox11'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label11", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label11'
      .setProperty("Text","with Skipper and now, like one of them, he played in") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label11'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label112", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label112'
      .setProperty("Text","the mud and ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label112'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number12", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number12'
      .setProperty("Text","(12)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number12'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox12", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox12'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox12'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label13", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label13'
      .setProperty("Text","across his prized flowerbed.  He sighed as he ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label13'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number13", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number13'
      .setProperty("Text","(13)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number13'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox13", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox13'
      .setProperty("Font","normal normal 3vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox13'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label14", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label14'
      .setProperty("Text","the door shut in anger.  ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label14'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label14232", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label14232'
      .setProperty("Text","                                               ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label14232'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"unicode2", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'unicode2'
      .setProperty("Text","🥞") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'unicode2'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label142", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label142'
      .setProperty("CSS",{          "margin-left":"40px"     }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'label142'
      .setProperty("Text"," The doorbell rang and he raised his eyebrows.  Could it be the officers?  He pulled the door open and  ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label142'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label1422", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label1422'
      .setProperty("Text","here stood Madam Kate, smiling shyly.  Mr Winston looked at her in surprise as she") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label1422'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number14", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number14'
      .setProperty("Text","(14)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number14'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox14", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox14'
      .setProperty("Font","normal normal 3vw") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox14'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label15", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label15'
      .setProperty("Text","him with a large pie.  He leaned forward and caught   ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label15'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label153", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label153'
      .setProperty("Tooltip","a whiff of its aroma - a pleasant smell that is only smelt for a short time") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'label153'
      .setProperty("Text","a whiff of its aroma.  ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label153'
      .setProperty("Font","italic bold 2vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'label153'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label1532", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label1532'
      .setProperty("Text"," All the unhappiness he had  ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label1532'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label15322", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label15322'
      .setProperty("Text","about her cats was ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label15322'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label152", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label152'
      .setProperty("Tooltip","momentarily(adverb) - for a very short time") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'label152'
      .setProperty("Text","momentarily ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label152'
      .setProperty("Font","italic bold 2vw ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'label152'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"number15", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'number15'
      .setProperty("Text","(15)") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'number15'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBox15", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBox15'
      .setProperty("Font","normal normal 3vw") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'comboBox15'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label16", _view.closepassge) // EJsS HtmlView.HtmlView Page: declaration of element 'label16'
      .setProperty("Text",".  He shall enjoy the pie first.") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label16'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"block", _view.control) // EJsS HtmlView.HtmlView Page: declaration of element 'block'
      .setProperty("Display","none") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'block'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_2_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_2_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_2_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_3_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_3_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_3_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_4_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_4_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_4_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_5_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_5_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_5_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_6_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_6_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_6_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_7_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_7_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_7_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_8_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_8_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_8_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_9_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_9_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_9_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_10_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_10_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_10_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_11_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_11_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_11_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_12_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_12_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_12_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_13_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_13_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_13_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_14_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_14_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_14_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_15_", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_15_'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_15_'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"correct", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'correct'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'correct'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoptions", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoptions'
      .setProperty("Background","Red") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'comboxoptions'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoptions'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoptionsforever", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoptionsforever'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoptionsforever'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_2", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_2'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_2'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_22", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_22'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_22'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_23", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_23'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_23'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_24", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_24'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_24'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_25", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_25'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_25'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_26", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_26'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_26'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_27", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_27'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_27'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_28", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_28'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_28'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_29", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_29'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_29'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_30", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_30'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_30'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_31", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_31'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_31'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_32", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_32'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_32'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_33", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_33'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_33'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_34", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_34'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_34'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"comboxoption_1_35", _view.block) // EJsS HtmlView.HtmlView Page: declaration of element 'comboxoption_1_35'
      .setProperty("Display","block") // EJsS HtmlView.HtmlView Page: setting property 'Display' for element 'comboxoption_1_35'
      ;

    _view._addElement(EJSS_INTERFACE.audio,"audio", _view.control) // EJsS HtmlView.HtmlView Page: declaration of element 'audio'
      .setProperty("Loop",false) // EJsS HtmlView.HtmlView Page: setting property 'Loop' for element 'audio'
      .setProperty("AudioUrl","./Kids Cheering - Gaming Sound Effect (HD).wav") // EJsS HtmlView.HtmlView Page: setting property 'AudioUrl' for element 'audio'
      ;

  };

  return _view;
}



      var _model;
      var _scorm;
      window.addEventListener('load',
        function () { 
          _model =  new clozepassageav2("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
