var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./simpleraydiagram/Screenshot.png"]="data:image/png;base64,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";
__base64Images["./simpleraydiagram/mb_icon.png"]="data:image/png;base64,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";
__base64Images["./simpleraydiagram/narrow_candle.gif"]="data:image/gif;base64,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";
__base64Images["./simpleraydiagram/bigeye.png"]="data:image/png;base64,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";
__base64Images["./simpleraydiagram/WC_logo.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADIAAAApCAIAAAD4TO2+AAAACXBIWXMAAAsTAAALEwEAmpwYAAAN50lEQVRYCYVYSXMcR3rNrMzaq7q6G92NlSAJabaIUdjji3xR+Bf46AiPHY6Yn+jTXObksRwzE2HLPow0kgiBoEgAjQZ6r641F7+sAhstUrSTZPKrpfN79b41k/7rb39LdgaltL2yLKuua8iiVtx1hBCMMYmhBd5h1MIjS5sZ9/HyqprZzNGVyPPSdX3HCzSl3LZ1VbQLblfG5a7cPn1n5h96Azi01tDHbcvhFtWAq9LNWmjhOA6zHapJjXekNO9w7jmeZzvXk5skjh3X49wu6loKYYDv4PiQuv8LFnBsH0MZlrCIxqfpuirSFZ5Ob25Gx/tM1mWZZekmS1PQ54IcL4j6/ZKL25ubJIxULajtOoxVVUXtFtgPwO0C3WrcFT7IVlFkgMVhLU3SdDWbTABreX/LqUjXy7vxzd14nKUrx/YGg0Gn1+vsn0RRNL6+6iWdveGIa1doJYnmjbYtSVthF8T7MgcruyS1b+CO43uMUE50ul5Mrt+cf/2Xusiz9fqcUlnmdZ6qMgdiYturOi+mk+lsFsad1xeXeZF+8qtfHdoW8zwvcImQ7ZpbQFvhfTTbO4YtjF1kkHEHvkUokaK+vXrz5vK78euXRbpmlNiUdwJvtD8a9eIw8BACMOYmq86vXt3m+SxNi83C98CRPn16Vsnc5e5WGZb9UXl7cyu8a8QWE2Z4DEAtFtOvvvrz9cuLbDFVddnvxCfD0V4cHA66R3sJcFFi5VVdVur5/vDbV5evxvp2vfjmP/+rWOfdIO4kPfIW1hbTVtiCeF9g//Kb3+DuO6/iUmlRV9X46s0f/+Pz6fjKt1kS+Ef7o8DivTDY7ybDJE58N3DcwPOjIPjo8ODZyXEYhJzZZVXN5ktGGCesMxxiNYxW91Z4H8ruHa6UaK/BEAbkdibKqrL8D//+OcmLDrf7rvvx8YHL2Miz44BHCDOj1KWM2ZQ6MLqluc8/+eVz4srefvz1y5vF4naY72erZZwkikjCiUW5lAphgNlmuzAeZfg6Lh6i9wHKFpPhDympTldLmzPPsZ8eH+zv7cGISZJ0u13McGj8vlZSwZA2hz8SqnzXe3Zyst8fDIdDKfTr6yuJUKbmU6mRkIEJ9CIBPwL5McnE7w9Iensp6vz69esZ0qPDRp3ooN8fdCIqRcfxoRt5AxmrkoZpBY6R98FYBcOXsR/0O+JoqPPJclMWmlkKNGmLSmVRSwEWUjOz9EOAvguqBcN3MUFuL40yUZ5/+xX8C4sejU59Rj1meU7QjTr4XmBSlSYMiqwSLwFfqZB1TVpn7qjbVW4kgg7xYxgFgwKEAv/4aHwF+JNbRe/iaq4fYEFuID36FjL13WSCYHNEnUQxtxiREqnbAJKSSPADVwFrMImxCHdAvKlCeOzYjBfCN2CkTeFUWsEnGg1KKSqkAHtNPf1RTGa19sE7mHCZ57msas/xHcvKskx69jrL4BkVN+CQPuDz8HfgsFEjHSdDQTLvO0BfVgWVdWBbuRRWXVDlaKmUZsSwBEM2bvMBl29ZfGQL+Npb7UwV5dwp5AYVLyurNIOXoL6xASoxhuvaNkLQ+Ax+Btsx4nCuUJzBYl3WDmdcZz7crsi06wGNgunxF35owulB1//P1pa2VojD2HX8ki68wLcdryirsBPBf8MwhCHQ86AMQyjLErxiJk7oeQ7SepyEymLMDUWWcS9URaGDQlu2RiZB9W88HlZX+PPhgRTyGBItT+3LG6vwY3uzYCRw11IExGaKrXNx8erS9V1ZVyIrYi+6m05nRTnLsiURB0O0FwfpLLc4s3gdBF4cB8lyPO12SJTQulY5Bcklrwmy11u1bYJ9J80++NY7uIHP98MnT57Or8foF6IwsmyX2s4mX9+MF0WRw8uRCI4HbhDvvZ5fInfJxWqR1T1h7fX7fhBEcWT7ngmRdWqyo8kiZmBl07g1ZbdVau7Aqs3zrfAIq33Q/hKzRdyT42df1J8XqyXYSizrbq5X6WaTll4YNN3W0uXhx8/PTo7Jt5cXH41GSLJnJ0/iIMRSMGOp6qqs0TDC/5gmJiUgRWDWCEyFSNwyhDvQuMUE+TEScYHRvgFBCZp0e4gylRFZFmgoFuWaWWjqaLpMAasbhdmmQOIIOf+7Tz8tlhPfdUPPdaDAsvKyyGvpD7pKIEUw8IMagPYLEspdq2Wrq8W3vYT2H4lEg44Qz/ZVpE6ePv12Os6y+p5OmbK6YfL8aNh8N4zoTb6/6qGJkb6uyrjTRYD6nmfVipkItWqkEAaH9NHkNkbSyjJpSwMjXL81aqNrF1Bz4y1buNg+awUJD6X07Oc/v3rxTZdboOGw1x/4yfGgQ21eKnU3vg2RvaQ8Ozq+uDi/+n663KRhHA2TXr+ThEkn4FZRShKjKjEiiLJN9MFcWH8H0qPeFkPL3AeNqJEFiBwenDw9+4lczR1Vw8cjRgdJhKqTTqdffvnl88MnZVmLUgwGB+mm/u5mfDGZDHv9p/tHI3S2NKK+p5r01qRQBY+DBU1qQM1oRotwF2crs3/8539q33hndpmtGDHtA7WqdE21ChkNJJkvpy9fff/li3ON+qMpMBV5sVyshMuHz56Eg954Nl2t104YsE5IQo8GYUEDqohgiFfKJFwbyZUxNBM/YO2Btge2KqB/b+AHMz33qWNrKz4+ZffzMr+cz9b4zUbVb6Z3glpJP/n64vL8+mXUjY/Pnuw/P7MDR9gd++AAQeh0E/gRF/W6RLnIStsV0vIsJq0ScaMkzUmN1eBomBBGSLCo6ABSyQoz+4df/3qLahc+QxlGTOEDMUuBprleLdb394VQlu8df/yTGktZPE0zBKnDneVqUabZv/3udzIv/vqvPoni2LKR6kGVXUotLYbwQ41CzoAF0d0ADvSafxhIGQ9OBwhG4Qd9i2uQjg0EqgUa38E0ilaUIpEGSAFBeH756tXVVTeMLcc72j9wCN3v7VlK/v1nny032Ww6OTw9EoRl2JZzXRYFd3zUUDgWdmkIfqUfTATfN0CaEABuQ1fD2WOCaKnazuhNlSLMtgVyH2NOErMwiEZD6Lu6u7s4f7Fcp1ZS78UxygBymKv06eGRTaxlkk9FOVkvot6I4GBAKLBIg9h2XNHsv9FAoKKbDWjjW6ZsN5RhQkEyvexuOsVL7XsPM2ol2mHbbKtLraO94Sp+A6aEx7r9zi8+fg46q7yIA3/Q62DrsddNXMsCJft7CRGVDILGRyxsx1DUSZ43mCxu0BgTotV5ANNYExUcl8bZkHi36bSB9ENY5ucEP8arCEevP3D3hvV8QXyaeL6jbVJgH5ajbTgY9LQS0GdHkbZtgt0PJTnjldS2a5sWvtkhl3lBcGLiojmyiesUWfYWF9owA6hF2TC4k07f3n1AiCYSWyuNTSz2VdxmLNg7Or3Kq6zEvrB+cvJUFhVgWchuzBp196Kkpz1X+Z5wPFHBp3Sar1hdkUKXQgUNZ4yjFlIttINNCz4AVmu0wawIW4DDFeqDYQv/HoDs/IebQqGVg2Ohs1O2x7Fl741G95PbYraxNZ3nFUpyd9APmLbzjJk2p3TjcEMomq+iqPD1aG7vF7NyUWgnYp1uiQyBgliV2BH5gYx6CRSiGkGFQrVEFQYyjaLZwEK7CJsae5n/G/9rUOPQBQsRBvDwAwpwOeFP/uZvp1/86fvLC824HTqqEBvsheL4VuSlSoPK1QUDOZu6XiPPrrPNm/E389Wnn32WblZmC0KC2In90Bx7rWZ3aLjNYAxRiqBCokE7mcGht2xBwgDY7QySzTEEWEW3axlSkRpQaQZnZ/Cj6fXVi+9eDrod33UWWYYdz2I1DaaLOO7Vhc6kpJFn4ZSrPzjt9eFQFVp4Yg4Q6qJE261k7fs+1gVDBbJOnuMRBlpfWRjmHhJEC2iLCYIp/tgVoKG30BAge5ntDPYaJHBIFL+4uurbZmc9Wyy9OFiuV+l84szXUbhZrvN5JZx+01CACT/EPsALQ8DCEZAfuMYilaKecXMgwzC7KRiymVF5H2G1gHbZwgkCaioIE3AzIbGHxjkbEs5XX3/zh9//3pwF+ur2xd2zo4O7u7tsnaoKNruuauwnwxAJTFlZqUpGkUaY493eT7HR7iYx9k4mSRsYxpMwQzU6IhgTsLBF8HG9a8RdTI3McBaKeMRLsF1VFP/zxX8vFovL8+8WdzMcXAGwylL35lYuFqSsfJc5JbY5eRwPBv1hzV0cRLlIH4f70/kSbovetem/4K5Im6Y1BSbgwDq4j8/GDM9B1oHGh1S7xQShlRHkGIgpDHwKVinzzfxugr0VTtLwe7Tqyyx9c/1a17Ut62y5ZlIHbhAkMY6AEcVHo+HPfvrTIhfT6fz09BSUFJvMQDENhDkvhiIsC5Lg6fAwCDAo7mCYaGxxtHN7CRmGxktwQ9s2zlhkGxw94FOogy5cF3WBMg5Ny/WiJpUTOWjwUVIIZ8Jh0rO6g24Y+jhyvb6++ejZR52wI8oKfEB9JWpJCWABB9ThJnAALr4fvlsJib+PNXGLDwKGaTZMs6bxaqHkeDyOMcLwdrpBaw7EyNZxHLEi7hz0cRzFU1IWq3iQOIMOj3w/DspNPrm6Ozo8PTw8woLYDKOBAPEwKOzfCAQWBLiGIHP+iBFEXfOy2Namt7QZUMi/yH2igmejps7m9/hBVZVeJ+LpvcPRvINLri1//+gXvcSzq1kqFqP9gUy6nf4IB5nFerVI14eHxzhWEnKDxhRrwgigBPTgq0AWkIEkZAfACoIATyEj1yBN/C+mKOB0Fq27/gAAAABJRU5ErkJggg==";
__base64Images["./simpleraydiagram/FlatMirror.jpg"]="data:image/jpeg;base64,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";
__base64Images["./simpleraydiagram/PacoEsquembre2011.png"]="data:image/png;base64,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";
