var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./cannon.png"]="data:image/png;base64,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";
__base64Images["./projectile/Screen Shot 2017-10-23 at 2.42.31 PM.png"]="data:image/png;base64,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";
