var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./MassAndSpring/01authorleongtzekwang.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/MassAndSpring.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./MassAndSpring/PacoEsquembre2011.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/Screen Shot 2017-10-24 at 8.57.06 AM.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/WC_logo.png"]="data:image/png;base64,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";
__base64Images["./MassAndSpring/MassAndSpringComplete.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./MassAndSpring/MassAndSpring.gif"]="data:image/gif;base64,R0lGODlhbwBHAIcAAAAAAP8A/+/v/wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAAAIALAAAAABvAEcAAAj/AAUIHEiwoMGDCBMqXMiwocOHECNKnEixosWLGDNq3Mixo0MAIEOKHEkSgMeTHEuqLImyJcaVMEO6nEkxZkyaOCHahJmzJ8OdK30KRQhU5dCjBIuyRIpUKUmmTZ2KhHpU6lSqQq3KxOpTK0iuXb2C7enV5FicZc+iFat2Ztq2Lt/CRSl3rse6dlOyzUv06se9fAeGDECY8NeGePkCKMy4sNmFie0ubkz5cMLIcCdTrgwZMNGDjwWDNhha9OXNqAOULog5KenVsGG/Pp0a9WrBnmWz1p2UN27atTn31dqbtYDSlgWaRI78+G7gwRnfVg44uXPmxrG71k46uu3hVn+H4l6efXt50dxZe988vezV8c5Nw4cfX3n9670Hr2/c3vN98vKZFyB6Av63H3/gSUWaafWZ9diDAzYYIHIHSpegU6NJaN+GEG4YX4cNwlahapf592GE+KEIIIc/jTjdcSbC+NyMv9FI3UcHvggjcYEdt56OO4bXI0jRWfcajz36mBqQ1CGZpH6OMdmkkEnmZ6RCrVUZUZZaPsRll4jFCKaXYo4ZppNmbllmmliuyeaFSr0p0Zdy7oZmnZ3diWeJeu4Jmpt+BqlgoHlSSSicRR3aZp+KCopho38yqiidkFZq6aVsBgQAOw==";
