function pvg_cut_the_rope(_topFrame,_libraryPath,_codebasePath) {
  var _model = EJSS_CORE.createAnimation();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var showControls; // EjsS Model.Variables.Display.showControls
  var topPanelHeight; // EjsS Model.Variables.Display.topPanelHeight
  var controlPanelHeight; // EjsS Model.Variables.Display.controlPanelHeight
  var displayScale; // EjsS Model.Variables.Display.displayScale

  var xMin; // EjsS Model.Variables.World.xMin
  var xMax; // EjsS Model.Variables.World.xMax
  var yMin; // EjsS Model.Variables.World.yMin
  var yMax; // EjsS Model.Variables.World.yMax
  var xMiddle; // EjsS Model.Variables.World.xMiddle
  var yMiddle; // EjsS Model.Variables.World.yMiddle
  var yRange; // EjsS Model.Variables.World.yRange
  var yMargin; // EjsS Model.Variables.World.yMargin
  var running; // EjsS Model.Variables.World.running
  var gameOver; // EjsS Model.Variables.World.gameOver
  var randomGenerator; // EjsS Model.Variables.World.randomGenerator
  var time; // EjsS Model.Variables.World.time
  var deltaTime; // EjsS Model.Variables.World.deltaTime
  var g; // EjsS Model.Variables.World.g
  var xLastClick; // EjsS Model.Variables.World.xLastClick
  var yLastClick; // EjsS Model.Variables.World.yLastClick

  var startX; // EjsS Model.Variables.Instructions.startX
  var startY; // EjsS Model.Variables.Instructions.startY
  var startWidth; // EjsS Model.Variables.Instructions.startWidth
  var startHeight; // EjsS Model.Variables.Instructions.startHeight
  var startMessage; // EjsS Model.Variables.Instructions.startMessage
  var playAgainMessage; // EjsS Model.Variables.Instructions.playAgainMessage
  var gameWonMessage; // EjsS Model.Variables.Instructions.gameWonMessage
  var gameSurvivedMessage; // EjsS Model.Variables.Instructions.gameSurvivedMessage
  var gameLostMessage; // EjsS Model.Variables.Instructions.gameLostMessage
  var gameOverMessage; // EjsS Model.Variables.Instructions.gameOverMessage
  var gameResultMessage; // EjsS Model.Variables.Instructions.gameResultMessage
  var message; // EjsS Model.Variables.Instructions.message
  var YOU_LOST; // EjsS Model.Variables.Instructions.YOU_LOST
  var YOU_WON; // EjsS Model.Variables.Instructions.YOU_WON
  var YOU_SURVIVED; // EjsS Model.Variables.Instructions.YOU_SURVIVED

  var bigMass; // EjsS Model.Variables.Big mass.bigMass
  var massDiameter; // EjsS Model.Variables.Big mass.massDiameter
  var xMass; // EjsS Model.Variables.Big mass.xMass
  var yMass; // EjsS Model.Variables.Big mass.yMass
  var vxMass; // EjsS Model.Variables.Big mass.vxMass
  var vyMass; // EjsS Model.Variables.Big mass.vyMass
  var frMass; // EjsS Model.Variables.Big mass.frMass

  var frogSizeX; // EjsS Model.Variables.Frog.frogSizeX
  var frogSizeY; // EjsS Model.Variables.Frog.frogSizeY
  var xFrog; // EjsS Model.Variables.Frog.xFrog
  var yFrog; // EjsS Model.Variables.Frog.yFrog
  var goalDistance; // EjsS Model.Variables.Frog.goalDistance

  var maxRopes; // EjsS Model.Variables.Ropes.maxRopes
  var massesPerRope; // EjsS Model.Variables.Ropes.massesPerRope
  var maxMasses; // EjsS Model.Variables.Ropes.maxMasses
  var nRopes; // EjsS Model.Variables.Ropes.nRopes
  var ropeLength; // EjsS Model.Variables.Ropes.ropeLength
  var x; // EjsS Model.Variables.Ropes.x
  var y; // EjsS Model.Variables.Ropes.y
  var vx; // EjsS Model.Variables.Ropes.vx
  var vy; // EjsS Model.Variables.Ropes.vy
  var ax; // EjsS Model.Variables.Ropes.ax
  var ay; // EjsS Model.Variables.Ropes.ay
  var mass; // EjsS Model.Variables.Ropes.mass
  var sx; // EjsS Model.Variables.Ropes.sx
  var sy; // EjsS Model.Variables.Ropes.sy
  var link; // EjsS Model.Variables.Ropes.link
  var k; // EjsS Model.Variables.Ropes.k
  var fr; // EjsS Model.Variables.Ropes.fr
  var fr2; // EjsS Model.Variables.Ropes.fr2

  var _privateOdesList;
  var _ODEi_evolution1;

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      showControls : showControls,
      topPanelHeight : topPanelHeight,
      controlPanelHeight : controlPanelHeight,
      displayScale : displayScale,
      xMin : xMin,
      xMax : xMax,
      yMin : yMin,
      yMax : yMax,
      xMiddle : xMiddle,
      yMiddle : yMiddle,
      yRange : yRange,
      yMargin : yMargin,
      running : running,
      gameOver : gameOver,
      randomGenerator : randomGenerator,
      time : time,
      deltaTime : deltaTime,
      g : g,
      xLastClick : xLastClick,
      yLastClick : yLastClick,
      startX : startX,
      startY : startY,
      startWidth : startWidth,
      startHeight : startHeight,
      startMessage : startMessage,
      playAgainMessage : playAgainMessage,
      gameWonMessage : gameWonMessage,
      gameSurvivedMessage : gameSurvivedMessage,
      gameLostMessage : gameLostMessage,
      gameOverMessage : gameOverMessage,
      gameResultMessage : gameResultMessage,
      message : message,
      YOU_LOST : YOU_LOST,
      YOU_WON : YOU_WON,
      YOU_SURVIVED : YOU_SURVIVED,
      bigMass : bigMass,
      massDiameter : massDiameter,
      xMass : xMass,
      yMass : yMass,
      vxMass : vxMass,
      vyMass : vyMass,
      frMass : frMass,
      frogSizeX : frogSizeX,
      frogSizeY : frogSizeY,
      xFrog : xFrog,
      yFrog : yFrog,
      goalDistance : goalDistance,
      maxRopes : maxRopes,
      massesPerRope : massesPerRope,
      maxMasses : maxMasses,
      nRopes : nRopes,
      ropeLength : ropeLength,
      x : x,
      y : y,
      vx : vx,
      vy : vy,
      ax : ax,
      ay : ay,
      mass : mass,
      sx : sx,
      sy : sy,
      link : link,
      k : k,
      fr : fr,
      fr2 : fr2
    };
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    if(typeof json.showControls != "undefined") showControls = json.showControls;
    if(typeof json.topPanelHeight != "undefined") topPanelHeight = json.topPanelHeight;
    if(typeof json.controlPanelHeight != "undefined") controlPanelHeight = json.controlPanelHeight;
    if(typeof json.displayScale != "undefined") displayScale = json.displayScale;
    if(typeof json.xMin != "undefined") xMin = json.xMin;
    if(typeof json.xMax != "undefined") xMax = json.xMax;
    if(typeof json.yMin != "undefined") yMin = json.yMin;
    if(typeof json.yMax != "undefined") yMax = json.yMax;
    if(typeof json.xMiddle != "undefined") xMiddle = json.xMiddle;
    if(typeof json.yMiddle != "undefined") yMiddle = json.yMiddle;
    if(typeof json.yRange != "undefined") yRange = json.yRange;
    if(typeof json.yMargin != "undefined") yMargin = json.yMargin;
    if(typeof json.running != "undefined") running = json.running;
    if(typeof json.gameOver != "undefined") gameOver = json.gameOver;
    if(typeof json.randomGenerator != "undefined") randomGenerator = json.randomGenerator;
    if(typeof json.time != "undefined") time = json.time;
    if(typeof json.deltaTime != "undefined") deltaTime = json.deltaTime;
    if(typeof json.g != "undefined") g = json.g;
    if(typeof json.xLastClick != "undefined") xLastClick = json.xLastClick;
    if(typeof json.yLastClick != "undefined") yLastClick = json.yLastClick;
    if(typeof json.startX != "undefined") startX = json.startX;
    if(typeof json.startY != "undefined") startY = json.startY;
    if(typeof json.startWidth != "undefined") startWidth = json.startWidth;
    if(typeof json.startHeight != "undefined") startHeight = json.startHeight;
    if(typeof json.startMessage != "undefined") startMessage = json.startMessage;
    if(typeof json.playAgainMessage != "undefined") playAgainMessage = json.playAgainMessage;
    if(typeof json.gameWonMessage != "undefined") gameWonMessage = json.gameWonMessage;
    if(typeof json.gameSurvivedMessage != "undefined") gameSurvivedMessage = json.gameSurvivedMessage;
    if(typeof json.gameLostMessage != "undefined") gameLostMessage = json.gameLostMessage;
    if(typeof json.gameOverMessage != "undefined") gameOverMessage = json.gameOverMessage;
    if(typeof json.gameResultMessage != "undefined") gameResultMessage = json.gameResultMessage;
    if(typeof json.message != "undefined") message = json.message;
    if(typeof json.YOU_LOST != "undefined") YOU_LOST = json.YOU_LOST;
    if(typeof json.YOU_WON != "undefined") YOU_WON = json.YOU_WON;
    if(typeof json.YOU_SURVIVED != "undefined") YOU_SURVIVED = json.YOU_SURVIVED;
    if(typeof json.bigMass != "undefined") bigMass = json.bigMass;
    if(typeof json.massDiameter != "undefined") massDiameter = json.massDiameter;
    if(typeof json.xMass != "undefined") xMass = json.xMass;
    if(typeof json.yMass != "undefined") yMass = json.yMass;
    if(typeof json.vxMass != "undefined") vxMass = json.vxMass;
    if(typeof json.vyMass != "undefined") vyMass = json.vyMass;
    if(typeof json.frMass != "undefined") frMass = json.frMass;
    if(typeof json.frogSizeX != "undefined") frogSizeX = json.frogSizeX;
    if(typeof json.frogSizeY != "undefined") frogSizeY = json.frogSizeY;
    if(typeof json.xFrog != "undefined") xFrog = json.xFrog;
    if(typeof json.yFrog != "undefined") yFrog = json.yFrog;
    if(typeof json.goalDistance != "undefined") goalDistance = json.goalDistance;
    if(typeof json.maxRopes != "undefined") maxRopes = json.maxRopes;
    if(typeof json.massesPerRope != "undefined") massesPerRope = json.massesPerRope;
    if(typeof json.maxMasses != "undefined") maxMasses = json.maxMasses;
    if(typeof json.nRopes != "undefined") nRopes = json.nRopes;
    if(typeof json.ropeLength != "undefined") ropeLength = json.ropeLength;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.vx != "undefined") vx = json.vx;
    if(typeof json.vy != "undefined") vy = json.vy;
    if(typeof json.ax != "undefined") ax = json.ax;
    if(typeof json.ay != "undefined") ay = json.ay;
    if(typeof json.mass != "undefined") mass = json.mass;
    if(typeof json.sx != "undefined") sx = json.sx;
    if(typeof json.sy != "undefined") sy = json.sy;
    if(typeof json.link != "undefined") link = json.link;
    if(typeof json.k != "undefined") k = json.k;
    if(typeof json.fr != "undefined") fr = json.fr;
    if(typeof json.fr2 != "undefined") fr2 = json.fr2;
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Keyboard events"] = true;
    __pagesEnabled["Running"] = true;
    __pagesEnabled["Evol Page"] = true;
    __pagesEnabled["Goal"] = true;
    __pagesEnabled["Floor"] = true;
    __pagesEnabled["Segments"] = true;
  });

  _model.addToReset(function() {
    showControls = true; // EjsS Model.Variables.Display.showControls
    topPanelHeight = showControls ? "95%" : "100%"; // EjsS Model.Variables.Display.topPanelHeight
    controlPanelHeight = "5%"; // EjsS Model.Variables.Display.controlPanelHeight
    displayScale = 3.0/4.0; // EjsS Model.Variables.Display.displayScale
  });

  _model.addToReset(function() {
    xMin = 0; // EjsS Model.Variables.World.xMin
    xMax = 100; // EjsS Model.Variables.World.xMax
    yMin = 0; // EjsS Model.Variables.World.yMin
    yMax = yMin + (xMax-xMin)/displayScale; // EjsS Model.Variables.World.yMax
    xMiddle = (xMin+xMax)/2; // EjsS Model.Variables.World.xMiddle
    yMiddle = (yMin+yMax)/2; // EjsS Model.Variables.World.yMiddle
    yRange = yMax-yMin; // EjsS Model.Variables.World.yRange
    yMargin = yRange/10; // EjsS Model.Variables.World.yMargin
    running = false; // EjsS Model.Variables.World.running
    gameOver = false; // EjsS Model.Variables.World.gameOver
    randomGenerator = RNG(); // EjsS Model.Variables.World.randomGenerator
    time = 0; // EjsS Model.Variables.World.time
    deltaTime = 1.0/20.0; // EjsS Model.Variables.World.deltaTime
    g = 9.8; // EjsS Model.Variables.World.g
    xLastClick = 0; // EjsS Model.Variables.World.xLastClick
    yLastClick = 0; // EjsS Model.Variables.World.yLastClick
  });

  _model.addToReset(function() {
    startX = (xMin+xMax)/2; // EjsS Model.Variables.Instructions.startX
    startY = (yMin+yMax)/2; // EjsS Model.Variables.Instructions.startY
    startWidth = xMax-xMin; // EjsS Model.Variables.Instructions.startWidth
    startHeight = (yMax-yMin)/12; // EjsS Model.Variables.Instructions.startHeight
    startMessage = "Click or Tap the ceiling to start"; // EjsS Model.Variables.Instructions.startMessage
    playAgainMessage = "Click or Tap to Play Again"; // EjsS Model.Variables.Instructions.playAgainMessage
    gameWonMessage = "Congratulations. You Win!"; // EjsS Model.Variables.Instructions.gameWonMessage
    gameSurvivedMessage = "You survived, but the cities were destroyed!"; // EjsS Model.Variables.Instructions.gameSurvivedMessage
    gameLostMessage = "You Lost: the frog is hungry!"; // EjsS Model.Variables.Instructions.gameLostMessage
    gameOverMessage = "GAME OVER"; // EjsS Model.Variables.Instructions.gameOverMessage
    gameResultMessage = gameLostMessage; // EjsS Model.Variables.Instructions.gameResultMessage
    message = startMessage; // EjsS Model.Variables.Instructions.message
    YOU_LOST = 0; // EjsS Model.Variables.Instructions.YOU_LOST
    YOU_WON = 1; // EjsS Model.Variables.Instructions.YOU_WON
    YOU_SURVIVED = 2; // EjsS Model.Variables.Instructions.YOU_SURVIVED
  });

  _model.addToReset(function() {
    bigMass = 10; // EjsS Model.Variables.Big mass.bigMass
    massDiameter = yRange/30; // EjsS Model.Variables.Big mass.massDiameter
    xMass = xMiddle; // EjsS Model.Variables.Big mass.xMass
    yMass = yMin + 3*yRange/4; // EjsS Model.Variables.Big mass.yMass
    vxMass = 0; // EjsS Model.Variables.Big mass.vxMass
    vyMass = 0; // EjsS Model.Variables.Big mass.vyMass
    frMass = 0.05; // EjsS Model.Variables.Big mass.frMass
  });

  _model.addToReset(function() {
    frogSizeX = yRange/10; // EjsS Model.Variables.Frog.frogSizeX
    frogSizeY = frogSizeX*0.7; // EjsS Model.Variables.Frog.frogSizeY
    xFrog = xMiddle; // EjsS Model.Variables.Frog.xFrog
    yFrog = yMin; // EjsS Model.Variables.Frog.yFrog
    goalDistance = frogSizeX/4; // EjsS Model.Variables.Frog.goalDistance
  });

  _model.addToReset(function() {
    maxRopes = 10; // EjsS Model.Variables.Ropes.maxRopes
    massesPerRope = 10; // EjsS Model.Variables.Ropes.massesPerRope
    maxMasses = maxRopes*massesPerRope; // EjsS Model.Variables.Ropes.maxMasses
    nRopes = 0; // EjsS Model.Variables.Ropes.nRopes
    ropeLength = new Array(maxRopes); // EjsS Model.Variables.Ropes.ropeLength
    (function () {
      var _i0;
      for (_i0=0; _i0<maxRopes; _i0+=1) {  // EjsS Model.Variables.Ropes.ropeLength
        ropeLength[_i0] = 0;  // EjsS Model.Variables.Ropes.ropeLength
      }
    }());
    x = new Array(maxMasses); // EjsS Model.Variables.Ropes.x
    (function () {
      var _i0;
      for (_i0=0; _i0<maxMasses; _i0+=1) {  // EjsS Model.Variables.Ropes.x
        x[_i0] = 0;  // EjsS Model.Variables.Ropes.x
      }
    }());
    y = new Array(maxMasses); // EjsS Model.Variables.Ropes.y
    (function () {
      var _i0;
      for (_i0=0; _i0<maxMasses; _i0+=1) {  // EjsS Model.Variables.Ropes.y
        y[_i0] = 10;  // EjsS Model.Variables.Ropes.y
      }
    }());
    vx = new Array(maxMasses); // EjsS Model.Variables.Ropes.vx
    (function () {
      var _i0;
      for (_i0=0; _i0<maxMasses; _i0+=1) {  // EjsS Model.Variables.Ropes.vx
        vx[_i0] = 0;  // EjsS Model.Variables.Ropes.vx
      }
    }());
    vy = new Array(maxMasses); // EjsS Model.Variables.Ropes.vy
    (function () {
      var _i0;
      for (_i0=0; _i0<maxMasses; _i0+=1) {  // EjsS Model.Variables.Ropes.vy
        vy[_i0] = 0;  // EjsS Model.Variables.Ropes.vy
      }
    }());
    ax = new Array(maxMasses); // EjsS Model.Variables.Ropes.ax
    (function () {
      var _i0;
      for (_i0=0; _i0<maxMasses; _i0+=1) {  // EjsS Model.Variables.Ropes.ax
        ax[_i0] = 0;  // EjsS Model.Variables.Ropes.ax
      }
    }());
    ay = new Array(maxMasses); // EjsS Model.Variables.Ropes.ay
    (function () {
      var _i0;
      for (_i0=0; _i0<maxMasses; _i0+=1) {  // EjsS Model.Variables.Ropes.ay
        ay[_i0] = 0;  // EjsS Model.Variables.Ropes.ay
      }
    }());
    mass = new Array(maxMasses); // EjsS Model.Variables.Ropes.mass
    (function () {
      var _i0;
      for (_i0=0; _i0<maxMasses; _i0+=1) {  // EjsS Model.Variables.Ropes.mass
        mass[_i0] = bigMass/massesPerRope/10;  // EjsS Model.Variables.Ropes.mass
      }
    }());
    sx = new Array(maxMasses); // EjsS Model.Variables.Ropes.sx
    (function () {
      var _i0;
      for (_i0=0; _i0<maxMasses; _i0+=1) {  // EjsS Model.Variables.Ropes.sx
        sx[_i0] = 0;  // EjsS Model.Variables.Ropes.sx
      }
    }());
    sy = new Array(maxMasses); // EjsS Model.Variables.Ropes.sy
    (function () {
      var _i0;
      for (_i0=0; _i0<maxMasses; _i0+=1) {  // EjsS Model.Variables.Ropes.sy
        sy[_i0] = 0;  // EjsS Model.Variables.Ropes.sy
      }
    }());
    link = new Array(maxMasses); // EjsS Model.Variables.Ropes.link
    (function () {
      var _i0;
      for (_i0=0; _i0<maxMasses; _i0+=1) {  // EjsS Model.Variables.Ropes.link
        link[_i0] = false;  // EjsS Model.Variables.Ropes.link
      }
    }());
    k = 1000; // EjsS Model.Variables.Ropes.k
    fr = 300; // EjsS Model.Variables.Ropes.fr
    fr2 = 1; // EjsS Model.Variables.Ropes.fr2
  });

  _model.addToReset(function() {
    _privateOdesList=[];
    _ODEi_evolution1 = _ODE_evolution1();
    _privateOdesList.push(_ODEi_evolution1);
  });

  _model.addToReset(function() {
    _model.setAutoplay(true);
    _model.setPauseOnPageExit(true);
    _model.setFPS(20);
    _model.setStepsPerDisplay(10);
  });

  /**  // > CustomCode.Tools:1
   * Returns a random double value between min and max  // > CustomCode.Tools:2
   */  // > CustomCode.Tools:3
  function getRandomValue(min,max) {  // > CustomCode.Tools:4
    return randomGenerator.nextRange(min,max);  // > CustomCode.Tools:5
  //  return min+(max-min)*Math.random();  // > CustomCode.Tools:6
  }  // > CustomCode.Tools:7
  function RNG(seed) { // Adapted from http://stackoverflow.com/questions/424292/seedable-javascript-random-number-generator  // > CustomCode.Tools:8
    var self = {};  // > CustomCode.Tools:9
    // LCG using GCC's constants  // > CustomCode.Tools:10
    self.m = 0x80000000; // 2**31;  // > CustomCode.Tools:11
    self.a = 1103515245;  // > CustomCode.Tools:12
    self.c = 12345;  // > CustomCode.Tools:13
    self.firstState = (seed) ? seed : Math.floor(Math.random() * (self.m-1));   // > CustomCode.Tools:14
    self.state = self.firstState;  // > CustomCode.Tools:15
      // > CustomCode.Tools:16
    self.nextInt = function() {  // > CustomCode.Tools:17
      self.state = (self.a * self.state + self.c) % self.m;  // > CustomCode.Tools:18
      return self.state;  // > CustomCode.Tools:19
    };  // > CustomCode.Tools:20
      // > CustomCode.Tools:21
    self.nextDouble = function() { // returns in range [0,1]  // > CustomCode.Tools:22
      return self.nextInt() / (self.m - 1);  // > CustomCode.Tools:23
    };  // > CustomCode.Tools:24
    self.nextRange = function(start, end) {  // > CustomCode.Tools:25
    // returns in range [start, end): including start, excluding end  // > CustomCode.Tools:26
    // can't modulu nextInt because of weak randomness in lower bits  // > CustomCode.Tools:27
      var rangeSize = end - start;  // > CustomCode.Tools:28
      var randomUnder1 = self.nextInt() / self.m;  // > CustomCode.Tools:29
      return start + Math.floor(randomUnder1 * rangeSize);  // > CustomCode.Tools:30
    };  // > CustomCode.Tools:31
    self.reset = function() {  // > CustomCode.Tools:32
      self.state = self.firstState;  // > CustomCode.Tools:33
    };  // > CustomCode.Tools:34
      // > CustomCode.Tools:35
    return self;  // > CustomCode.Tools:36
  }  // > CustomCode.Tools:37

  /**  // > CustomCode.Control:1
   * What to do when the user clicks in a panel  // > CustomCode.Control:2
   * @param point double[2] the point of the click  // > CustomCode.Control:3
   */  // > CustomCode.Control:4
  function clickAtPoint (point) {  // > CustomCode.Control:5
    if (running) { // Implement here what happens if you click at a point when the game is running  // > CustomCode.Control:6
      if (Math.abs(point[1]-yMax)<yMargin/2) {  // > CustomCode.Control:7
        xLastClick = Number.NaN;  // > CustomCode.Control:8
        yLastClick = Number.NaN;  // > CustomCode.Control:9
        createRope(point);  // > CustomCode.Control:10
      }        // > CustomCode.Control:11
      else {  // > CustomCode.Control:12
        xLastClick = point[0];  // > CustomCode.Control:13
        yLastClick = point[1];      // > CustomCode.Control:14
      }  // > CustomCode.Control:15
    }  // > CustomCode.Control:16
    else { // Game is stopped  // > CustomCode.Control:17
      if (gameOver) _reset();  // > CustomCode.Control:18
      else { // Implement here what happens if you click at a point when the game is running  // > CustomCode.Control:19
        xLastClick = Number.NaN;  // > CustomCode.Control:20
        yLastClick = Number.NaN;  // > CustomCode.Control:21
        createRope(point);  // > CustomCode.Control:22
      }  // > CustomCode.Control:23
    }  // > CustomCode.Control:24
  }  // > CustomCode.Control:25
  /**  // > CustomCode.Control:26
   * What happens when you click at the main message  // > CustomCode.Control:27
   */  // > CustomCode.Control:28
  function clickAtMessage () {  // > CustomCode.Control:29
    if (!running) { // Game is stopped  // > CustomCode.Control:30
      if (gameOver) _reset();  // > CustomCode.Control:31
      else running = true;  // > CustomCode.Control:32
    }  // > CustomCode.Control:33
  }  // > CustomCode.Control:34
  /**  // > CustomCode.Control:35
    * the game ended  // > CustomCode.Control:36
    * @param status one of:  // > CustomCode.Control:37
    *  1 : you lost  // > CustomCode.Control:38
    *  2 : you won  // > CustomCode.Control:39
    *  3 : you survived but golas not achieved  // > CustomCode.Control:40
  */  // > CustomCode.Control:41
  function endOfGame (status) {  // > CustomCode.Control:42
    switch(status) {  // > CustomCode.Control:43
      case YOU_LOST : gameResultMessage = gameLostMessage; break;  // > CustomCode.Control:44
      case YOU_WON  : gameResultMessage = gameWonMessage; break;  // > CustomCode.Control:45
      case YOU_SURVIVED : gameResultMessage = gameSurvivedMessage; break;  // > CustomCode.Control:46
    }  // > CustomCode.Control:47
    message = playAgainMessage;  // > CustomCode.Control:48
    running = false;  // > CustomCode.Control:49
    gameOver = true;  // > CustomCode.Control:50
  }  // > CustomCode.Control:51

  function createRope(atPoint) {  // > CustomCode.Create rope:1
    if (nRopes>=maxRopes) {  // > CustomCode.Create rope:2
      alert("Warning: No more ropes available!");  // > CustomCode.Create rope:3
      return;  // > CustomCode.Create rope:4
    }  // > CustomCode.Create rope:5
    atPoint[1] = yMax-yMargin/2;  // > CustomCode.Create rope:6
    var dx = (xMass-atPoint[0]), dy = (yMass - atPoint[1]);  // > CustomCode.Create rope:7
    ropeLength[nRopes] = Math.sqrt(dx*dx+dy*dy);  // > CustomCode.Create rope:8
    var m = nRopes*massesPerRope;  // > CustomCode.Create rope:9
    for (var i=0; i<massesPerRope; i++, m++) {  // > CustomCode.Create rope:10
      x[m] = atPoint[0] + i*dx/massesPerRope;  // > CustomCode.Create rope:11
      y[m] = atPoint[1] + i*dy/massesPerRope;  // > CustomCode.Create rope:12
      vx[m] = 0;  // > CustomCode.Create rope:13
      vy[m] = 0;  // > CustomCode.Create rope:14
      link[m] = true;  // > CustomCode.Create rope:15
    }  // > CustomCode.Create rope:16
    nRopes++;  // > CustomCode.Create rope:17
    running = true;  // > CustomCode.Create rope:18
  }  // > CustomCode.Create rope:19

  function cutRope(point) {  // > CustomCode.Cut rope:1
    if (isNaN(xLastClick)) return;  // > CustomCode.Cut rope:2
    var p1 = xLastClick, p2 = yLastClick;  // > CustomCode.Cut rope:3
    var u1 = point[0]-p1, u2 = point[1]-p2;  // > CustomCode.Cut rope:4
    for (var rope=0; rope<nRopes; rope++) {  // > CustomCode.Cut rope:5
      for (var i=0; i<massesPerRope; i++) {  // > CustomCode.Cut rope:6
        var m = rope*massesPerRope+i;  // > CustomCode.Cut rope:7
        var a1 = x[m], a2 = y[m];  // > CustomCode.Cut rope:8
        var v1,v2;  // > CustomCode.Cut rope:9
        if (i==(massesPerRope-1)) {  // > CustomCode.Cut rope:10
          v1 = xMass-a1;  // > CustomCode.Cut rope:11
          v2 = yMass-a2;  // > CustomCode.Cut rope:12
        }  // > CustomCode.Cut rope:13
        else {  // > CustomCode.Cut rope:14
          v1 = x[m+1]-a1;  // > CustomCode.Cut rope:15
          v2 = y[m+1]-a2;  // > CustomCode.Cut rope:16
        }  // > CustomCode.Cut rope:17
        var det = -v1*u2+u1*v2;  // > CustomCode.Cut rope:18
        if (Math.abs(det)<1.0e-10) continue;  // > CustomCode.Cut rope:19
        var t = (-(p1-a1)*u2+u1*(p2-a2))/det;  // > CustomCode.Cut rope:20
        if (t<=0 || t>1) continue;  // > CustomCode.Cut rope:21
        var s = (v1*(p2-a2)-v2*(p1-a1))/det;  // > CustomCode.Cut rope:22
        if (s>0 && s<=1) link[m] = false; // Cut the Rope!!!  // > CustomCode.Cut rope:23
      }  // > CustomCode.Cut rope:24
    }  // > CustomCode.Cut rope:25
  }  // > CustomCode.Cut rope:26

  function checkGame () {  // > CustomCode.Check goal:1
      // > CustomCode.Check goal:2
  }  // > CustomCode.Check goal:3

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Keyboard events"]) return;
    xMass = getRandomValue(xMin,xMax);  // > Initialization.Keyboard events:1
    xFrog = getRandomValue(xMin,xMax);  // > Initialization.Keyboard events:2
  });

  _model.addToInitialization(function() {
    _initializeSolvers();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Running"]) return;
    if (!running) _breakAfterThisPage();  // > Evolution.Running:1
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Evol Page"]) return;
    _ODEi_evolution1.step();
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["Segments"]) return;
    var m;  // > FixedRelations.Segments:1
    for (var rope=0; rope<nRopes; rope++) {  // > FixedRelations.Segments:2
      var l = ropeLength[rope]/massesPerRope;  // > FixedRelations.Segments:3
      for (var i=0,n=massesPerRope-1; i<n; i++) {  // > FixedRelations.Segments:4
        m = rope*massesPerRope+i;  // > FixedRelations.Segments:5
        sx[m] = x[m+1]-x[m];  // > FixedRelations.Segments:6
        sy[m] = y[m+1]-y[m];  // > FixedRelations.Segments:7
        /*  // > FixedRelations.Segments:8
        var length = Math.sqrt(sx[m]*sx[m]+sy[m]*sy[m]);  // > FixedRelations.Segments:9
        if (length>=l) sColor[m] = "Blue";  // > FixedRelations.Segments:10
        else sColor[m] = "Red";  // > FixedRelations.Segments:11
        */  // > FixedRelations.Segments:12
      }  // > FixedRelations.Segments:13
      m = (rope+1)*massesPerRope-1;  // > FixedRelations.Segments:14
      sx[m] = xMass - x[m];  // > FixedRelations.Segments:15
      sy[m] = yMass - y[m];  // > FixedRelations.Segments:16
      /*  // > FixedRelations.Segments:17
      double length = Math.sqrt(sx[m]*sx[m]+sy[m]*sy[m]);  // > FixedRelations.Segments:18
        if (length>=l) sColor[m] = "Blue";  // > FixedRelations.Segments:19
        else sColor[m] = "Red";  // > FixedRelations.Segments:20
      */  // > FixedRelations.Segments:21
    }  // > FixedRelations.Segments:22
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  function _initializeSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].initializeSolver();
  }

  function _automaticResetSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].automaticResetSolver();
  }

  _model.resetSolvers = function() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].resetSolver();
  };

  function _getODE(_odeName) {
    if (_odeName=="Evol Page") return _ODEi_evolution1;
    return null;
  }

  function _getEventSolver(_odeName) {
    var ode = _getODE(_odeName);
    if (ode===null) return null;
    return ode.getEventSolver();
  }

  function _setSolverClass(_odeName, _engine) {
    var ode = _getODE(_odeName);
    if (ode===null) return;
    if (!_engine.setODE) {
      var classname = _engine.toLowerCase();
      if      (classname.indexOf("boga")>=0)   _engine = EJSS_ODE_SOLVERS.bogackiShampine23;
      else if (classname.indexOf("cash")>=0)   _engine = EJSS_ODE_SOLVERS.cashKarp45;
      else if (classname.indexOf("dopri5")>=0) _engine = EJSS_ODE_SOLVERS.dopri5;
      else if (classname.indexOf("dopri8")>=0) _engine = EJSS_ODE_SOLVERS.dopri853;
      else if (classname.indexOf("richa")>=0)  _engine = EJSS_ODE_SOLVERS.eulerRichardson;
      else if (classname.indexOf("euler")>=0)  _engine = EJSS_ODE_SOLVERS.euler;
      else if (classname.indexOf("fehlberg87")>=0) _engine = EJSS_ODE_SOLVERS.fehlberg87;
      else if (classname.indexOf("fehlberg8")>=0)  _engine = EJSS_ODE_SOLVERS.fehlberg8;
      else if (classname.indexOf("radau")>=0)   _engine = EJSS_ODE_SOLVERS.radau5;
      else if (classname.indexOf("runge")>=0)  _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("rk4")>=0)    _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("verlet")>=0) _engine = EJSS_ODE_SOLVERS.velocityVerlet;
    }
    if (_engine) ode.setSolverClass(_engine);
  }

  function _ODE_evolution1() {
    var __odeSelf = {};
    var __eventSolver;
    var __solverClass = EJSS_ODE_SOLVERS.cashKarp45;
    var __state=[];
    var _ODE_evolution1_Event1;
    var _ODE_evolution1_Event2;
    var __ignoreErrors=false;
    var __mustInitialize=true;
    var __isEnabled=true;
    var __mustUserReinitialize=false;
    var __mustReinitialize=true;

    var _xLength;
    var _vxLength;
    var _yLength;
    var _vyLength;

    __odeSelf.setSolverClass = function(__aSolverClass) {
      __solverClass = __aSolverClass;
      __instantiateSolver();
    };

    function __instantiateSolver() {
      __state=[];
      _xLength = x.length;
      _vxLength = vx.length;
      _yLength = y.length;
      _vyLength = vy.length;
      __pushState();
      __eventSolver = EJSS_ODE_SOLVERS.interpolatorEventSolver(__solverClass(),__odeSelf);
      __mustInitialize = true;
    }

    __odeSelf.setEnabled = function(_enabled) { __isEnabled = _enabled; };

    __odeSelf.getIndependentVariableValue = function() { return __eventSolver.getIndependentVariableValue(); };

    __odeSelf.getInternalStepSize = function() { return __eventSolver.getInternalStepSize(); };

    __odeSelf.isAccelerationIndependentOfVelocity = function() { return false; };

    __odeSelf.initializeSolver = function() {
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); return; }
      __pushState();
      __eventSolver.initialize(deltaTime);
      __eventSolver.setBestInterpolation(false);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.removeAllEvents();
      if (__pagesEnabled["Goal"]) __eventSolver.addEvent(_ODE_evolution1_Event1());
      if (__pagesEnabled["Floor"]) __eventSolver.addEvent(_ODE_evolution1_Event2());
      __eventSolver.setEstimateFirstStep(false);
      __eventSolver.setEnableExceptions(false);
      __eventSolver.setTolerances(0.01,0.01);
      __mustReinitialize = true;
      __mustInitialize = false;
    };

    function __pushState() {
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
      if (!__mustReinitialize)
        for (__j=0,__n=__cIn; __j<_xLength; __j++)
          if (__state[__n++]!=x[__j] || __state[__n++]!=vx[__j]) { __mustReinitialize = true; break; }
      for (__j=0; __j<_xLength; __j++) { // These two alternate in the state
         __state[__cIn++] = x[__j];
         __state[__cIn++] = vx[__j];
      }
      if (!__mustReinitialize)
        for (__j=0,__n=__cIn; __j<_yLength; __j++)
          if (__state[__n++]!=y[__j] || __state[__n++]!=vy[__j]) { __mustReinitialize = true; break; }
      for (__j=0; __j<_yLength; __j++) { // These two alternate in the state
         __state[__cIn++] = y[__j];
         __state[__cIn++] = vy[__j];
      }
        if (__state[__cIn]!=xMass) __mustReinitialize = true;
        __state[__cIn++] = xMass;
        if (__state[__cIn]!=vxMass) __mustReinitialize = true;
        __state[__cIn++] = vxMass;
        if (__state[__cIn]!=yMass) __mustReinitialize = true;
        __state[__cIn++] = yMass;
        if (__state[__cIn]!=vyMass) __mustReinitialize = true;
        __state[__cIn++] = vyMass;
        if (__state[__cIn]!=time) __mustReinitialize = true;
        __state[__cIn++] = time;
    }

    function __arraysChanged () {
      if (_xLength != x.length) return true;
      if (_vxLength != vx.length) return true;
      if (_yLength != y.length) return true;
      if (_vyLength != vy.length) return true;
      return false;
    }

    __odeSelf.getEventSolver = function() {
      return __eventSolver;
    };

    __odeSelf.resetSolver = function() {
      __mustUserReinitialize = true;
    };

    __odeSelf.automaticResetSolver = function() {
      __mustReinitialize = true;
    };

    function __errorAction () {
      if (__ignoreErrors) return;
      console.log (__eventSolver.getErrorMessage());
      _pause();
      // Make sure the solver is reinitialized;
      __mustReinitialize = true;
    }

    __odeSelf.step = function() { return __privateStep(false); };

    __odeSelf.solverStep = function() { return __privateStep(true); };

    function __privateStep(__takeMaximumStep) {
      if (!__isEnabled) return 0;
      if (deltaTime===0) return 0;
      if (__mustInitialize) __odeSelf.initializeSolver();
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); }
      __eventSolver.setStepSize(deltaTime);
      __eventSolver.setInternalStepSize(deltaTime);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.setTolerances(0.01,0.01);
      __pushState();
      if (__mustUserReinitialize) { 
        __eventSolver.userReinitialize();
        __mustUserReinitialize = false;
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      else if (__mustReinitialize) { 
        __eventSolver.reinitialize();
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      var __stepTaken = __takeMaximumStep ? __eventSolver.maxStep() : __eventSolver.step();
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        for (__i=0; __i<_xLength; __i++) { // These two alternate in the state
          x[__i] = __state[__cOut++];
          vx[__i] = __state[__cOut++];
        }
        for (__i=0; __i<_yLength; __i++) { // These two alternate in the state
          y[__i] = __state[__cOut++];
          vy[__i] = __state[__cOut++];
        }
        xMass = __state[__cOut++];
        vxMass = __state[__cOut++];
        yMass = __state[__cOut++];
        vyMass = __state[__cOut++];
        time = __state[__cOut++];
      // Check for error
      if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      return __stepTaken;
    }

    __odeSelf.getState = function() { return __state; };

    __odeSelf.getRate = function(_aState,_aRate) {
      _aRate[_aRate.length-1] = 0.0; // In case the prelim code returns
      var __index=-1; // so that it can be used in preliminary code
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var x = [];
        var vx = [];
        for (__i=0; __i<_xLength; __i++) { // These two alternate in the state
          x[__i] = _aState[__cOut++];
          vx[__i] = _aState[__cOut++];
        }
        var y = [];
        var vy = [];
        for (__i=0; __i<_yLength; __i++) { // These two alternate in the state
          y[__i] = _aState[__cOut++];
          vy[__i] = _aState[__cOut++];
        }
        var xMass = _aState[__cOut++];
        var vxMass = _aState[__cOut++];
        var yMass = _aState[__cOut++];
        var vyMass = _aState[__cOut++];
        var time = _aState[__cOut++];
      // Preliminary code: Code to be executed before rate equations are evaluated
        var axMass = 0;  // > Preliminary code for ODE.Evol Page:1
        var ayMass = running ? -g : 0;  // > Preliminary code for ODE.Evol Page:2
        axMass -= frMass*vxMass;  // > Preliminary code for ODE.Evol Page:3
        ayMass -= frMass*vyMass;  // > Preliminary code for ODE.Evol Page:4
        var m,ux,uy,length,force,dvx,dvy,projection,frx,fry;  // > Preliminary code for ODE.Evol Page:5
        for (var rope=0; rope<nRopes; rope++) {  // > Preliminary code for ODE.Evol Page:6
          var l = ropeLength[rope]/massesPerRope;  // > Preliminary code for ODE.Evol Page:7
          for (var i=1; i<massesPerRope; i++) {  // > Preliminary code for ODE.Evol Page:8
            m = rope*massesPerRope+i;  // > Preliminary code for ODE.Evol Page:9
            if (link[m-1]) {  // > Preliminary code for ODE.Evol Page:10
              ux = x[m-1]-x[m];  // > Preliminary code for ODE.Evol Page:11
              uy = y[m-1]-y[m];  // > Preliminary code for ODE.Evol Page:12
              length = Math.sqrt(ux*ux+uy*uy);  // > Preliminary code for ODE.Evol Page:13
              ux /= length; uy /= length;  // > Preliminary code for ODE.Evol Page:14
              force = k * (length-l);  // > Preliminary code for ODE.Evol Page:15
              ax[m] = force*ux/mass[m];  // > Preliminary code for ODE.Evol Page:16
              ay[m] = force*uy/mass[m]-g;  // > Preliminary code for ODE.Evol Page:17
              if (i>1) {  // > Preliminary code for ODE.Evol Page:18
                ax[m-1] -= force*ux/mass[m-1];  // > Preliminary code for ODE.Evol Page:19
                ay[m-1] -= force*uy/mass[m-1];  // > Preliminary code for ODE.Evol Page:20
              }  // > Preliminary code for ODE.Evol Page:21
              // Friction  // > Preliminary code for ODE.Evol Page:22
              dvx = vx[m-1]-vx[m], dvy = vy[m-1]-vy[m];  // > Preliminary code for ODE.Evol Page:23
              projection = dvx*ux+dvy*uy;  // > Preliminary code for ODE.Evol Page:24
              frx = fr*projection*ux;  // > Preliminary code for ODE.Evol Page:25
              fry = fr*projection*uy;  // > Preliminary code for ODE.Evol Page:26
              ax[m] += frx;   // > Preliminary code for ODE.Evol Page:27
              ay[m] += fry;  // > Preliminary code for ODE.Evol Page:28
              if (i>1) {  // > Preliminary code for ODE.Evol Page:29
                ax[m-1] -= frx;  // > Preliminary code for ODE.Evol Page:30
                ay[m-1] -= fry;  // > Preliminary code for ODE.Evol Page:31
              }  // > Preliminary code for ODE.Evol Page:32
            }  // > Preliminary code for ODE.Evol Page:33
            else {  // > Preliminary code for ODE.Evol Page:34
              ax[m] = 0;  // > Preliminary code for ODE.Evol Page:35
              ay[m] = -g;  // > Preliminary code for ODE.Evol Page:36
            }  // > Preliminary code for ODE.Evol Page:37
            ax[m] -= fr2*vx[m];  // > Preliminary code for ODE.Evol Page:38
            ay[m] -= fr2*vy[m];  // > Preliminary code for ODE.Evol Page:39
          } // end of for i  // > Preliminary code for ODE.Evol Page:40
          // Now, the big mass  // > Preliminary code for ODE.Evol Page:41
          m = (rope+1)*massesPerRope-1;  // > Preliminary code for ODE.Evol Page:42
          if (link[m]) {  // > Preliminary code for ODE.Evol Page:43
            ux = x[m]-xMass, uy = y[m]-yMass;  // > Preliminary code for ODE.Evol Page:44
            length = Math.sqrt(ux*ux+uy*uy);  // > Preliminary code for ODE.Evol Page:45
            ux /= length; uy /= length;  // > Preliminary code for ODE.Evol Page:46
            force = k * (length-l);  // > Preliminary code for ODE.Evol Page:47
            axMass += force*ux/bigMass;  // > Preliminary code for ODE.Evol Page:48
            ayMass += force*uy/bigMass;  // > Preliminary code for ODE.Evol Page:49
            ax[m] -= force*ux/mass[m];  // > Preliminary code for ODE.Evol Page:50
            ay[m] -= force*uy/mass[m];  // > Preliminary code for ODE.Evol Page:51
            dvx = vx[m]-vxMass, dvy = vy[m]-vyMass;  // > Preliminary code for ODE.Evol Page:52
            projection = dvx*ux+dvy*uy;  // > Preliminary code for ODE.Evol Page:53
            frx = fr*projection*ux;  // > Preliminary code for ODE.Evol Page:54
            fry = fr*projection*uy;  // > Preliminary code for ODE.Evol Page:55
            axMass += frx;  // > Preliminary code for ODE.Evol Page:56
            ayMass += fry;  // > Preliminary code for ODE.Evol Page:57
            ax[m] -= frx;  // > Preliminary code for ODE.Evol Page:58
            ay[m] -= fry;  // > Preliminary code for ODE.Evol Page:59
          }  // > Preliminary code for ODE.Evol Page:60
        } // end of for rope  // > Preliminary code for ODE.Evol Page:61
      // Compute the rate
        var __cRate=0;
        var i;
        for (i=0;i<_xLength;i++) { // These two alternate in the state
          _aRate[__cRate++] = Array.isArray(vx[i]) ? vx[i][i] : vx[i]; // Rate for ODE: Evol Page:x
          _aRate[__cRate++] = Array.isArray(ax[i]) ? ax[i][i] : ax[i]; // Rate for ODE: Evol Page:vx
        }
        for (i=0;i<_yLength;i++) { // These two alternate in the state
          _aRate[__cRate++] = Array.isArray(vy[i]) ? vy[i][i] : vy[i]; // Rate for ODE: Evol Page:y
          _aRate[__cRate++] = Array.isArray(ay[i]) ? ay[i][i] : ay[i]; // Rate for ODE: Evol Page:vy
        }
        _aRate[__cRate++] = vxMass; // Rate for ODE: Evol Page:xMass
        _aRate[__cRate++] = axMass; // Rate for ODE: Evol Page:vxMass
        _aRate[__cRate++] = vyMass; // Rate for ODE: Evol Page:yMass
        _aRate[__cRate++] = ayMass; // Rate for ODE: Evol Page:vyMass
        _aRate[__cRate++] = 1; // independent variable
        return _aRate;
    }; //end of getRate

    _ODE_evolution1_Event1 = function() {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return EJSS_ODE_SOLVERS.EVENT_TYPE.CROSSING_EVENT; };

      _eventSelf.getRootFindingMethod = function() { return EJSS_ODE_SOLVERS.EVENT_METHOD.BISECTION; };

      _eventSelf.getMaxIterations = function() { return 100; };

      _eventSelf.getTolerance = function() { return 1.0e-5; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var x = [];
        var vx = [];
        for (__i=0; __i<_xLength; __i++) { // These two alternate in the state
          x[__i] = _aState[__cOut++];
          vx[__i] = _aState[__cOut++];
        }
        var y = [];
        var vy = [];
        for (__i=0; __i<_yLength; __i++) { // These two alternate in the state
          y[__i] = _aState[__cOut++];
          vy[__i] = _aState[__cOut++];
        }
        var xMass = _aState[__cOut++];
        var vxMass = _aState[__cOut++];
        var yMass = _aState[__cOut++];
        var vyMass = _aState[__cOut++];
        var time = _aState[__cOut++];
        var dx = xMass-xFrog, dy = yMass-yFrog;  // > Event zero-condition for page Evol Page:1
        return Math.sqrt(dx*dx+dy*dy)-goalDistance;  // > Event zero-condition for page Evol Page:2
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        for (__i=0; __i<_xLength; __i++) { // These two alternate in the state
          x[__i] = __state[__cOut++];
          vx[__i] = __state[__cOut++];
        }
        for (__i=0; __i<_yLength; __i++) { // These two alternate in the state
          y[__i] = __state[__cOut++];
          vy[__i] = __state[__cOut++];
        }
        xMass = __state[__cOut++];
        vxMass = __state[__cOut++];
        yMass = __state[__cOut++];
        vyMass = __state[__cOut++];
        time = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
      for (__j=0; __j<_xLength; __j++) { // These two alternate in the state
         __state[__cIn++] = x[__j];
         __state[__cIn++] = vx[__j];
      }
      for (__j=0; __j<_yLength; __j++) { // These two alternate in the state
         __state[__cIn++] = y[__j];
         __state[__cIn++] = vy[__j];
      }
        __state[__cIn++] = xMass;
        __state[__cIn++] = vxMass;
        __state[__cIn++] = yMass;
        __state[__cIn++] = vyMass;
        __state[__cIn++] = time;
        return _returnValue;
      };

      function __userDefinedAction() {
        endOfGame(YOU_WON);  // > Event action for page Evol Page:1
        return true;
      }

      return _eventSelf;
    }; // End of event

    _ODE_evolution1_Event2 = function() {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return EJSS_ODE_SOLVERS.EVENT_TYPE.CROSSING_EVENT; };

      _eventSelf.getRootFindingMethod = function() { return EJSS_ODE_SOLVERS.EVENT_METHOD.BISECTION; };

      _eventSelf.getMaxIterations = function() { return 100; };

      _eventSelf.getTolerance = function() { return 1.0e-5; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var x = [];
        var vx = [];
        for (__i=0; __i<_xLength; __i++) { // These two alternate in the state
          x[__i] = _aState[__cOut++];
          vx[__i] = _aState[__cOut++];
        }
        var y = [];
        var vy = [];
        for (__i=0; __i<_yLength; __i++) { // These two alternate in the state
          y[__i] = _aState[__cOut++];
          vy[__i] = _aState[__cOut++];
        }
        var xMass = _aState[__cOut++];
        var vxMass = _aState[__cOut++];
        var yMass = _aState[__cOut++];
        var vyMass = _aState[__cOut++];
        var time = _aState[__cOut++];
        return yMass-massDiameter/2-yMin;  // > Event zero-condition for page Evol Page:1
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        for (__i=0; __i<_xLength; __i++) { // These two alternate in the state
          x[__i] = __state[__cOut++];
          vx[__i] = __state[__cOut++];
        }
        for (__i=0; __i<_yLength; __i++) { // These two alternate in the state
          y[__i] = __state[__cOut++];
          vy[__i] = __state[__cOut++];
        }
        xMass = __state[__cOut++];
        vxMass = __state[__cOut++];
        yMass = __state[__cOut++];
        vyMass = __state[__cOut++];
        time = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
      for (__j=0; __j<_xLength; __j++) { // These two alternate in the state
         __state[__cIn++] = x[__j];
         __state[__cIn++] = vx[__j];
      }
      for (__j=0; __j<_yLength; __j++) { // These two alternate in the state
         __state[__cIn++] = y[__j];
         __state[__cIn++] = vy[__j];
      }
        __state[__cIn++] = xMass;
        __state[__cIn++] = vxMass;
        __state[__cIn++] = yMass;
        __state[__cIn++] = vyMass;
        __state[__cIn++] = time;
        return _returnValue;
      };

      function __userDefinedAction() {
        var dx = xMass-xFrog, dy = yMass-yFrog;  // > Event action for page Evol Page:1
        if (Math.sqrt(dx*dx+dy*dy)>goalDistance) endOfGame(YOU_LOST);  // > Event action for page Evol Page:2
        else endOfGame(YOU_WON);  // > Event action for page Evol Page:3
        return true;
      }

      return _eventSelf;
    }; // End of event

    __instantiateSolver();

    return __odeSelf;
  }

  function _historic_x(__time) {
    var __beginIndex = 0;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,new Array(x.length),__beginIndex,x.ength);
  }

  function _historic_vx(__time) {
    var __beginIndex = 0 + x.length;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,new Array(vx.length),__beginIndex,vx.ength);
  }

  function _historic_y(__time) {
    var __beginIndex = 0 + x.length + vx.length;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,new Array(y.length),__beginIndex,y.ength);
  }

  function _historic_vy(__time) {
    var __beginIndex = 0 + x.length + vx.length + y.length;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,new Array(vy.length),__beginIndex,vy.ength);
  }

  function _historic_xMass(__time) {
    var __index = 0 + x.length + vx.length + y.length + vy.length;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

  function _historic_vxMass(__time) {
    var __index = 0 + x.length + vx.length + y.length + vy.length + 1;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

  function _historic_yMass(__time) {
    var __index = 0 + x.length + vx.length + y.length + vy.length + 1 + 1;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

  function _historic_vyMass(__time) {
    var __index = 0 + x.length + vx.length + y.length + vy.length + 1 + 1 + 1;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

    _model._resized = function(_width,_height) {
      _view._resized(_width,_height);
  }; // end of _resized
    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 768, height : 1024 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new pvg_cut_the_rope_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.topPanel.linkProperty("Height",  function() { return topPanelHeight; }, function(_v) { topPanelHeight = _v; } ); // HtmlView Page linking property 'Height' for element 'topPanel'
          _view.drawingPanel.linkProperty("MinimumX",  function() { return xMin; }, function(_v) { xMin = _v; } ); // HtmlView Page linking property 'MinimumX' for element 'drawingPanel'
          _view.drawingPanel.linkProperty("MinimumY",  function() { return yMin; }, function(_v) { yMin = _v; } ); // HtmlView Page linking property 'MinimumY' for element 'drawingPanel'
          _view.drawingPanel.setAction("OnPress", clickAtPoint); // HtmlView Page setting action 'OnPress' for element 'drawingPanel'
          _view.drawingPanel.linkProperty("MaximumY",  function() { return yMax; }, function(_v) { yMax = _v; } ); // HtmlView Page linking property 'MaximumY' for element 'drawingPanel'
          _view.drawingPanel.setAction("OnDrag", cutRope); // HtmlView Page setting action 'OnDrag' for element 'drawingPanel'
          _view.drawingPanel.linkProperty("MaximumX",  function() { return xMax; }, function(_v) { xMax = _v; } ); // HtmlView Page linking property 'MaximumX' for element 'drawingPanel'
          _view.drawingPanel.setAction("OnResize", function() {
  _view._touch();

}); // HtmlView Page setting action 'OnResize' for element 'drawingPanel'
          _view.worldLimitsShape.linkProperty("SizeX",  function() { return 3*(xMax-xMin); } ); // HtmlView Page linking property 'SizeX' for element 'worldLimitsShape'
          _view.worldLimitsShape.linkProperty("X",  function() { return xMiddle; }, function(_v) { xMiddle = _v; } ); // HtmlView Page linking property 'X' for element 'worldLimitsShape'
          _view.worldLimitsShape.linkProperty("Y",  function() { return yMax; }, function(_v) { yMax = _v; } ); // HtmlView Page linking property 'Y' for element 'worldLimitsShape'
          _view.worldLimitsShape.linkProperty("SizeY",  function() { return yMargin; }, function(_v) { yMargin = _v; } ); // HtmlView Page linking property 'SizeY' for element 'worldLimitsShape'
          _view.frogImage.linkProperty("SizeX",  function() { return frogSizeX; }, function(_v) { frogSizeX = _v; } ); // HtmlView Page linking property 'SizeX' for element 'frogImage'
          _view.frogImage.linkProperty("X",  function() { return xFrog; }, function(_v) { xFrog = _v; } ); // HtmlView Page linking property 'X' for element 'frogImage'
          _view.frogImage.linkProperty("Y",  function() { return yFrog; }, function(_v) { yFrog = _v; } ); // HtmlView Page linking property 'Y' for element 'frogImage'
          _view.frogImage.linkProperty("SizeY",  function() { return frogSizeY; }, function(_v) { frogSizeY = _v; } ); // HtmlView Page linking property 'SizeY' for element 'frogImage'
          _view.segmentSet.linkProperty("NumberOfElements",  function() { return maxMasses; }, function(_v) { maxMasses = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'segmentSet'
          _view.segmentSet.linkProperty("SizeX",  function() { return sx; }, function(_v) { sx = _v; } ); // HtmlView Page linking property 'SizeX' for element 'segmentSet'
          _view.segmentSet.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'X' for element 'segmentSet'
          _view.segmentSet.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'Y' for element 'segmentSet'
          _view.segmentSet.linkProperty("Visibility",  function() { return link; }, function(_v) { link = _v; } ); // HtmlView Page linking property 'Visibility' for element 'segmentSet'
          _view.segmentSet.linkProperty("SizeY",  function() { return sy; }, function(_v) { sy = _v; } ); // HtmlView Page linking property 'SizeY' for element 'segmentSet'
          _view.bigMassShape.linkProperty("SizeX",  function() { return massDiameter; }, function(_v) { massDiameter = _v; } ); // HtmlView Page linking property 'SizeX' for element 'bigMassShape'
          _view.bigMassShape.linkProperty("X",  function() { return xMass; }, function(_v) { xMass = _v; } ); // HtmlView Page linking property 'X' for element 'bigMassShape'
          _view.bigMassShape.linkProperty("Y",  function() { return yMass; }, function(_v) { yMass = _v; } ); // HtmlView Page linking property 'Y' for element 'bigMassShape'
          _view.bigMassShape.linkProperty("SizeY",  function() { return massDiameter; }, function(_v) { massDiameter = _v; } ); // HtmlView Page linking property 'SizeY' for element 'bigMassShape'
          _view.messageGroup.linkProperty("X",  function() { return startX; }, function(_v) { startX = _v; } ); // HtmlView Page linking property 'X' for element 'messageGroup'
          _view.messageGroup.linkProperty("Y",  function() { return startY; }, function(_v) { startY = _v; } ); // HtmlView Page linking property 'Y' for element 'messageGroup'
          _view.messageGroup.linkProperty("Visibility",  function() { return !running; } ); // HtmlView Page linking property 'Visibility' for element 'messageGroup'
          _view.messageShape.linkProperty("SizeX",  function() { return startWidth; }, function(_v) { startWidth = _v; } ); // HtmlView Page linking property 'SizeX' for element 'messageShape'
          _view.messageShape.linkProperty("SizeY",  function() { return startHeight; }, function(_v) { startHeight = _v; } ); // HtmlView Page linking property 'SizeY' for element 'messageShape'
          _view.messageText.linkProperty("Text",  function() { return message; }, function(_v) { message = _v; } ); // HtmlView Page linking property 'Text' for element 'messageText'
          _view.messageText.setAction("OnPress", clickAtMessage); // HtmlView Page setting action 'OnPress' for element 'messageText'
          _view.gameOverText.linkProperty("Y",  function() { return yMin + (yMax-yMin)/6; } ); // HtmlView Page linking property 'Y' for element 'gameOverText'
          _view.gameOverText.linkProperty("Text",  function() { return gameOverMessage; }, function(_v) { gameOverMessage = _v; } ); // HtmlView Page linking property 'Text' for element 'gameOverText'
          _view.gameOverText.linkProperty("Visibility",  function() { return gameOver; }, function(_v) { gameOver = _v; } ); // HtmlView Page linking property 'Visibility' for element 'gameOverText'
          _view.gameResultText.linkProperty("Y",  function() { return yMin + (yMax-yMin)/12; } ); // HtmlView Page linking property 'Y' for element 'gameResultText'
          _view.gameResultText.linkProperty("Text",  function() { return gameResultMessage; }, function(_v) { gameResultMessage = _v; } ); // HtmlView Page linking property 'Text' for element 'gameResultText'
          _view.gameResultText.linkProperty("Visibility",  function() { return gameOver; }, function(_v) { gameOver = _v; } ); // HtmlView Page linking property 'Visibility' for element 'gameResultText'
          _view.controlPanel.linkProperty("Height",  function() { return controlPanelHeight; }, function(_v) { controlPanelHeight = _v; } ); // HtmlView Page linking property 'Height' for element 'controlPanel'
          _view.controlPanel.linkProperty("Visibility",  function() { return showControls; }, function(_v) { showControls = _v; } ); // HtmlView Page linking property 'Visibility' for element 'controlPanel'
          _view.playPauseButton.setAction("OffClick", _pause); // HtmlView Page setting action 'OffClick' for element 'playPauseButton'
          _view.playPauseButton.linkProperty("State",  function() { return _isPaused; } ); // HtmlView Page linking property 'State' for element 'playPauseButton'
          _view.playPauseButton.setAction("OnClick", _play); // HtmlView Page setting action 'OnClick' for element 'playPauseButton'
          _view.stepButton.setAction("OnClick", _step); // HtmlView Page setting action 'OnClick' for element 'stepButton'
          _view.resetButton.setAction("OnClick", _reset); // HtmlView Page setting action 'OnClick' for element 'resetButton'
          _view.timeField.linkProperty("Value",  function() { return time; }, function(_v) { time = _v; } ); // HtmlView Page linking property 'Value' for element 'timeField'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(true);
  _model.setFPS(20);
  _model.setStepsPerDisplay(10);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function pvg_cut_the_rope_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = pvg_cut_the_rope_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);

  _view._addDescriptionPage('Game instructions','./pvg_cut_the_rope/pvg_cut_the_rope_instructions.xhtml');
  _view._addDescriptionPage('Credits','./pvg_cut_the_rope/pvg_cut_the_rope_credits.xhtml');

  return _view;
} // end of main function

function pvg_cut_the_rope_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"topPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'topPanel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'topPanel'
      .setProperty("CSS",{   "position" : "absolute",   "top" : "0px",    "margin-left":"0px",    "left":"0%" }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'topPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.drawingPanel,"drawingPanel", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'drawingPanel'
      .setProperty("Height","100%") // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'drawingPanel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'drawingPanel'
      .setProperty("ShowAreaRectangle",false) // EJsS HtmlView.HtmlView Page: setting property 'ShowAreaRectangle' for element 'drawingPanel'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'drawingPanel'
      .setProperty("SquareAspect",true) // EJsS HtmlView.HtmlView Page: setting property 'SquareAspect' for element 'drawingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"worldLimitsShape", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'worldLimitsShape'
      .setProperty("FillColor","DarkGray") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'worldLimitsShape'
      .setProperty("RelativePosition","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'worldLimitsShape'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'worldLimitsShape'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"frogImage", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'frogImage'
      .setProperty("RelativePosition","SOUTH") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'frogImage'
      .setProperty("ImageUrl","./pvg_cut_the_rope/frog.png") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'frogImage'
      ;

    _view._addElement(EJSS_DRAWING2D.segmentSet,"segmentSet", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'segmentSet'
      .setProperty("LineWidth",3) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'segmentSet'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"bigMassShape", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'bigMassShape'
      .setProperty("FillColor","Magenta") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'bigMassShape'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"messageGroup", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'messageGroup'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"messageShape", _view.messageGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'messageShape'
      .setProperty("FillColor","Pink") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'messageShape'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'messageShape'
      .setProperty("Visibility",false) // EJsS HtmlView.HtmlView Page: setting property 'Visibility' for element 'messageShape'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"messageText", _view.messageGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'messageText'
      .setProperty("FillColor","Black") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'messageText'
      .setProperty("Sensitivity",50) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'messageText'
      .setProperty("Font","normal bold 22px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'messageText'
      .setProperty("EnabledPosition","ENABLED_FIXED") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'messageText'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"gameOverText", _view.messageGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'gameOverText'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'gameOverText'
      .setProperty("Font","normal bold 26px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'gameOverText'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"gameResultText", _view.messageGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'gameResultText'
      .setProperty("Font","normal bold 22px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'gameResultText'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"controlPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'controlPanel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'controlPanel'
      .setProperty("CSS",{   "position" : "absolute",   "bottom" : "2px",    "margin-left":"0px",    "left":"0%" }) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'controlPanel'
      ;

    _view._addElement(EJSS_INTERFACE.twoStateButton,"playPauseButton", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'playPauseButton'
      .setProperty("Tooltip","Play/Pause") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'playPauseButton'
      .setProperty("ImageOnUrl","/org/opensourcephysics/resources/controls/images/play.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOnUrl' for element 'playPauseButton'
      .setProperty("ImageOffUrl","/org/opensourcephysics/resources/controls/images/pause.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOffUrl' for element 'playPauseButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"stepButton", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'stepButton'
      .setProperty("Tooltip","Initialize") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'stepButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/stepforward.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'stepButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'resetButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/reset.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'resetButton'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"timeLabel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'timeLabel'
      .setProperty("Text","Time:") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'timeLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"timeField", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'timeField'
      .setProperty("Width","50px") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'timeField'
      .setProperty("Format","0.00") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'timeField'
      .setProperty("Editable",false) // EJsS HtmlView.HtmlView Page: setting property 'Editable' for element 'timeField'
      ;

  };

  return _view;
}



      var _model;
      window.addEventListener('load',
        function () { 
          _model =  new pvg_cut_the_rope("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
      var interval = setInterval(function() {
         if(document.readyState === 'complete') {
           window.addEventListener('resize', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           window.addEventListener('scroll', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           var startCaptureBut = document.getElementById('startCaptureBut'); 
           var stopCaptureBut = document.getElementById('stopCaptureBut'); 
           var resetCaptureBut = document.getElementById('resetCaptureBut'); 
           var playCaptureBut = document.getElementById('playCaptureBut'); 
           var stepCaptureBut = document.getElementById('stepCaptureBut'); 
           if (startCaptureBut) {
             startCaptureBut.onclick = function() {
               _model.startCapture();
             };
             stopCaptureBut.onclick = function() {
               _model.saveText('recording','rec',JSON.stringify(_model.stopCapture()));
             };
             resetCaptureBut.onclick = function() {
               _model.resetCapture();
             };
             playCaptureBut.onclick = function() {
               _model.readText(null,'.rec',function(content){
               _model.playCapture(JSON.parse(content),function(){startCaptureBut.disabled=false; playCaptureBut.disabled=false; stepCaptureBut.disabled=false; window.alert(end_reproduction_message);});               });
             };
             stepCaptureBut.onchange= function() {
               var stepCapt;
               if (stepCaptureBut.value >= 0) stepCapt =  stepCaptureBut.value + 1;
               else stepCapt = 1 + 1.8*stepCaptureBut.value/8;
               _model.changeCaptureStep(stepCapt);
             };
           }
           clearInterval(interval);
         };
      }, 200)
