var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./pvg_cut_the_rope/frog.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/stepforward.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM6WLrcO0GAAoUYYL444XDKYHUZSA0fZYYcFV1O1QWYtt54HASdsMoumE4StKQ2xEqtAUSVQBmNLWdKAAAh/k9Db3B5cmlnaHQgMjAwMCBieSBTdW4gTWljcm9zeXN0ZW1zLCBJbmMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuDQpKTEYgR1IgVmVyIDEuMA0KADs=";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
