/* _inputParameters: an object with different values for the model parameters */
function SimpleSingleTank(_topFrame,_libraryPath,_codebasePath, _inputParameters) {
  var _model = EJSS_CORE.createAnimation();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var t; // EjsS Model.Variables.Tank.t
  var dt; // EjsS Model.Variables.Tank.dt
  var g; // EjsS Model.Variables.Tank.g
  var R; // EjsS Model.Variables.Tank.R
  var r; // EjsS Model.Variables.Tank.r
  var height; // EjsS Model.Variables.Tank.height
  var level; // EjsS Model.Variables.Tank.level
  var A; // EjsS Model.Variables.Tank.A
  var a; // EjsS Model.Variables.Tank.a

  var setPoint; // EjsS Model.Variables.PI control.setPoint
  var Kflow; // EjsS Model.Variables.PI control.Kflow
  var u; // EjsS Model.Variables.PI control.u
  var Kp; // EjsS Model.Variables.PI control.Kp
  var Ti; // EjsS Model.Variables.PI control.Ti
  var integral; // EjsS Model.Variables.PI control.integral

  var memory; // EjsS Model.Variables.Interface.memory
  var hasLiquid; // EjsS Model.Variables.Interface.hasLiquid
  var liquidColor; // EjsS Model.Variables.Interface.liquidColor
  var automaticMode; // EjsS Model.Variables.Interface.automaticMode
  var setPointColor; // EjsS Model.Variables.Interface.setPointColor
  var trailColor; // EjsS Model.Variables.Interface.trailColor
  var dragging; // EjsS Model.Variables.Interface.dragging

  var _privateOdesList;
  var _ODEi_evolution1;
  var userEvents1=[];

  _model.getOdes = function() { return[_ODEi_evolution1]};

  _model.removeEvents = function(){
    userEvents1=[];
  };

  _model.addFixedRel = function(code){_model.addToFixedRelations(function() { eval(code);});};

    function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      t : t,
      dt : dt,
      g : g,
      R : R,
      r : r,
      height : height,
      level : level,
      A : A,
      a : a,
      setPoint : setPoint,
      Kflow : Kflow,
      u : u,
      Kp : Kp,
      Ti : Ti,
      integral : integral,
      memory : memory,
      hasLiquid : hasLiquid,
      liquidColor : liquidColor,
      automaticMode : automaticMode,
      setPointColor : setPointColor,
      trailColor : trailColor,
      dragging : dragging
    };
  };

  function _serializePublic() { return _model.serializePublic(); }

  _model._userSerializePublic = function() {
    return {
      t : t,
      dt : dt,
      g : g,
      R : R,
      r : r,
      height : height,
      level : level,
      A : A,
      a : a,
      setPoint : setPoint,
      Kflow : Kflow,
      u : u,
      Kp : Kp,
      Ti : Ti,
      integral : integral,
      memory : memory,
      hasLiquid : hasLiquid,
      liquidColor : liquidColor,
      automaticMode : automaticMode,
      setPointColor : setPointColor,
      trailColor : trailColor,
      dragging : dragging
    };
  };

  _model._readParameters = function(json) {
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.g != "undefined") g = json.g;
    if(typeof json.R != "undefined") R = json.R;
    if(typeof json.r != "undefined") r = json.r;
    if(typeof json.height != "undefined") height = json.height;
    if(typeof json.level != "undefined") level = json.level;
    if(typeof json.A != "undefined") A = json.A;
    if(typeof json.a != "undefined") a = json.a;
    if(typeof json.setPoint != "undefined") setPoint = json.setPoint;
    if(typeof json.Kflow != "undefined") Kflow = json.Kflow;
    if(typeof json.u != "undefined") u = json.u;
    if(typeof json.Kp != "undefined") Kp = json.Kp;
    if(typeof json.Ti != "undefined") Ti = json.Ti;
    if(typeof json.integral != "undefined") integral = json.integral;
    if(typeof json.memory != "undefined") memory = json.memory;
    if(typeof json.hasLiquid != "undefined") hasLiquid = json.hasLiquid;
    if(typeof json.liquidColor != "undefined") liquidColor = json.liquidColor;
    if(typeof json.automaticMode != "undefined") automaticMode = json.automaticMode;
    if(typeof json.setPointColor != "undefined") setPointColor = json.setPointColor;
    if(typeof json.trailColor != "undefined") trailColor = json.trailColor;
    if(typeof json.dragging != "undefined") dragging = json.dragging;
  };

  _model._readParametersPublic = function(json) {
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.g != "undefined") g = json.g;
    if(typeof json.R != "undefined") R = json.R;
    if(typeof json.r != "undefined") r = json.r;
    if(typeof json.height != "undefined") height = json.height;
    if(typeof json.level != "undefined") level = json.level;
    if(typeof json.A != "undefined") A = json.A;
    if(typeof json.a != "undefined") a = json.a;
    if(typeof json.setPoint != "undefined") setPoint = json.setPoint;
    if(typeof json.Kflow != "undefined") Kflow = json.Kflow;
    if(typeof json.u != "undefined") u = json.u;
    if(typeof json.Kp != "undefined") Kp = json.Kp;
    if(typeof json.Ti != "undefined") Ti = json.Ti;
    if(typeof json.integral != "undefined") integral = json.integral;
    if(typeof json.memory != "undefined") memory = json.memory;
    if(typeof json.hasLiquid != "undefined") hasLiquid = json.hasLiquid;
    if(typeof json.liquidColor != "undefined") liquidColor = json.liquidColor;
    if(typeof json.automaticMode != "undefined") automaticMode = json.automaticMode;
    if(typeof json.setPointColor != "undefined") setPointColor = json.setPointColor;
    if(typeof json.trailColor != "undefined") trailColor = json.trailColor;
    if(typeof json.dragging != "undefined") dragging = json.dragging;
  };

  function _unserializePublic(json) { return _model.unserializePublic(json); }

  _model._userUnserializePublic = function(json) {
    _model._readParametersPublic(json);
   _resetSolvers();
   _model.update();
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    _model._readParameters(json);
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Init Page"] = true;
    __pagesEnabled["Dynamics"] = true;
    __pagesEnabled["Control"] = true;
    __pagesEnabled["FixRel Page"] = true;
  });

  _model.addToReset(function() {
    t = 0; // EjsS Model.Variables.Tank.t
    dt = 0.05; // EjsS Model.Variables.Tank.dt
    g = 9.8; // EjsS Model.Variables.Tank.g
    R = 0.0295; // EjsS Model.Variables.Tank.R
    r = 0.0015; // EjsS Model.Variables.Tank.r
    height = 0.2; // EjsS Model.Variables.Tank.height
    level = 0.11; // EjsS Model.Variables.Tank.level
    A = Math.PI*R*R; // EjsS Model.Variables.Tank.A
    a = Math.PI*r*r; // EjsS Model.Variables.Tank.a
  });

  _model.addToReset(function() {
    setPoint = 0.05; // EjsS Model.Variables.PI control.setPoint
    Kflow = 2.7e-6; // EjsS Model.Variables.PI control.Kflow
    u = 0; // EjsS Model.Variables.PI control.u
    Kp = 20; // EjsS Model.Variables.PI control.Kp
    Ti = 0.8; // EjsS Model.Variables.PI control.Ti
    integral = 0; // EjsS Model.Variables.PI control.integral
  });

  _model.addToReset(function() {
    memory = false; // EjsS Model.Variables.Interface.memory
    hasLiquid = level>1.e-04; // EjsS Model.Variables.Interface.hasLiquid
    liquidColor = "blue"; // EjsS Model.Variables.Interface.liquidColor
    automaticMode = true; // EjsS Model.Variables.Interface.automaticMode
    setPointColor = "Black"; // EjsS Model.Variables.Interface.setPointColor
    trailColor = "Blue"; // EjsS Model.Variables.Interface.trailColor
    dragging = false; // EjsS Model.Variables.Interface.dragging
  });

  if (_inputParameters) {
    _inputParameters = _model.parseInputParameters(_inputParameters);
    if (_inputParameters) _model.addToReset(function() { _model._readParameters(_inputParameters); });
  }

  _model.addToReset(function() {
    _privateOdesList=[];
    _ODEi_evolution1 = _ODE_evolution1();
    _privateOdesList.push(_ODEi_evolution1);
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setPauseOnPageExit(true);
    _model.setFPS(20);
    _model.setStepsPerDisplay(10);
  });

  function checkSetPoint() {  // > CustomCode.PI:1
    //console.log ("CP wants to be "+setPoint);  // > CustomCode.PI:2
    if (setPoint>height) setPoint = height;  // > CustomCode.PI:3
    else if (setPoint<0) setPoint = 0;  // > CustomCode.PI:4
    //console.log ("CP will be "+setPoint);  // > CustomCode.PI:5
    integral = 0;  // > CustomCode.PI:6
  }  // > CustomCode.PI:7

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Init Page"]) return;
    t = 0.0;  // > Initialization.Init Page:1
    level = 0.11;  // > Initialization.Init Page:2
    automaticMode = true;  // > Initialization.Init Page:3
    u = 0;  // > Initialization.Init Page:4
    integral = 0;  // > Initialization.Init Page:5
    if (!memory) _view._reset();  // > Initialization.Init Page:6
    var yAxis = _view.plottingPanel.getAxisY();  // > Initialization.Init Page:7
    yAxis.setScalePrecision(2);  // > Initialization.Init Page:8
    yAxis.setAutoTicks(false);  // > Initialization.Init Page:9
    yAxis.setTicks(4);  // > Initialization.Init Page:10
  });

  _model.addToInitialization(function() {
    _initializeSolvers();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Dynamics"]) return;
    _ODEi_evolution1.step();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Control"]) return;
    if (automaticMode) {  // > Evolution.Control:1
      var uBefore = u;  // > Evolution.Control:2
      // P + I action  // > Evolution.Control:3
      u = Kp*(setPoint - level) + integral;  // > Evolution.Control:4
      if (u<0) u = 0;  // > Evolution.Control:5
      // Update integral action  // > Evolution.Control:6
      integral = integral + Kp*dt/Ti * (setPoint - level);  // > Evolution.Control:7
      if (uBefore!== u) _resetSolvers();  // > Evolution.Control:8
    }  // > Evolution.Control:9
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["FixRel Page"]) return;
    hasLiquid = level>1.0e-4;  // > FixedRelations.FixRel Page:1
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  function _initializeSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].initializeSolver();
  }

  function _automaticResetSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].automaticResetSolver();
  }

  _model.resetSolvers = function() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].resetSolver();
  };

  _getODE = function (_odeName) {
    if (_odeName=="Dynamics") return _ODEi_evolution1;
    return null;
  }

  function _getEventSolver(_odeName) {
    var ode = _getODE(_odeName);
    if (ode===null) return null;
    return ode.getEventSolver();
  }

  function _setSolverClass(_odeName, _engine) {
    var ode = _getODE(_odeName);
    if (ode===null) return;
    if (!_engine.setODE) {
      var classname = _engine.toLowerCase();
      if      (classname.indexOf("boga")>=0)   _engine = EJSS_ODE_SOLVERS.bogackiShampine23;
      else if (classname.indexOf("cash")>=0)   _engine = EJSS_ODE_SOLVERS.cashKarp45;
      else if (classname.indexOf("dopri5")>=0) _engine = EJSS_ODE_SOLVERS.dopri5;
      else if (classname.indexOf("dopri8")>=0) _engine = EJSS_ODE_SOLVERS.dopri853;
      else if (classname.indexOf("richa")>=0)  _engine = EJSS_ODE_SOLVERS.eulerRichardson;
      else if (classname.indexOf("euler")>=0)  _engine = EJSS_ODE_SOLVERS.euler;
      else if (classname.indexOf("fehlberg87")>=0) _engine = EJSS_ODE_SOLVERS.fehlberg87;
      else if (classname.indexOf("fehlberg8")>=0)  _engine = EJSS_ODE_SOLVERS.fehlberg8;
      else if (classname.indexOf("radau")>=0)   _engine = EJSS_ODE_SOLVERS.radau5;
      else if (classname.indexOf("runge")>=0)  _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("rk4")>=0)    _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("verlet")>=0) _engine = EJSS_ODE_SOLVERS.velocityVerlet;
    }
    if (_engine) ode.setSolverClass(_engine);
  }

  function _ODE_evolution1() {
    var __odeSelf = {};
    var __eventSolver;
    var __solverClass = EJSS_ODE_SOLVERS.rungeKutta4;
    var __state=[];
    var __ignoreErrors=false;
    var __mustInitialize=true;
    var __isEnabled=true;
    var __mustUserReinitialize=false;
    var __mustReinitialize=true;


    __odeSelf._getOdeVars = function (){ return["level","t"]};

    __odeSelf.setSolverClass = function(__aSolverClass) {
      __solverClass = __aSolverClass;
      __instantiateSolver();
    };

    function __instantiateSolver() {
      __state=[];
      __pushState();
      __eventSolver = EJSS_ODE_SOLVERS.interpolatorEventSolver(__solverClass(),__odeSelf);
      __mustInitialize = true;
    }

    __odeSelf.setEnabled = function(_enabled) { __isEnabled = _enabled; };

    __odeSelf.getIndependentVariableValue = function() { return __eventSolver.getIndependentVariableValue(); };

    __odeSelf.getInternalStepSize = function() { return __eventSolver.getInternalStepSize(); };

    __odeSelf.isAccelerationIndependentOfVelocity = function() { return false; };

    __odeSelf.initializeSolver = function() {
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); return; }
      __pushState();
      __eventSolver.initialize(dt);
      __eventSolver.setBestInterpolation(false);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.removeAllEvents();
      for(k in userEvents1){__eventSolver.addEvent(userEvents1[k]);}
      __eventSolver.setEstimateFirstStep(false);
      __eventSolver.setEnableExceptions(false);
      __mustReinitialize = true;
      __mustInitialize = false;
    };

    function __pushState() {
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        if (__state[__cIn]!=level) __mustReinitialize = true;
        __state[__cIn++] = level;
        if (__state[__cIn]!=t) __mustReinitialize = true;
        __state[__cIn++] = t;
    }

    function __arraysChanged () {
      return false;
    }

    __odeSelf.getEventSolver = function() {
      return __eventSolver;
    };

    __odeSelf.resetSolver = function() {
      __mustUserReinitialize = true;
    };

    __odeSelf.automaticResetSolver = function() {
      __mustReinitialize = true;
    };

    function __errorAction () {
      if (__ignoreErrors) return;
      console.log (__eventSolver.getErrorMessage());
      _pause();
      // Make sure the solver is reinitialized;
      __mustReinitialize = true;
    }

    __odeSelf.step = function() { return __privateStep(false); };

    __odeSelf.solverStep = function() { return __privateStep(true); };

    function __privateStep(__takeMaximumStep) {
      if (!__isEnabled) return 0;
      if (dt===0) return 0;
      if (__mustInitialize) __odeSelf.initializeSolver();
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); }
      __eventSolver.setStepSize(dt);
      __eventSolver.setInternalStepSize(dt);
      __eventSolver.setMaximumInternalSteps(10000);
      __pushState();
      if (__mustUserReinitialize) { 
        __eventSolver.userReinitialize();
        __mustUserReinitialize = false;
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      else if (__mustReinitialize) { 
        __eventSolver.reinitialize();
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      var __stepTaken = __takeMaximumStep ? __eventSolver.maxStep() : __eventSolver.step();
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        level = __state[__cOut++];
        t = __state[__cOut++];
      // Check for error
      if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      return __stepTaken;
    }

    __odeSelf.getState = function() { return __state; };

    __odeSelf.getRate = function(_aState,_aRate) {
      _aRate[_aRate.length-1] = 0.0; // In case the prelim code returns
      var __index=-1; // so that it can be used in preliminary code
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var level = _aState[__cOut++];
        var t = _aState[__cOut++];
      // Preliminary code: Code to be executed before rate equations are evaluated
        var deltaLevel;  // > Preliminary code for ODE.Dynamics:1
        if (level>=0)   // > Preliminary code for ODE.Dynamics:2
          deltaLevel = -a/A * Math.sqrt(2*g*level) + Kflow/A * u;  // > Preliminary code for ODE.Dynamics:3
        else   // > Preliminary code for ODE.Dynamics:4
          deltaLevel = Kflow/A * u;  // > Preliminary code for ODE.Dynamics:5
      // Compute the rate
        var __cRate=0;
        _aRate[__cRate++] = deltaLevel; // Rate for ODE: Dynamics:level
        _aRate[__cRate++] = 1; // independent variable
        return _aRate;
    }; //end of getRate

    __odeSelf._addEvent = function(userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent){
    var User_Event = function (userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent) {
      var _eventSelf = {};

      _eventSelf.getTypeOfEvent = function() { return eventType; };

      _eventSelf.getRootFindingMethod = function() { return eventMethod; };

      _eventSelf.getMaxIterations = function() { return maxIter; };

      _eventSelf.getTolerance = function() { return eventTolerance; };

      _eventSelf.evaluate = function(_aState) { 
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var level = _aState[__cOut++];
        var t = _aState[__cOut++];
      return eval(userCondition);
      };

      _eventSelf.action = function() { 
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        level = __state[__cOut++];
        t = __state[__cOut++];
        var _returnValue = __userDefinedAction();
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        __state[__cIn++] = level;
        __state[__cIn++] = t;
        return _returnValue;
      };

      function __userDefinedAction() {
        if (undefined != functions) eval(functions.toString());
        eval(userAction);
        return endAtEvent;
      }

      return _eventSelf;
    }; // End of event

   userEvents1.push(User_Event(userCondition,userAction,eventType,eventMethod,maxIter,eventTolerance,endAtEvent));
   }

    __instantiateSolver();

    return __odeSelf;
  }

  function _historic_level(__time) {
    var __index = 0;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

    _model._resized = function(_width,_height) {
      _view._resized(_width,_height);
  }; // end of _resized
    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 800, height : 500 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new SimpleSingleTank_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.tankBasin.linkProperty("LevelColor",  function() { return liquidColor; }, function(_v) { liquidColor = _v; } ); // HtmlView Page linking property 'LevelColor' for element 'tankBasin'
          _view.endlessTank.linkProperty("LevelColor",  function() { return liquidColor; }, function(_v) { liquidColor = _v; } ); // HtmlView Page linking property 'LevelColor' for element 'endlessTank'
          _view.pipeToValve.linkProperty("Points",  function() { return [[0.06, 0.0] ]; } ); // HtmlView Page linking property 'Points' for element 'pipeToValve'
          _view.pipeToValve.linkProperty("FillColor",  function() { return liquidColor; }, function(_v) { liquidColor = _v; } ); // HtmlView Page linking property 'FillColor' for element 'pipeToValve'
          _view.pipeFromValve.linkProperty("Points",  function() { return [[0.051, 0.0], [0,-0.03] ]; } ); // HtmlView Page linking property 'Points' for element 'pipeFromValve'
          _view.pipeFromValve.linkProperty("FillColor",  function() { return u>0 ? liquidColor : "White"; } ); // HtmlView Page linking property 'FillColor' for element 'pipeFromValve'
          _view.liquidToTank.linkProperty("Points",  function() { return [[0.0, -0.22] ]; } ); // HtmlView Page linking property 'Points' for element 'liquidToTank'
          _view.liquidToTank.linkProperty("FillColor",  function() { return liquidColor; }, function(_v) { liquidColor = _v; } ); // HtmlView Page linking property 'FillColor' for element 'liquidToTank'
          _view.liquidToTank.linkProperty("Visibility",  function() { return u>0; } ); // HtmlView Page linking property 'Visibility' for element 'liquidToTank'
          _view.tank.linkProperty("LevelColor",  function() { return liquidColor; }, function(_v) { liquidColor = _v; } ); // HtmlView Page linking property 'LevelColor' for element 'tank'
          _view.tank.linkProperty("SizeX",  function() { return 2*R; } ); // HtmlView Page linking property 'SizeX' for element 'tank'
          _view.tank.linkProperty("Level",  function() { return level; }, function(_v) { level = _v; } ); // HtmlView Page linking property 'Level' for element 'tank'
          _view.tank.linkProperty("SizeY",  function() { return height; }, function(_v) { height = _v; } ); // HtmlView Page linking property 'SizeY' for element 'tank'
          _view.pipeFromTank.linkProperty("Points",  function() { return [[0.0, -0.01] ]; } ); // HtmlView Page linking property 'Points' for element 'pipeFromTank'
          _view.pipeFromTank.linkProperty("FillColor",  function() { return hasLiquid ? liquidColor : "White"; } ); // HtmlView Page linking property 'FillColor' for element 'pipeFromTank'
          _view.liquidFromTank.linkProperty("Points",  function() { return [[0.0, -0.1] ]; } ); // HtmlView Page linking property 'Points' for element 'liquidFromTank'
          _view.liquidFromTank.linkProperty("FillColor",  function() { return liquidColor; }, function(_v) { liquidColor = _v; } ); // HtmlView Page linking property 'FillColor' for element 'liquidFromTank'
          _view.liquidFromTank.linkProperty("Visibility",  function() { return hasLiquid; }, function(_v) { hasLiquid = _v; } ); // HtmlView Page linking property 'Visibility' for element 'liquidFromTank'
          _view.interactionArrow.setAction("OnRelease", function(_data,_info) {
  dragging = false;

}); // HtmlView Page setting action 'OnRelease' for element 'interactionArrow'
          _view.interactionArrow.linkProperty("Visibility",  function() { return hasLiquid; }, function(_v) { hasLiquid = _v; } ); // HtmlView Page linking property 'Visibility' for element 'interactionArrow'
          _view.interactionArrow.setAction("OnPress", function(_data,_info) {
  dragging = true;

}); // HtmlView Page setting action 'OnPress' for element 'interactionArrow'
          _view.interactionArrow.linkProperty("SizeY",  function() { return level; }, function(_v) { level = _v; } ); // HtmlView Page linking property 'SizeY' for element 'interactionArrow'
          _view.interactionArrow.setAction("OnDrag", function(_data,_info) {
  integral = 0;
  if (level<0) level = 0;
  else if (level>height) level = height;

}); // HtmlView Page setting action 'OnDrag' for element 'interactionArrow'
          _view.setPointText.setAction("OnRelease", function(_data,_info) {
  dragging = false;

}); // HtmlView Page setting action 'OnRelease' for element 'setPointText'
          _view.setPointText.linkProperty("Y",  function() { return setPoint; }, function(_v) { setPoint = _v; } ); // HtmlView Page linking property 'Y' for element 'setPointText'
          _view.setPointText.setAction("OnPress", function(_data,_info) {
  dragging = true;

}); // HtmlView Page setting action 'OnPress' for element 'setPointText'
          _view.setPointText.setAction("OnDrag", checkSetPoint); // HtmlView Page setting action 'OnDrag' for element 'setPointText'
          _view.setPointArrow.setAction("OnRelease", function(_data,_info) {
  dragging = false;

}); // HtmlView Page setting action 'OnRelease' for element 'setPointArrow'
          _view.setPointArrow.linkProperty("Y",  function() { return setPoint; }, function(_v) { setPoint = _v; } ); // HtmlView Page linking property 'Y' for element 'setPointArrow'
          _view.setPointArrow.setAction("OnPress", function(_data,_info) {
  dragging = true;

}); // HtmlView Page setting action 'OnPress' for element 'setPointArrow'
          _view.setPointArrow.setAction("OnDrag", checkSetPoint); // HtmlView Page setting action 'OnDrag' for element 'setPointArrow'
          _view.lcGroup.linkProperty("X",  function() { return 0.205+R; } ); // HtmlView Page linking property 'X' for element 'lcGroup'
          _view.lcGroup.linkProperty("Y",  function() { return height/2; } ); // HtmlView Page linking property 'Y' for element 'lcGroup'
          _view.plottingPanel.linkProperty("MaximumY",  function() { return height; }, function(_v) { height = _v; } ); // HtmlView Page linking property 'MaximumY' for element 'plottingPanel'
          _view.setPointTrail.linkProperty("LineColor",  function() { return setPointColor; }, function(_v) { setPointColor = _v; } ); // HtmlView Page linking property 'LineColor' for element 'setPointTrail'
          _view.setPointTrail.linkProperty("InputX",  function() { return t; }, function(_v) { t = _v; } ); // HtmlView Page linking property 'InputX' for element 'setPointTrail'
          _view.setPointTrail.linkProperty("InputY",  function() { return setPoint; }, function(_v) { setPoint = _v; } ); // HtmlView Page linking property 'InputY' for element 'setPointTrail'
          _view.levelTrail.linkProperty("LineColor",  function() { return trailColor; }, function(_v) { trailColor = _v; } ); // HtmlView Page linking property 'LineColor' for element 'levelTrail'
          _view.levelTrail.linkProperty("InputX",  function() { return t; }, function(_v) { t = _v; } ); // HtmlView Page linking property 'InputX' for element 'levelTrail'
          _view.levelTrail.linkProperty("InputY",  function() { return level; }, function(_v) { level = _v; } ); // HtmlView Page linking property 'InputY' for element 'levelTrail'
          _view.playPauseButton.setAction("OffClick", _pause); // HtmlView Page setting action 'OffClick' for element 'playPauseButton'
          _view.playPauseButton.linkProperty("State",  function() { return _isPaused; } ); // HtmlView Page linking property 'State' for element 'playPauseButton'
          _view.playPauseButton.setAction("OnClick", _play); // HtmlView Page setting action 'OnClick' for element 'playPauseButton'
          _view.initButton.setAction("OnClick", function(_data,_info) {
  if (memory) {
    var style = _view.setPointTrail.getStyle();
    style.setLineColor("Grey");
    style.setLineWidth(1);
    _view.setPointTrail.newSegment();
    
    style = _view.levelTrail.getStyle();
    style.setLineColor("Cyan");
    style.setLineWidth(1);
    _view.levelTrail.newSegment();
  }
  _initialize();

}); // HtmlView Page setting action 'OnClick' for element 'initButton'
          _view.resetButton.setAction("OnClick", _reset); // HtmlView Page setting action 'OnClick' for element 'resetButton'
          _view.memoryCheckBox.linkProperty("Checked",  function() { return memory; }, function(_v) { memory = _v; } ); // HtmlView Page linking property 'Checked' for element 'memoryCheckBox'
          _view.timeField.linkProperty("Value",  function() { return t; }, function(_v) { t = _v; } ); // HtmlView Page linking property 'Value' for element 'timeField'
          _view.manualRadioButton.linkProperty("Checked",  function() { return !automaticMode; } ); // HtmlView Page linking property 'Checked' for element 'manualRadioButton'
          _view.manualRadioButton.setAction("OnCheckOn", function(_data,_info) {
  automaticMode = false;

}); // HtmlView Page setting action 'OnCheckOn' for element 'manualRadioButton'
          _view.autoRadioButton.linkProperty("Checked",  function() { return automaticMode; }, function(_v) { automaticMode = _v; } ); // HtmlView Page linking property 'Checked' for element 'autoRadioButton'
          _view.autoRadioButton.setAction("OnCheckOn", function(_data,_info) {
  automaticMode = true;

}); // HtmlView Page setting action 'OnCheckOn' for element 'autoRadioButton'
          _view.RField.linkProperty("Value",  function() { return R; }, function(_v) { R = _v; } ); // HtmlView Page linking property 'Value' for element 'RField'
          _view.RField.setAction("OnChange", function(_data,_info) {
  A = Math.PI*R*R;

}); // HtmlView Page setting action 'OnChange' for element 'RField'
          _view.rField.linkProperty("Value",  function() { return r; }, function(_v) { r = _v; } ); // HtmlView Page linking property 'Value' for element 'rField'
          _view.rField.setAction("OnChange", function(_data,_info) {
  a = Math.PI*r*r;

}); // HtmlView Page setting action 'OnChange' for element 'rField'
          _view.spField.linkProperty("Value",  function() { return setPoint; }, function(_v) { setPoint = _v; } ); // HtmlView Page linking property 'Value' for element 'spField'
          _view.uField.linkProperty("Value",  function() { return u; }, function(_v) { u = _v; } ); // HtmlView Page linking property 'Value' for element 'uField'
          _view.uField.setAction("OnChange", function(_data,_info) {
  _resetSolvers();

}); // HtmlView Page setting action 'OnChange' for element 'uField'
          _view.kpSlider.linkProperty("Value",  function() { return Kp; }, function(_v) { Kp = _v; } ); // HtmlView Page linking property 'Value' for element 'kpSlider'
          _view.tiSlider.linkProperty("Value",  function() { return Ti; }, function(_v) { Ti = _v; } ); // HtmlView Page linking property 'Value' for element 'tiSlider'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(20);
  _model.setStepsPerDisplay(10);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function SimpleSingleTank_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = SimpleSingleTank_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);

  _view._addDescriptionPage('Single tank','./SimpleSingleTank_Intro_1.html');

  return _view;
} // end of main function

function SimpleSingleTank_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"labelPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'labelPanel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'labelPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label", _view.labelPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'label'
      .setProperty("Foreground","Blue") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'label'
      .setProperty("Text","Single tank PI control <hr/>") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label'
      .setProperty("Font","normal bold 22px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'label'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"topPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'topPanel'
      .setProperty("Width","100%") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'topPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.drawingPanel,"drawingPanel", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'drawingPanel'
      .setProperty("Height",300) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'drawingPanel'
      .setProperty("Width",300) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'drawingPanel'
      .setProperty("MinimumX",0) // EJsS HtmlView.HtmlView Page: setting property 'MinimumX' for element 'drawingPanel'
      .setProperty("MinimumY",-0.1) // EJsS HtmlView.HtmlView Page: setting property 'MinimumY' for element 'drawingPanel'
      .setProperty("Background","white") // EJsS HtmlView.HtmlView Page: setting property 'Background' for element 'drawingPanel'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'drawingPanel'
      .setProperty("Foreground","White") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'drawingPanel'
      .setProperty("SquareAspect",true) // EJsS HtmlView.HtmlView Page: setting property 'SquareAspect' for element 'drawingPanel'
      .setProperty("MaximumY",0.3) // EJsS HtmlView.HtmlView Page: setting property 'MaximumY' for element 'drawingPanel'
      .setProperty("MaximumX",0.4) // EJsS HtmlView.HtmlView Page: setting property 'MaximumX' for element 'drawingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.tank,"tankBasin", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'tankBasin'
      .setProperty("SizeX",0.38) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'tankBasin'
      .setProperty("RelativePosition","SOUTH") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'tankBasin'
      .setProperty("X",0.2) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'tankBasin'
      .setProperty("Y",-0.1) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'tankBasin'
      .setProperty("Level",0.02) // EJsS HtmlView.HtmlView Page: setting property 'Level' for element 'tankBasin'
      .setProperty("SizeY",0.1) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'tankBasin'
      .setProperty("DrawLines",false) // EJsS HtmlView.HtmlView Page: setting property 'DrawLines' for element 'tankBasin'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'tankBasin'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"valveGroup", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'valveGroup'
      ;

    _view._addElement(EJSS_DRAWING2D.tank,"endlessTank", _view.valveGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'endlessTank'
      .setProperty("SizeX",0.05) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'endlessTank'
      .setProperty("RelativePosition","SOUTH_EAST") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'endlessTank'
      .setProperty("X",0.051) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'endlessTank'
      .setProperty("Y",0.2465) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'endlessTank'
      .setProperty("Level",0.05) // EJsS HtmlView.HtmlView Page: setting property 'Level' for element 'endlessTank'
      .setProperty("SizeY",0.5) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'endlessTank'
      .setProperty("DrawLines",false) // EJsS HtmlView.HtmlView Page: setting property 'DrawLines' for element 'endlessTank'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'endlessTank'
      ;

    _view._addElement(EJSS_DRAWING2D.pipe,"pipeToValve", _view.valveGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'pipeToValve'
      .setProperty("X",0.05) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'pipeToValve'
      .setProperty("Y",0.25) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'pipeToValve'
      ;

    _view._addElement(EJSS_DRAWING2D.image,"valveImage", _view.valveGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'valveImage'
      .setProperty("SizeX",0.04) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'valveImage'
      .setProperty("RelativePosition","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'valveImage'
      .setProperty("X",0.13) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'valveImage'
      .setProperty("ImageUrl","./SimpleSingleTank/ValveImage.png") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'valveImage'
      .setProperty("Y",0.25) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'valveImage'
      .setProperty("SizeY",0.05) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'valveImage'
      ;

    _view._addElement(EJSS_DRAWING2D.pipe,"pipeFromValve", _view.valveGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'pipeFromValve'
      .setProperty("X",0.15) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'pipeFromValve'
      .setProperty("Y",0.25) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'pipeFromValve'
      ;

    _view._addElement(EJSS_DRAWING2D.pipe,"liquidToTank", _view.valveGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'liquidToTank'
      .setProperty("X",0.201) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'liquidToTank'
      .setProperty("Y",0.22) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'liquidToTank'
      .setProperty("DrawLines",false) // EJsS HtmlView.HtmlView Page: setting property 'DrawLines' for element 'liquidToTank'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"tankGroup", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'tankGroup'
      ;

    _view._addElement(EJSS_DRAWING2D.tank,"tank", _view.tankGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'tank'
      .setProperty("RelativePosition","SOUTH") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'tank'
      .setProperty("X",0.2) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'tank'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'tank'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'tank'
      ;

    _view._addElement(EJSS_DRAWING2D.pipe,"pipeFromTank", _view.tankGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'pipeFromTank'
      .setProperty("X",0.2) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'pipeFromTank'
      .setProperty("Y",0.001) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'pipeFromTank'
      ;

    _view._addElement(EJSS_DRAWING2D.pipe,"liquidFromTank", _view.tankGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'liquidFromTank'
      .setProperty("X",0.2) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'liquidFromTank'
      .setProperty("Y",0.001) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'liquidFromTank'
      .setProperty("DrawLines",false) // EJsS HtmlView.HtmlView Page: setting property 'DrawLines' for element 'liquidFromTank'
      ;

    _view._addElement(EJSS_DRAWING2D.arrow,"interactionArrow", _view.tankGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'interactionArrow'
      .setProperty("Sensitivity",10) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'interactionArrow'
      .setProperty("SizeX",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'interactionArrow'
      .setProperty("EnabledSize","ENABLED_Y") // EJsS HtmlView.HtmlView Page: setting property 'EnabledSize' for element 'interactionArrow'
      .setProperty("X",0.2) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'interactionArrow'
      .setProperty("LineColor","Yellow") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'interactionArrow'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'interactionArrow'
      .setProperty("LineWidth",0) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'interactionArrow'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"setPointGroup", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'setPointGroup'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"setPointText", _view.setPointGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'setPointText'
      .setProperty("Sensitivity",20) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'setPointText'
      .setProperty("RelativePosition","CENTERED") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'setPointText'
      .setProperty("X",0.025) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'setPointText'
      .setProperty("Text","SP") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'setPointText'
      .setProperty("Font","normal normal 14px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'setPointText'
      .setProperty("EnabledPosition","ENABLED_Y") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'setPointText'
      ;

    _view._addElement(EJSS_DRAWING2D.arrow,"setPointArrow", _view.setPointGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'setPointArrow'
      .setProperty("SizeX",0.1) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'setPointArrow'
      .setProperty("X",0.06) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'setPointArrow'
      .setProperty("SizeY",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'setPointArrow'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'setPointArrow'
      .setProperty("EnabledPosition","ENABLED_Y") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'setPointArrow'
      ;

    _view._addElement(EJSS_DRAWING2D.group,"lcGroup", _view.drawingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'lcGroup'
      ;

    _view._addElement(EJSS_DRAWING2D.arrow,"lcToArrow", _view.lcGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'lcToArrow'
      .setProperty("SizeX",0.05) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'lcToArrow'
      .setProperty("SizeY",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'lcToArrow'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"lcCircleShape", _view.lcGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'lcCircleShape'
      .setProperty("SizeX",0.05) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'lcCircleShape'
      .setProperty("X",0.075) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'lcCircleShape'
      .setProperty("SizeY",0.05) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'lcCircleShape'
      .setProperty("DrawFill",false) // EJsS HtmlView.HtmlView Page: setting property 'DrawFill' for element 'lcCircleShape'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"lcText", _view.lcGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'lcText'
      .setProperty("X",0.077) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'lcText'
      .setProperty("Y",0.003) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'lcText'
      .setProperty("Text","LC") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'lcText'
      .setProperty("Font","normal normal 14px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'lcText'
      ;

    _view._addElement(EJSS_DRAWING2D.arrow,"lcFromSPArrow", _view.lcGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'lcFromSPArrow'
      .setProperty("SizeX",-0.03) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'lcFromSPArrow'
      .setProperty("X",0.13) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'lcFromSPArrow'
      .setProperty("SizeY",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'lcFromSPArrow'
      ;

    _view._addElement(EJSS_DRAWING2D.text,"lcSPText", _view.lcGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'lcSPText'
      .setProperty("X",0.15) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'lcSPText'
      .setProperty("Y",0.003) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'lcSPText'
      .setProperty("Text","SP") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'lcSPText'
      .setProperty("Font","normal normal 14px ") // EJsS HtmlView.HtmlView Page: setting property 'Font' for element 'lcSPText'
      ;

    _view._addElement(EJSS_DRAWING2D.segment,"lcUpSegment", _view.lcGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'lcUpSegment'
      .setProperty("SizeX",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'lcUpSegment'
      .setProperty("X",0.075) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'lcUpSegment'
      .setProperty("Y",0.025) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'lcUpSegment'
      .setProperty("SizeY",0.145) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'lcUpSegment'
      ;

    _view._addElement(EJSS_DRAWING2D.arrow,"lcTopArrow", _view.lcGroup) // EJsS HtmlView.HtmlView Page: declaration of element 'lcTopArrow'
      .setProperty("SizeX",-0.15) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'lcTopArrow'
      .setProperty("X",0.075) // EJsS HtmlView.HtmlView Page: setting property 'X' for element 'lcTopArrow'
      .setProperty("Y",0.17) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'lcTopArrow'
      .setProperty("SizeY",0) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'lcTopArrow'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"emptyLabel", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'emptyLabel'
      .setProperty("Width",10) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'emptyLabel'
      .setProperty("Text","") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'emptyLabel'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"plottingPanel", _view.topPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'plottingPanel'
      .setProperty("Height",300) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'plottingPanel'
      .setProperty("Width",400) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'plottingPanel'
      .setProperty("MinimumX",0) // EJsS HtmlView.HtmlView Page: setting property 'MinimumX' for element 'plottingPanel'
      .setProperty("MinimumY",0) // EJsS HtmlView.HtmlView Page: setting property 'MinimumY' for element 'plottingPanel'
      .setProperty("TitleY","Level") // EJsS HtmlView.HtmlView Page: setting property 'TitleY' for element 'plottingPanel'
      .setProperty("AutoScaleY",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'plottingPanel'
      .setProperty("TitleX","Time") // EJsS HtmlView.HtmlView Page: setting property 'TitleX' for element 'plottingPanel'
      .setProperty("AutoScaleX",true) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'plottingPanel'
      .setProperty("Title","Tank level") // EJsS HtmlView.HtmlView Page: setting property 'Title' for element 'plottingPanel'
      .setProperty("MaximumX",1) // EJsS HtmlView.HtmlView Page: setting property 'MaximumX' for element 'plottingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.trail,"setPointTrail", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'setPointTrail'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'setPointTrail'
      ;

    _view._addElement(EJSS_DRAWING2D.trail,"levelTrail", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'levelTrail'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'levelTrail'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"controlPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'controlPanel'
      ;

    _view._addElement(EJSS_INTERFACE.twoStateButton,"playPauseButton", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'playPauseButton'
      .setProperty("Tooltip","Play/Pause") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'playPauseButton'
      .setProperty("ImageOnUrl","/org/opensourcephysics/resources/controls/images/play.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOnUrl' for element 'playPauseButton'
      .setProperty("ImageOffUrl","/org/opensourcephysics/resources/controls/images/pause.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOffUrl' for element 'playPauseButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"initButton", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'initButton'
      .setProperty("Tooltip","Initialize") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'initButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/stepback.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'initButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'resetButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/reset.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'resetButton'
      ;

    _view._addElement(EJSS_INTERFACE.checkBox,"memoryCheckBox", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'memoryCheckBox'
      .setProperty("Text","Memory") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'memoryCheckBox'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"timeLabel", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'timeLabel'
      .setProperty("Text","Time:") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'timeLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"timeField", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'timeField'
      .setProperty("Width","50px") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'timeField'
      .setProperty("Format","0.00") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'timeField'
      .setProperty("Editable",false) // EJsS HtmlView.HtmlView Page: setting property 'Editable' for element 'timeField'
      ;

    _view._addElement(EJSS_INTERFACE.radioButton,"manualRadioButton", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'manualRadioButton'
      .setProperty("Text","Manual") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'manualRadioButton'
      ;

    _view._addElement(EJSS_INTERFACE.radioButton,"autoRadioButton", _view.controlPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'autoRadioButton'
      .setProperty("Text","Automatic") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'autoRadioButton'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"paramsPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'paramsPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"RLabel", _view.paramsPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'RLabel'
      .setProperty("Text","R=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'RLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"RField", _view.paramsPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'RField'
      .setProperty("Width","50px") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'RField'
      .setProperty("Format","0.000") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'RField'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"rLabel", _view.paramsPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'rLabel'
      .setProperty("Text","r=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'rLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"rField", _view.paramsPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'rField'
      .setProperty("Width","50px") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'rField'
      .setProperty("Format","0.000") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'rField'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"spLabel", _view.paramsPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'spLabel'
      .setProperty("Text","sp=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'spLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"spField", _view.paramsPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'spField'
      .setProperty("Width","50px") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'spField'
      .setProperty("Format","0.000") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'spField'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"uLabel", _view.paramsPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'uLabel'
      .setProperty("Text","u=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'uLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"uField", _view.paramsPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'uField'
      .setProperty("Width","50px") // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'uField'
      .setProperty("Format","0.000") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'uField'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"slidersPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'slidersPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"kpLabel", _view.slidersPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'kpLabel'
      .setProperty("Text","Kp =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'kpLabel'
      ;

    _view._addElement(EJSS_INTERFACE.slider,"kpSlider", _view.slidersPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'kpSlider'
      .setProperty("Minimum",0) // EJsS HtmlView.HtmlView Page: setting property 'Minimum' for element 'kpSlider'
      .setProperty("Maximum",40) // EJsS HtmlView.HtmlView Page: setting property 'Maximum' for element 'kpSlider'
      .setProperty("ShowText",true) // EJsS HtmlView.HtmlView Page: setting property 'ShowText' for element 'kpSlider'
      .setProperty("Format","0.00") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'kpSlider'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"tiLabel", _view.slidersPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'tiLabel'
      .setProperty("Text","Ti =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'tiLabel'
      ;

    _view._addElement(EJSS_INTERFACE.slider,"tiSlider", _view.slidersPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'tiSlider'
      .setProperty("Minimum",0) // EJsS HtmlView.HtmlView Page: setting property 'Minimum' for element 'tiSlider'
      .setProperty("Maximum",3) // EJsS HtmlView.HtmlView Page: setting property 'Maximum' for element 'tiSlider'
      .setProperty("ShowText",true) // EJsS HtmlView.HtmlView Page: setting property 'ShowText' for element 'tiSlider'
      .setProperty("Format","0.00") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'tiSlider'
      ;

  };

  return _view;
}



      var _model;
      window.addEventListener('load',
        function () { 
          _model =  new SimpleSingleTank("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
      var interval = setInterval(function() {
         if(document.readyState === 'complete') {
           window.addEventListener('resize', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           window.addEventListener('scroll', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           var startCaptureBut = document.getElementById('startCaptureBut'); 
           var stopCaptureBut = document.getElementById('stopCaptureBut'); 
           var resetCaptureBut = document.getElementById('resetCaptureBut'); 
           var playCaptureBut = document.getElementById('playCaptureBut'); 
           var stepCaptureBut = document.getElementById('stepCaptureBut'); 
           if (startCaptureBut) {
             startCaptureBut.onclick = function() {
               _model.startCapture();
             };
             stopCaptureBut.onclick = function() {
               _model.saveText('recording','rec',JSON.stringify(_model.stopCapture()));
             };
             resetCaptureBut.onclick = function() {
               _model.resetCapture();
             };
             playCaptureBut.onclick = function() {
               _model.readText(null,'.rec',function(content){
               _model.playCapture(JSON.parse(content),function(){startCaptureBut.disabled=false; playCaptureBut.disabled=false; stepCaptureBut.disabled=false; window.alert(end_reproduction_message);});               });
             };
             stepCaptureBut.onchange= function() {
               var stepCapt;
               if (stepCaptureBut.value >= 0) stepCapt =  stepCaptureBut.value + 1;
               else stepCapt = 1 + 1.8*stepCaptureBut.value/8;
               _model.changeCaptureStep(stepCapt);
             };
           }
           clearInterval(interval);
         };
      }, 200)
