function EarthAndMoon3D(_topFrame,_libraryPath,_codebasePath) {
  var _model = EJSS_CORE.createAnimation();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var G; // EjsS Model.Variables.Variables.G
  var M; // EjsS Model.Variables.Variables.M
  var ext; // EjsS Model.Variables.Variables.ext
  var h; // EjsS Model.Variables.Variables.h
  var tol; // EjsS Model.Variables.Variables.tol
  var t; // EjsS Model.Variables.Variables.t
  var x; // EjsS Model.Variables.Variables.x
  var vx; // EjsS Model.Variables.Variables.vx
  var y; // EjsS Model.Variables.Variables.y
  var vy; // EjsS Model.Variables.Variables.vy

  var rotation; // EjsS Model.Variables.Auxiliary.rotation
  var moonTrail; // EjsS Model.Variables.Auxiliary.moonTrail

  var _privateOdesList;
  var _ODEi_evolution1;

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      G : G,
      M : M,
      ext : ext,
      h : h,
      tol : tol,
      t : t,
      x : x,
      vx : vx,
      y : y,
      vy : vy,
      rotation : rotation,
      moonTrail : moonTrail
    };
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    if(typeof json.G != "undefined") G = json.G;
    if(typeof json.M != "undefined") M = json.M;
    if(typeof json.ext != "undefined") ext = json.ext;
    if(typeof json.h != "undefined") h = json.h;
    if(typeof json.tol != "undefined") tol = json.tol;
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.vx != "undefined") vx = json.vx;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.vy != "undefined") vy = json.vy;
    if(typeof json.rotation != "undefined") rotation = json.rotation;
    if(typeof json.moonTrail != "undefined") moonTrail = json.moonTrail;
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["ODEs"] = true;
    __pagesEnabled["Earth rotation"] = true;
  });

  _model.addToReset(function() {
    G = 1; // EjsS Model.Variables.Variables.G
    M = 1.0; // EjsS Model.Variables.Variables.M
    ext = 1; // EjsS Model.Variables.Variables.ext
    h = 0.01; // EjsS Model.Variables.Variables.h
    tol = 0.0001; // EjsS Model.Variables.Variables.tol
    t = 0.0; // EjsS Model.Variables.Variables.t
    x = 1.5; // EjsS Model.Variables.Variables.x
    vx = 0.0; // EjsS Model.Variables.Variables.vx
    y = 0.0; // EjsS Model.Variables.Variables.y
    vy = 0.7; // EjsS Model.Variables.Variables.vy
  });

  _model.addToReset(function() {
    rotation = 0; // EjsS Model.Variables.Auxiliary.rotation
    moonTrail = false; // EjsS Model.Variables.Auxiliary.moonTrail
  });

  _model.addToReset(function() {
    _privateOdesList=[];
    _ODEi_evolution1 = _ODE_evolution1();
    _privateOdesList.push(_ODEi_evolution1);
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setPauseOnPageExit(true);
    _model.setFPS(20);
    _model.setStepsPerDisplay(1);
  });

  _model.addToInitialization(function() {
    _initializeSolvers();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["ODEs"]) return;
    _ODEi_evolution1.step();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Earth rotation"]) return;
    rotation += 0.1;  // > Evolution.Earth rotation:1
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  function _initializeSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].initializeSolver();
  }

  function _automaticResetSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].automaticResetSolver();
  }

  _model.resetSolvers = function() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].resetSolver();
  };

  function _getODE(_odeName) {
    if (_odeName=="ODEs") return _ODEi_evolution1;
    return null;
  }

  function _getEventSolver(_odeName) {
    var ode = _getODE(_odeName);
    if (ode===null) return null;
    return ode.getEventSolver();
  }

  function _setSolverClass(_odeName, _engine) {
    var ode = _getODE(_odeName);
    if (ode===null) return;
    if (!_engine.setODE) {
      var classname = _engine.toLowerCase();
      if      (classname.indexOf("boga")>=0)   _engine = EJSS_ODE_SOLVERS.bogackiShampine23;
      else if (classname.indexOf("cash")>=0)   _engine = EJSS_ODE_SOLVERS.cashKarp45;
      else if (classname.indexOf("dopri5")>=0) _engine = EJSS_ODE_SOLVERS.dopri5;
      else if (classname.indexOf("dopri8")>=0) _engine = EJSS_ODE_SOLVERS.dopri853;
      else if (classname.indexOf("richa")>=0)  _engine = EJSS_ODE_SOLVERS.eulerRichardson;
      else if (classname.indexOf("euler")>=0)  _engine = EJSS_ODE_SOLVERS.euler;
      else if (classname.indexOf("fehlberg87")>=0) _engine = EJSS_ODE_SOLVERS.fehlberg87;
      else if (classname.indexOf("fehlberg8")>=0)  _engine = EJSS_ODE_SOLVERS.fehlberg8;
      else if (classname.indexOf("radau")>=0)   _engine = EJSS_ODE_SOLVERS.radau5;
      else if (classname.indexOf("runge")>=0)  _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("rk4")>=0)    _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("verlet")>=0) _engine = EJSS_ODE_SOLVERS.velocityVerlet;
    }
    if (_engine) ode.setSolverClass(_engine);
  }

  function _ODE_evolution1() {
    var __odeSelf = {};
    var __eventSolver;
    var __solverClass = EJSS_ODE_SOLVERS.cashKarp45;
    var __state=[];
    var __ignoreErrors=false;
    var __mustInitialize=true;
    var __isEnabled=true;
    var __mustUserReinitialize=false;
    var __mustReinitialize=true;


    __odeSelf.setSolverClass = function(__aSolverClass) {
      __solverClass = __aSolverClass;
      __instantiateSolver();
    };

    function __instantiateSolver() {
      __state=[];
      __pushState();
      __eventSolver = EJSS_ODE_SOLVERS.interpolatorEventSolver(__solverClass(),__odeSelf);
      __mustInitialize = true;
    }

    __odeSelf.setEnabled = function(_enabled) { __isEnabled = _enabled; };

    __odeSelf.getIndependentVariableValue = function() { return __eventSolver.getIndependentVariableValue(); };

    __odeSelf.getInternalStepSize = function() { return __eventSolver.getInternalStepSize(); };

    __odeSelf.isAccelerationIndependentOfVelocity = function() { return false; };

    __odeSelf.initializeSolver = function() {
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); return; }
      __pushState();
      __eventSolver.initialize(h);
      __eventSolver.setBestInterpolation(false);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.removeAllEvents();
      __eventSolver.setEstimateFirstStep(false);
      __eventSolver.setEnableExceptions(false);
      __eventSolver.setTolerances(tol,tol);
      __mustReinitialize = true;
      __mustInitialize = false;
    };

    function __pushState() {
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
        if (__state[__cIn]!=x) __mustReinitialize = true;
        __state[__cIn++] = x;
        if (__state[__cIn]!=vx) __mustReinitialize = true;
        __state[__cIn++] = vx;
        if (__state[__cIn]!=y) __mustReinitialize = true;
        __state[__cIn++] = y;
        if (__state[__cIn]!=vy) __mustReinitialize = true;
        __state[__cIn++] = vy;
        if (__state[__cIn]!=t) __mustReinitialize = true;
        __state[__cIn++] = t;
    }

    function __arraysChanged () {
      return false;
    }

    __odeSelf.getEventSolver = function() {
      return __eventSolver;
    };

    __odeSelf.resetSolver = function() {
      __mustUserReinitialize = true;
    };

    __odeSelf.automaticResetSolver = function() {
      __mustReinitialize = true;
    };

    function __errorAction () {
      if (__ignoreErrors) return;
      console.log (__eventSolver.getErrorMessage());
      _pause();
      // Make sure the solver is reinitialized;
      __mustReinitialize = true;
    }

    __odeSelf.step = function() { return __privateStep(false); };

    __odeSelf.solverStep = function() { return __privateStep(true); };

    function __privateStep(__takeMaximumStep) {
      if (!__isEnabled) return 0;
      if (h===0) return 0;
      if (__mustInitialize) __odeSelf.initializeSolver();
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); }
      __eventSolver.setStepSize(h);
      __eventSolver.setInternalStepSize(h);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.setTolerances(tol,tol);
      __pushState();
      if (__mustUserReinitialize) { 
        __eventSolver.userReinitialize();
        __mustUserReinitialize = false;
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      else if (__mustReinitialize) { 
        __eventSolver.reinitialize();
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      var __stepTaken = __takeMaximumStep ? __eventSolver.maxStep() : __eventSolver.step();
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        x = __state[__cOut++];
        vx = __state[__cOut++];
        y = __state[__cOut++];
        vy = __state[__cOut++];
        t = __state[__cOut++];
      // Check for error
      if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      return __stepTaken;
    }

    __odeSelf.getState = function() { return __state; };

    __odeSelf.getRate = function(_aState,_aRate) {
      _aRate[_aRate.length-1] = 0.0; // In case the prelim code returns
      var __index=-1; // so that it can be used in preliminary code
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var x = _aState[__cOut++];
        var vx = _aState[__cOut++];
        var y = _aState[__cOut++];
        var vy = _aState[__cOut++];
        var t = _aState[__cOut++];
      // Preliminary code: Code to be executed before rate equations are evaluated
        var den = Math.pow(x*x+y*y,1.5);  // > Preliminary code for ODE.ODEs:1
        var aux = - G * M  / den;  // > Preliminary code for ODE.ODEs:2
        var ax = x * aux;  // > Preliminary code for ODE.ODEs:3
        var ay = y * aux;  // > Preliminary code for ODE.ODEs:4
      // Compute the rate
        var __cRate=0;
        _aRate[__cRate++] = vx; // Rate for ODE: ODEs:x
        _aRate[__cRate++] = ax; // Rate for ODE: ODEs:vx
        _aRate[__cRate++] = vy; // Rate for ODE: ODEs:y
        _aRate[__cRate++] = ay; // Rate for ODE: ODEs:vy
        _aRate[__cRate++] = 1; // independent variable
        return _aRate;
    }; //end of getRate

    __instantiateSolver();

    return __odeSelf;
  }

  function _historic_x(__time) {
    var __index = 0;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

  function _historic_vx(__time) {
    var __index = 0 + 1;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

  function _historic_y(__time) {
    var __index = 0 + 1 + 1;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

  function _historic_vy(__time) {
    var __index = 0 + 1 + 1 + 1;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,__index);
  }

    _model._resized = function(_width,_height) {
      _view._resized(_width,_height);
  }; // end of _resized
    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 800, height : 600 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new EarthAndMoon3D_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view._setRootProperty(_model,"RunAlways",true) // HtmlView Page setting property 'RunAlways' for root element
          _view.drawingPanel3D.linkProperty("MaximumZ",  function() { return ext; }, function(_v) { ext = _v; } ); // HtmlView Page linking property 'MaximumZ' for element 'drawingPanel3D'
          _view.drawingPanel3D.linkProperty("MaximumY",  function() { return ext; }, function(_v) { ext = _v; } ); // HtmlView Page linking property 'MaximumY' for element 'drawingPanel3D'
          _view.drawingPanel3D.linkProperty("MaximumX",  function() { return ext; }, function(_v) { ext = _v; } ); // HtmlView Page linking property 'MaximumX' for element 'drawingPanel3D'
          _view.drawingPanel3D.linkProperty("MinimumX",  function() { return -ext; } ); // HtmlView Page linking property 'MinimumX' for element 'drawingPanel3D'
          _view.drawingPanel3D.linkProperty("MinimumY",  function() { return -ext; } ); // HtmlView Page linking property 'MinimumY' for element 'drawingPanel3D'
          _view.drawingPanel3D.linkProperty("MinimumZ",  function() { return -ext; } ); // HtmlView Page linking property 'MinimumZ' for element 'drawingPanel3D'
          _view.rotationZ3D.linkProperty("Angle",  function() { return rotation; }, function(_v) { rotation = _v; } ); // HtmlView Page linking property 'Angle' for element 'rotationZ3D'
          _view.moonSphere3D.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'X' for element 'moonSphere3D'
          _view.moonSphere3D.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'Y' for element 'moonSphere3D'
          _view.moonTrail3D.linkProperty("InputX",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'InputX' for element 'moonTrail3D'
          _view.moonTrail3D.linkProperty("Visibility",  function() { return moonTrail; }, function(_v) { moonTrail = _v; } ); // HtmlView Page linking property 'Visibility' for element 'moonTrail3D'
          _view.moonTrail3D.linkProperty("InputY",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'InputY' for element 'moonTrail3D'
          _view.playPauseButton.setAction("OffClick", _pause); // HtmlView Page setting action 'OffClick' for element 'playPauseButton'
          _view.playPauseButton.linkProperty("State",  function() { return _isPaused; } ); // HtmlView Page linking property 'State' for element 'playPauseButton'
          _view.playPauseButton.setAction("OnClick", _play); // HtmlView Page setting action 'OnClick' for element 'playPauseButton'
          _view.stepButton.setAction("OnClick", function() {
  _step();

}); // HtmlView Page setting action 'OnClick' for element 'stepButton'
          _view.initButton.setAction("OnClick", function() {
  _initialize();

}); // HtmlView Page setting action 'OnClick' for element 'initButton'
          _view.resetButton.setAction("OnClick", function() {
  _reset();

}); // HtmlView Page setting action 'OnClick' for element 'resetButton'
          _view.trailCheckBox.linkProperty("Checked",  function() { return moonTrail; }, function(_v) { moonTrail = _v; } ); // HtmlView Page linking property 'Checked' for element 'trailCheckBox'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(20);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function EarthAndMoon3D_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = EarthAndMoon3D_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);

  _view._addDescriptionPage('Earth and Moon in 3D','./EarthAndMoon3D_Intro_1.html');

  return _view;
} // end of main function

function EarthAndMoon3D_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_DRAWING3D.drawingPanel,"drawingPanel3D", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'drawingPanel3D'
      .setProperty("Height",400) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'drawingPanel3D'
      .setProperty("Width",640) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'drawingPanel3D'
      .setProperty("CameraZ",0) // EJsS HtmlView.HtmlView Page: setting property 'CameraZ' for element 'drawingPanel3D'
      .setProperty("CameraY",0) // EJsS HtmlView.HtmlView Page: setting property 'CameraY' for element 'drawingPanel3D'
      .setProperty("CameraX",3) // EJsS HtmlView.HtmlView Page: setting property 'CameraX' for element 'drawingPanel3D'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'drawingPanel3D'
      .setProperty("DecorationType","NONE") // EJsS HtmlView.HtmlView Page: setting property 'DecorationType' for element 'drawingPanel3D'
      ;

    _view._addElement(EJSS_DRAWING3D.sphere,"spaceSphere", _view.drawingPanel3D) // EJsS HtmlView.HtmlView Page: declaration of element 'spaceSphere'
      .setProperty("TextureUrl","./EarthAndMoon3D/night_sky.png") // EJsS HtmlView.HtmlView Page: setting property 'TextureUrl' for element 'spaceSphere'
      .setProperty("SizeX",5) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'spaceSphere'
      .setProperty("SizeZ",5) // EJsS HtmlView.HtmlView Page: setting property 'SizeZ' for element 'spaceSphere'
      .setProperty("SizeY",5) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'spaceSphere'
      ;

    _view._addElement(EJSS_DRAWING3D.sphere,"earthSphere3D", _view.drawingPanel3D) // EJsS HtmlView.HtmlView Page: declaration of element 'earthSphere3D'
      .setProperty("TextureUrl","./EarthAndMoon3D/earth.jpg") // EJsS HtmlView.HtmlView Page: setting property 'TextureUrl' for element 'earthSphere3D'
      .setProperty("SizeX",0.3) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'earthSphere3D'
      .setProperty("SizeZ",0.3) // EJsS HtmlView.HtmlView Page: setting property 'SizeZ' for element 'earthSphere3D'
      .setProperty("SizeY",0.3) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'earthSphere3D'
      ;

    _view._addElement(EJSS_DRAWING3D.rotationZ,"rotationZ3D", _view.earthSphere3D) // EJsS HtmlView.HtmlView Page: declaration of element 'rotationZ3D'
      ;

    _view._addElement(EJSS_DRAWING3D.sphere,"moonSphere3D", _view.drawingPanel3D) // EJsS HtmlView.HtmlView Page: declaration of element 'moonSphere3D'
      .setProperty("TextureUrl","./EarthAndMoon3D/moon.jpg") // EJsS HtmlView.HtmlView Page: setting property 'TextureUrl' for element 'moonSphere3D'
      .setProperty("SizeX",0.1) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'moonSphere3D'
      .setProperty("SizeZ",0.1) // EJsS HtmlView.HtmlView Page: setting property 'SizeZ' for element 'moonSphere3D'
      .setProperty("SizeY",0.1) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'moonSphere3D'
      ;

    _view._addElement(EJSS_DRAWING3D.trail,"moonTrail3D", _view.drawingPanel3D) // EJsS HtmlView.HtmlView Page: declaration of element 'moonTrail3D'
      .setProperty("InputZ",0) // EJsS HtmlView.HtmlView Page: setting property 'InputZ' for element 'moonTrail3D'
      .setProperty("LineColor","white") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'moonTrail3D'
      .setProperty("DrawLines",true) // EJsS HtmlView.HtmlView Page: setting property 'DrawLines' for element 'moonTrail3D'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"bottomPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'bottomPanel'
      .setProperty("BorderStyle","double") // EJsS HtmlView.HtmlView Page: setting property 'BorderStyle' for element 'bottomPanel'
      .setProperty("BorderColor","Black") // EJsS HtmlView.HtmlView Page: setting property 'BorderColor' for element 'bottomPanel'
      .setProperty("BorderWidth",3) // EJsS HtmlView.HtmlView Page: setting property 'BorderWidth' for element 'bottomPanel'
      ;

    _view._addElement(EJSS_INTERFACE.twoStateButton,"playPauseButton", _view.bottomPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'playPauseButton'
      .setProperty("Tooltip","Play/Pause") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'playPauseButton'
      .setProperty("ImageOnUrl","/org/opensourcephysics/resources/controls/images/play.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOnUrl' for element 'playPauseButton'
      .setProperty("ImageOffUrl","/org/opensourcephysics/resources/controls/images/pause.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOffUrl' for element 'playPauseButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"stepButton", _view.bottomPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'stepButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/stepforward.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'stepButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"initButton", _view.bottomPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'initButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/stepback.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'initButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton", _view.bottomPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'resetButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/reset.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'resetButton'
      ;

    _view._addElement(EJSS_INTERFACE.checkBox,"trailCheckBox", _view.bottomPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'trailCheckBox'
      .setProperty("Text","Show Moon trail") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'trailCheckBox'
      ;

  };

  return _view;
}



      var _model;
      window.addEventListener('load',
        function () { 
          _model =  new EarthAndMoon3D("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
      var interval = setInterval(function() {
         if(document.readyState === 'complete') {
           window.addEventListener('resize', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           window.addEventListener('scroll', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           var startCaptureBut = document.getElementById('startCaptureBut'); 
           var stopCaptureBut = document.getElementById('stopCaptureBut'); 
           var resetCaptureBut = document.getElementById('resetCaptureBut'); 
           var playCaptureBut = document.getElementById('playCaptureBut'); 
           var stepCaptureBut = document.getElementById('stepCaptureBut'); 
           if (startCaptureBut) {
             startCaptureBut.onclick = function() {
               _model.startCapture();
             };
             stopCaptureBut.onclick = function() {
               _model.saveText('recording','rec',JSON.stringify(_model.stopCapture()));
             };
             resetCaptureBut.onclick = function() {
               _model.resetCapture();
             };
             playCaptureBut.onclick = function() {
               _model.readText(null,'.rec',function(content){
               _model.playCapture(JSON.parse(content),function(){startCaptureBut.disabled=false; playCaptureBut.disabled=false; stepCaptureBut.disabled=false; window.alert(end_reproduction_message);});               });
             };
             stepCaptureBut.onchange= function() {
               var stepCapt;
               if (stepCaptureBut.value >= 0) stepCapt =  stepCaptureBut.value + 1;
               else stepCapt = 1 + 1.8*stepCaptureBut.value/8;
               _model.changeCaptureStep(stepCapt);
             };
           }
           clearInterval(interval);
         };
      }, 200)
