function DataFitting_Solution(_topFrame,_libraryPath,_codebasePath) {
  var _model = EJSS_CORE.createAnimation();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog
  };

var numericJS = numeric;
  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var xmin; // EjsS Model.Variables.Global.xmin
  var xmax; // EjsS Model.Variables.Global.xmax
  var ymin; // EjsS Model.Variables.Global.ymin
  var ymax; // EjsS Model.Variables.Global.ymax
  var fitOrder; // EjsS Model.Variables.Global.fitOrder

  var a; // EjsS Model.Variables.Fit.a
  var b; // EjsS Model.Variables.Fit.b
  var c; // EjsS Model.Variables.Fit.c
  var d; // EjsS Model.Variables.Fit.d
  var e; // EjsS Model.Variables.Fit.e
  var functionString; // EjsS Model.Variables.Fit.functionString
  var fitColor; // EjsS Model.Variables.Fit.fitColor
  var fitPoints; // EjsS Model.Variables.Fit.fitPoints

  var maxPoints; // EjsS Model.Variables.Data.maxPoints
  var nPoints; // EjsS Model.Variables.Data.nPoints
  var x; // EjsS Model.Variables.Data.x
  var y; // EjsS Model.Variables.Data.y
  var visible; // EjsS Model.Variables.Data.visible

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      xmin : xmin,
      xmax : xmax,
      ymin : ymin,
      ymax : ymax,
      fitOrder : fitOrder,
      a : a,
      b : b,
      c : c,
      d : d,
      e : e,
      functionString : functionString,
      fitColor : fitColor,
      fitPoints : fitPoints,
      maxPoints : maxPoints,
      nPoints : nPoints,
      x : x,
      y : y,
      visible : visible
    };
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    if(typeof json.xmin != "undefined") xmin = json.xmin;
    if(typeof json.xmax != "undefined") xmax = json.xmax;
    if(typeof json.ymin != "undefined") ymin = json.ymin;
    if(typeof json.ymax != "undefined") ymax = json.ymax;
    if(typeof json.fitOrder != "undefined") fitOrder = json.fitOrder;
    if(typeof json.a != "undefined") a = json.a;
    if(typeof json.b != "undefined") b = json.b;
    if(typeof json.c != "undefined") c = json.c;
    if(typeof json.d != "undefined") d = json.d;
    if(typeof json.e != "undefined") e = json.e;
    if(typeof json.functionString != "undefined") functionString = json.functionString;
    if(typeof json.fitColor != "undefined") fitColor = json.fitColor;
    if(typeof json.fitPoints != "undefined") fitPoints = json.fitPoints;
    if(typeof json.maxPoints != "undefined") maxPoints = json.maxPoints;
    if(typeof json.nPoints != "undefined") nPoints = json.nPoints;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.visible != "undefined") visible = json.visible;
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Plot function"] = true;
  });

  _model.addToReset(function() {
    xmin = -10.0; // EjsS Model.Variables.Global.xmin
    xmax = 10.0; // EjsS Model.Variables.Global.xmax
    ymin = -3; // EjsS Model.Variables.Global.ymin
    ymax = 3; // EjsS Model.Variables.Global.ymax
    fitOrder = ["Order 1"]; // EjsS Model.Variables.Global.fitOrder
  });

  _model.addToReset(function() {
    a = 0.0; // EjsS Model.Variables.Fit.a
    b = 0; // EjsS Model.Variables.Fit.b
    c = 0; // EjsS Model.Variables.Fit.c
    d = 0; // EjsS Model.Variables.Fit.d
    e = 0; // EjsS Model.Variables.Fit.e
    functionString = "a*x^4 + b*x^3 + c*x^2 + d*x + e"; // EjsS Model.Variables.Fit.functionString
    fitColor = "Black"; // EjsS Model.Variables.Fit.fitColor
    fitPoints = 500; // EjsS Model.Variables.Fit.fitPoints
  });

  _model.addToReset(function() {
    maxPoints = 100; // EjsS Model.Variables.Data.maxPoints
    nPoints = 0; // EjsS Model.Variables.Data.nPoints
    x = new Array(maxPoints); // EjsS Model.Variables.Data.x
    (function () {
      var _i0;
      for (_i0=0; _i0<maxPoints; _i0+=1) {  // EjsS Model.Variables.Data.x
        x[_i0] = 0;  // EjsS Model.Variables.Data.x
      }
    }());
    y = new Array(maxPoints); // EjsS Model.Variables.Data.y
    (function () {
      var _i0;
      for (_i0=0; _i0<maxPoints; _i0+=1) {  // EjsS Model.Variables.Data.y
        y[_i0] = 0;  // EjsS Model.Variables.Data.y
      }
    }());
    visible = new Array(maxPoints); // EjsS Model.Variables.Data.visible
    (function () {
      var _i0;
      for (_i0=0; _i0<maxPoints; _i0+=1) {  // EjsS Model.Variables.Data.visible
        visible[_i0] = false;  // EjsS Model.Variables.Data.visible
      }
    }());
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setFPS(100);
    _model.setStepsPerDisplay(1);
  });

  function computeBestFit() {  // > CustomCode.Fit:1
    var i,j,k;  // > CustomCode.Fit:2
    if (nPoints<2) {  // > CustomCode.Fit:3
      alert("Error: too few points.\nOur fit requires at least two points!");  // > CustomCode.Fit:4
      return;  // > CustomCode.Fit:5
    }  // > CustomCode.Fit:6
    var m = 1;  // > CustomCode.Fit:7
    var order = fitOrder[0];  // > CustomCode.Fit:8
    if        (order.indexOf("1")>=0) m = 1;  // > CustomCode.Fit:9
    else if (order.indexOf("2")>=0) m = 2;  // > CustomCode.Fit:10
    else if (order.indexOf("3")>=0) m = 3;  // > CustomCode.Fit:11
    else if (order.indexOf("4")>=0) m = 4;  // > CustomCode.Fit:12
    if(m<1 || m>4) {  // > CustomCode.Fit:13
      alert("Error: The degree of the polynomial must be between 1 and 4");  // > CustomCode.Fit:14
      return;  // > CustomCode.Fit:15
    }  // > CustomCode.Fit:16
      // > CustomCode.Fit:17
    /*  // > CustomCode.Fit:18
    We define the (fi,fj)_d with {f1, ... , f(m+1)} = {1, ... , x^(m)}, to save space,   // > CustomCode.Fit:19
    we define the relevant products sx, sx^2... sx^(2*m),sy, syx, syx^2...  // > CustomCode.Fit:20
        in the sx[] and syx[] arrays, where the index is the power.  // > CustomCode.Fit:21
    */  // > CustomCode.Fit:22
    var sx = new Array(2*m+1);  // > CustomCode.Fit:23
    var syx = new Array(m+1);  // > CustomCode.Fit:24
    for(j=0;j<2*m+1;j++) sx[j] = 0;  // > CustomCode.Fit:25
    for(j=0;j<m+1;j++) syx[j] = 0;  // > CustomCode.Fit:26
    var aux = 1; //Auxiliary to the sums  // > CustomCode.Fit:27
    for (i=0; i<nPoints; i++) { // compute sums  // > CustomCode.Fit:28
      for(j=0; j<2*m+1; j++)  {  // > CustomCode.Fit:29
        sx[j] += aux;  // > CustomCode.Fit:30
        if (j<m+1){  // > CustomCode.Fit:31
          syx[j] += y[i]*aux;  // > CustomCode.Fit:32
        }  // > CustomCode.Fit:33
        aux *= x[i];  // > CustomCode.Fit:34
      }  // > CustomCode.Fit:35
      aux = 1;  // > CustomCode.Fit:36
    }  // > CustomCode.Fit:37
    var A=new Array(m+1);  // > CustomCode.Fit:38
    for(i=0;i<m+1;i++) {  // > CustomCode.Fit:39
      A[i] = new Array(m+1);  // > CustomCode.Fit:40
      for(j=0;j<m+1;j++) A[i][j] = sx[i+j];  // > CustomCode.Fit:41
    }  // > CustomCode.Fit:42
    var B=new Array(m+1);  // > CustomCode.Fit:43
    for(i=0;i<m+1;i++) B[i] = syx[i];  // > CustomCode.Fit:44
    // Solve system  // > CustomCode.Fit:45
    var X = numeric.solve(A,B); // solves A*X = B.  // > CustomCode.Fit:46
    a=0; b=0; c=0; d=0; e=0;  // > CustomCode.Fit:47
    switch (m) {  // > CustomCode.Fit:48
      case 1 : e = X[0]; d = X[1]; break;  // > CustomCode.Fit:49
      case 2 : e = X[0]; d = X[1]; c = X[2]; break;  // > CustomCode.Fit:50
      case 3 : e = X[0]; d = X[1]; c = X[2]; b = X[3]; break;  // > CustomCode.Fit:51
      case 4 : e = X[0]; d = X[1]; c = X[2]; b = X[3]; a = X[4]; break;  // > CustomCode.Fit:52
    }    // > CustomCode.Fit:53
    fitColor = "Black"; // done!  // > CustomCode.Fit:54
  }  // > CustomCode.Fit:55

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["Plot function"]) return;
    _view._update(); // make sure the view has the new values of a,b,c,d,e and f(x)  // > FixedRelations.Plot function:1
    _view.fitTrail.clear(); // clear the trail  // > FixedRelations.Plot function:2
    _view.fitFunction.setParameters({ "a":a, "b":b, "c":c,"d":d,"e":e}); // Prepare the function  // > FixedRelations.Plot function:3
    var x = xmin;  // > FixedRelations.Plot function:4
    var dx = (xmax-xmin)/(fitPoints-1);  // > FixedRelations.Plot function:5
    for (var i=0; i<fitPoints; i++) {  // > FixedRelations.Plot function:6
      x += dx;  // > FixedRelations.Plot function:7
      var y = _view.fitFunction.evaluate({"x":x }); // evaluate the function  // > FixedRelations.Plot function:8
      _view.fitTrail.addPoint(x,y); // add the curve points  // > FixedRelations.Plot function:9
    }  // > FixedRelations.Plot function:10
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

    _model._resized = function(_width,_height) {
      _view._resized(_width,_height);
  }; // end of _resized
    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 800, height : 560 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new DataFitting_Solution_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.plottingPanel.linkProperty("MaximumY",  function() { return ymax; }, function(_v) { ymax = _v; } ); // HtmlView Page linking property 'MaximumY' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MaximumX",  function() { return xmax; }, function(_v) { xmax = _v; } ); // HtmlView Page linking property 'MaximumX' for element 'plottingPanel'
          _view.plottingPanel.setAction("OnRelease", function() {
  if (nPoints>=maxPoints) {
    alert("Error : Too many data points!\nClick 'Clear'");
    return;
  }
  var position = _view.plottingPanel.getInteraction().getInteractionPoint();
  x[nPoints] = position[0];
  y[nPoints] = position[1];
  visible[nPoints] = true;
  nPoints++;
  fitColor = "Red";

}); // HtmlView Page setting action 'OnRelease' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MinimumX",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'MinimumX' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("MinimumY",  function() { return ymin; }, function(_v) { ymin = _v; } ); // HtmlView Page linking property 'MinimumY' for element 'plottingPanel'
          _view.plottingPanel.linkProperty("TLMessage",  function() { return nPoints>0 ? "" : "Click to add points and try to fit using f(x)"; } ); // HtmlView Page linking property 'TLMessage' for element 'plottingPanel'
          _view.pointsShapeSet.linkProperty("NumberOfElements",  function() { return maxPoints; }, function(_v) { maxPoints = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'pointsShapeSet'
          _view.pointsShapeSet.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'X' for element 'pointsShapeSet'
          _view.pointsShapeSet.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'Y' for element 'pointsShapeSet'
          _view.pointsShapeSet.linkProperty("Visibility",  function() { return visible; }, function(_v) { visible = _v; } ); // HtmlView Page linking property 'Visibility' for element 'pointsShapeSet'
          _view.fitTrail.linkProperty("LineColor",  function() { return fitColor; }, function(_v) { fitColor = _v; } ); // HtmlView Page linking property 'LineColor' for element 'fitTrail'
          _view.fieldXmin.linkProperty("Value",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'Value' for element 'fieldXmin'
          _view.fieldXmax.linkProperty("Value",  function() { return xmax; }, function(_v) { xmax = _v; } ); // HtmlView Page linking property 'Value' for element 'fieldXmax'
          _view.fieldYmin.linkProperty("Value",  function() { return ymin; }, function(_v) { ymin = _v; } ); // HtmlView Page linking property 'Value' for element 'fieldYmin'
          _view.fieldYmax.linkProperty("Value",  function() { return ymax; }, function(_v) { ymax = _v; } ); // HtmlView Page linking property 'Value' for element 'fieldYmax'
          _view.fieldPoints.linkProperty("Value",  function() { return nPoints; }, function(_v) { nPoints = _v; } ); // HtmlView Page linking property 'Value' for element 'fieldPoints'
          _view.buttonClear.setAction("OnClick", function() {
  nPoints = 0;
  for (var i=0; i<maxPoints; i++) 
    visible[i] = i<nPoints;
  a=0; b=0; c=0; d=0; e=0;
  fitColor = "red";

}); // HtmlView Page setting action 'OnClick' for element 'buttonClear'
          _view.buttonReset.setAction("OnClick", _reset); // HtmlView Page setting action 'OnClick' for element 'buttonReset'
          _view.fitFunction.linkProperty("Value",  function() { return functionString; }, function(_v) { functionString = _v; } ); // HtmlView Page linking property 'Value' for element 'fitFunction'
          _view.fieldA.linkProperty("Value",  function() { return a; }, function(_v) { a = _v; } ); // HtmlView Page linking property 'Value' for element 'fieldA'
          _view.fieldB.linkProperty("Value",  function() { return b; }, function(_v) { b = _v; } ); // HtmlView Page linking property 'Value' for element 'fieldB'
          _view.fieldC.linkProperty("Value",  function() { return c; }, function(_v) { c = _v; } ); // HtmlView Page linking property 'Value' for element 'fieldC'
          _view.fieldD.linkProperty("Value",  function() { return d; }, function(_v) { d = _v; } ); // HtmlView Page linking property 'Value' for element 'fieldD'
          _view.fieldE.linkProperty("Value",  function() { return e; }, function(_v) { e = _v; } ); // HtmlView Page linking property 'Value' for element 'fieldE'
          _view.buttonFit.setAction("OnClick", computeBestFit); // HtmlView Page setting action 'OnClick' for element 'buttonFit'
          _view.comboBoxM.linkProperty("Options",  function() { return ["Order 1", "Order 2", "Order 3", "Order 4"]; } ); // HtmlView Page linking property 'Options' for element 'comboBoxM'
          _view.comboBoxM.setAction("OnChange", function() {
  fitColor = "Red";

}); // HtmlView Page setting action 'OnChange' for element 'comboBoxM'
          _view.comboBoxM.linkProperty("SelectedOptions",  function() { return fitOrder; }, function(_v) { fitOrder = _v; } ); // HtmlView Page linking property 'SelectedOptions' for element 'comboBoxM'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(100);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function DataFitting_Solution_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = DataFitting_Solution_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);

  _view._addDescriptionPage('Data fitting','./DataFitting_Solution_Intro_1.html');
  _view._addDescriptionPage('Solution','./DataFitting_Solution_Intro_2.html');

  return _view;
} // end of main function

function DataFitting_Solution_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"plotPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'plotPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"plottingPanel", _view.plotPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'plottingPanel'
      .setProperty("Height",400) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'plottingPanel'
      .setProperty("Width",600) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'plottingPanel'
      .setProperty("Enabled",true) // EJsS HtmlView.HtmlView Page: setting property 'Enabled' for element 'plottingPanel'
      .setProperty("Title","Fit the data points") // EJsS HtmlView.HtmlView Page: setting property 'Title' for element 'plottingPanel'
      .setProperty("TitleY","f(x)") // EJsS HtmlView.HtmlView Page: setting property 'TitleY' for element 'plottingPanel'
      .setProperty("AutoScaleY",true) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'plottingPanel'
      .setProperty("TitleX","x") // EJsS HtmlView.HtmlView Page: setting property 'TitleX' for element 'plottingPanel'
      .setProperty("AutoScaleX",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'plottingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"pointsShapeSet", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'pointsShapeSet'
      .setProperty("SizeX",6) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'pointsShapeSet'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'pointsShapeSet'
      .setProperty("LineColor","Black") // EJsS HtmlView.HtmlView Page: setting property 'LineColor' for element 'pointsShapeSet'
      .setProperty("SizeY",6) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'pointsShapeSet'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'pointsShapeSet'
      ;

    _view._addElement(EJSS_DRAWING2D.trail,"fitTrail", _view.plottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fitTrail'
      .setProperty("LineWidth",2) // EJsS HtmlView.HtmlView Page: setting property 'LineWidth' for element 'fitTrail'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"worldPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'worldPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"labelXmin", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'labelXmin'
      .setProperty("Text","x min=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'labelXmin'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"fieldXmin", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fieldXmin'
      .setProperty("Width",50) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fieldXmin'
      .setProperty("Format","0.00") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'fieldXmin'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"labelXmax", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'labelXmax'
      .setProperty("Text","x max=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'labelXmax'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"fieldXmax", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fieldXmax'
      .setProperty("Width",50) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fieldXmax'
      .setProperty("Format","0.00") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'fieldXmax'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"labelYmin", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'labelYmin'
      .setProperty("Text","y min=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'labelYmin'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"fieldYmin", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fieldYmin'
      .setProperty("Width",50) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fieldYmin'
      .setProperty("Format","0.00") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'fieldYmin'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"labelYmax", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'labelYmax'
      .setProperty("Text","y max=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'labelYmax'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"fieldYmax", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fieldYmax'
      .setProperty("Width",50) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fieldYmax'
      .setProperty("Format","0.00") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'fieldYmax'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"points", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'points'
      .setProperty("Text","points:") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'points'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"fieldPoints", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fieldPoints'
      .setProperty("Width",30) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fieldPoints'
      .setProperty("Format","0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'fieldPoints'
      .setProperty("Editable",false) // EJsS HtmlView.HtmlView Page: setting property 'Editable' for element 'fieldPoints'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label3", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'label3'
      .setProperty("Width",10) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'label3'
      .setProperty("Text","") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'label3'
      ;

    _view._addElement(EJSS_INTERFACE.button,"buttonClear", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'buttonClear'
      .setProperty("Tooltip","Clear all points") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'buttonClear'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/erase.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'buttonClear'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label2", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'label2'
      .setProperty("Width",10) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'label2'
      ;

    _view._addElement(EJSS_INTERFACE.button,"buttonReset", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'buttonReset'
      .setProperty("Tooltip","Reset") // EJsS HtmlView.HtmlView Page: setting property 'Tooltip' for element 'buttonReset'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/reset.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'buttonReset'
      ;

    _view._addElement(EJSS_INTERFACE.separator,"separator", _view.worldPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'separator'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"functionPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'functionPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"functionLabel", _view.functionPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'functionLabel'
      .setProperty("Text","f(x)=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'functionLabel'
      ;

    _view._addElement(EJSS_INTERFACE.functionField,"fitFunction", _view.functionPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fitFunction'
      .setProperty("Width",400) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fitFunction'
      ;

    _view._addElement(EJSS_INTERFACE.separator,"separator2", _view.functionPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'separator2'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"fitPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'fitPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"labelA", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'labelA'
      .setProperty("Text","a=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'labelA'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"fieldA", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fieldA'
      .setProperty("Width",50) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fieldA'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"labelB", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'labelB'
      .setProperty("Text","b=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'labelB'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"fieldB", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fieldB'
      .setProperty("Width",50) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fieldB'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"labelC", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'labelC'
      .setProperty("Text","c=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'labelC'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"fieldC", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fieldC'
      .setProperty("Width",50) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fieldC'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"labelD", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'labelD'
      .setProperty("Text","d=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'labelD'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"fieldD", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fieldD'
      .setProperty("Width",50) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fieldD'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"labelE", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'labelE'
      .setProperty("Text","e=") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'labelE'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"fieldE", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'fieldE'
      .setProperty("Width",50) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'fieldE'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"label", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'label'
      .setProperty("Width",20) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'label'
      ;

    _view._addElement(EJSS_INTERFACE.button,"buttonFit", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'buttonFit'
      .setProperty("Text","Best fit") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'buttonFit'
      ;

    _view._addElement(EJSS_INTERFACE.comboBox,"comboBoxM", _view.fitPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'comboBoxM'
      .setProperty("Height",25) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'comboBoxM'
      .setProperty("Multiple",false) // EJsS HtmlView.HtmlView Page: setting property 'Multiple' for element 'comboBoxM'
      ;

  };

  return _view;
}



      var _model;
      window.addEventListener('load',
        function () { 
          _model =  new DataFitting_Solution("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
      var interval = setInterval(function() {
         if(document.readyState === 'complete') {
           window.addEventListener('resize', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           window.addEventListener('scroll', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           var startCaptureBut = document.getElementById('startCaptureBut'); 
           var stopCaptureBut = document.getElementById('stopCaptureBut'); 
           var resetCaptureBut = document.getElementById('resetCaptureBut'); 
           var playCaptureBut = document.getElementById('playCaptureBut'); 
           var stepCaptureBut = document.getElementById('stepCaptureBut'); 
           if (startCaptureBut) {
             startCaptureBut.onclick = function() {
               _model.startCapture();
             };
             stopCaptureBut.onclick = function() {
               _model.saveText('recording','rec',JSON.stringify(_model.stopCapture()));
             };
             resetCaptureBut.onclick = function() {
               _model.resetCapture();
             };
             playCaptureBut.onclick = function() {
               _model.readText(null,'.rec',function(content){
               _model.playCapture(JSON.parse(content),function(){startCaptureBut.disabled=false; playCaptureBut.disabled=false; stepCaptureBut.disabled=false; window.alert(end_reproduction_message);});               });
             };
             stepCaptureBut.onchange= function() {
               var stepCapt;
               if (stepCaptureBut.value >= 0) stepCapt =  stepCaptureBut.value + 1;
               else stepCapt = 1 + 1.8*stepCaptureBut.value/8;
               _model.changeCaptureStep(stepCapt);
             };
           }
           clearInterval(interval);
         };
      }, 200)
