function CoupledOscillatorChain(_topFrame,_libraryPath,_codebasePath) {
  var _model = EJSS_CORE.createAnimation();
  var _view;
  var _isPlaying = false;
  var _isPaused = true;
  var _isMobile = (navigator===undefined) ? false : navigator.userAgent.match(/iPhone|iPad|iPod|Android|BlackBerry|Opera Mini|IEMobile/i);

var _stringProperties = {};
  var _tools = {
    showInputDialog : EJSS_INTERFACE.BoxPanel.showInputDialog,
    showOkDialog : EJSS_INTERFACE.BoxPanel.showOkDialog,
    showOkCancelDialog : EJSS_INTERFACE.BoxPanel.showOkCancelDialog
  };

  function _play()  { _isPaused = false; _isPlaying = true;  _model.play();  }
  function _pause() { _isPaused = true;  _isPlaying = false; _model.pause(); }
  function _step()  { _pause();  _model.step(); }
  function _reset() { _model.reset();  _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); }
  _model._play  = _play;
  _model._pause = _pause;
  _model._step  = _step;
  _model._reset = _reset;
  function _update() { _model.update(); }
  function _initialize() { _model.initialize(); }
  function _setFPS(_fps) { _model.setFPS(_fps); }
  function _setDelay(_delay) { _model.setDelay(_delay); }
  function _setStepsPerDisplay(_spd) { _model.setStepsPerDisplay(_spd); }
  function _setUpdateView(_updateView) { _model.setUpdateView(_updateView); }
  function _setAutoplay(_auto) { _model.setAutoplay(_auto); }
  function _println(_message) { console.log(_message); }

  function _breakAfterThisPage() { _model.setShouldBreak(true); }

  function _resetSolvers() { if (_model.resetSolvers) _model.resetSolvers(); }

  function _saveText(name,type,content) { if (_model.saveText) _model.saveText(name,type,content); }

  function _saveState(name) { if (_model.saveState) _model.saveState(name); }

  function _saveImage(name,panelname) { if (_model.saveImage) _model.saveImage(name,panelname); }

  function _readState(url,type) { if (_model.readState) _model.readState(url,type); }

  function _readText(url,type,varname) { if (_model.readText) _model.readText(url,type,varname); }

  function _getStringProperty(propertyName) {
    var _value = _stringProperties[propertyName];
    if (_value===undefined) return propertyName;
    else return _value;
  }
  var __pagesEnabled = [];
  function _setPageEnabled(pageName,enabled) { __pagesEnabled[pageName] = enabled; }

  var n; // EjsS Model.Variables.Auxiliary Vars.n
  var xmin; // EjsS Model.Variables.Auxiliary Vars.xmin
  var xmax; // EjsS Model.Variables.Auxiliary Vars.xmax
  var dx; // EjsS Model.Variables.Auxiliary Vars.dx
  var x; // EjsS Model.Variables.Auxiliary Vars.x
  var fStr; // EjsS Model.Variables.Auxiliary Vars.fStr
  var k; // EjsS Model.Variables.Auxiliary Vars.k
  var dy; // EjsS Model.Variables.Auxiliary Vars.dy
  var index; // EjsS Model.Variables.Auxiliary Vars.index
  var released; // EjsS Model.Variables.Auxiliary Vars.released

  var y; // EjsS Model.Variables.Dynamical Vars.y
  var v; // EjsS Model.Variables.Dynamical Vars.v
  var t; // EjsS Model.Variables.Dynamical Vars.t
  var dt; // EjsS Model.Variables.Dynamical Vars.dt
  var tol; // EjsS Model.Variables.Dynamical Vars.tol

  var _privateOdesList;
  var _ODEi_evolution1;

  function _serialize() { return _model.serialize(); }

  _model._userSerialize = function() {
    return {
      n : n,
      xmin : xmin,
      xmax : xmax,
      dx : dx,
      x : x,
      fStr : fStr,
      k : k,
      dy : dy,
      index : index,
      released : released,
      y : y,
      v : v,
      t : t,
      dt : dt,
      tol : tol
    };
  };

  function _unserialize(json) { return _model.unserialize(json); }

  _model._userUnserialize = function(json) {
    if(typeof json.n != "undefined") n = json.n;
    if(typeof json.xmin != "undefined") xmin = json.xmin;
    if(typeof json.xmax != "undefined") xmax = json.xmax;
    if(typeof json.dx != "undefined") dx = json.dx;
    if(typeof json.x != "undefined") x = json.x;
    if(typeof json.fStr != "undefined") fStr = json.fStr;
    if(typeof json.k != "undefined") k = json.k;
    if(typeof json.dy != "undefined") dy = json.dy;
    if(typeof json.index != "undefined") index = json.index;
    if(typeof json.released != "undefined") released = json.released;
    if(typeof json.y != "undefined") y = json.y;
    if(typeof json.v != "undefined") v = json.v;
    if(typeof json.t != "undefined") t = json.t;
    if(typeof json.dt != "undefined") dt = json.dt;
    if(typeof json.tol != "undefined") tol = json.tol;
   _resetSolvers();
   _model.update();
  };

  _model.addToReset(function() {
    __pagesEnabled["Init Page"] = true;
    __pagesEnabled["Evol Page"] = true;
    __pagesEnabled["FixRel Page"] = true;
  });

  _model.addToReset(function() {
    n = 32; // EjsS Model.Variables.Auxiliary Vars.n
    xmin = 0; // EjsS Model.Variables.Auxiliary Vars.xmin
    xmax = 2*Math.PI; // EjsS Model.Variables.Auxiliary Vars.xmax
    dx = (xmax-xmin)/(n-1); // EjsS Model.Variables.Auxiliary Vars.dx
    x = new Array(n); // EjsS Model.Variables.Auxiliary Vars.x
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Auxiliary Vars.x
        x[_i0] = 0;  // EjsS Model.Variables.Auxiliary Vars.x
      }
    }());
    fStr = "exp(-4*(x-pi)^2)"; // EjsS Model.Variables.Auxiliary Vars.fStr
    k = 4*Math.PI*Math.PI; // EjsS Model.Variables.Auxiliary Vars.k
    dy = new Array(n-1); // EjsS Model.Variables.Auxiliary Vars.dy
    (function () {
      var _i0;
      for (_i0=0; _i0<n-1; _i0+=1) {  // EjsS Model.Variables.Auxiliary Vars.dy
        dy[_i0] = 0.1;  // EjsS Model.Variables.Auxiliary Vars.dy
      }
    }());
    index = 0; // EjsS Model.Variables.Auxiliary Vars.index
    released = false; // EjsS Model.Variables.Auxiliary Vars.released
  });

  _model.addToReset(function() {
    y = new Array(n); // EjsS Model.Variables.Dynamical Vars.y
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Dynamical Vars.y
        y[_i0] = 0;  // EjsS Model.Variables.Dynamical Vars.y
      }
    }());
    v = new Array(n); // EjsS Model.Variables.Dynamical Vars.v
    (function () {
      var _i0;
      for (_i0=0; _i0<n; _i0+=1) {  // EjsS Model.Variables.Dynamical Vars.v
        v[_i0] = 0;  // EjsS Model.Variables.Dynamical Vars.v
      }
    }());
    t = 0; // EjsS Model.Variables.Dynamical Vars.t
    dt = 0.1; // EjsS Model.Variables.Dynamical Vars.dt
    tol = 1.0E-7; // EjsS Model.Variables.Dynamical Vars.tol
  });

  _model.addToReset(function() {
    _privateOdesList=[];
    _ODEi_evolution1 = _ODE_evolution1();
    _privateOdesList.push(_ODEi_evolution1);
  });

  _model.addToReset(function() {
    _model.setAutoplay(false);
    _model.setPauseOnPageExit(true);
    _model.setFPS(10);
    _model.setStepsPerDisplay(1);
  });

  function changeN () {  // > CustomCode.Change N:1
    n=Math.max(n,3);  // > CustomCode.Change N:2
    x= new Array(n);  // > CustomCode.Change N:3
    y= new Array(n);  // > CustomCode.Change N:4
    v= new Array(n);  // > CustomCode.Change N:5
    dy= new Array(n-1);  // > CustomCode.Change N:6
    dx=(xmax-xmin)/(n-1);  // > CustomCode.Change N:7
    _initialize();  // > CustomCode.Change N:8
  }  // > CustomCode.Change N:9

  _model.addToInitialization(function() {
    if (!__pagesEnabled["Init Page"]) return;
    t=0;  // > Initialization.Init Page:1
    var xi=xmin;  // > Initialization.Init Page:2
    _view._update();  // > Initialization.Init Page:3
    for(var i=0; i<n; i++){  // > Initialization.Init Page:4
      x[i]=xi;  // > Initialization.Init Page:5
      y[i]=_view.functionField.evaluate({x:xi});   // > Initialization.Init Page:6
      v[i]=0;  // > Initialization.Init Page:7
      xi+=dx;  // > Initialization.Init Page:8
    }  // > Initialization.Init Page:9
  });

  _model.addToInitialization(function() {
    _initializeSolvers();
  });

  _model.addToEvolution(function() {
    if (!__pagesEnabled["Evol Page"]) return;
    _ODEi_evolution1.step();
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  _model.addToFixedRelations(function() {
    if (!__pagesEnabled["FixRel Page"]) return;
    for(var i=0; i<n-1; i++){  // > FixedRelations.FixRel Page:1
      dy[i]=y[i+1]-y[i];   // > FixedRelations.FixRel Page:2
    }  // > FixedRelations.FixRel Page:3
  });

  _model.addToFixedRelations(function() { _isPaused = _model.isPaused(); _isPlaying = _model.isPlaying(); });

  function _initializeSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].initializeSolver();
  }

  function _automaticResetSolvers() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].automaticResetSolver();
  }

  _model.resetSolvers = function() {
    for (var i=0,n=_privateOdesList.length; i<n; i++) _privateOdesList[i].resetSolver();
  };

  function _getODE(_odeName) {
    if (_odeName=="Evol Page") return _ODEi_evolution1;
    return null;
  }

  function _getEventSolver(_odeName) {
    var ode = _getODE(_odeName);
    if (ode===null) return null;
    return ode.getEventSolver();
  }

  function _setSolverClass(_odeName, _engine) {
    var ode = _getODE(_odeName);
    if (ode===null) return;
    if (!_engine.setODE) {
      var classname = _engine.toLowerCase();
      if      (classname.indexOf("boga")>=0)   _engine = EJSS_ODE_SOLVERS.bogackiShampine23;
      else if (classname.indexOf("cash")>=0)   _engine = EJSS_ODE_SOLVERS.cashKarp45;
      else if (classname.indexOf("dopri5")>=0) _engine = EJSS_ODE_SOLVERS.dopri5;
      else if (classname.indexOf("dopri8")>=0) _engine = EJSS_ODE_SOLVERS.dopri853;
      else if (classname.indexOf("richa")>=0)  _engine = EJSS_ODE_SOLVERS.eulerRichardson;
      else if (classname.indexOf("euler")>=0)  _engine = EJSS_ODE_SOLVERS.euler;
      else if (classname.indexOf("fehlberg87")>=0) _engine = EJSS_ODE_SOLVERS.fehlberg87;
      else if (classname.indexOf("fehlberg8")>=0)  _engine = EJSS_ODE_SOLVERS.fehlberg8;
      else if (classname.indexOf("radau")>=0)   _engine = EJSS_ODE_SOLVERS.radau5;
      else if (classname.indexOf("runge")>=0)  _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("rk4")>=0)    _engine = EJSS_ODE_SOLVERS.rungeKutta4;
      else if (classname.indexOf("verlet")>=0) _engine = EJSS_ODE_SOLVERS.velocityVerlet;
    }
    if (_engine) ode.setSolverClass(_engine);
  }

  function _ODE_evolution1() {
    var __odeSelf = {};
    var __eventSolver;
    var __solverClass = EJSS_ODE_SOLVERS.rungeKutta4;
    var __state=[];
    var __ignoreErrors=false;
    var __mustInitialize=true;
    var __isEnabled=true;
    var __mustUserReinitialize=false;
    var __mustReinitialize=true;

    var _yLength;
    var _vLength;

    __odeSelf.setSolverClass = function(__aSolverClass) {
      __solverClass = __aSolverClass;
      __instantiateSolver();
    };

    function __instantiateSolver() {
      __state=[];
      _yLength = y.length;
      _vLength = v.length;
      __pushState();
      __eventSolver = EJSS_ODE_SOLVERS.interpolatorEventSolver(__solverClass(),__odeSelf);
      __mustInitialize = true;
    }

    __odeSelf.setEnabled = function(_enabled) { __isEnabled = _enabled; };

    __odeSelf.getIndependentVariableValue = function() { return __eventSolver.getIndependentVariableValue(); };

    __odeSelf.getInternalStepSize = function() { return __eventSolver.getInternalStepSize(); };

    __odeSelf.isAccelerationIndependentOfVelocity = function() { return false; };

    __odeSelf.initializeSolver = function() {
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); return; }
      __pushState();
      __eventSolver.initialize(dt);
      __eventSolver.setBestInterpolation(false);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.removeAllEvents();
      __eventSolver.setEstimateFirstStep(false);
      __eventSolver.setEnableExceptions(false);
      __eventSolver.setTolerances(tol,tol);
      __mustReinitialize = true;
      __mustInitialize = false;
    };

    function __pushState() {
      // Copy our variables to __state[] 
        var __j=0;
        var __n=0;
        var __cIn=0;
      if (!__mustReinitialize)
        for (__j=0,__n=__cIn; __j<_yLength; __j++)
          if (__state[__n++]!=y[__j] || __state[__n++]!=v[__j]) { __mustReinitialize = true; break; }
      for (__j=0; __j<_yLength; __j++) { // These two alternate in the state
         __state[__cIn++] = y[__j];
         __state[__cIn++] = v[__j];
      }
        if (__state[__cIn]!=t) __mustReinitialize = true;
        __state[__cIn++] = t;
    }

    function __arraysChanged () {
      if (_yLength != y.length) return true;
      if (_vLength != v.length) return true;
      return false;
    }

    __odeSelf.getEventSolver = function() {
      return __eventSolver;
    };

    __odeSelf.resetSolver = function() {
      __mustUserReinitialize = true;
    };

    __odeSelf.automaticResetSolver = function() {
      __mustReinitialize = true;
    };

    function __errorAction () {
      if (__ignoreErrors) return;
      console.log (__eventSolver.getErrorMessage());
      _pause();
      // Make sure the solver is reinitialized;
      __mustReinitialize = true;
    }

    __odeSelf.step = function() { return __privateStep(false); };

    __odeSelf.solverStep = function() { return __privateStep(true); };

    function __privateStep(__takeMaximumStep) {
      if (!__isEnabled) return 0;
      if (dt===0) return 0;
      if (__mustInitialize) __odeSelf.initializeSolver();
      if (__arraysChanged()) { __instantiateSolver(); __odeSelf.initializeSolver(); }
      __eventSolver.setStepSize(dt);
      __eventSolver.setInternalStepSize(dt);
      __eventSolver.setMaximumInternalSteps(10000);
      __eventSolver.setTolerances(tol,tol);
      __pushState();
      if (__mustUserReinitialize) { 
        __eventSolver.userReinitialize();
        __mustUserReinitialize = false;
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      else if (__mustReinitialize) { 
        __eventSolver.reinitialize();
        __mustReinitialize = false;
        if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      }
      var __stepTaken = __takeMaximumStep ? __eventSolver.maxStep() : __eventSolver.step();
      // Extract our variables from __state
        var __i=0;
        var __cOut=0;
        for (__i=0; __i<_yLength; __i++) { // These two alternate in the state
          y[__i] = __state[__cOut++];
          v[__i] = __state[__cOut++];
        }
        t = __state[__cOut++];
      // Check for error
      if (__eventSolver.getErrorCode()!=EJSS_ODE_SOLVERS.ERROR.NO_ERROR) __errorAction();
      return __stepTaken;
    }

    __odeSelf.getState = function() { return __state; };

    __odeSelf.getRate = function(_aState,_aRate) {
      _aRate[_aRate.length-1] = 0.0; // In case the prelim code returns
      var __index=-1; // so that it can be used in preliminary code
      // Extract our variables from _aState
        var __i=0;
        var __cOut=0;
        var y = [];
        var v = [];
        for (__i=0; __i<_yLength; __i++) { // These two alternate in the state
          y[__i] = _aState[__cOut++];
          v[__i] = _aState[__cOut++];
        }
        var t = _aState[__cOut++];
      // Preliminary code: Code to be executed before rate equations are evaluated
        var a = new Array(n);  // > Preliminary code for ODE.Evol Page:1
        y[0]=v[0]=a[0]=0;  // > Preliminary code for ODE.Evol Page:2
        if (!released) y[n-1]=v[n-1]=a[n-1]=0;  // > Preliminary code for ODE.Evol Page:3
        else a[n-1] = k*(y[n-2]-y[n-1]);  // > Preliminary code for ODE.Evol Page:4
        for(var i=1; i<n-1; i++){  // > Preliminary code for ODE.Evol Page:5
          a[i]=k*(y[i-1]-2*y[i]+y[i+1]);  // > Preliminary code for ODE.Evol Page:6
        }  // > Preliminary code for ODE.Evol Page:7
      // Compute the rate
        var __cRate=0;
        for (__i=0;__i<_yLength;__i++) { // These two alternate in the state
          _aRate[__cRate++] = Array.isArray(v[__i]) ? v[__i][__i] : v[__i]; // Rate for ODE: Evol Page:y
          _aRate[__cRate++] = Array.isArray(a) ? a[__i] : a; // Rate for ODE: Evol Page:v
        }
        _aRate[__cRate++] = 1; // independent variable
        return _aRate;
    }; //end of getRate

    __instantiateSolver();

    return __odeSelf;
  }

  function _historic_y(__time) {
    var __beginIndex = 0;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,new Array(y.length),__beginIndex,y.ength);
  }

  function _historic_v(__time) {
    var __beginIndex = 0 + y.length;
    return _ODEi_evolution1.getEventSolver().getStateHistory().interpolate(__time,new Array(v.length),__beginIndex,v.ength);
  }

    _model._resized = function(_width,_height) {
      _view._resized(_width,_height);
  }; // end of _resized
    _model._fontResized = function(iBase,iSize,iDelta) {
      _view._fontResized(iBase,iSize,iDelta);
  }; // end of _fontResized

  function _getViews() {
    var _viewsInfo = [];
    var _counter = 0;
    _viewsInfo[_counter++] = { name : "HtmlView Page", width : 700, height : 400 };
    return _viewsInfo;
  } // end of _getViews

  function _selectView(_viewNumber) {
    _view = null;
    _view = new CoupledOscillatorChain_View(_topFrame,_viewNumber,_libraryPath,_codebasePath);
    var _view_super_reset = _view._reset;
    _view._reset = function() {
      _view_super_reset();
      switch(_viewNumber) {
        case -10 : break; // make Lint happy
        default :
        case 0:
          _view.orbitPlottingPanel.linkProperty("MinimumX",  function() { return xmin-0.3; } ); // HtmlView Page linking property 'MinimumX' for element 'orbitPlottingPanel'
          _view.orbitPlottingPanel.linkProperty("Enabled",  function() { return _isPaused; } ); // HtmlView Page linking property 'Enabled' for element 'orbitPlottingPanel'
          _view.orbitPlottingPanel.linkProperty("BLMessage",  function() { return "time="+_view._format(t,"0.00"); } ); // HtmlView Page linking property 'BLMessage' for element 'orbitPlottingPanel'
          _view.orbitPlottingPanel.linkProperty("MaximumX",  function() { return xmax+0.3; } ); // HtmlView Page linking property 'MaximumX' for element 'orbitPlottingPanel'
          _view.analyticCurve.linkProperty("FunctionY",  function() { return fStr; }, function(_v) { fStr = _v; } ); // HtmlView Page linking property 'FunctionY' for element 'analyticCurve'
          _view.analyticCurve.linkProperty("Maximum",  function() { return xmax; }, function(_v) { xmax = _v; } ); // HtmlView Page linking property 'Maximum' for element 'analyticCurve'
          _view.analyticCurve.linkProperty("Minimum",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'Minimum' for element 'analyticCurve'
          _view.shapeSet.linkProperty("NumberOfElements",  function() { return n; }, function(_v) { n = _v; } ); // HtmlView Page linking property 'NumberOfElements' for element 'shapeSet'
          _view.shapeSet.setAction("OnRelease", function() {
  v[index]=0;
  y[0]=v[0]=0;
  y[n-1]=v[n-1]=0;

}); // HtmlView Page setting action 'OnRelease' for element 'shapeSet'
          _view.shapeSet.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'X' for element 'shapeSet'
          _view.shapeSet.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'Y' for element 'shapeSet'
          _view.shapeSet.linkProperty("ElementInteracted",  function() { return index; }, function(_v) { index = _v; } ); // HtmlView Page linking property 'ElementInteracted' for element 'shapeSet'
          _view.springSet.linkProperty("NumberOfElements",  function() { return n-1; } ); // HtmlView Page linking property 'NumberOfElements' for element 'springSet'
          _view.springSet.linkProperty("SizeX",  function() { return dx; }, function(_v) { dx = _v; } ); // HtmlView Page linking property 'SizeX' for element 'springSet'
          _view.springSet.linkProperty("X",  function() { return x; }, function(_v) { x = _v; } ); // HtmlView Page linking property 'X' for element 'springSet'
          _view.springSet.linkProperty("Y",  function() { return y; }, function(_v) { y = _v; } ); // HtmlView Page linking property 'Y' for element 'springSet'
          _view.springSet.linkProperty("SizeY",  function() { return dy; }, function(_v) { dy = _v; } ); // HtmlView Page linking property 'SizeY' for element 'springSet'
          _view.leftWallShape.linkProperty("X",  function() { return xmin; }, function(_v) { xmin = _v; } ); // HtmlView Page linking property 'X' for element 'leftWallShape'
          _view.rightWallShape.linkProperty("X",  function() { return xmax; }, function(_v) { xmax = _v; } ); // HtmlView Page linking property 'X' for element 'rightWallShape'
          _view.runPauseButton.setAction("OffClick", _pause); // HtmlView Page setting action 'OffClick' for element 'runPauseButton'
          _view.runPauseButton.linkProperty("State",  function() { return _isPaused; } ); // HtmlView Page linking property 'State' for element 'runPauseButton'
          _view.runPauseButton.setAction("OnClick", _play); // HtmlView Page setting action 'OnClick' for element 'runPauseButton'
          _view.stepButton.setAction("OnClick", function() {
  _step();

}); // HtmlView Page setting action 'OnClick' for element 'stepButton'
          _view.resetButton.setAction("OnClick", function() {
  _reset();

}); // HtmlView Page setting action 'OnClick' for element 'resetButton'
          _view.functionField.linkProperty("Value",  function() { return fStr; }, function(_v) { fStr = _v; } ); // HtmlView Page linking property 'Value' for element 'functionField'
          _view.functionField.setAction("OnChange", _initialize); // HtmlView Page setting action 'OnChange' for element 'functionField'
          _view.nField.linkProperty("Value",  function() { return n; }, function(_v) { n = _v; } ); // HtmlView Page linking property 'Value' for element 'nField'
          _view.nField.setAction("OnChange", changeN); // HtmlView Page setting action 'OnChange' for element 'nField'
          _view.releaseButton.setAction("OnClick", function() {
  released = true;

}); // HtmlView Page setting action 'OnClick' for element 'releaseButton'
          break;
      } // end of switch
    }; // end of new reset

    _model.setView(_view);
    _model.reset();
    _view._enableEPub();
  } // end of _selectView

  _model.setAutoplay(false);
  _model.setFPS(10);
  _model.setStepsPerDisplay(1);
  _selectView(_model._autoSelectView(_getViews())); // this includes _model.reset()
  return _model;
}
function CoupledOscillatorChain_View (_topFrame,_viewNumber,_libraryPath,_codebasePath) {
  var _view;
  switch(_viewNumber) {
    case -10 : break; // make Lint happy
    default :
    case 0: _view = CoupledOscillatorChain_View_0 (_topFrame); break;
  } // end of switch

  if (_codebasePath) _view._setResourcePath(_codebasePath);

  if (_libraryPath) _view._setLibraryPath(_libraryPath);

  _view._addDescriptionPage('Oscillator Chain','./OscillatorChain/OscillatorChain.html');
  _view._addDescriptionPage('Theory','./OscillatorChain/CoupledOscillatorModel.html');

  return _view;
} // end of main function

function CoupledOscillatorChain_View_0 (_topFrame) {
  var _view = EJSS_CORE.createView(_topFrame);

  _view._reset = function() {
    _view._clearAll();
    _view._addElement(EJSS_INTERFACE.panel,"labelPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'labelPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"labelTitle", _view.labelPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'labelTitle'
      .setProperty("Foreground","Blue") // EJsS HtmlView.HtmlView Page: setting property 'Foreground' for element 'labelTitle'
      .setProperty("Text","<h1>Coupled Oscillator Chain</h1>") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'labelTitle'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"mainPanel", _view._topFrame) // EJsS HtmlView.HtmlView Page: declaration of element 'mainPanel'
      .setProperty("CSS",{ "display" : "inline-block"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'mainPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"centerPanel", _view.mainPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'centerPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.plottingPanel,"orbitPlottingPanel", _view.centerPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'orbitPlottingPanel'
      .setProperty("Height",300) // EJsS HtmlView.HtmlView Page: setting property 'Height' for element 'orbitPlottingPanel'
      .setProperty("Width",600) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'orbitPlottingPanel'
      .setProperty("MinimumY",-1.1) // EJsS HtmlView.HtmlView Page: setting property 'MinimumY' for element 'orbitPlottingPanel'
      .setProperty("AutoScaleY",true) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleY' for element 'orbitPlottingPanel'
      .setProperty("AutoScaleX",false) // EJsS HtmlView.HtmlView Page: setting property 'AutoScaleX' for element 'orbitPlottingPanel'
      .setProperty("Title","") // EJsS HtmlView.HtmlView Page: setting property 'Title' for element 'orbitPlottingPanel'
      .setProperty("SquareAspect",false) // EJsS HtmlView.HtmlView Page: setting property 'SquareAspect' for element 'orbitPlottingPanel'
      .setProperty("MaximumY",1.1) // EJsS HtmlView.HtmlView Page: setting property 'MaximumY' for element 'orbitPlottingPanel'
      ;

    _view._addElement(EJSS_DRAWING2D.analyticCurve,"analyticCurve", _view.orbitPlottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'analyticCurve'
      .setProperty("FunctionX","x") // EJsS HtmlView.HtmlView Page: setting property 'FunctionX' for element 'analyticCurve'
      .setProperty("Variable","x") // EJsS HtmlView.HtmlView Page: setting property 'Variable' for element 'analyticCurve'
      ;

    _view._addElement(EJSS_DRAWING2D.shapeSet,"shapeSet", _view.orbitPlottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'shapeSet'
      .setProperty("Sensitivity",8) // EJsS HtmlView.HtmlView Page: setting property 'Sensitivity' for element 'shapeSet'
      .setProperty("SizeX",10) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'shapeSet'
      .setProperty("PixelSize",true) // EJsS HtmlView.HtmlView Page: setting property 'PixelSize' for element 'shapeSet'
      .setProperty("SizeY",10) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'shapeSet'
      .setProperty("EnabledPosition","ENABLED_Y") // EJsS HtmlView.HtmlView Page: setting property 'EnabledPosition' for element 'shapeSet'
      ;

    _view._addElement(EJSS_DRAWING2D.springSet,"springSet", _view.orbitPlottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'springSet'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"leftWallShape", _view.orbitPlottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'leftWallShape'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'leftWallShape'
      .setProperty("SizeX",0.2) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'leftWallShape'
      .setProperty("RelativePosition","EAST") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'leftWallShape'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'leftWallShape'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'leftWallShape'
      .setProperty("SizeY",0.5) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'leftWallShape'
      ;

    _view._addElement(EJSS_DRAWING2D.shape,"rightWallShape", _view.orbitPlottingPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'rightWallShape'
      .setProperty("FillColor","Red") // EJsS HtmlView.HtmlView Page: setting property 'FillColor' for element 'rightWallShape'
      .setProperty("SizeX",0.2) // EJsS HtmlView.HtmlView Page: setting property 'SizeX' for element 'rightWallShape'
      .setProperty("RelativePosition","WEST") // EJsS HtmlView.HtmlView Page: setting property 'RelativePosition' for element 'rightWallShape'
      .setProperty("ShapeType","RECTANGLE") // EJsS HtmlView.HtmlView Page: setting property 'ShapeType' for element 'rightWallShape'
      .setProperty("Y",0) // EJsS HtmlView.HtmlView Page: setting property 'Y' for element 'rightWallShape'
      .setProperty("SizeY",0.5) // EJsS HtmlView.HtmlView Page: setting property 'SizeY' for element 'rightWallShape'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"bottomPanel", _view.mainPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'bottomPanel'
      .setProperty("Width",550) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'bottomPanel'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"buttonLeftPanel", _view.bottomPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'buttonLeftPanel'
      .setProperty("Width",150) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'buttonLeftPanel'
      .setProperty("CSS",{ "float":"left"}) // EJsS HtmlView.HtmlView Page: setting property 'CSS' for element 'buttonLeftPanel'
      ;

    _view._addElement(EJSS_INTERFACE.twoStateButton,"runPauseButton", _view.buttonLeftPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'runPauseButton'
      .setProperty("ImageOnUrl","/org/opensourcephysics/resources/controls/images/play.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOnUrl' for element 'runPauseButton'
      .setProperty("ImageOffUrl","/org/opensourcephysics/resources/controls/images/pause.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageOffUrl' for element 'runPauseButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"stepButton", _view.buttonLeftPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'stepButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/stepforward.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'stepButton'
      ;

    _view._addElement(EJSS_INTERFACE.button,"resetButton", _view.buttonLeftPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'resetButton'
      .setProperty("ImageUrl","/org/opensourcephysics/resources/controls/images/reset.gif") // EJsS HtmlView.HtmlView Page: setting property 'ImageUrl' for element 'resetButton'
      ;

    _view._addElement(EJSS_INTERFACE.panel,"bottomRightPanel", _view.bottomPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'bottomRightPanel'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"functionLabel", _view.bottomRightPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'functionLabel'
      .setProperty("Text","f(x,0) =") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'functionLabel'
      ;

    _view._addElement(EJSS_INTERFACE.functionField,"functionField", _view.bottomRightPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'functionField'
      .setProperty("Width",200) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'functionField'
      ;

    _view._addElement(EJSS_INTERFACE.imageAndTextButton,"nLabel", _view.bottomRightPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nLabel'
      .setProperty("Text"," n = ") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'nLabel'
      ;

    _view._addElement(EJSS_INTERFACE.numberField,"nField", _view.bottomRightPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'nField'
      .setProperty("Width",50) // EJsS HtmlView.HtmlView Page: setting property 'Width' for element 'nField'
      .setProperty("Format","0") // EJsS HtmlView.HtmlView Page: setting property 'Format' for element 'nField'
      ;

    _view._addElement(EJSS_INTERFACE.button,"releaseButton", _view.bottomRightPanel) // EJsS HtmlView.HtmlView Page: declaration of element 'releaseButton'
      .setProperty("Text","Release") // EJsS HtmlView.HtmlView Page: setting property 'Text' for element 'releaseButton'
      ;

  };

  return _view;
}



      var _model;
      window.addEventListener('load',
        function () { 
          _model =  new CoupledOscillatorChain("_topFrame","_ejs_library/",null);
          if (typeof _isApp !== "undefined" && _isApp) _model.setRunAlways(true);
          TextResizeDetector.TARGET_ELEMENT_ID = '_topFrame';
          TextResizeDetector.USER_INIT_FUNC = function () {
            var iBase = TextResizeDetector.addEventListener(function(e,args) {
              _model._fontResized(args[0].iBase,args[0].iSize,args[0].iDelta);
              },null);
            _model._fontResized(iBase);
          };
          _model.onload();
        }, false);
      var interval = setInterval(function() {
         if(document.readyState === 'complete') {
           window.addEventListener('resize', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           window.addEventListener('scroll', function () { if (_model._resized) _model._resized(window.innerWidth,window.innerHeight); }, false);
           var startCaptureBut = document.getElementById('startCaptureBut'); 
           var stopCaptureBut = document.getElementById('stopCaptureBut'); 
           var resetCaptureBut = document.getElementById('resetCaptureBut'); 
           var playCaptureBut = document.getElementById('playCaptureBut'); 
           var stepCaptureBut = document.getElementById('stepCaptureBut'); 
           if (startCaptureBut) {
             startCaptureBut.onclick = function() {
               _model.startCapture();
             };
             stopCaptureBut.onclick = function() {
               _model.saveText('recording','rec',JSON.stringify(_model.stopCapture()));
             };
             resetCaptureBut.onclick = function() {
               _model.resetCapture();
             };
             playCaptureBut.onclick = function() {
               _model.readText(null,'.rec',function(content){
               _model.playCapture(JSON.parse(content),function(){startCaptureBut.disabled=false; playCaptureBut.disabled=false; stepCaptureBut.disabled=false; window.alert(end_reproduction_message);});               });
             };
             stepCaptureBut.onchange= function() {
               var stepCapt;
               if (stepCaptureBut.value >= 0) stepCapt =  stepCaptureBut.value + 1;
               else stepCapt = 1 + 1.8*stepCaptureBut.value/8;
               _model.changeCaptureStep(stepCapt);
             };
           }
           clearInterval(interval);
         };
      }, 200)
