var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./potentiometer/01authortansengkwang.png"]="data:image/png;base64,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";
__base64Images["./potentiometer/Screen Shot 2016-11-11 at 3.04.38 PM.png"]="data:image/png;base64,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";
__base64Images["./potentiometer/galvonometer.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
