var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./Unnamed/256px-Soccer_ball.svg.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./Unnamed/soccer-304171_960_720.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/close.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAh3ALEJFMhqBQAAK1gNXIiNFQArgVixCmQFgMKFVhIybLjCysCCGxdqxKaRFq2FJhsCwEZRoMmT2F4KXBFoZMyXKQXWtIhS5seDF136JIgwKM6cLGl6vAnTJ02SCpHeVEnQJsOCQTMG/djxKsKIEw1uXVjwoFVsAQEAOw==";
__base64Images["./Unnamed/Screenshot 2019-04-05 at 10.49.03 AM.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./Unnamed/full_screen.png"]="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAABgAAAAYCAYAAADgdz34AAAACXBIWXMAAAsTAAALEwEAmpwYAAAAIGNIUk0AAHolAACAgwAA+f8AAIDpAAB1MAAA6mAAADqYAAAXb5JfxUYAAAPySURBVHjatJZdiFVVFMd/+9w9dz7u3KuJNjIm0tiAgz1NoFn2QYHWgxCUDxoR9dKnD/pURvQSGfQxECXlQ+BXiEjREL1YkTDYkDPWi9aEMTCJd+51mlHvnXvvOWfvtXo4Zyz0OqjkgnXgHNZe/73X+v/XPkZVuZVm5wCMMVQqlWdVdW367YaRjTEBcLpQKHymqhEAIoKIMDEx8YGIxPo/WKlUOgwYEUke5XJpsKtr6aZj52ocGatCxmAw13+GNFS98NAdHWzu7aRarZzJ5Tp7zejo6P39/f1Dh8YusuXz8SQ6lmRhWwDZYP7kTqCWxtsARHntiW52rb+d4eHhrXZBPr8ZYNvRc2A8PSvzbLwzRzYTcHS8yulzNWi5BogIXUuybF29kIZTRoo1ToxVePfHIrvWL2ZBofNRi+oigCiMYLbOF4/1snZ5AYBVv5+CSgMK2eYAdUfJeT58uC95DWM63hiFwKJO8SItgRdxABnnIXa0WnN5/XdbeiCjEMUQN/Ew5Pune/6lZAYQB84BgnqVlKaCcTEYz76TJQ7b87yzsYf9v5ShEQIWTLP6O/aNTvJIz0LeOzZBJfSgHpwiaV6rooCiLoYWYeDbcYiET4eLzEzWIGfBx81L1KLs/WGCwVNTzJRqKTEyIAGiiopiVSXRVOzAeWiz0JphZqoKrQbEg8zDovaAmb9nk9ggSHJ4j6qgKtjkKIqZq2vmP+T3gPfXp4W5WJfsRgVEmQOQBDm6AuBmLBYwIOoRFSySJnRR4g2fQM9G0J5NxNa0w+m4igWqaWzGpCPMoJL0IFCjoAreQS2iI2vAO3a/1E97u4FLjYR2zbwWQSPmkxf7yXUEtGUEwhicQzXJa0UFECRyMF1h8K0HeaB3EdlcgWfWLCP//FfQEMgEV6mYaszIwOPcc1c3z61bRvFCyMoXBqHDIppQNfCiCUviGOoRgpDNdYDUeWXfKFTrSfOuFJnz4GO27z2JNCq0d7bRagOohxC6ZEqrEgAWgagegjpGzkxBHILz/HH2UlqOJip2MYhn7OwMtVjQMOLnP6cgjiBqEHsPBmtnpi/8hoX+FQsYOlVk50dD7Nx9POG0NWCBMLp6dJukyeXiRfJP7QWnEHuoRSxaVmBxvpVfZ2vnTV9f320nhoemK3XHmu1f89dYGYKUNUEAwTx3m0kYjqRKFKV9aYHj729i9YqFvLrj9bvNZKnMnj17ntyx7eUjuTbLePESfh5icm3CYlCWL8mDgUNffvPmxg0b3jaTpTKqyn3r7l05MDCws7u7a5U1GYu58TtZVHVqanp8/8GDHx88cOCnyVJZr9xoG9BJUpibMQVmgdrlKt7q35Z/BgD4LZFsdEtqqgAAAABJRU5ErkJggg==";
__base64Images["/org/opensourcephysics/resources/controls/images/stepback.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAM4WLrcPCIOUEYQ1NlZb3YVBWGgMpjD2VgXZ5Ga4Hplbd+oGATfws4w006iC/qIHeMD2HNkAFCcIwEAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
