/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_solvers.rk;

import org.opensourcephysics.numerics.ode_interpolation.Bootstrap2IntervalData;
import org.opensourcephysics.numerics.ode_interpolation.IntervalData;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngineDiscreteTimeAdaptive;

public class CashKarp45
extends SolverEngineDiscreteTimeAdaptive {
    private static final double A_11 = 0.2;
    private static final double A_21 = 0.075;
    private static final double A_22 = 0.225;
    private static final double A_31 = 0.3;
    private static final double A_32 = -0.9;
    private static final double A_33 = 1.2;
    private static final double A_41 = -0.2037037037037037;
    private static final double A_42 = 2.5;
    private static final double A_43 = -2.5925925925925926;
    private static final double A_44 = 1.2962962962962963;
    private static final double A_51 = 0.029495804398148147;
    private static final double A_52 = 0.341796875;
    private static final double A_53 = 0.041594328703703706;
    private static final double A_54 = 0.40034541377314814;
    private static final double A_55 = 0.061767578125;
    private static final double B4_1 = 0.10217737268518519;
    private static final double B4_2 = 0.0;
    private static final double B4_3 = 0.38390790343915343;
    private static final double B4_4 = 0.24459273726851852;
    private static final double B4_5 = 0.019321986607142856;
    private static final double B4_6 = 0.25;
    private static final double B5_1 = 0.09788359788359788;
    private static final double B5_2 = 0.0;
    private static final double B5_3 = 0.4025764895330113;
    private static final double B5_4 = 0.21043771043771045;
    private static final double B5_5 = 0.0;
    private static final double B5_6 = 0.2891022021456804;
    private double[] mRate2;
    private double[] mRate3;
    private double[] mRate4;
    private double[] mRate5;
    private double[] mRate6;
    private double[] mOrder4;

    @Override
    protected int getNumberOfEvaluations() {
        return 6;
    }

    @Override
    protected void allocateOtherArrays() {
        super.allocateOtherArrays();
        this.mRate2 = new double[this.mDimension];
        this.mRate3 = new double[this.mDimension];
        this.mRate4 = new double[this.mDimension];
        this.mRate5 = new double[this.mDimension];
        this.mRate6 = new double[this.mDimension];
        this.mOrder4 = new double[this.mDimension];
    }

    @Override
    protected void computeIntermediateStep(double d, double[] dArray) {
        int n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * 0.2 * this.mInitialRate[n];
            ++n;
        }
        this.mODE.getRate(dArray, this.mRate2);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * (0.075 * this.mInitialRate[n] + 0.225 * this.mRate2[n]);
            ++n;
        }
        this.mODE.getRate(dArray, this.mRate3);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * (0.3 * this.mInitialRate[n] + -0.9 * this.mRate2[n] + 1.2 * this.mRate3[n]);
            ++n;
        }
        this.mODE.getRate(dArray, this.mRate4);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * (-0.2037037037037037 * this.mInitialRate[n] + 2.5 * this.mRate2[n] + -2.5925925925925926 * this.mRate3[n] + 1.2962962962962963 * this.mRate4[n]);
            ++n;
        }
        this.mODE.getRate(dArray, this.mRate5);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * (0.029495804398148147 * this.mInitialRate[n] + 0.341796875 * this.mRate2[n] + 0.041594328703703706 * this.mRate3[n] + 0.40034541377314814 * this.mRate4[n] + 0.061767578125 * this.mRate5[n]);
            ++n;
        }
        this.mODE.getRate(dArray, this.mRate6);
        n = 0;
        while (n < this.mTimeIndex) {
            dArray[n] = this.mInitialState[n] + d * (0.09788359788359788 * this.mInitialRate[n] + 0.0 * this.mRate2[n] + 0.4025764895330113 * this.mRate3[n] + 0.21043771043771045 * this.mRate4[n] + 0.0 * this.mRate5[n] + 0.2891022021456804 * this.mRate6[n]);
            ++n;
        }
        dArray[this.mTimeIndex] = this.mInitialTime + d * this.mInitialRate[this.mTimeIndex];
    }

    @Override
    protected InterpolatorEventSolver.DISCONTINUITY_CODE computeIntermediateStep(InterpolatorEventSolver interpolatorEventSolver, double d, double[] dArray) {
        int n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * 0.2 * this.mInitialRate[n];
            ++n;
        }
        switch (interpolatorEventSolver.checkDiscontinuity(dArray, false)) {
            case DISCONTINUITY_PRODUCED_ERROR: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
            }
            case DISCONTINUITY_JUST_PASSED: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_JUST_PASSED;
            }
            case DISCONTINUITY_ALONG_STEP: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
            }
            case DISCONTINUITY_EXACTLY_ON_STEP: {
                break;
            }
        }
        this.mODE.getRate(dArray, this.mRate2);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * (0.075 * this.mInitialRate[n] + 0.225 * this.mRate2[n]);
            ++n;
        }
        switch (interpolatorEventSolver.checkDiscontinuity(dArray, false)) {
            case DISCONTINUITY_PRODUCED_ERROR: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
            }
            case DISCONTINUITY_JUST_PASSED: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_JUST_PASSED;
            }
            case DISCONTINUITY_ALONG_STEP: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
            }
            case DISCONTINUITY_EXACTLY_ON_STEP: {
                break;
            }
        }
        this.mODE.getRate(dArray, this.mRate3);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * (0.3 * this.mInitialRate[n] + -0.9 * this.mRate2[n] + 1.2 * this.mRate3[n]);
            ++n;
        }
        switch (interpolatorEventSolver.checkDiscontinuity(dArray, false)) {
            case DISCONTINUITY_PRODUCED_ERROR: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
            }
            case DISCONTINUITY_JUST_PASSED: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_JUST_PASSED;
            }
            case DISCONTINUITY_ALONG_STEP: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
            }
            case DISCONTINUITY_EXACTLY_ON_STEP: {
                break;
            }
        }
        this.mODE.getRate(dArray, this.mRate4);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * (-0.2037037037037037 * this.mInitialRate[n] + 2.5 * this.mRate2[n] + -2.5925925925925926 * this.mRate3[n] + 1.2962962962962963 * this.mRate4[n]);
            ++n;
        }
        switch (interpolatorEventSolver.checkDiscontinuity(dArray, false)) {
            case DISCONTINUITY_PRODUCED_ERROR: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
            }
            case DISCONTINUITY_JUST_PASSED: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_JUST_PASSED;
            }
            case DISCONTINUITY_ALONG_STEP: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
            }
            case DISCONTINUITY_EXACTLY_ON_STEP: {
                break;
            }
        }
        this.mODE.getRate(dArray, this.mRate5);
        n = 0;
        while (n < this.mDimension) {
            dArray[n] = this.mInitialState[n] + d * (0.029495804398148147 * this.mInitialRate[n] + 0.341796875 * this.mRate2[n] + 0.041594328703703706 * this.mRate3[n] + 0.40034541377314814 * this.mRate4[n] + 0.061767578125 * this.mRate5[n]);
            ++n;
        }
        switch (interpolatorEventSolver.checkDiscontinuity(dArray, false)) {
            case DISCONTINUITY_PRODUCED_ERROR: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_PRODUCED_ERROR;
            }
            case DISCONTINUITY_JUST_PASSED: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_JUST_PASSED;
            }
            case DISCONTINUITY_ALONG_STEP: {
                return InterpolatorEventSolver.DISCONTINUITY_CODE.DISCONTINUITY_ALONG_STEP;
            }
            case DISCONTINUITY_EXACTLY_ON_STEP: {
                break;
            }
        }
        this.mODE.getRate(dArray, this.mRate6);
        n = 0;
        while (n < this.mTimeIndex) {
            dArray[n] = this.mInitialState[n] + d * (0.09788359788359788 * this.mInitialRate[n] + 0.0 * this.mRate2[n] + 0.4025764895330113 * this.mRate3[n] + 0.21043771043771045 * this.mRate4[n] + 0.0 * this.mRate5[n] + 0.2891022021456804 * this.mRate6[n]);
            ++n;
        }
        dArray[this.mTimeIndex] = this.mInitialTime + d * this.mInitialRate[this.mTimeIndex];
        return interpolatorEventSolver.checkDiscontinuity(dArray, true);
    }

    @Override
    protected IntervalData computeFinalRateAndCreateIntervalData() {
        this.mODE.getRate(this.mFinalState, this.mFinalRate);
        return new Bootstrap2IntervalData(this.mInitialState, this.mInitialRate, this.mFinalState, this.mFinalRate, this.mODE);
    }

    @Override
    protected double getMethodOrder() {
        return 5.0;
    }

    @Override
    protected double computeApproximation(double d) {
        int n = 0;
        while (n < this.mTimeIndex) {
            this.mOrder4[n] = this.mInitialState[n] + d * (0.10217737268518519 * this.mInitialRate[n] + 0.0 * this.mRate2[n] + 0.38390790343915343 * this.mRate3[n] + 0.24459273726851852 * this.mRate4[n] + 0.019321986607142856 * this.mRate5[n] + 0.25 * this.mRate6[n]);
            ++n;
        }
        this.mOrder4[this.mTimeIndex] = this.mInitialTime + d * this.mInitialRate[this.mTimeIndex];
        return super.computeError(this.mOrder4);
    }
}

