/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_solvers;

import org.opensourcephysics.numerics.ode_solvers.DelayDifferentialEquation;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngineDiscreteTime;

public abstract class SolverEngineDiscreteTimeAdaptive
extends SolverEngineDiscreteTime {
    private static final double FAC1 = 0.33;
    private static final double FAC2 = 6.0;
    private static final double BETA = 0.0;
    private static final double SAFE = 0.9;
    private final double mExpO1 = 1.0 / this.getMethodOrder() - 0.0;
    private double mErrOld = 1.0E-4;
    private double mFactor = 0.0;
    private boolean mEstimate = false;
    private double mActualStepSize;
    private double mAbsoluteTolerance = Double.NaN;
    private double mRelativeTolerance = Double.NaN;
    protected double[] mAbsTol;
    protected double[] mRelTol;

    protected abstract double computeApproximation(double var1);

    protected abstract double getMethodOrder();

    @Override
    protected void allocateOtherArrays() {
        this.mRelTol = new double[this.mDimension];
        this.mAbsTol = new double[this.mDimension];
        this.setTolerances(1.0E-6, 1.0E-6);
    }

    @Override
    public void reinitialize(double[] dArray) {
        super.reinitialize(dArray);
        this.mActualStepSize = this.mEstimate ? this.limitStepSize(this.estimateFirstStepSize(this.mStepSize)) : this.limitStepSize(this.mStepSize);
    }

    @Override
    public final void setEstimateFirstStep(boolean bl) {
        this.mEstimate = bl;
    }

    @Override
    public void setMaximumStepSize(double d) {
        super.setMaximumStepSize(d);
        this.mActualStepSize = this.limitStepSize(this.mActualStepSize);
    }

    @Override
    public final void setTolerances(double d, double d2) {
        if (this.mAbsoluteTolerance == d && this.mRelativeTolerance == d2) {
            return;
        }
        this.mAbsoluteTolerance = d;
        this.mRelativeTolerance = d2;
        int n = 0;
        while (n < this.mDimension) {
            this.mAbsTol[n] = d;
            this.mRelTol[n] = d2;
            ++n;
        }
        this.mFinalTime = Double.NaN;
        this.mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
        this.mActualStepSize = this.mEstimate ? this.limitStepSize(this.estimateFirstStepSize(this.mStepSize)) : this.limitStepSize(this.mStepSize);
    }

    public final void setTolerances(double[] dArray, double[] dArray2) {
        this.mRelativeTolerance = Double.NaN;
        this.mAbsoluteTolerance = Double.NaN;
        System.arraycopy(dArray, 0, this.mAbsTol, 0, this.mDimension);
        System.arraycopy(dArray2, 0, this.mRelTol, 0, this.mDimension);
        this.mFinalTime = Double.NaN;
        this.mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
        this.mActualStepSize = this.mEstimate ? this.limitStepSize(this.estimateFirstStepSize(this.mStepSize)) : this.limitStepSize(this.mStepSize);
    }

    @Override
    protected final void computeOneStep(boolean bl) {
        this.mErrorCode = InterpolatorEventSolver.ERROR.NO_ERROR;
        int n = 0;
        while (n < 500) {
            if (bl) {
                switch (this.computeIntermediateStep(this.mEventSolver, this.mActualStepSize, this.mFinalState)) {
                    case DISCONTINUITY_PRODUCED_ERROR: {
                        this.mFinalTime = Double.NaN;
                        return;
                    }
                    case NO_DISCONTINUITY_ALONG_STEP: 
                    case DISCONTINUITY_EXACTLY_ON_STEP: {
                        this.mFinalTime = this.mFinalState[this.mTimeIndex];
                        break;
                    }
                    case DISCONTINUITY_ALONG_STEP: 
                    case DISCONTINUITY_JUST_PASSED: {
                        this.mFinalTime = this.findTheDiscontinuity(this.mActualStepSize);
                        this.mActualStepSize = this.mFinalTime - this.mInitialTime;
                    }
                }
                if (Double.isNaN(this.mFinalTime)) {
                    this.mErrorCode = InterpolatorEventSolver.ERROR.DISCONTINUITY_PRODUCED_ERROR;
                    return;
                }
            } else {
                this.computeIntermediateStep(this.mActualStepSize, this.mFinalState);
                this.mFinalTime = this.mFinalState[this.mTimeIndex];
            }
            double d = this.computeApproximation(this.mActualStepSize);
            this.mAccumulatedEvaluations += (long)this.getNumberOfEvaluations();
            if (d <= 1.0) {
                this.mStateHistory.clean(this.mInitialTime);
                this.mStateHistory.addIntervalData(this.computeFinalRateAndCreateIntervalData());
                this.mActualStepSize = n > 0 ? this.limitStepSize(this.mActualStepSize > 0.0 ? Math.min(this.mActualStepSize, this.estimatedStepSize(d)) : Math.max(this.mActualStepSize, this.estimatedStepSize(d))) : this.limitStepSize(this.estimatedStepSize(d));
                return;
            }
            this.mActualStepSize = this.limitStepSize(this.mActualStepSize > 0.0 ? Math.min(this.mActualStepSize, this.estimatedStepSize(d)) : Math.max(this.mActualStepSize, this.estimatedStepSize(d)));
            ++n;
        }
        this.mFinalTime = Double.NaN;
        this.mErrorCode = InterpolatorEventSolver.ERROR.DID_NOT_CONVERGE;
    }

    @Override
    protected double getActualStepSize() {
        return this.mActualStepSize;
    }

    protected final double computeError(double[] dArray) {
        double d = 0.0;
        int n = 0;
        while (n < this.mDimension) {
            double d2 = this.mAbsTol[n] + this.mRelTol[n] * Math.max(Math.abs(this.mFinalState[n]), Math.abs(this.mInitialState[n]));
            double d3 = (this.mFinalState[n] - dArray[n]) / d2;
            d += d3 * d3;
            ++n;
        }
        return Math.sqrt(d / (double)this.mDimension);
    }

    private double estimatedStepSize(double d) {
        double d2 = 0.0;
        if (d != 0.0) {
            d2 = Math.pow(d, this.mExpO1);
            this.mFactor = d2 / Math.exp(0.0 * Math.log(this.mErrOld));
            this.mFactor = Math.max(0.16666666666666666, Math.min(3.0303030303030303, this.mFactor / 0.9));
        } else {
            d2 = 3.0303030303030303;
            this.mFactor = 0.16666666666666666;
        }
        if (d <= 1.0) {
            this.mErrOld = Math.max(d, 1.0E-4);
            return this.mActualStepSize / this.mFactor;
        }
        return this.mActualStepSize / Math.min(3.0303030303030303, d2 / 0.9);
    }

    private final double limitStepSize(double d) {
        if (d >= 0.0) {
            if (this.mODE instanceof DelayDifferentialEquation) {
                double[] dArray = ((DelayDifferentialEquation)this.mODE).getDelays(this.mInitialState);
                int n = 0;
                int n2 = dArray.length;
                while (n < n2) {
                    d = Math.min(d, dArray[n] / 2.0);
                    ++n;
                }
            }
            return Math.min(d, this.mMaximumStepSize);
        }
        if (this.mODE instanceof DelayDifferentialEquation) {
            double[] dArray = ((DelayDifferentialEquation)this.mODE).getDelays(this.mInitialState);
            int n = 0;
            int n3 = dArray.length;
            while (n < n3) {
                d = Math.max(d, dArray[n] / 2.0);
                ++n;
            }
        }
        return Math.max(d, -this.mMaximumStepSize);
    }

    private final double estimateFirstStepSize(double d) {
        int n;
        int n2;
        int n3 = d < 0.0 ? -1 : 1;
        d = Math.abs(d);
        double d2 = 0.0;
        double d3 = 0.0;
        int n4 = 0;
        while (n4 < this.mDimension) {
            double d4 = this.mAbsTol[n4] + this.mRelTol[n4] * Math.abs(this.mInitialState[n4]);
            double d5 = this.mInitialRate[n4] / d4;
            d2 += d5 * d5;
            d5 = this.mInitialState[n4] / d4;
            d3 += d5 * d5;
            ++n4;
        }
        double d6 = d2 <= 1.0E-10 || d3 <= 1.0E-10 ? 1.0E-6 : Math.sqrt(d3 / d2) * 0.01;
        d6 = (double)n3 * Math.min(d6, d);
        if (this.mODE instanceof DelayDifferentialEquation) {
            this.mEventSolver.resetDiscontinuities(this.mInitialState);
            n2 = 0;
            boolean bl = false;
            while (!bl) {
                n = 0;
                while (n < this.mDimension) {
                    this.mFinalState[n] = this.mInitialState[n] + d6 * this.mInitialRate[n];
                    ++n;
                }
                switch (this.mEventSolver.checkDiscontinuity(this.mFinalState, false)) {
                    case DISCONTINUITY_PRODUCED_ERROR: {
                        return Double.NaN;
                    }
                    case DISCONTINUITY_ALONG_STEP: 
                    case DISCONTINUITY_JUST_PASSED: {
                        d6 /= 2.0;
                        break;
                    }
                    case DISCONTINUITY_EXACTLY_ON_STEP: {
                        bl = true;
                        break;
                    }
                    case NO_DISCONTINUITY_ALONG_STEP: {
                        bl = true;
                    }
                }
                if (++n2 <= 100) continue;
                return Double.NaN;
            }
        } else {
            n2 = 0;
            while (n2 < this.mDimension) {
                this.mFinalState[n2] = this.mInitialState[n2] + d6 * this.mInitialRate[n2];
                ++n2;
            }
        }
        this.mODE.getRate(this.mFinalState, this.mFinalRate);
        double d7 = 0.0;
        n = 0;
        while (n < this.mDimension) {
            double d8 = this.mAbsTol[n] + this.mRelTol[n] * Math.abs(this.mInitialState[n]);
            double d9 = (this.mFinalRate[n] - this.mInitialRate[n]) / d8;
            d7 += d9 * d9;
            ++n;
        }
        double d10 = Math.max(Math.abs(d7 = Math.sqrt(d7) / d6), Math.sqrt(d2));
        double d11 = d10 <= 1.0E-15 ? Math.max(1.0E-6, Math.abs(d6) * 0.001) : Math.exp(1.0 / this.getMethodOrder() * Math.log(0.01 / d10));
        d6 = (double)n3 * Math.min(100.0 * d6, d11);
        if (d != 0.0) {
            d6 = (double)n3 * Math.min(Math.abs(d6), d);
        }
        return d6;
    }
}

