/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.drawing2d;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.drawing2d.ElementSegment;

public class ElementArrow
extends ElementSegment {
    public static final int ARROW = 0;
    public static final int SEGMENT = 1;
    public static final int BOX = 2;
    public static final int TRIANGLE = 3;
    public static final int RHOMBUS = 4;
    private static final double ARROW_CST = 0.35;
    private static final double ARROW_MAX = 25.0;
    private int headPoints;
    private int[] headA;
    private int[] headB;
    private int[] secondHeadA;
    private int[] secondHeadB;

    public ElementArrow() {
        this.setSize(new double[]{0.1, 0.1});
        this.setArrowType(0);
        this.getStyle().setRelativePosition(5);
        this.headPoints = 0;
        this.headA = new int[7];
        this.headB = new int[7];
        this.secondHeadA = new int[4];
        this.secondHeadB = new int[4];
    }

    public void setArrowType(int n) {
        this.arrowType = n;
        this.setNeedToProject(true);
    }

    public int getArrowType() {
        return this.arrowType;
    }

    @Override
    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.isReallyVisible()) {
            return;
        }
        if (this.hasChanged() || this.needsToProject()) {
            this.projectPoints();
        }
        this.drawHead((Graphics2D)graphics);
    }

    @Override
    protected void projectPoints() {
        super.projectPoints();
        if (this.arrowType == 1) {
            this.headPoints = 2;
            this.headA[0] = (int)this.pixelOrigin[0];
            this.headB[0] = (int)this.pixelOrigin[1];
            this.headA[1] = (int)this.pixelEnd[0];
            this.headB[1] = (int)this.pixelEnd[1];
            return;
        }
        double d = this.pixelEnd[0] - this.pixelOrigin[0];
        double d2 = this.pixelEnd[1] - this.pixelOrigin[1];
        double d3 = Math.sqrt(d * d + d2 * d2);
        if (d3 == 0.0) {
            this.headPoints = 2;
            this.headA[0] = (int)this.pixelOrigin[0];
            this.headB[0] = (int)this.pixelOrigin[1];
            this.headA[1] = (int)this.pixelEnd[0];
            this.headB[1] = (int)this.pixelEnd[1];
            return;
        }
        d = 0.35 * d / d3;
        d2 = 0.35 * d2 / d3;
        if (this.arrowType == 4) {
            d *= 0.9;
            d2 *= 0.9;
        } else if (this.arrowType == 3) {
            d *= 2.0;
            d2 *= 2.0;
        } else if (d3 > 25.0) {
            d *= 25.0 / d3;
            d2 *= 25.0 / d3;
        }
        double d4 = this.pixelEnd[0] - d * d3;
        double d5 = this.pixelEnd[1] - d2 * d3;
        d *= d3 / 2.0;
        d2 *= d3 / 2.0;
        switch (this.arrowType) {
            default: {
                this.headPoints = 6;
                this.headA[0] = (int)d4;
                this.headB[0] = (int)d5;
                this.headA[1] = (int)(d4 - d2);
                this.headB[1] = (int)(d5 + d);
                this.headA[2] = (int)this.pixelEnd[0];
                this.headB[2] = (int)this.pixelEnd[1];
                this.headA[3] = (int)(d4 + d2);
                this.headB[3] = (int)(d5 - d);
                this.headA[4] = (int)d4;
                this.headB[4] = (int)d5;
                this.headA[5] = (int)this.pixelOrigin[0];
                this.headB[5] = (int)this.pixelOrigin[1];
                break;
            }
            case 2: {
                this.headPoints = 7;
                this.headA[0] = (int)d4;
                this.headB[0] = (int)d5;
                this.headA[1] = (int)(d4 - d2);
                this.headB[1] = (int)(d5 + d);
                this.headA[2] = (int)(this.pixelEnd[0] - d2);
                this.headB[2] = (int)(this.pixelEnd[1] + d);
                this.headA[3] = (int)(this.pixelEnd[0] + d2);
                this.headB[3] = (int)(this.pixelEnd[1] - d);
                this.headA[4] = (int)(d4 + d2);
                this.headB[4] = (int)(d5 - d);
                this.headA[5] = (int)d4;
                this.headB[5] = (int)d5;
                this.headA[6] = (int)this.pixelOrigin[0];
                this.headB[6] = (int)this.pixelOrigin[1];
                break;
            }
            case 3: {
                this.headPoints = 4;
                this.headA[0] = (int)(this.pixelOrigin[0] - d2);
                this.headB[0] = (int)(this.pixelOrigin[1] + d);
                this.headA[1] = (int)(this.pixelOrigin[0] + d2);
                this.headB[1] = (int)(this.pixelOrigin[1] - d);
                this.headA[2] = (int)this.pixelEnd[0];
                this.headB[2] = (int)this.pixelEnd[1];
                this.headA[3] = this.headA[0];
                this.headB[3] = this.headB[0];
                break;
            }
            case 4: {
                double d6 = (this.pixelOrigin[0] + this.pixelEnd[0]) / 2.0;
                double d7 = (this.pixelOrigin[1] + this.pixelEnd[1]) / 2.0;
                this.headPoints = 4;
                this.headA[0] = (int)this.pixelEnd[0];
                this.headB[0] = (int)this.pixelEnd[1];
                this.headA[1] = (int)(d6 - d2);
                this.headB[1] = (int)(d7 + d);
                this.headA[2] = (int)(d6 + d2);
                this.headB[2] = (int)(d7 - d);
                this.headA[3] = this.headA[0];
                this.headB[3] = this.headB[0];
                this.secondHeadA[0] = (int)this.pixelOrigin[0];
                this.secondHeadB[0] = (int)this.pixelOrigin[1];
                this.secondHeadA[1] = this.headA[1];
                this.secondHeadB[1] = this.headB[1];
                this.secondHeadA[2] = this.headA[2];
                this.secondHeadB[2] = this.headB[2];
                this.secondHeadA[3] = this.secondHeadA[0];
                this.secondHeadB[3] = this.secondHeadB[0];
            }
        }
    }

    private void drawHead(Graphics2D graphics2D) {
        Paint paint = this.getStyle().getFillColor();
        graphics2D.setStroke(this.getStyle().getLineStroke());
        if (this.arrowType == 4) {
            Color color;
            if (paint != null) {
                graphics2D.setPaint(paint);
                graphics2D.fillPolygon(this.headA, this.headB, 4);
            }
            if ((color = this.getStyle().getExtraColor()) != null) {
                graphics2D.setPaint(color);
                graphics2D.fillPolygon(this.secondHeadA, this.secondHeadB, 4);
            }
            return;
        }
        if (this.headPoints > 2 && paint != null && this.getStyle().isDrawingFill()) {
            graphics2D.setPaint(paint);
            graphics2D.fillPolygon(this.headA, this.headB, this.headPoints - 1);
        }
        graphics2D.setColor(this.getStyle().getLineColor());
        graphics2D.drawPolyline(this.headA, this.headB, this.headPoints);
    }
}

