/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.colos.ejs.library.control.ConstantParser;
import org.colos.ejs.library.control.swing.ControlSwingElement;
import org.colos.ejs.library.control.value.DoubleValue;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.display.TeXParser;

public class ControlNumberField
extends ControlSwingElement {
    private static final int NUMBER_FIELD_ADDED = 6;
    protected static final int VARIABLE = 0;
    protected static final int VALUE = 1;
    private static final int FIELD_BACKGROUND = 13;
    private static final int FIELD_FOREGROUND = 12;
    protected static final DecimalFormat defaultFormat = new DecimalFormat("0.000;0.000");
    protected JTextField textfield;
    protected DoubleValue internalValue;
    protected double defaultValue;
    protected boolean defaultValueSet;
    protected int defaultColumns;
    protected DecimalFormat format;
    protected String formatStr = null;
    protected boolean foregroundSet;
    protected Color defaultColor;
    protected Color editingColor;
    protected Color errorColor;
    private static List<String> infoList = null;

    protected void fixTheFormat(DecimalFormat decimalFormat) {
    }

    @Override
    protected Component createVisual() {
        this.textfield = new JTextField();
        this.fixTheFormat(defaultFormat);
        this.format = defaultFormat;
        this.defaultValue = 0.0;
        this.defaultValueSet = false;
        this.defaultColumns = this.textfield.getColumns();
        this.internalValue = new DoubleValue(this.defaultValue);
        this.textfield.setText(this.format.format(this.internalValue.value));
        this.textfield.addActionListener(new MyActionListener());
        this.textfield.addKeyListener(new MyKeyListener());
        this.textfield.setBackground(Color.WHITE);
        this.textfield.setForeground(Color.BLACK);
        this.foregroundSet = false;
        this.decideColors(this.textfield.getBackground());
        return this.textfield;
    }

    @Override
    public void reset() {
        if (this.defaultValueSet) {
            this.setTheValue(this.defaultValue);
            this.setInternalValue(this.defaultValue);
        }
    }

    private void setTheValue(double d) {
        if (d != this.internalValue.value) {
            this.internalValue.value = d;
            if (SwingUtilities.isEventDispatchThread()) {
                this.textfield.setText(this.format.format(d));
                this.getVisual().setBackground(this.defaultColor);
            } else {
                final String string = this.format.format(d);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public synchronized void run() {
                        ControlNumberField.this.textfield.setText(string);
                        ControlNumberField.this.getVisual().setBackground(ControlNumberField.this.defaultColor);
                    }
                });
            }
        }
    }

    protected void setInternalValue(double d) {
        this.internalValue.value = d;
        this.variableChanged(0, this.internalValue);
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("variable");
            infoList.add("value");
            infoList.add("editable");
            infoList.add("format");
            infoList.add("action");
            infoList.add("columns");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("variable")) {
            return "int|double";
        }
        if (string.equals("value")) {
            return "int|double CONSTANT DEPRECATED";
        }
        if (string.equals("editable")) {
            return "boolean";
        }
        if (string.equals("format")) {
            return "Format|Object|String TRANSLATABLE";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("columns")) {
            return "int";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.setTheValue(value.getDouble());
                break;
            }
            case 1: {
                this.defaultValueSet = true;
                this.defaultValue = value.getDouble();
                this.setActive(false);
                this.reset();
                this.setActive(true);
                break;
            }
            case 2: {
                if (value.getBoolean()) {
                    this.textfield.setEditable(true);
                    if (this.foregroundSet) break;
                    this.textfield.setForeground(Color.BLACK);
                    break;
                }
                this.textfield.setEditable(false);
                if (this.foregroundSet) break;
                this.textfield.setForeground(Color.GRAY);
                break;
            }
            case 3: {
                DecimalFormat decimalFormat = null;
                if (value.getObject() instanceof DecimalFormat) {
                    decimalFormat = (DecimalFormat)value.getObject();
                    this.fixTheFormat(decimalFormat);
                    this.formatStr = null;
                } else {
                    String string = TeXParser.parseTeX(value.getString());
                    if (string.equals(this.formatStr)) {
                        return;
                    }
                    this.formatStr = string;
                    decimalFormat = (DecimalFormat)ConstantParser.formatConstant(this.formatStr).getObject();
                    this.fixTheFormat(decimalFormat);
                }
                if (decimalFormat.equals(this.format)) {
                    return;
                }
                this.format = decimalFormat;
                if (SwingUtilities.isEventDispatchThread()) {
                    this.textfield.setText(this.format.format(this.internalValue.value));
                    break;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public synchronized void run() {
                        ControlNumberField.this.textfield.setText(ControlNumberField.this.format.format(ControlNumberField.this.internalValue.value));
                    }
                });
                break;
            }
            case 4: {
                this.removeAction(1, this.getProperty("action"));
                this.addAction(1, value.getString());
                break;
            }
            case 5: {
                if (value.getInteger() == this.textfield.getColumns()) break;
                this.textfield.setColumns(value.getInteger());
                if (this.textfield.getParent() == null) break;
                this.textfield.getParent().validate();
                break;
            }
            case 13: {
                super.setValue(7, value);
                this.decideColors(this.getVisual().getBackground());
                this.setColor(this.defaultColor);
                break;
            }
            case 12: {
                super.setValue(6, value);
                this.foregroundSet = true;
                break;
            }
            default: {
                super.setValue(n - 6, value);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return "<none>";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "0.000;0.000";
            }
            case 4: {
                return "<no_action>";
            }
            case 5: {
                return Integer.toString(this.defaultColumns);
            }
            default: {
                return super.getDefaultValueString(n - 6);
            }
            case 13: {
                return "WHITE";
            }
            case 12: 
        }
        return "BLACK/GRAY";
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                break;
            }
            case 1: {
                this.defaultValueSet = false;
                break;
            }
            case 2: {
                this.textfield.setEditable(true);
                if (this.foregroundSet) break;
                this.textfield.setForeground(Color.BLACK);
                break;
            }
            case 3: {
                this.format = defaultFormat;
                this.formatStr = null;
                Runnable runnable = new Runnable(){

                    @Override
                    public synchronized void run() {
                        ControlNumberField.this.textfield.setText(ControlNumberField.this.format.format(ControlNumberField.this.internalValue.value));
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    runnable.run();
                    break;
                }
                SwingUtilities.invokeLater(runnable);
                break;
            }
            case 4: {
                this.removeAction(1, this.getProperty("action"));
                break;
            }
            case 5: {
                this.textfield.setColumns(this.defaultColumns);
                if (this.textfield.getParent() == null) break;
                this.textfield.getParent().validate();
                break;
            }
            case 13: {
                super.setDefaultValue(7);
                this.decideColors(this.getVisual().getBackground());
                this.setColor(this.defaultColor);
                break;
            }
            case 12: {
                super.setDefaultValue(6);
                this.foregroundSet = false;
                break;
            }
            default: {
                super.setDefaultValue(n - 6);
            }
        }
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return this.internalValue;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 6);
    }

    protected void setColor(Color color) {
        this.textfield.setBackground(color);
    }

    protected void decideColors(Color color) {
        if (color == null) {
            return;
        }
        this.defaultColor = color;
        this.editingColor = this.defaultColor.equals(Color.yellow) ? Color.orange : Color.yellow;
        this.errorColor = this.defaultColor.equals(Color.red) ? Color.magenta : Color.red;
    }

    protected void acceptValue() {
        this.setColor(this.defaultColor);
        try {
            this.setInternalValue(this.format.parse(this.textfield.getText()).doubleValue());
            if (this.isUnderEjs) {
                this.setFieldListValueWithAlternative(0, 1, this.internalValue);
            }
        }
        catch (Exception exception) {
            this.setColor(this.errorColor);
        }
    }

    protected class MyActionListener
    implements ActionListener {
        protected MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ControlNumberField.this.textfield.isEditable()) {
                ControlNumberField.this.acceptValue();
            }
        }
    }

    protected class MyKeyListener
    implements KeyListener {
        protected MyKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 0);
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 1);
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            this.processKeyEvent(keyEvent, 2);
        }

        private void processKeyEvent(KeyEvent keyEvent, int n) {
            if (!ControlNumberField.this.textfield.isEditable()) {
                return;
            }
            if (keyEvent.getKeyChar() != '\n') {
                ControlNumberField.this.setColor(ControlNumberField.this.editingColor);
            }
            if (keyEvent.getKeyCode() == 27) {
                ControlNumberField.this.setValue(0, ControlNumberField.this.internalValue);
            }
        }
    }
}

