/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library.control.drawing2d;

import java.util.ArrayList;
import java.util.List;
import org.colos.ejs.library.control.drawing2d.ControlSet2D;
import org.colos.ejs.library.control.value.Value;
import org.opensourcephysics.drawing2d.Element;
import org.opensourcephysics.drawing2d.ElementShape;

public class ControlShapeSet2D
extends ControlSet2D {
    private static final int PROPERTIES_ADDED = 3;
    static List<String> infoList = null;

    @Override
    protected int getPropertiesAddedToSet() {
        return 3;
    }

    @Override
    protected Element createAnElement() {
        ElementShape elementShape = new ElementShape();
        return elementShape;
    }

    @Override
    protected void copyAnElement(Element element, Element element2) {
        super.copyAnElement(element, element2);
        ((ElementShape)element2).setShapeType(((ElementShape)element).getShapeType());
        ((ElementShape)element2).setPixelSize(((ElementShape)element).isPixelSize());
    }

    @Override
    public List<String> getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList<String>();
            infoList.add("style");
            infoList.add("pixelSize");
            infoList.add("elementposition");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    @Override
    public String getPropertyInfo(String string) {
        if (string.equals("style")) {
            return "MarkerShape|int|int[]";
        }
        if (string.equals("pixelSize")) {
            return "boolean|boolean[]";
        }
        if (string.equals("elementposition")) {
            return "ElementPosition|int|int[]";
        }
        return super.getPropertyInfo(string);
    }

    @Override
    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n2 = 0;
                    int n3 = Math.min(this.elements.length, nArray.length);
                    while (n2 < n3) {
                        ((ElementShape)this.elements[n2]).setShapeType(nArray[n2]);
                        ++n2;
                    }
                } else {
                    int n4 = value.getInteger();
                    int n5 = 0;
                    while (n5 < this.elements.length) {
                        ((ElementShape)this.elements[n5]).setShapeType(n4);
                        ++n5;
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n6 = 0;
                    int n7 = Math.min(this.elements.length, blArray.length);
                    while (n6 < n7) {
                        ((ElementShape)this.elements[n6]).setPixelSize(blArray[n6]);
                        ++n6;
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n8 = 0;
                    while (n8 < this.elements.length) {
                        ((ElementShape)this.elements[n8]).setPixelSize(bl);
                        ++n8;
                    }
                }
                break;
            }
            case 2: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n9 = 0;
                    int n10 = Math.min(this.elements.length, nArray.length);
                    while (n9 < n10) {
                        this.elements[n9].getStyle().setRelativePosition(nArray[n9]);
                        ++n9;
                    }
                } else {
                    int n11 = value.getInteger();
                    int n12 = 0;
                    while (n12 < this.elements.length) {
                        this.elements[n12].getStyle().setRelativePosition(n11);
                        ++n12;
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 3, value);
            }
        }
    }

    @Override
    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = 0;
                while (n2 < this.elements.length) {
                    ((ElementShape)this.elements[n2]).setShapeType(1);
                    ++n2;
                }
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 < this.elements.length) {
                    ((ElementShape)this.elements[n3]).setPixelSize(false);
                    ++n3;
                }
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.elements.length) {
                    this.elements[n4].getStyle().setRelativePosition(0);
                    ++n4;
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 3);
            }
        }
    }

    @Override
    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "ELLIPSE";
            }
            case 1: {
                return "false";
            }
            case 2: {
                return "CENTERED";
            }
        }
        return super.getDefaultValueString(n - 3);
    }

    @Override
    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                return null;
            }
        }
        return super.getValue(n - 3);
    }
}

