/*
 * Decompiled with CFR 0.152.
 */
package org.colos.ejs.library;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.Timer;
import org.colos.ejs.library.MoodleLink;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.utils.SwingWorker;
import org.opensourcephysics.tools.ResourceLoader;

public class MoodleConnection
implements MoodleLink {
    static ImageIcon moodleIcon = ResourceLoader.getIcon("org/colos/ejs/library/resources/Moodle.png");
    private URL moodle_upload_file = null;
    private URL send_files_list = null;
    private String ejsapp_id = null;
    private String user_id = null;
    private String context_id = null;
    private String moodle_lang = null;
    private String moodle_user = null;
    private String moodle_pass = null;
    private Component parentComponent = null;
    private Simulation simulation = null;
    private SavePanel savePanel = new SavePanel();
    private ReadPanel readPanel = new ReadPanel();
    private ProgressDialog progressMonitor;
    private LongTask task;
    private Timer timer;
    private int previous;

    public MoodleConnection(JApplet jApplet, Simulation simulation) {
        this.simulation = simulation;
        String string = jApplet.getParameter("moodle_upload_file");
        int n = string.indexOf("upload_file.php");
        String string2 = String.valueOf(string.substring(0, n)) + "send_files_list.php";
        try {
            this.moodle_upload_file = new URL(string);
            this.context_id = jApplet.getParameter("context_id");
            this.user_id = jApplet.getParameter("user_id");
            this.ejsapp_id = jApplet.getParameter("ejsapp_id");
            this.moodle_lang = jApplet.getParameter("language");
            this.moodle_user = jApplet.getParameter("user_moodle");
            this.moodle_pass = jApplet.getParameter("password_moodle");
            simulation.setLocale(this.moodle_lang);
            System.out.println("Connected to Moodle\n");
        }
        catch (MalformedURLException malformedURLException) {
            if (this.moodle_upload_file != null) {
                System.out.println("Malformed URL exception for URL = <" + string + ">");
            }
            this.moodle_upload_file = null;
        }
        try {
            this.send_files_list = new URL(string2);
        }
        catch (MalformedURLException malformedURLException) {
            if (this.send_files_list != null) {
                System.out.println("Malformed URL exception for URL = <" + string2 + ">");
            }
            this.send_files_list = null;
        }
        if (this.context_id == null) {
            System.out.println("context_id parameter was not found");
        }
        if (this.user_id == null) {
            System.out.println("user_id parameter was not found");
        }
        if (this.ejsapp_id == null) {
            System.out.println("ejsapp_id parameter was not found");
        }
        if (this.moodle_lang == null) {
            System.out.println("language parameter was not found");
        }
        if (this.moodle_user == null) {
            System.out.println("username parameter was not found");
        }
        if (this.moodle_pass == null) {
            System.out.println("password parameter was not found");
        }
    }

    @Override
    public boolean isConnected() {
        return this.moodle_upload_file != null && this.send_files_list != null;
    }

    @Override
    public void setParentComponent(Component component) {
        this.parentComponent = component;
    }

    @Override
    public void setNameLabel(String string) {
        this.savePanel.nameLabel.setText(string);
    }

    @Override
    public void setAnnotationLabel(String string) {
        this.savePanel.annotationLabel.setText(string);
    }

    private void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Delay interrupted!");
        }
    }

    @Override
    public String saveBinary(String string, String string2, byte[] byArray) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        this.task = new LongTask(string, string2, byArray);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    @Override
    public String saveImage(String string, String string2, Image image) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        int n = string.lastIndexOf(46);
        if (n == 0) {
            string = String.valueOf(string) + ".gif";
        }
        if ((string = n > 0 ? String.valueOf(string.substring(0, n)) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + string.substring(n) : String.valueOf(string) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + ".gif").length() <= 0) {
            return null;
        }
        this.task = new LongTask(string, string2, image);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    @Override
    public String saveText(String string, String string2, String string3) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        int n = string.lastIndexOf(46);
        if (n == 0) {
            string = String.valueOf(string) + ".txt";
        }
        if ((string = n > 0 ? String.valueOf(string.substring(0, n)) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + string.substring(n) : String.valueOf(string) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + ".txt").length() <= 0) {
            return null;
        }
        this.task = new LongTask(string, string2, string3, true);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    @Override
    public String saveXML(String string, String string2, String string3) {
        if (!this.isConnected()) {
            return null;
        }
        if (!this.savePanel.showSaveOptions(string, string2)) {
            return null;
        }
        string = this.savePanel.nameField.getText().trim();
        if (string.length() <= 0) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == 0) {
            string = String.valueOf(string) + ".xml";
        }
        if ((string = n > 0 ? String.valueOf(string.substring(0, n)) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + string.substring(n) : String.valueOf(string) + "_context_id_" + this.context_id + "_user_id_" + this.user_id + "_ejsapp_id_" + this.ejsapp_id + ".xml").length() <= 0) {
            return null;
        }
        this.task = new LongTask(string, string2, string3, false);
        this.timer = new Timer(100, new TimerListener());
        if (this.progressMonitor == null) {
            this.progressMonitor = new ProgressDialog();
            this.progressMonitor.showProgressDialog(true);
        }
        this.task.go();
        this.timer.start();
        return string;
    }

    @Override
    public byte[] readBinary(String string) {
        if (!this.isConnected()) {
            return null;
        }
        return null;
    }

    @Override
    public String readText(String string) {
        String string2;
        if (!this.isConnected()) {
            return null;
        }
        if (string == "") {
            try {
                URLConnection uRLConnection = this.send_files_list.openConnection();
                uRLConnection.setDoOutput(true);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
                outputStreamWriter.write("ejsapp_id=" + this.ejsapp_id + "&type=text");
                outputStreamWriter.flush();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                string = bufferedReader.readLine();
                outputStreamWriter.close();
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.out.println("CAN'T OPEN CONNECTION: " + exception);
            }
            string2 = "url:" + this.readPanel.chooseFile(string);
        } else {
            string2 = string;
        }
        return string2;
    }

    @Override
    public String readXML(String string) {
        String string2;
        if (!this.isConnected()) {
            return null;
        }
        if (string == null) {
            try {
                URLConnection uRLConnection = this.send_files_list.openConnection();
                uRLConnection.setDoOutput(true);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(uRLConnection.getOutputStream());
                outputStreamWriter.write("ejsapp_id=" + this.ejsapp_id + "&type=.xml");
                outputStreamWriter.flush();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                string = bufferedReader.readLine();
                outputStreamWriter.close();
                bufferedReader.close();
            }
            catch (Exception exception) {
                System.out.println("CAN'T OPEN CONNECTION: " + exception);
            }
            string2 = "url:" + this.readPanel.chooseFile(string);
        } else {
            string2 = string;
        }
        return string2;
    }

    @Override
    public Image readImage(String string) {
        if (!this.isConnected()) {
            return null;
        }
        return null;
    }

    private BufferedImage toBufferedImage(Image image) {
        int n;
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean bl = MoodleConnection.hasAlpha(image);
        BufferedImage bufferedImage = null;
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            n = 1;
            if (bl) {
                n = 2;
            }
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            bufferedImage = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null), n);
        }
        catch (HeadlessException headlessException) {}
        if (bufferedImage == null) {
            n = 1;
            if (bl) {
                n = 2;
            }
            bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), n);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            return ((BufferedImage)image).getColorModel().hasAlpha();
        }
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {}
        return pixelGrabber.getColorModel().hasAlpha();
    }

    private void httpRequest(String string, String string2, byte[] byArray, Image image) {
        String string3 = "\r\n";
        String string4 = "--";
        String string5 = "***232404jkg4220957934FW**";
        try {
            Object object;
            URLConnection uRLConnection = this.moodle_upload_file.openConnection();
            ((HttpURLConnection)uRLConnection).setRequestMethod("POST");
            uRLConnection.setDoInput(true);
            uRLConnection.setDoOutput(true);
            uRLConnection.setUseCaches(false);
            uRLConnection.setRequestProperty("Connection", "Keep-Alive");
            uRLConnection.setRequestProperty("Content-Type", "multipart/form-data;boundary=" + string5);
            DataOutputStream dataOutputStream = new DataOutputStream(uRLConnection.getOutputStream());
            dataOutputStream.writeBytes(String.valueOf(string4) + string5 + string3);
            dataOutputStream.writeBytes("Content-Disposition: form-data; name=\"user_file\"; filename=\"" + string + "\"" + string3);
            dataOutputStream.writeBytes(string3);
            if (string2 != null) {
                dataOutputStream.writeBytes(string2);
            }
            if (byArray != null) {
                dataOutputStream.write(byArray);
            }
            if (image != null) {
                object = this.toBufferedImage(image);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)object, "gif", byteArrayOutputStream);
                byteArrayOutputStream.flush();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                byteArrayOutputStream.close();
                dataOutputStream.write(byArray2);
            }
            dataOutputStream.writeBytes(string3);
            dataOutputStream.writeBytes(String.valueOf(string4) + string5 + string4 + string3);
            object = new DataInputStream(uRLConnection.getInputStream());
            ((FilterInputStream)object).close();
            dataOutputStream.flush();
            dataOutputStream.close();
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println("CLIENT REQUEST: " + malformedURLException);
        }
        catch (IOException iOException) {
            System.out.println("CLIENT REQUEST: " + iOException);
        }
    }

    private Component getParentComponent() {
        if (this.simulation != null) {
            return this.simulation.getParentComponent();
        }
        return this.parentComponent;
    }

    private void showException(Exception exception) {
        exception.printStackTrace();
        System.out.println("A dialog should appear now");
        JOptionPane.showMessageDialog(this.getParentComponent(), exception.getLocalizedMessage());
    }

    static /* synthetic */ void access$1(MoodleConnection moodleConnection, int n) {
        moodleConnection.delay(n);
    }

    static /* synthetic */ void access$2(MoodleConnection moodleConnection, String string, String string2, byte[] byArray, Image image) {
        moodleConnection.httpRequest(string, string2, byArray, image);
    }

    static /* synthetic */ void access$3(MoodleConnection moodleConnection, Exception exception) {
        moodleConnection.showException(exception);
    }

    private class LongTask {
        private int lengthOfTask;
        private int current = 0;
        private String statMessage;
        private String filename;
        private String annotation;
        private Image image;
        private String txt;
        private byte[] data;
        private boolean isText;
        private String kindFragment;
        private boolean isOk = false;

        LongTask(String string, String string2, Image image) {
            this.kindFragment = "image";
            this.filename = string;
            this.annotation = string2;
            this.image = image;
            this.lengthOfTask = 100;
        }

        LongTask(String string, String string2, String string3, boolean bl) {
            this.kindFragment = "text";
            this.filename = string;
            this.annotation = string2;
            this.txt = string3;
            this.isText = bl;
            this.lengthOfTask = 100;
        }

        LongTask(String string, String string2, byte[] byArray) {
            this.kindFragment = "data";
            this.filename = string;
            this.annotation = string2;
            this.data = byArray;
            this.lengthOfTask = 100;
        }

        void go() {
            this.current = 0;
            new SwingWorker(){

                @Override
                public Object construct() {
                    if (LongTask.this.kindFragment.equals("image")) {
                        return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.image);
                    }
                    if (LongTask.this.kindFragment.equals("text")) {
                        return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.txt, LongTask.this.isText);
                    }
                    return new ActualTask(LongTask.this, LongTask.this.filename, LongTask.this.annotation, LongTask.this.data);
                }
            };
        }

        int getCurrent() {
            return this.current;
        }

        void stop() {
            this.current = this.lengthOfTask;
        }

        boolean getStatus() {
            return this.isOk;
        }

        boolean done() {
            return this.current >= this.lengthOfTask;
        }

        String getMessage() {
            return this.statMessage;
        }

        static /* synthetic */ void access$0(LongTask longTask, int n) {
            longTask.current = n;
        }

        static /* synthetic */ int access$1(LongTask longTask) {
            return longTask.current;
        }

        static /* synthetic */ void access$2(LongTask longTask, String string) {
            longTask.statMessage = string;
        }

        static /* synthetic */ int access$3(LongTask longTask) {
            return longTask.lengthOfTask;
        }

        static /* synthetic */ void access$4(LongTask longTask, boolean bl) {
            longTask.isOk = bl;
        }

        static /* synthetic */ MoodleConnection access$12(LongTask longTask) {
            return longTask.MoodleConnection.this;
        }

        /*
         * Exception performing whole class analysis.
         */
        class ActualTask {
            final /* synthetic */ LongTask this$1;

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String var2_2, String var3_3, Image var4_4) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        var5_5 = 0;
                        while (var5_5 < 50) {
                            LongTask.access$0(var1_1, var5_5);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + 100 + "%.");
                            ++var5_5;
                        }
                        MoodleConnection.access$2(LongTask.access$12(var1_1), var2_2, null, null, var4_4);
                        var5_5 = 50;
                        while (var5_5 < 101) {
                            LongTask.access$0(var1_1, var5_5);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++var5_5;
                        }
                        break block5;
                    }
                    catch (Exception var5_6) {
                        MoodleConnection.access$3(LongTask.access$12(var1_1), var5_6);
                        var6_7 = 50;
                        ** while (var6_7 < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, var6_7);
                        MoodleConnection.access$1(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++var6_7;
                        continue;
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String var2_2, String var3_3, String var4_4, boolean var5_5) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        var6_6 = 0;
                        while (var6_6 < 50) {
                            LongTask.access$0(var1_1, var6_6);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            ++var6_6;
                        }
                        MoodleConnection.access$2(LongTask.access$12(var1_1), var2_2, var4_4, null, null);
                        var6_6 = 50;
                        while (var6_6 < 101) {
                            LongTask.access$0(var1_1, var6_6);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++var6_6;
                        }
                        break block5;
                    }
                    catch (Exception var6_7) {
                        MoodleConnection.access$3(LongTask.access$12(var1_1), var6_7);
                        var7_8 = 50;
                        ** while (var7_8 < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, var7_8);
                        MoodleConnection.access$1(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++var7_8;
                        continue;
                    }
                }
            }

            /*
             * Unable to fully structure code
             */
            ActualTask(LongTask var1_1, String var2_2, String var3_3, byte[] var4_4) {
                block5: {
                    this.this$1 = var1_1;
                    super();
                    try {
                        var5_5 = 0;
                        while (var5_5 < 50) {
                            LongTask.access$0(var1_1, var5_5);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 20);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            ++var5_5;
                        }
                        MoodleConnection.access$2(LongTask.access$12(var1_1), var2_2, null, var4_4, null);
                        var5_5 = 50;
                        while (var5_5 < 101) {
                            LongTask.access$0(var1_1, var5_5);
                            MoodleConnection.access$1(LongTask.access$12(var1_1), 50);
                            LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                            LongTask.access$4(var1_1, true);
                            ++var5_5;
                        }
                        break block5;
                    }
                    catch (Exception var5_6) {
                        MoodleConnection.access$3(LongTask.access$12(var1_1), var5_6);
                        var6_7 = 50;
                        ** while (var6_7 < 101)
                    }
lbl-1000:
                    // 1 sources

                    {
                        LongTask.access$0(var1_1, var6_7);
                        MoodleConnection.access$1(LongTask.access$12(var1_1), 10);
                        LongTask.access$2(var1_1, "Completed " + LongTask.access$1(var1_1) + "% out of " + LongTask.access$3(var1_1) + "%.");
                        LongTask.access$4(var1_1, false);
                        ++var6_7;
                        continue;
                    }
                }
            }
        }
    }

    private class ModifiableJOptionPane
    extends JOptionPane {
        private boolean resizable;

        public ModifiableJOptionPane(Object object, int n, int n2, Icon icon) {
            super(object, n, n2, icon);
        }

        @Override
        public JDialog createDialog(Component component, String string) throws HeadlessException {
            JDialog jDialog = super.createDialog(component, string);
            jDialog.setResizable(this.isResizable());
            return jDialog;
        }

        @Override
        public JInternalFrame createInternalFrame(Component component, String string) {
            JInternalFrame jInternalFrame = super.createInternalFrame(component, string);
            jInternalFrame.setResizable(this.isResizable());
            return jInternalFrame;
        }

        public void setResizable(boolean bl) {
            this.resizable = bl;
        }

        public boolean isResizable() {
            return this.resizable;
        }
    }

    class ProgressDialog
    extends JDialog {
        private JProgressBar progressBar;
        private JLabel msg;
        private JLabel note;

        public ProgressDialog() {
            super(JOptionPane.getFrameForComponent(MoodleConnection.this.getParentComponent()), "Progress");
            this.progressBar = new JProgressBar(0, 100);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.msg = new JLabel("Monitoring the Delivery");
            this.note = new JLabel("Initializing progress...");
            JPanel jPanel = new JPanel(new GridLayout(3, 0));
            jPanel.add(this.msg);
            jPanel.add(this.note);
            jPanel.add(this.progressBar);
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setContentPane(jPanel);
            this.setSize(380, 120);
            this.setLocation(300, 300);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    ProgressDialog.this.dispose();
                    MoodleConnection.this.progressMonitor.dispose();
                    MoodleConnection.this.progressMonitor = null;
                }
            });
        }

        public void setProgress(int n) {
            this.progressBar.setValue(n);
        }

        public void setNote(String string) {
            this.note.setText(string);
        }

        public void showProgressDialog(boolean bl) {
            this.setVisible(bl);
        }

        public void setBarIndeterminate(boolean bl) {
            this.progressBar.setIndeterminate(bl);
        }

        public void setBarString(String string) {
            this.progressBar.setString(string);
        }
    }

    private class ReadPanel
    extends JPanel {
        String filesLabel = "List of files saved with this lab";
        String loadFile = "Moodle - Load from EJSApp File Browser";
        JLabel filesJLabel = new JLabel(this.filesLabel);
        DefaultListModel<String> listModel = new DefaultListModel();
        JList<String> list = new JList<String>(this.listModel);

        ReadPanel() {
            this.list.setSelectionMode(0);
            JPanel jPanel = new JPanel(new GridLayout(0, 1));
            jPanel.add(this.filesJLabel);
            JScrollPane jScrollPane = new JScrollPane(this.list);
            this.setLayout(new BorderLayout());
            this.add((Component)jScrollPane, "Center");
            this.add((Component)jPanel, "North");
        }

        String chooseFile(String string) {
            String string2 = "";
            this.listModel.clear();
            ModifiableJOptionPane modifiableJOptionPane = new ModifiableJOptionPane(this, -1, 2, moodleIcon);
            modifiableJOptionPane.setResizable(true);
            if (string != null) {
                String[] stringArray = string.split(";");
                String[] stringArray2 = new String[(stringArray.length + 1) / 2];
                int n = 0;
                while (n <= (stringArray.length - 1) / 2) {
                    this.listModel.add(n, stringArray[2 * n]);
                    stringArray2[n] = stringArray[2 * n + 1];
                    ++n;
                }
                JDialog jDialog = modifiableJOptionPane.createDialog(MoodleConnection.this.getParentComponent(), this.loadFile);
                jDialog.setResizable(true);
                jDialog.setContentPane(modifiableJOptionPane);
                jDialog.setVisible(true);
                Object object = modifiableJOptionPane.getValue();
                Integer n2 = 0;
                int n3 = this.list.getSelectedIndex();
                if (object == n2 && n3 >= 0) {
                    string2 = stringArray2[n3];
                }
            } else {
                JDialog jDialog = modifiableJOptionPane.createDialog(MoodleConnection.this.getParentComponent(), this.loadFile);
                jDialog.setResizable(true);
                jDialog.setContentPane(modifiableJOptionPane);
                jDialog.setVisible(true);
            }
            return string2;
        }
    }

    private class SavePanel
    extends JPanel {
        String saveFile = "Moodle - Save to EJSApp File Browser";
        JLabel nameLabel = new JLabel("Name");
        JLabel annotationLabel;
        JPanel leftPanel;
        JPanel rightPanel;
        JTextField nameField;
        JTextField annotationField;

        SavePanel() {
            this.nameLabel.setHorizontalAlignment(0);
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.nameField = new JTextField();
            this.nameField.setColumns(15);
            this.annotationLabel = new JLabel("Annotation");
            this.annotationLabel.setHorizontalAlignment(0);
            this.annotationLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            this.annotationField = new JTextField();
            this.annotationField.setColumns(15);
            this.leftPanel = new JPanel(new GridLayout(0, 1));
            this.leftPanel.add(this.nameLabel);
            this.rightPanel = new JPanel(new GridLayout(0, 1));
            this.rightPanel.add(this.nameField);
            this.setLayout(new BorderLayout());
            this.add((Component)this.leftPanel, "West");
            this.add((Component)this.rightPanel, "Center");
        }

        boolean showSaveOptions(String string, String string2) {
            if (string != null) {
                this.nameField.setText(string);
            }
            if (string2 != null) {
                this.annotationField.setText(string2);
            }
            ModifiableJOptionPane modifiableJOptionPane = new ModifiableJOptionPane(this, -1, 2, moodleIcon);
            modifiableJOptionPane.setResizable(true);
            JDialog jDialog = modifiableJOptionPane.createDialog(MoodleConnection.this.getParentComponent(), this.saveFile);
            jDialog.setResizable(true);
            jDialog.setContentPane(modifiableJOptionPane);
            jDialog.setVisible(true);
            Object object = modifiableJOptionPane.getValue();
            Integer n = 0;
            return object == n;
        }
    }

    class TimerListener
    implements ActionListener {
        TimerListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (MoodleConnection.this.task.done()) {
                if (MoodleConnection.this.task.getStatus()) {
                    MoodleConnection.this.progressMonitor.setProgress(100);
                    MoodleConnection.this.progressMonitor.setNote("Completed 100% out of 100%.");
                    MoodleConnection.this.progressMonitor.setBarString("Successful Delivery. Refresh your EJSApp File Browser block");
                } else {
                    MoodleConnection.this.progressMonitor.setBarString("Sending with problems. Try again!!");
                    MoodleConnection.this.progressMonitor.setNote(MoodleConnection.this.task.getMessage());
                }
                MoodleConnection.this.task.stop();
                Toolkit.getDefaultToolkit().beep();
                MoodleConnection.this.timer.stop();
            } else {
                int n = MoodleConnection.this.task.getCurrent();
                if (n == MoodleConnection.this.previous) {
                    MoodleConnection.this.progressMonitor.setBarIndeterminate(true);
                    MoodleConnection.this.progressMonitor.setBarString("Sending file... Please wait");
                } else {
                    MoodleConnection.this.progressMonitor.setBarIndeterminate(false);
                    MoodleConnection.this.progressMonitor.setBarString("Progress");
                }
                MoodleConnection.this.previous = n;
                MoodleConnection.this.progressMonitor.setNote(MoodleConnection.this.task.getMessage());
                MoodleConnection.this.progressMonitor.setProgress(n);
            }
        }
    }
}

