/*
 * Decompiled with CFR 0.152.
 */
package ejsBilliardPhysics_pkg;

import ejsBilliardPhysics_pkg.ejsBilliardPhysicsSimulation;
import ejsBilliardPhysics_pkg.ejsBilliardPhysicsView;
import java.awt.Dimension;
import java.awt.Frame;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.colos.ejs.library.LauncherApplet;
import org.colos.ejs.library.Model;
import org.colos.ejs.library.Simulation;
import org.colos.ejs.library.View;
import org.colos.ejs.library.control.EjsControl;
import org.colos.ejs.library.control.swing.ControlWindow;
import org.colos.ejs.library.utils.HtmlPageInfo;
import org.colos.ejs.library.utils.LocaleItem;
import org.colos.ejs.library.utils.TranslatorUtil;
import org.opensourcephysics.display.OSPRuntime;
import org.opensourcephysics.numerics.ode_solvers.EjsS_ODE;
import org.opensourcephysics.numerics.ode_solvers.InterpolatorEventSolver;
import org.opensourcephysics.numerics.ode_solvers.SolverEngine;
import org.opensourcephysics.numerics.ode_solvers.StateEvent;
import org.opensourcephysics.numerics.ode_solvers.rk.CashKarp45;
import org.opensourcephysics.numerics.ode_solvers.symplectic.VelocityVerletSavvy;
import org.opensourcephysics.tools.ResourceLoader;

public class ejsBilliardPhysics
extends Model {
    public ejsBilliardPhysicsSimulation _simulation = null;
    public ejsBilliardPhysicsView _view = null;
    public ejsBilliardPhysics _model = this;
    private static Map<String, Set<HtmlPageInfo>> __htmlPagesMap;
    protected Hashtable<String, EjsS_ODE> _privateOdesList = new Hashtable();
    public double range = 800.0;
    public double xmin = -this.range / 2.0;
    public double xmax = this.range / 2.0;
    public double ymin = -this.range / 4.0;
    public double ymax = this.range / 4.0;
    public double t = 0.0;
    public double k = 0.8;
    public double f = -40.0;
    public double arrowX = 0.0;
    public double arrowY = 0.0;
    public double xOriginal;
    public double yOriginal;
    public double baseLength = 50.0;
    public double TOLERANCE = 0.001;
    public boolean horizontalRebound;
    public int ballRebounded;
    public int collision1;
    public int collision2;
    public int n = 16;
    public double[] x;
    public double[] y;
    public double[] vx;
    public double[] vy;
    public double[] diameter;
    public double[] mass;
    public double m = 1.0;
    public boolean cueBreak = false;
    public double rackgap = 2.0;
    public int[] ballScored;
    public int noBallScored = 0;
    public int nPocket = 6;
    public double[] pocketX;
    public double[] pocketY;
    public double pocketSize = 10.0;
    private boolean _isEnabled_initialization1 = true;
    private boolean _isEnabled_evolution1 = true;
    private boolean _isEnabled_evolution1_Event1 = true;
    private boolean _isEnabled_evolution1_Event2 = true;
    private boolean _isEnabled_constraints1 = true;
    private _ODE_evolution1 _ODEi_evolution1;

    public static void _addHtmlPageInfo(String string, String string2, String string3, String string4) {
        LocaleItem localeItem;
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            set = new HashSet<HtmlPageInfo>();
            __htmlPagesMap.put(string, set);
        }
        if ((localeItem = LocaleItem.getLocaleItem(string2)) != null) {
            set.add(new HtmlPageInfo(localeItem, string3, string4));
        }
    }

    public static HtmlPageInfo _getHtmlPageClassInfo(String string, LocaleItem localeItem) {
        Set<HtmlPageInfo> set = __htmlPagesMap.get(string);
        if (set == null) {
            return null;
        }
        HtmlPageInfo htmlPageInfo = null;
        for (HtmlPageInfo htmlPageInfo2 : set) {
            if (htmlPageInfo2.getLocaleItem().isDefaultItem()) {
                htmlPageInfo = htmlPageInfo2;
            }
            if (!htmlPageInfo2.getLocaleItem().equals(localeItem)) continue;
            return htmlPageInfo2;
        }
        return htmlPageInfo;
    }

    @Override
    public HtmlPageInfo _getHtmlPageInfo(String string, LocaleItem localeItem) {
        return ejsBilliardPhysics._getHtmlPageClassInfo(string, localeItem);
    }

    public static String _getEjsModel() {
        return "/ejsBilliardPhysics.ejs";
    }

    public static String _getModelDirectory() {
        return "";
    }

    public static Dimension _getEjsAppletDimension() {
        return new Dimension(601, 506);
    }

    public static Set<String> _getEjsResources() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("/me.png");
        hashSet.add("/billiardphysics.PNG");
        return hashSet;
    }

    public static boolean _common_initialization(String[] stringArray) {
        int n;
        String string = null;
        boolean bl = true;
        if (stringArray != null) {
            for (n = 0; n < stringArray.length; ++n) {
                if (stringArray[n].equals("-_lookAndFeel")) {
                    string = stringArray[++n];
                    continue;
                }
                if (stringArray[n].equals("-_decorateWindows")) {
                    bl = true;
                    continue;
                }
                if (!stringArray[n].equals("-_doNotDecorateWindows")) continue;
                bl = false;
            }
        }
        if (string != null) {
            OSPRuntime.setLookAndFeel(bl, string);
        }
        ResourceLoader.addSearchPath(".");
        n = 0;
        boolean bl2 = false;
        try {
            if ("true".equals(System.getProperty("org.osp.launcher"))) {
                OSPRuntime.setLauncherMode(true);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (System.getProperty("osp_ejs") != null) {
                bl2 = true;
                Simulation.setPathToLibrary("C:/Users/macmas.tyeu/Desktop/EJS_5.1/bin/config/");
                n = 1;
            }
        }
        catch (Exception exception) {
            n = 0;
        }
        try {
            EjsControl.setDefaultScreen(Integer.parseInt(System.getProperty("screen")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n == 0) {
            Simulation.setPathToLibrary("C:/Users/macmas.tyeu/Desktop/EJS_5.1/bin/config/");
        }
        if (!bl2) {
            // empty if block
        }
        return true;
    }

    public static void main(String[] stringArray) {
        if (!ejsBilliardPhysics._common_initialization(stringArray)) {
            if (OSPRuntime.isLauncherMode()) {
                return;
            }
            System.exit(-1);
        }
        ejsBilliardPhysics ejsBilliardPhysics2 = new ejsBilliardPhysics(stringArray);
    }

    public static JComponent getModelPane(String[] stringArray, JFrame jFrame) {
        if (!ejsBilliardPhysics._common_initialization(stringArray)) {
            return null;
        }
        ejsBilliardPhysics ejsBilliardPhysics2 = new ejsBilliardPhysics("plottingFrame", jFrame, null, null, stringArray, true);
        return (JComponent)ejsBilliardPhysics2._getView().getComponent("plottingFrame");
    }

    public ejsBilliardPhysics() {
        this(null, null, null, null, null, false);
    }

    public ejsBilliardPhysics(String[] stringArray) {
        this(null, null, null, null, stringArray, true);
    }

    public ejsBilliardPhysics(String string, Frame frame, URL uRL, LauncherApplet launcherApplet, String[] stringArray, boolean bl) {
        ControlWindow.setKeepHidden(true);
        this.__theArguments = stringArray;
        this.__theApplet = launcherApplet;
        NumberFormat numberFormat = NumberFormat.getInstance();
        if (numberFormat instanceof DecimalFormat) {
            ((DecimalFormat)numberFormat).getDecimalFormatSymbols().setDecimalSeparator('.');
        }
        this._simulation = new ejsBilliardPhysicsSimulation(this, string, frame, uRL, bl);
        this._simulation.processArguments(stringArray);
        ControlWindow.setKeepHidden(false);
    }

    @Override
    public String _getClassEjsModel() {
        return ejsBilliardPhysics._getEjsModel();
    }

    @Override
    public Set<String> _getClassEjsResources() {
        return ejsBilliardPhysics._getEjsResources();
    }

    @Override
    public String _getClassModelDirectory() {
        return ejsBilliardPhysics._getModelDirectory();
    }

    @Override
    public View _getView() {
        return this._view;
    }

    @Override
    public Simulation _getSimulation() {
        return this._simulation;
    }

    @Override
    public int _getPreferredStepsPerDisplay() {
        return 1;
    }

    @Override
    public void _resetModel() {
        int n;
        this._isEnabled_initialization1 = true;
        this._isEnabled_evolution1 = true;
        this._isEnabled_evolution1_Event1 = true;
        this._isEnabled_evolution1_Event2 = true;
        this._isEnabled_constraints1 = true;
        this.range = 800.0;
        this.xmin = -this.range / 2.0;
        this.xmax = this.range / 2.0;
        this.ymin = -this.range / 4.0;
        this.ymax = this.range / 4.0;
        this.t = 0.0;
        this.k = 0.8;
        this.f = -40.0;
        this.arrowX = 0.0;
        this.arrowY = 0.0;
        this.baseLength = 50.0;
        this.TOLERANCE = 0.001;
        this.n = 16;
        this.x = new double[this.n];
        this.y = new double[this.n];
        this.vx = new double[this.n];
        this.vy = new double[this.n];
        this.diameter = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.diameter[n] = 20.0;
        }
        this.mass = new double[this.n];
        for (n = 0; n < this.n; ++n) {
            this.mass[n] = 0.17;
        }
        this.m = 1.0;
        this.cueBreak = false;
        this.rackgap = 2.0;
        this.ballScored = new int[this.n - 1];
        this.noBallScored = 0;
        this.nPocket = 6;
        this.pocketX = new double[this.nPocket];
        this.pocketY = new double[this.nPocket];
        this.pocketSize = 10.0;
        this._ODEi_evolution1 = new _ODE_evolution1();
    }

    public void _initializeSolvers() {
        for (EjsS_ODE ejsS_ODE : this._privateOdesList.values()) {
            ejsS_ODE.initializeSolver();
        }
    }

    @Override
    public void _initializeModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_initialization1;
        if (bl) {
            this._initialization1();
        }
        if (this.__shouldBreak) {
            return;
        }
        this._initializeSolvers();
    }

    @Override
    public void _automaticResetSolvers() {
        this._ODEi_evolution1.automaticResetSolver();
    }

    @Override
    public void _resetSolvers() {
        this._ODEi_evolution1.resetSolver();
    }

    @Override
    public void _stepModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_evolution1;
        if (bl) {
            this._ODEi_evolution1.step();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _updateModel() {
        this.__shouldBreak = false;
        boolean bl = this._isEnabled_constraints1;
        if (bl) {
            this._constraints1();
        }
        if (this.__shouldBreak) {
            return;
        }
    }

    @Override
    public void _freeMemory() {
        this.getSimulation().setEnded();
        this.x = null;
        this.y = null;
        this.vx = null;
        this.vy = null;
        this.diameter = null;
        this.mass = null;
        this.ballScored = null;
        this.pocketX = null;
        this.pocketY = null;
        this._ODEi_evolution1 = null;
        System.gc();
    }

    public EjsS_ODE _getODE(String string) {
        try {
            return this._privateOdesList.get(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public InterpolatorEventSolver _getEventSolver(String string) {
        try {
            return this._privateOdesList.get(string).getEventSolver();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void _setSolverClass(String string, Class<?> clazz) {
        try {
            this._privateOdesList.get(string).setSolverClass(clazz);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
        }
    }

    public String _setSolverClass(String string, String string2) {
        if (string2 == null) {
            System.err.println("Null solver class name!");
            return null;
        }
        try {
            return this._privateOdesList.get(string).setSolverClass(string2);
        }
        catch (Exception exception) {
            System.err.println("There is no ODE with this name " + string);
            return null;
        }
    }

    public void _setPageEnabled(String string, boolean bl) {
        boolean bl2 = false;
        if ("Init Page".equals(string)) {
            bl2 = true;
            this._isEnabled_initialization1 = bl;
        }
        if ("Evol Page".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1 = bl;
            this._automaticResetSolvers();
        }
        if ("bouncing".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1_Event1 = bl;
            this._ODEi_evolution1.initializeSolver();
        }
        if ("collision".equals(string)) {
            bl2 = true;
            this._isEnabled_evolution1_Event2 = bl;
            this._ODEi_evolution1.initializeSolver();
        }
        if ("FixRel Page".equals(string)) {
            bl2 = true;
            this._isEnabled_constraints1 = bl;
        }
        if (!bl2) {
            System.out.println("_setPageEnabled() warning. Page not found: " + string);
        }
    }

    public void _initialization1() {
        this.t = 0.0;
        this.rackup();
        for (int i = 0; i < this.n - 1; ++i) {
            this.ballScored[i] = 99;
        }
        this.noBallScored = 0;
    }

    public void _constraints1() {
        int n;
        for (n = 0; n < this.n; ++n) {
            if (Math.abs(this.vx[n]) < this.TOLERANCE) {
                this.vx[n] = 0.0;
                continue;
            }
            if (!(Math.abs(this.vy[n]) < this.TOLERANCE)) continue;
            this.vy[n] = 0.0;
        }
        for (n = 0; n < this.n - 1; ++n) {
            for (int i = 0; i < this.n - 1; ++i) {
                if (n == this.ballScored[i]) continue;
                if (this.x[n] <= this.xmax && this.x[n] >= this.xmax - this.diameter[n] && this.y[n] <= this.ymax && this.y[n] >= this.ymax - this.diameter[n]) {
                    this.x[n] = -300 + 40 * n;
                    this.y[n] = 250.0;
                    this.vx[n] = 0.0;
                    this.vy[n] = 0.0;
                    ++this.noBallScored;
                    this.ballScored[this.noBallScored - 1] = n;
                    continue;
                }
                if (this.x[n] >= this.xmin && this.x[n] <= this.xmin + this.diameter[n] && this.y[n] >= this.ymin && this.y[n] <= this.ymin + this.diameter[n]) {
                    this.x[n] = -300 + 40 * n;
                    this.y[n] = 250.0;
                    this.vx[n] = 0.0;
                    this.vy[n] = 0.0;
                    ++this.noBallScored;
                    this.ballScored[this.noBallScored - 1] = n;
                    continue;
                }
                if (this.x[n] >= this.xmin && this.x[n] <= this.xmin + this.diameter[n] && this.y[n] <= this.ymax && this.y[n] >= this.ymax - this.diameter[n]) {
                    this.x[n] = -300 + 40 * n;
                    this.y[n] = 250.0;
                    this.vx[n] = 0.0;
                    this.vy[n] = 0.0;
                    ++this.noBallScored;
                    this.ballScored[this.noBallScored - 1] = n;
                    continue;
                }
                if (this.x[n] <= this.xmax && this.x[n] >= this.xmax - this.diameter[n] && this.y[n] >= this.ymin && this.y[n] <= this.ymin + this.diameter[n]) {
                    this.x[n] = -300 + 40 * n;
                    this.y[n] = 250.0;
                    this.vx[n] = 0.0;
                    this.vy[n] = 0.0;
                    ++this.noBallScored;
                    this.ballScored[this.noBallScored - 1] = n;
                    continue;
                }
                if (this.x[n] <= this.diameter[n] / 2.0 && this.x[n] >= -this.diameter[n] / 2.0 && this.y[n] >= this.ymin && this.y[n] <= this.ymin + this.diameter[n]) {
                    this.x[n] = -300 + 40 * n;
                    this.y[n] = 250.0;
                    this.vx[n] = 0.0;
                    this.vy[n] = 0.0;
                    ++this.noBallScored;
                    this.ballScored[this.noBallScored - 1] = n;
                    continue;
                }
                if (!(this.x[n] <= this.diameter[n] / 2.0) || !(this.x[n] >= -this.diameter[n] / 2.0) || !(this.y[n] <= this.ymax) || !(this.y[n] >= this.ymax - this.diameter[n])) continue;
                this.x[n] = -300 + 40 * n;
                this.y[n] = 250.0;
                this.vx[n] = 0.0;
                this.vy[n] = 0.0;
                ++this.noBallScored;
                this.ballScored[this.noBallScored - 1] = n;
            }
        }
    }

    public void rackup() {
        double d = this.range / 4.0;
        double d2 = (this.diameter[0] + this.rackgap) / 2.0 * Math.sqrt(3.0);
        double d3 = (this.diameter[0] + this.rackgap) / 2.0;
        this.x[0] = d;
        this.x[1] = d + d2;
        this.x[2] = this.x[1];
        this.x[3] = this.x[2] + d2;
        this.x[4] = this.x[3];
        this.x[5] = this.x[3];
        this.x[6] = this.x[5] + d2;
        this.x[7] = this.x[6];
        this.x[8] = this.x[6];
        this.x[9] = this.x[6];
        this.x[10] = this.x[9] + d2;
        this.x[11] = this.x[10];
        this.x[12] = this.x[10];
        this.x[13] = this.x[10];
        this.x[14] = this.x[10];
        this.y[0] = 0.0;
        this.y[4] = this.y[0];
        this.y[12] = this.y[0];
        this.y[1] = -d3;
        this.y[7] = this.y[1];
        this.y[3] = this.y[1] * 2.0;
        this.y[11] = this.y[3];
        this.y[6] = this.y[1] * 3.0;
        this.y[10] = this.y[1] * 4.0;
        this.y[2] = -this.y[1];
        this.y[5] = -this.y[3];
        this.y[8] = -this.y[7];
        this.y[9] = -this.y[6];
        this.y[13] = -this.y[11];
        this.y[14] = -this.y[10];
        this.x[15] = -d;
        this.y[15] = 0.0;
        this.pocketX[0] = this.xmin + this.pocketSize;
        this.pocketY[0] = this.ymax - this.pocketSize;
        this.pocketX[1] = this.xmin + this.xmax;
        this.pocketY[1] = this.ymax - this.pocketSize;
        this.pocketX[2] = this.xmax - this.pocketSize;
        this.pocketY[2] = this.ymax - this.pocketSize;
        this.pocketX[3] = this.xmin + this.pocketSize;
        this.pocketY[3] = this.ymin + this.pocketSize;
        this.pocketX[4] = this.xmin + this.xmax;
        this.pocketY[4] = this.ymin + this.pocketSize;
        this.pocketX[5] = this.xmax - this.pocketSize;
        this.pocketY[5] = this.ymin + this.pocketSize;
    }

    public double getFriction(double d, double d2, int n, boolean bl) {
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        if (Math.abs(d) < this.TOLERANCE) {
            this.vx[n] = 0.0;
            d4 = 0.0;
        } else if (Math.abs(d2) < this.TOLERANCE) {
            this.vy[n] = 0.0;
            d5 = 0.0;
        } else {
            double d6 = Math.sqrt(d * d + d2 * d2);
            d4 = this.f * d / d6;
            d5 = this.f * d2 / d6;
        }
        d3 = bl ? d4 : d5;
        return d3;
    }

    public double _method_for_plottingPanel_minimumX() {
        return this.xmin - 10.0;
    }

    public double _method_for_plottingPanel_maximumX() {
        return this.xmax + 10.0;
    }

    public double _method_for_plottingPanel_minimumY() {
        return this.ymin - 10.0;
    }

    public double _method_for_plottingPanel_maximumY() {
        return this.ymax + 10.0;
    }

    public double _method_for_table_sizeY() {
        return this.range / 2.0;
    }

    public void _method_for_ballSet_pressAction() {
        if (this._isPlaying()) {
            this._pause();
        }
        this.xOriginal = this.x[15];
        this.yOriginal = this.y[15];
    }

    public void _method_for_ballSet_dragAction() {
        this.arrowX = this.xOriginal - this.x[15];
        this.arrowY = this.yOriginal - this.y[15];
    }

    public void _method_for_ballSet_releaseAction() {
        this.vx[15] = 1000.0 * (this.arrowX / this.baseLength);
        this.vy[15] = 1000.0 * (this.arrowY / this.baseLength);
        this.arrowX = 0.0;
        this.arrowY = 0.0;
        this.cueBreak = true;
        if (this._isPaused()) {
            this._play();
        }
    }

    public double _method_for_arrow_x() {
        return this.x[15];
    }

    public double _method_for_arrow_y() {
        return this.y[15];
    }

    public double _method_for_cueBall_x() {
        return this.x[15];
    }

    public double _method_for_cueBall_y() {
        return this.y[15];
    }

    public double _method_for_cueBall_sizeX() {
        return this.diameter[15];
    }

    public double _method_for_cueBall_sizeY() {
        return this.diameter[15];
    }

    public double _method_for_pocketSet_sizeX() {
        return this.pocketSize * 2.0;
    }

    public double _method_for_pocketSet_sizeY() {
        return this.pocketSize * 2.0;
    }

    public void _method_for_playPauseButton_actionOn() {
        this._play();
    }

    public void _method_for_playPauseButton_actionOff() {
        this._pause();
    }

    public void _method_for_resetButton_action() {
        this._reset();
    }

    static {
        __translatorUtil = new TranslatorUtil();
        __htmlPagesMap = new HashMap<String, Set<HtmlPageInfo>>();
    }

    private class _ODE_evolution1
    implements EjsS_ODE,
    VelocityVerletSavvy {
        private SolverEngine __solver = null;
        private InterpolatorEventSolver __eventSolver = null;
        private Class<?> __solverClass = CashKarp45.class;
        private double[] __state = null;
        private boolean __ignoreErrors = false;
        private boolean __mustInitialize = true;
        private boolean __isEnabled = true;
        private boolean __mustUserReinitialize = false;
        private boolean __mustReinitialize = true;
        private double[] _x;
        private double[] _y;
        private double[] _vx;
        private double[] _vy;

        _ODE_evolution1() {
            this.__instantiateSolver();
            ejsBilliardPhysics.this._privateOdesList.put("Evol Page", this);
        }

        @Override
        public InterpolatorEventSolver getEventSolver() {
            return this.__eventSolver;
        }

        @Override
        public void setSolverClass(Class<?> clazz) {
            this.__solverClass = clazz;
            this.__instantiateSolver();
        }

        @Override
        public String setSolverClass(String string) {
            String string2 = "org.opensourcephysics.numerics.ode_solvers.";
            if ((string = string.trim().toLowerCase()).indexOf("euler") >= 0) {
                string = string.indexOf("rich") >= 0 ? string2 + "rk.EulerRichardson" : string2 + "rk.Euler";
            } else if (string.indexOf("verlet") >= 0) {
                string = string2 + "symplectic.VelocityVerlet";
            } else if (string.indexOf("runge") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("rk4") >= 0) {
                string = string2 + "rk.RK4";
            } else if (string.indexOf("boga") >= 0) {
                string = string2 + "rk.BogackiShampine23";
            } else if (string.indexOf("cash") >= 0) {
                string = string2 + "rk.CashKarp45";
            } else if (string.indexOf("fehl") >= 0) {
                string = string.indexOf("7") >= 0 ? string2 + "rk.Fehlberg78" : string2 + "rk.Fehlberg8";
            } else if (string.indexOf("dorm") >= 0 || string.indexOf("dopri") >= 0) {
                string = string.indexOf("8") >= 0 ? string2 + "rk.Dopri853" : string2 + "rk.Dopri5";
            } else if (string.indexOf("radau") >= 0) {
                string = string2 + "rk.Radau5";
            } else {
                System.err.println("There is no solver with this name " + string);
                return null;
            }
            try {
                this.setSolverClass(Class.forName(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return string;
        }

        private void __instantiateSolver() {
            this.__state = new double[1 + ejsBilliardPhysics.this.x.length + ejsBilliardPhysics.this.y.length + ejsBilliardPhysics.this.vx.length + ejsBilliardPhysics.this.vy.length];
            this._x = new double[ejsBilliardPhysics.this.x.length];
            this._y = new double[ejsBilliardPhysics.this.y.length];
            this._vx = new double[ejsBilliardPhysics.this.vx.length];
            this._vy = new double[ejsBilliardPhysics.this.vy.length];
            this.__pushState();
            try {
                Class[] classArray = new Class[]{};
                Object[] objectArray = new Object[]{};
                Constructor<?> constructor = this.__solverClass.getDeclaredConstructor(classArray);
                this.__solver = (SolverEngine)constructor.newInstance(objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.__eventSolver = new InterpolatorEventSolver(this.__solver, this);
            this.__mustInitialize = true;
        }

        @Override
        public void setEnabled(boolean bl) {
            this.__isEnabled = bl;
        }

        @Override
        public double getIndependentVariableValue() {
            return this.__eventSolver.getIndependentVariableValue();
        }

        @Override
        public double getInternalStepSize() {
            return this.__eventSolver.getInternalStepSize();
        }

        @Override
        public boolean isAccelerationIndependentOfVelocity() {
            return false;
        }

        @Override
        public void initializeSolver() {
            if (this.__arraysChanged()) {
                this.__instantiateSolver();
                this.initializeSolver();
                return;
            }
            this.__pushState();
            this.__eventSolver.initialize(0.01);
            this.__eventSolver.setBestInterpolation(false);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.removeAllEvents();
            if (ejsBilliardPhysics.this._isEnabled_evolution1_Event1) {
                this.__eventSolver.addEvent(new _ODE_evolution1_Event1());
            }
            if (ejsBilliardPhysics.this._isEnabled_evolution1_Event2) {
                this.__eventSolver.addEvent(new _ODE_evolution1_Event2());
            }
            this.__eventSolver.setEstimateFirstStep(false);
            this.__eventSolver.setEnableExceptions(false);
            this.__eventSolver.setTolerances(ejsBilliardPhysics.this.TOLERANCE, ejsBilliardPhysics.this.TOLERANCE);
            this.__mustReinitialize = true;
            this.__mustInitialize = false;
        }

        private void __pushState() {
            int n;
            int n2;
            int n3 = 0;
            if (!this.__mustReinitialize) {
                n2 = n3;
                for (n = 0; n < ejsBilliardPhysics.this.x.length; ++n) {
                    if (this.__state[n2++] == ejsBilliardPhysics.this.x[n]) continue;
                    this.__mustReinitialize = true;
                    break;
                }
            }
            System.arraycopy(ejsBilliardPhysics.this.x, 0, this.__state, n3, ejsBilliardPhysics.this.x.length);
            n3 += ejsBilliardPhysics.this.x.length;
            if (!this.__mustReinitialize) {
                n2 = n3;
                for (n = 0; n < ejsBilliardPhysics.this.y.length; ++n) {
                    if (this.__state[n2++] == ejsBilliardPhysics.this.y[n]) continue;
                    this.__mustReinitialize = true;
                    break;
                }
            }
            System.arraycopy(ejsBilliardPhysics.this.y, 0, this.__state, n3, ejsBilliardPhysics.this.y.length);
            n3 += ejsBilliardPhysics.this.y.length;
            if (!this.__mustReinitialize) {
                n2 = n3;
                for (n = 0; n < ejsBilliardPhysics.this.vx.length; ++n) {
                    if (this.__state[n2++] == ejsBilliardPhysics.this.vx[n]) continue;
                    this.__mustReinitialize = true;
                    break;
                }
            }
            System.arraycopy(ejsBilliardPhysics.this.vx, 0, this.__state, n3, ejsBilliardPhysics.this.vx.length);
            n3 += ejsBilliardPhysics.this.vx.length;
            if (!this.__mustReinitialize) {
                n2 = n3;
                for (n = 0; n < ejsBilliardPhysics.this.vy.length; ++n) {
                    if (this.__state[n2++] == ejsBilliardPhysics.this.vy[n]) continue;
                    this.__mustReinitialize = true;
                    break;
                }
            }
            System.arraycopy(ejsBilliardPhysics.this.vy, 0, this.__state, n3, ejsBilliardPhysics.this.vy.length);
            if (this.__state[n3 += ejsBilliardPhysics.this.vy.length] != ejsBilliardPhysics.this.t) {
                this.__mustReinitialize = true;
            }
            this.__state[n3++] = ejsBilliardPhysics.this.t;
        }

        private boolean __arraysChanged() {
            if (ejsBilliardPhysics.this.x.length != this._x.length) {
                return true;
            }
            if (ejsBilliardPhysics.this.y.length != this._y.length) {
                return true;
            }
            if (ejsBilliardPhysics.this.vx.length != this._vx.length) {
                return true;
            }
            return ejsBilliardPhysics.this.vy.length != this._vy.length;
        }

        public void resetSolver() {
            this.__mustUserReinitialize = true;
        }

        public void automaticResetSolver() {
            this.__mustReinitialize = true;
        }

        private void __errorAction() {
            if (this.__ignoreErrors) {
                return;
            }
            System.err.println(this.__eventSolver.getErrorMessage());
            int n = JOptionPane.showConfirmDialog(ejsBilliardPhysics.this._view.getComponent(ejsBilliardPhysics.this._simulation.getMainWindow()), Simulation.getEjsString("ODEError.Continue"), Simulation.getEjsString("Error"), 1);
            if (n == 0) {
                this.__ignoreErrors = true;
            } else if (n == 2) {
                ejsBilliardPhysics.this._pause();
            }
            this.__mustReinitialize = true;
        }

        @Override
        public double step() {
            return this.__privateStep(false);
        }

        @Override
        public double solverStep() {
            return this.__privateStep(true);
        }

        private double __privateStep(boolean bl) {
            if (!this.__isEnabled) {
                return 0.0;
            }
            if (this.__mustInitialize) {
                this.initializeSolver();
            }
            if (this.__arraysChanged()) {
                this.__instantiateSolver();
                this.initializeSolver();
            }
            this.__eventSolver.setStepSize(0.01);
            this.__eventSolver.setInternalStepSize(0.01);
            this.__eventSolver.setMaximumInternalSteps(10000);
            this.__eventSolver.setTolerances(ejsBilliardPhysics.this.TOLERANCE, ejsBilliardPhysics.this.TOLERANCE);
            this.__pushState();
            if (this.__mustUserReinitialize) {
                this.__eventSolver.userReinitialize();
                this.__mustUserReinitialize = false;
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                    this.__errorAction();
                }
            } else if (this.__mustReinitialize) {
                this.__eventSolver.reinitialize();
                this.__mustReinitialize = false;
                if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                    this.__errorAction();
                }
            }
            double d = bl ? this.__eventSolver.maxStep() : this.__eventSolver.step();
            int n = 0;
            System.arraycopy(this.__state, n, ejsBilliardPhysics.this.x, 0, ejsBilliardPhysics.this.x.length);
            System.arraycopy(this.__state, n += ejsBilliardPhysics.this.x.length, ejsBilliardPhysics.this.y, 0, ejsBilliardPhysics.this.y.length);
            System.arraycopy(this.__state, n += ejsBilliardPhysics.this.y.length, ejsBilliardPhysics.this.vx, 0, ejsBilliardPhysics.this.vx.length);
            System.arraycopy(this.__state, n += ejsBilliardPhysics.this.vx.length, ejsBilliardPhysics.this.vy, 0, ejsBilliardPhysics.this.vy.length);
            n += ejsBilliardPhysics.this.vy.length;
            ejsBilliardPhysics.this.t = this.__state[n++];
            if (this.__eventSolver.getErrorCode() != InterpolatorEventSolver.ERROR.NO_ERROR) {
                this.__errorAction();
            }
            return d;
        }

        @Override
        public double[] getState() {
            return this.__state;
        }

        @Override
        public void getRate(double[] dArray, double[] dArray2) {
            int n;
            dArray2[dArray2.length - 1] = 0.0;
            int n2 = -1;
            int n3 = 0;
            double[] dArray3 = this._x;
            System.arraycopy(dArray, n3, dArray3, 0, dArray3.length);
            double[] dArray4 = this._y;
            System.arraycopy(dArray, n3 += dArray3.length, dArray4, 0, dArray4.length);
            double[] dArray5 = this._vx;
            System.arraycopy(dArray, n3 += dArray4.length, dArray5, 0, dArray5.length);
            double[] dArray6 = this._vy;
            System.arraycopy(dArray, n3 += dArray5.length, dArray6, 0, dArray6.length);
            n3 += dArray6.length;
            double d = dArray[n3++];
            int n4 = 0;
            for (n = 0; n < dArray3.length; ++n) {
                dArray2[n4++] = dArray5[n];
            }
            for (n = 0; n < dArray4.length; ++n) {
                dArray2[n4++] = dArray6[n];
            }
            for (n = 0; n < dArray5.length; ++n) {
                dArray2[n4++] = ejsBilliardPhysics.this.getFriction(dArray5[n], dArray6[n], n, true);
            }
            for (n = 0; n < dArray6.length; ++n) {
                dArray2[n4++] = ejsBilliardPhysics.this.getFriction(dArray5[n], dArray6[n], n, false);
            }
            dArray2[n4++] = 1.0;
        }

        private class _ODE_evolution1_Event2
        implements StateEvent {
            private _ODE_evolution1_Event2() {
            }

            @Override
            public int getTypeOfEvent() {
                return 0;
            }

            @Override
            public int getRootFindingMethod() {
                return 0;
            }

            @Override
            public int getMaxIterations() {
                return 100;
            }

            public String toString() {
                return "collision";
            }

            @Override
            public double getTolerance() {
                return ejsBilliardPhysics.this.TOLERANCE;
            }

            @Override
            public double evaluate(double[] dArray) {
                int n;
                int n2 = 0;
                double[] dArray2 = _ODE_evolution1.this._x;
                System.arraycopy(dArray, n2, dArray2, 0, dArray2.length);
                double[] dArray3 = _ODE_evolution1.this._y;
                System.arraycopy(dArray, n2 += dArray2.length, dArray3, 0, dArray3.length);
                double[] dArray4 = _ODE_evolution1.this._vx;
                System.arraycopy(dArray, n2 += dArray3.length, dArray4, 0, dArray4.length);
                double[] dArray5 = _ODE_evolution1.this._vy;
                System.arraycopy(dArray, n2 += dArray4.length, dArray5, 0, dArray5.length);
                n2 += dArray5.length;
                double d = dArray[n2++];
                double d2 = ejsBilliardPhysics.this.TOLERANCE;
                if (ejsBilliardPhysics.this.cueBreak) {
                    n = ejsBilliardPhysics.this.n - 1;
                    ejsBilliardPhysics.this.cueBreak = false;
                } else {
                    n = ejsBilliardPhysics.this.n;
                }
                for (int i = 0; i < ejsBilliardPhysics.this.n; ++i) {
                    for (int j = i + 1; j < ejsBilliardPhysics.this.n; ++j) {
                        double d3;
                        double d4;
                        double d5 = dArray2[j] - dArray2[i];
                        double d6 = dArray3[j] - dArray3[i];
                        double d7 = (ejsBilliardPhysics.this.diameter[i] + ejsBilliardPhysics.this.diameter[j]) / 2.0;
                        double d8 = Math.sqrt(d5 * d5 + d6 * d6) - d7;
                        if (!(d8 < d2) || !(d5 * (d4 = dArray4[j] - dArray4[i]) + d6 * (d3 = dArray5[j] - dArray5[i]) < 0.0)) continue;
                        ejsBilliardPhysics.this.collision1 = i;
                        ejsBilliardPhysics.this.collision2 = j;
                        d2 = d8;
                    }
                }
                return d2;
            }

            @Override
            public boolean action() {
                int n = 0;
                System.arraycopy(_ODE_evolution1.this.__state, n, ejsBilliardPhysics.this.x, 0, ejsBilliardPhysics.this.x.length);
                System.arraycopy(_ODE_evolution1.this.__state, n += ejsBilliardPhysics.this.x.length, ejsBilliardPhysics.this.y, 0, ejsBilliardPhysics.this.y.length);
                System.arraycopy(_ODE_evolution1.this.__state, n += ejsBilliardPhysics.this.y.length, ejsBilliardPhysics.this.vx, 0, ejsBilliardPhysics.this.vx.length);
                System.arraycopy(_ODE_evolution1.this.__state, n += ejsBilliardPhysics.this.vx.length, ejsBilliardPhysics.this.vy, 0, ejsBilliardPhysics.this.vy.length);
                n += ejsBilliardPhysics.this.vy.length;
                ejsBilliardPhysics.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                int n2 = 0;
                System.arraycopy(ejsBilliardPhysics.this.x, 0, _ODE_evolution1.this.__state, n2, ejsBilliardPhysics.this.x.length);
                System.arraycopy(ejsBilliardPhysics.this.y, 0, _ODE_evolution1.this.__state, n2 += ejsBilliardPhysics.this.x.length, ejsBilliardPhysics.this.y.length);
                System.arraycopy(ejsBilliardPhysics.this.vx, 0, _ODE_evolution1.this.__state, n2 += ejsBilliardPhysics.this.y.length, ejsBilliardPhysics.this.vx.length);
                System.arraycopy(ejsBilliardPhysics.this.vy, 0, _ODE_evolution1.this.__state, n2 += ejsBilliardPhysics.this.vx.length, ejsBilliardPhysics.this.vy.length);
                n2 += ejsBilliardPhysics.this.vy.length;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = ejsBilliardPhysics.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                double d = ejsBilliardPhysics.this.x[ejsBilliardPhysics.this.collision2] - ejsBilliardPhysics.this.x[ejsBilliardPhysics.this.collision1];
                double d2 = ejsBilliardPhysics.this.y[ejsBilliardPhysics.this.collision2] - ejsBilliardPhysics.this.y[ejsBilliardPhysics.this.collision1];
                double d3 = Math.sqrt(d * d + d2 * d2);
                double d4 = d / d3;
                double d5 = d2 / d3;
                double d6 = -d5;
                double d7 = d4;
                double d8 = ejsBilliardPhysics.this.vx[ejsBilliardPhysics.this.collision1] * d4 + ejsBilliardPhysics.this.vy[ejsBilliardPhysics.this.collision1] * d5;
                double d9 = ejsBilliardPhysics.this.vx[ejsBilliardPhysics.this.collision1] * d6 + ejsBilliardPhysics.this.vy[ejsBilliardPhysics.this.collision1] * d7;
                double d10 = ejsBilliardPhysics.this.vx[ejsBilliardPhysics.this.collision2] * d4 + ejsBilliardPhysics.this.vy[ejsBilliardPhysics.this.collision2] * d5;
                double d11 = ejsBilliardPhysics.this.vx[ejsBilliardPhysics.this.collision2] * d6 + ejsBilliardPhysics.this.vy[ejsBilliardPhysics.this.collision2] * d7;
                double d12 = (2.0 * ejsBilliardPhysics.this.mass[ejsBilliardPhysics.this.collision2] * d10 + (ejsBilliardPhysics.this.mass[ejsBilliardPhysics.this.collision1] - ejsBilliardPhysics.this.mass[ejsBilliardPhysics.this.collision2]) * d8) / (ejsBilliardPhysics.this.mass[ejsBilliardPhysics.this.collision1] + ejsBilliardPhysics.this.mass[ejsBilliardPhysics.this.collision2]);
                double d13 = (2.0 * ejsBilliardPhysics.this.mass[ejsBilliardPhysics.this.collision1] * d8 + (ejsBilliardPhysics.this.mass[ejsBilliardPhysics.this.collision2] - ejsBilliardPhysics.this.mass[ejsBilliardPhysics.this.collision1]) * d10) / (ejsBilliardPhysics.this.mass[ejsBilliardPhysics.this.collision1] + ejsBilliardPhysics.this.mass[ejsBilliardPhysics.this.collision2]);
                ejsBilliardPhysics.this.vx[ejsBilliardPhysics.this.collision1] = d12 * d4 + d9 * d6;
                ejsBilliardPhysics.this.vy[ejsBilliardPhysics.this.collision1] = d12 * d5 + d9 * d7;
                ejsBilliardPhysics.this.vx[ejsBilliardPhysics.this.collision2] = d13 * d4 + d11 * d6;
                ejsBilliardPhysics.this.vy[ejsBilliardPhysics.this.collision2] = d13 * d5 + d11 * d7;
                return true;
            }
        }

        private class _ODE_evolution1_Event1
        implements StateEvent {
            private _ODE_evolution1_Event1() {
            }

            @Override
            public int getTypeOfEvent() {
                return 0;
            }

            @Override
            public int getRootFindingMethod() {
                return 0;
            }

            @Override
            public int getMaxIterations() {
                return 100;
            }

            public String toString() {
                return "bouncing";
            }

            @Override
            public double getTolerance() {
                return ejsBilliardPhysics.this.TOLERANCE;
            }

            @Override
            public double evaluate(double[] dArray) {
                int n;
                int n2 = 0;
                double[] dArray2 = _ODE_evolution1.this._x;
                System.arraycopy(dArray, n2, dArray2, 0, dArray2.length);
                double[] dArray3 = _ODE_evolution1.this._y;
                System.arraycopy(dArray, n2 += dArray2.length, dArray3, 0, dArray3.length);
                double[] dArray4 = _ODE_evolution1.this._vx;
                System.arraycopy(dArray, n2 += dArray3.length, dArray4, 0, dArray4.length);
                double[] dArray5 = _ODE_evolution1.this._vy;
                System.arraycopy(dArray, n2 += dArray4.length, dArray5, 0, dArray5.length);
                n2 += dArray5.length;
                double d = dArray[n2++];
                double d2 = ejsBilliardPhysics.this.TOLERANCE;
                if (ejsBilliardPhysics.this.cueBreak) {
                    n = ejsBilliardPhysics.this.n - 1;
                    ejsBilliardPhysics.this.cueBreak = false;
                } else {
                    n = ejsBilliardPhysics.this.n;
                }
                for (int i = 0; i < ejsBilliardPhysics.this.n; ++i) {
                    double d3 = ejsBilliardPhysics.this.diameter[i] / 2.0;
                    double d4 = dArray3[i] - ejsBilliardPhysics.this.ymin - d3;
                    if (dArray5[i] < 0.0 && d4 < d2) {
                        ejsBilliardPhysics.this.horizontalRebound = false;
                        ejsBilliardPhysics.this.ballRebounded = i;
                        d2 = d4;
                    }
                    d4 = ejsBilliardPhysics.this.ymax - d3 - dArray3[i];
                    if (dArray5[i] > 0.0 && d4 < d2) {
                        ejsBilliardPhysics.this.horizontalRebound = false;
                        ejsBilliardPhysics.this.ballRebounded = i;
                        d2 = d4;
                    }
                    d4 = dArray2[i] - ejsBilliardPhysics.this.xmin - d3;
                    if (dArray4[i] < 0.0 && d4 < d2) {
                        ejsBilliardPhysics.this.horizontalRebound = true;
                        ejsBilliardPhysics.this.ballRebounded = i;
                        d2 = d4;
                    }
                    d4 = ejsBilliardPhysics.this.xmax - d3 - dArray2[i];
                    if (!(dArray4[i] > 0.0) || !(d4 < d2)) continue;
                    ejsBilliardPhysics.this.horizontalRebound = true;
                    ejsBilliardPhysics.this.ballRebounded = i;
                    d2 = d4;
                }
                return d2;
            }

            @Override
            public boolean action() {
                int n = 0;
                System.arraycopy(_ODE_evolution1.this.__state, n, ejsBilliardPhysics.this.x, 0, ejsBilliardPhysics.this.x.length);
                System.arraycopy(_ODE_evolution1.this.__state, n += ejsBilliardPhysics.this.x.length, ejsBilliardPhysics.this.y, 0, ejsBilliardPhysics.this.y.length);
                System.arraycopy(_ODE_evolution1.this.__state, n += ejsBilliardPhysics.this.y.length, ejsBilliardPhysics.this.vx, 0, ejsBilliardPhysics.this.vx.length);
                System.arraycopy(_ODE_evolution1.this.__state, n += ejsBilliardPhysics.this.vx.length, ejsBilliardPhysics.this.vy, 0, ejsBilliardPhysics.this.vy.length);
                n += ejsBilliardPhysics.this.vy.length;
                ejsBilliardPhysics.this.t = _ODE_evolution1.this.__state[n++];
                boolean bl = this.userDefinedAction();
                int n2 = 0;
                System.arraycopy(ejsBilliardPhysics.this.x, 0, _ODE_evolution1.this.__state, n2, ejsBilliardPhysics.this.x.length);
                System.arraycopy(ejsBilliardPhysics.this.y, 0, _ODE_evolution1.this.__state, n2 += ejsBilliardPhysics.this.x.length, ejsBilliardPhysics.this.y.length);
                System.arraycopy(ejsBilliardPhysics.this.vx, 0, _ODE_evolution1.this.__state, n2 += ejsBilliardPhysics.this.y.length, ejsBilliardPhysics.this.vx.length);
                System.arraycopy(ejsBilliardPhysics.this.vy, 0, _ODE_evolution1.this.__state, n2 += ejsBilliardPhysics.this.vx.length, ejsBilliardPhysics.this.vy.length);
                n2 += ejsBilliardPhysics.this.vy.length;
                ((_ODE_evolution1)_ODE_evolution1.this).__state[n2++] = ejsBilliardPhysics.this.t;
                return bl;
            }

            private boolean userDefinedAction() {
                if (ejsBilliardPhysics.this.horizontalRebound) {
                    ejsBilliardPhysics.this.vx[ejsBilliardPhysics.this.ballRebounded] = -ejsBilliardPhysics.this.k * ejsBilliardPhysics.this.vx[ejsBilliardPhysics.this.ballRebounded];
                } else {
                    ejsBilliardPhysics.this.vy[ejsBilliardPhysics.this.ballRebounded] = -ejsBilliardPhysics.this.k * ejsBilliardPhysics.this.vy[ejsBilliardPhysics.this.ballRebounded];
                }
                return true;
            }
        }
    }
}

