/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ode_interpolation.ConstantConditionData;
import org.opensourcephysics.numerics.ode_interpolation.InitialConditionData;
import org.opensourcephysics.numerics.ode_interpolation.IntervalData;
import org.opensourcephysics.numerics.ode_solvers.DelayDifferentialEquation;

public class StateHistory {
    private LinkedList<IntervalData> mIntervalList = new LinkedList();
    private boolean mForwards = true;
    private IntervalData mLastResourceInterval = null;
    private double mMinimumLength = 0.0;
    private double mUserLength = 0.0;
    private double mActualLength = 0.0;

    public StateHistory(ODE oDE) {
        if (oDE instanceof DelayDifferentialEquation) {
            DelayDifferentialEquation delayDifferentialEquation = (DelayDifferentialEquation)oDE;
            this.mLastResourceInterval = new InitialConditionData(delayDifferentialEquation);
            delayDifferentialEquation.setStateMemory(this);
        } else {
            this.mLastResourceInterval = new ConstantConditionData(oDE.getState());
        }
    }

    public void setLength(double d) {
        this.mUserLength = Math.abs(d);
        this.mActualLength = Math.max(this.mMinimumLength, this.mUserLength);
    }

    public void setMinimumLength(double d) {
        this.mMinimumLength = Math.abs(d);
        this.mActualLength = Math.max(this.mMinimumLength, this.mUserLength);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void addIntervalData(IntervalData var1_1) {
        block6: {
            v0 = this.mForwards = var1_1.getLeft() <= var1_1.getRight();
            if (this.mIntervalList.isEmpty()) break block6;
            var2_2 /* !! */  = this.mIntervalList.getLast();
            if (!this.mForwards) ** GOTO lbl16
            while (var2_2 /* !! */  != null && var2_2 /* !! */ .getLeft() >= var1_1.getLeft()) {
                this.mIntervalList.removeLast();
                var2_2 /* !! */  = this.mIntervalList.isEmpty() != false ? null : this.mIntervalList.getLast();
            }
            if (var2_2 /* !! */  == null || !(var1_1.getLeft() < var2_2 /* !! */ .getRight())) break block6;
            var2_2 /* !! */ .setRight(var1_1.getLeft());
            break block6;
lbl-1000:
            // 1 sources

            {
                this.mIntervalList.removeLast();
                var2_2 /* !! */  = this.mIntervalList.isEmpty() != false ? null : this.mIntervalList.getLast();
lbl16:
                // 2 sources

                ** while (var2_2 /* !! */  != null && var2_2 /* !! */ .getLeft() <= var1_1.getLeft())
            }
lbl17:
            // 1 sources

            if (var2_2 /* !! */  != null && var1_1.getLeft() > var2_2 /* !! */ .getRight()) {
                var2_2 /* !! */ .setRight(var1_1.getLeft());
            }
        }
        this.mIntervalList.addLast(var1_1);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("History has now " + this.mIntervalList.size() + " intervals");
        ListIterator listIterator = this.mIntervalList.listIterator();
        while (listIterator.hasNext()) {
            IntervalData intervalData = (IntervalData)listIterator.next();
            stringBuffer.append("Interval : [" + intervalData.getLeft() + " , " + intervalData.getRight() + ")");
        }
        return stringBuffer.toString();
    }

    public void clearAll() {
        this.mIntervalList.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clean(double d) {
        if (Double.isInfinite(this.mActualLength)) {
            return;
        }
        if (this.mActualLength == 0.0) {
            this.clearAll();
            return;
        }
        d = this.mForwards ? d - this.mActualLength : d + this.mActualLength;
        LinkedList<IntervalData> linkedList = this.mIntervalList;
        synchronized (linkedList) {
            ArrayList<IntervalData> arrayList = new ArrayList<IntervalData>();
            if (this.mForwards) {
                d -= this.mActualLength;
                ListIterator listIterator = this.mIntervalList.listIterator();
                while (listIterator.hasNext()) {
                    IntervalData intervalData = (IntervalData)listIterator.next();
                    if (!(intervalData.getRight() > d)) {
                        arrayList.add(intervalData);
                        continue;
                    }
                    break;
                }
            } else {
                d += this.mActualLength;
                ListIterator listIterator = this.mIntervalList.listIterator();
                while (listIterator.hasNext()) {
                    IntervalData intervalData = (IntervalData)listIterator.next();
                    if (!(intervalData.getRight() < d)) {
                        arrayList.add(intervalData);
                        continue;
                    }
                    break;
                }
            }
            this.mIntervalList.removeAll(arrayList);
        }
    }

    private IntervalData findInterval(double d) {
        if (this.mForwards) {
            Iterator<IntervalData> iterator = this.mIntervalList.descendingIterator();
            while (iterator.hasNext()) {
                IntervalData intervalData = iterator.next();
                if (!(intervalData.getLeft() <= d)) continue;
                return intervalData;
            }
        } else {
            Iterator<IntervalData> iterator = this.mIntervalList.descendingIterator();
            while (iterator.hasNext()) {
                IntervalData intervalData = iterator.next();
                if (!(intervalData.getLeft() >= d)) continue;
                return intervalData;
            }
        }
        return this.mLastResourceInterval;
    }

    public double[] interpolate(double d, double[] dArray) {
        IntervalData intervalData = this.findInterval(d);
        return intervalData.interpolate(d, dArray);
    }

    public double[] interpolate(double d, double[] dArray, int n, int n2) {
        IntervalData intervalData = this.findInterval(d);
        return intervalData.interpolate(d, dArray, n, n2);
    }

    public double interpolate(double d, int n) {
        IntervalData intervalData = this.findInterval(d);
        return intervalData.interpolate(d, n);
    }
}

