/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ode_interpolation.IntervalData;
import org.opensourcephysics.numerics.ode_solvers.DelayDifferentialEquation;

public class InitialConditionData
extends IntervalData {
    private DelayDifferentialEquation mDDE;
    private double[] mState;

    public InitialConditionData(DelayDifferentialEquation delayDifferentialEquation) {
        super(Double.NaN, Double.NaN);
        double[] dArray = delayDifferentialEquation.getState();
        this.mDDE = delayDifferentialEquation;
        this.mState = new double[dArray.length];
    }

    @Override
    public double interpolate(double d, int n) {
        this.mDDE.getInitialCondition(d, this.mState);
        return this.mState[n];
    }

    @Override
    public double[] interpolate(double d, double[] dArray, int n, int n2) {
        this.mDDE.getInitialCondition(d, this.mState);
        System.arraycopy(this.mState, n, dArray, 0, n2);
        return dArray;
    }
}

