/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.numerics.ode_interpolation;

import org.opensourcephysics.numerics.ODE;
import org.opensourcephysics.numerics.ode_interpolation.BootstrapIntervalData;

public class Bootstrap2IntervalData
extends BootstrapIntervalData {
    private static final double BETA1 = 0.7;
    private static final double BETA2 = 0.85;
    private static final double bt2_den = 0.009639000000000005;
    private static final double bt2_cf11 = -0.06999999999999974;
    private static final double bt2_cf01 = 0.33000000000000007;
    private static final double bt2_cys1 = -1.26;
    private static final double bt2_cf12 = -0.46749999999999986;
    private static final double bt2_cf02 = 0.23250000000000015;
    private static final double bt2_cys2 = -0.765;
    private static final double bt2_m44 = -0.16799999999999982;
    private static final double bt2_m54 = -0.17849999999999996;
    private static final double bt2_m45 = -0.4095;
    private static final double bt2_m55 = -0.4924687499999998;
    private double[] state_bt2 = null;
    private double[] rate_bt21;
    private double[] rate_bt22;
    private double[] bt2_c2;
    private double[] bt2_c3;
    private double[] bt2_c4;
    private double[] bt2_c5;

    public Bootstrap2IntervalData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, ODE oDE) {
        super(dArray, dArray2, dArray3, dArray4, oDE);
        this.prepareSecondBootstrap();
    }

    @Override
    public double interpolate(double d, int n) {
        double d2 = (d - this.getLeft()) / this.mDeltaTime;
        return this.mLeftState[n] + d2 * (this.mDeltaTime * this.mLeftRate[n] + d2 * (this.bt2_c2[n] + d2 * (this.bt2_c3[n] + d2 * (this.bt2_c4[n] + d2 * this.bt2_c5[n]))));
    }

    @Override
    public double[] interpolate(double d, double[] dArray, int n, int n2) {
        this.bootstrap2((d - this.getLeft()) / this.mDeltaTime, dArray, n, n2);
        return dArray;
    }

    protected void bootstrap2(double d, double[] dArray, int n, int n2) {
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            dArray[n4] = this.mLeftState[n3] + d * (this.mDeltaTime * this.mLeftRate[n3] + d * (this.bt2_c2[n3] + d * (this.bt2_c3[n3] + d * (this.bt2_c4[n3] + d * this.bt2_c5[n3]))));
            ++n3;
            ++n4;
        }
    }

    private void prepareSecondBootstrap() {
        int n = this.mTimeIndex + 1;
        if (this.state_bt2 == null) {
            this.state_bt2 = new double[n];
            this.rate_bt21 = new double[n];
            this.rate_bt22 = new double[n];
            this.bt2_c2 = new double[n];
            this.bt2_c3 = new double[n];
            this.bt2_c4 = new double[n];
            this.bt2_c5 = new double[n];
        }
        super.bootstrap1(0.7, this.state_bt2, 0, this.mTimeIndex);
        this.state_bt2[this.mTimeIndex] = this.getLeft() + 0.7 * this.mDeltaTime;
        this.mODE.getRate(this.state_bt2, this.rate_bt21);
        super.bootstrap1(0.85, this.state_bt2, 0, this.mTimeIndex);
        this.state_bt2[this.mTimeIndex] = this.getLeft() + 0.85 * this.mDeltaTime;
        this.mODE.getRate(this.state_bt2, this.rate_bt22);
        int n2 = 0;
        while (n2 < n) {
            double d = this.mRightState[n2] - this.mLeftState[n2];
            double d2 = this.mDeltaTime * this.mLeftRate[n2];
            double d3 = this.mDeltaTime * this.mRightRate[n2];
            double d4 = this.mDeltaTime * this.rate_bt21[n2] + -0.06999999999999974 * d3 + 0.33000000000000007 * d2 + -1.26 * d;
            double d5 = this.mDeltaTime * this.rate_bt22[n2] + -0.46749999999999986 * d3 + 0.23250000000000015 * d2 + -0.765 * d;
            double d6 = (-0.4924687499999998 * d4 - -0.4095 * d5) / 0.009639000000000005;
            double d7 = (-0.16799999999999982 * d5 - -0.17849999999999996 * d4) / 0.009639000000000005;
            double d8 = d3 + d2 - 2.0 * d - 2.0 * d6 - 3.0 * d7;
            this.bt2_c5[n2] = d7;
            this.bt2_c4[n2] = d6;
            this.bt2_c3[n2] = d8;
            this.bt2_c2[n2] = d - d2 - d8 - d6 - d7;
            ++n2;
        }
    }
}

