var _isEPub = false;
var _isApp = false;

var __base64Images = [];
__base64Images["./VernierCaliper/s200_fu-kwun.hwang.png"]="data:image/png;base64,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";
__base64Images["./VernierCaliper/bottomverniertop.png"]="data:image/png;base64,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";
__base64Images["./VernierCaliper/fu-kwun.jpg"]="data:image/jpeg;base64,/9j/4AAQSkZJRgABAQAAAQABAAD/2wCEAAkGBwgHBgkIBwgKCgkLDRYPDQwMDRsUFRAWIB0iIiAdHx8kKDQsJCYxJx8fLT0tMTU3Ojo6Iys/RD84QzQ5OjcBCgoKDQwNGg8PGjclHyU3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3Nzc3N//AABEIAFoAWgMBIgACEQEDEQH/xAAbAAACAwEBAQAAAAAAAAAAAAAEBgIFBwMBAP/EADgQAAIBAwMCBAIIAwkAAAAAAAECAwAEEQUSITFBBhNRYXGBByIyQpGxwfCh0fEUFiMzNENScuH/xAAZAQACAwEAAAAAAAAAAAAAAAADBAECBQD/xAAeEQACAgMBAAMAAAAAAAAAAAAAAQIRAxIhMSIyQf/aAAwDAQACEQMRAD8A2K5mEEDyt0UZx6nsKyLxQLi9mkd9zM7nJPIyfQfp2xWp6wyi1w7YBOT8KzPXLxJ7lY7cgRDrxgBfWh5iY+lRa+GhcRKkm7B6g9BV3p/g7TIsGSEOffpVhZENGjeo9KtbY89KRXo+kkiFtpNpAgEUCqB2oryETGEUfKikIIHArxxx0otEWDnaBgqv4VXXQABJA+FWLrQF0h5FCkXjwWL6yQ3yTRoAT3z0NOnge4Yb4Wbhh9n0I/rSpq0ht7ZpApO054ovwx4js5p1KSBJQcHtn2NEwuhbOumnr0r2ucEizQrIhBVhnIrpT9iwp+OLtbax+scZ4wOpFZaLqOa7SJG3Fm3HBPy/f7Og/SraTS6RHcW4B2NtbjOB6/wrN/BsIa+lluhzG20AEEg+69QPfFLZn0vjVyHq1ASNN/HHOasraaLjEiE/GqORluyVj3IF5bcpVs/Aj05+deTQaYISLu7gibGQZXRc/jS0R7iQ4JIqjJIx8ajJOvtSPaCSJt1rfGSInIKuGBo+TVkii2uZGkztbanAPxJq+5yiX73dug3SzKi+pNBS6pYS58iVZcHnZzVNIunzx+ZenIwMKSSSfhQGn6v4ee4kgtRIjR53N5bKBjjk/Go9IfGWWqKl5ayLEeTWeWkksGpG3nADg43jg/OtDMsYTdFl06nBzx7Ul6ta+fr0bRAo8qgvG42lRnru6du1Vhxg8sdlw3jQEeLSLNJCS3lLnNWNBaTcw3VjDJBIJFCBSw9QPSjsVoxfxQo+PonfSLe3dtplvHZRLJ50u1w4yuAO9Inhy2iGp6qPISI+av1U6Kcc4+ea1zU7GPULRoJfXKn/AIt2NZ3Fp5sNcuiwK+YAGHuP2aWzxe1jeFxca/UFi0BSQZILdx1PGKBm8MafJCEmhEoDbwXJLbvXPWrmHaWwTx71YiO3CAn86DFBmLSaTCJTIqBWI5KjHbFGwW4GnTIcneScnrRNyyO22LoOtdYGiEPLLz61GvSy8Ke2soxCm5AzY+92I/pXSPTLNZJXSBVaU5kIXlvjRKna+QA0ZPY0dGISPT51yRzQHHZQ28REUSKp7AUoa9Cv94bVXXKS20iOPYEU83ciCLApS1G1lv8AWrRIBlzG0Y9izD+RqGiYpXbG76KrSa28OkyE7HlPlgjtTrQunWkdjYwWsQ+pCgQfIUVmtCEWopGblnvNyOVLHiu2RJorkLgsCrH1pnqEsSSoUkQMp7EVbJHaNHY56uzOjMQaIFwzLjJrhqds1ndyQtn6jYGe47UHJcNChdUMhA4UdTWa7i6ZoJpqzrq9td3Vp5Vhdm1dvtuOuPbiqsaBqQj2RavIQ32mkXLfI0U2pXCRhpbC4yfuoA361zGvXyoc6Jd5+7/6elWTtFlFs90zRruzJ36pLMhIO2QZxVz5hjJ5yKpU1a8k4fSbiNj3MiY/OiIbqSRT5sRjb0JBqsnRPVwNmuNwxVx4S0xnvf7dNHhFXEbN3Pt/Gl2JHuJ0iiBLOcAVplrCLa2igXkRqFz64ouCO0rYvnyarVBAqdQWp08InGvK9yKgX54qWcLPjGLdJCyqN207j6+lKLkhtvenTxC+26gU/eRvzpfvrASDfH1rNz/djmJ1FFfksOvNcpI70n6k7qvoOles7W5xKpGO9eNqsQXGcn0oSbQxsff4nG9ix+FRyTURdGb7CVKMMTluKghscvBenQrbm9bJmLFRn7tNIpU8EXm6K5gHPluCfmKa15rRw1ohDLezJDipZrwV9ijAwSRj0FSAwgFR/wBw/wDWuh6VzIF/xPAWW2uAceSx3D1U8fyNVw5HIph1YA2UuR9w0u23+QnwpLMvlY1hfKAruBZAQQPwqmk09fMzjNMM/egZAN3Sl5IOmCJCEXAFeONoJboBkk9qIPWhdR/0je9VObG3wZZGCzkuGGGnbd0xxjj9KZ19qEswBbxgAAbRwKLXpWnjjrFIRm7Z0VqlmuYqVEKn/9k=";
__base64Images["./VernierCaliper/Screen Shot 2016-09-28 at 11.33.51 AM (2) 2.png"]="data:image/png;base64,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";
__base64Images["./VernierCaliper/Screen Shot 2017-02-24 at 8.40.53 AM (2).png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/pause.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMyWLrcPEEABaWrs+ArrO7ZMwzLSF5RtjXr6rxwjAZqQKOeW6YUz/q6Xs7XABgXxpDMkQAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["/org/opensourcephysics/resources/controls/images/play.gif"]="data:image/gif;base64,R0lGODlhEAAQAKL/AP///5mZzGZmmTMzZgAAAMDAwAAAAAAAACH5BAEAAAUALAAAAAAQABAAQAMsWLrcPkHIAYBTUIzbBrXcMghhF01l9pUFyBbbiwUxm2n2iXL3ytMVW1BWSgAAIf5PQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgA7";
__base64Images["./VernierCaliper/Metallic-windows-backgrounds-swirls-pattern.png"]="data:image/png;base64,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";
__base64Images["./VernierCaliper/VernierCaliper.PNG"]="data:image/png;base64,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";
__base64Images["./VernierCaliper/verniervernier.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/window.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAP///8zM/7S02rSz2rO02rOz2rOz2bGx17Cw1a+v1a2t06ys0qqq0KenzaOkyaGgx52cw5qawZqawJqav5mZv5iYvpaWvJOTupOTuZKSuJGRt4+PtY+OtYyMs4yMsomJr4eGrIaGrISEqoCApn19o3p6oHR0mnNzmWZmmTMzZgAAAMDAwAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAPJbhxNsRBwAAAAAAAAAAhIa0PKcBRIbtAAAygAAAAAAAAAAAhIbdPKPsvKiihNsJBIeYAACCCQUMCOFkPJbhxNsNBwAAAAAAAAAAhIbIPKcBRIcBAAAygAAAAAAAAAAAhIbxPKPsvKiihNslBIesAACCCQUMCOFkBxzTCQUMAAAAAAAAswAyv38AOyYNAAAZQAAygAAygAAAAAAAP38ABIc7ggAyhIcJBAAAP38ygAAAwAAAAAAAAAAAEpgQAAAygAAAAAAABNslBIbLAAAABIl3OyYNAAAABIesBIeNPKezyQUOBIcJAAAyiQUMPKdjAAACAAAUUpgQMsAAMsAAAAAogAAUQAAAAAAAAAAURIc/AAAUcsAAEpgQBIc/PKK8PKLLBNrrMsAAAAAAMsEBMsBSAAAAEpbOMsAAAAAogAAUVBTUFBTUExn2AAAogAACMsAAAAAABIdWPKGQMsBMPKGHxNqCAAAAMsAAEpbQEpgSAAAAkxn2GEAaHMAbwAAAFBTUMslsMslsMsAAMslsMsBSAAACMslsAAAAgAAAgACQQABQwAAohIdAAAAAwAAAwABQwABwQABwQCwAAAAwwAAIjphWDphWAAAEQAAAAABQ8smDAABANtFiBIfbAAACUZJRxBhOdUAEP//AP/MzLTatLSz2tqzs7HZs7Cw19Wvr6zTraqq0s2np6HJpJydx8GamprAmpmZv76YmCH5BAEAACsAIf5QQ29weXJpZ2h0IDIwMDAgYnkgU3VuIE1pY3Jvc3lzdGVtcywgSW5jLiBBbGwgUmlnaHRzIFJlc2VydmVkLg0KSkxGIEdSIFZlciAxLjANCgAALAAAAAAQABAAAAhEAFcIHEiwoMGDBj8pXMjwU8FPeiJKlAiRYMWDFwVmfKjHYkeMHzWG5OgR4caNJQeiVDlypUiLDRuOXDGxZkSEOHMeDAgAOw==";
__base64Images["./VernierCaliper/lookangphoto.png"]="data:image/png;base64,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";
__base64Images["./VernierCaliper/verniercaliperss.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/close.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///////wAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAh3ALEJFMhqBQAAK1gNXIiNFQArgVixCmQFgMKFVhIybLjCysCCGxdqxKaRFq2FJhsCwEZRoMmT2F4KXBFoZMyXKQXWtIhS5seDF136JIgwKM6cLGl6vAnTJ02SCpHeVEnQJsOCQTMG/djxKsKIEw1uXVjwoFVsAQEAOw==";
__base64Images["./VernierCaliper/topvernier.png"]="data:image/png;base64,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";
__base64Images["./VernierCaliper/verniermain.png"]="data:image/png;base64,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";
__base64Images["./VernierCaliper/Vernier_icon.png"]="data:image/png;base64,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";
__base64Images["./VernierCaliper/2014-11-27_2315s.png"]="data:image/png;base64,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";
__base64Images["/org/opensourcephysics/resources/controls/images/reset.gif"]="data:image/gif;base64,R0lGODlhEAAQAIcAAAAAAAAAMwAAZgAAmQAAzAAA/wAzAAAzMwAzZgAzmQAzzAAz/wBmAABmMwBmZgBmmQBmzABm/wCZAACZMwCZZgCZmQCZzACZ/wDMAADMMwDMZgDMmQDMzADM/wD/AAD/MwD/ZgD/mQD/zAD//zMAADMAMzMAZjMAmTMAzDMA/zMzADMzMzMzZjMzmTMzzDMz/zNmADNmMzNmZjNmmTNmzDNm/zOZADOZMzOZZjOZmTOZzDOZ/zPMADPMMzPMZjPMmTPMzDPM/zP/ADP/MzP/ZjP/mTP/zDP//2YAAGYAM2YAZmYAmWYAzGYA/2YzAGYzM2YzZmYzmWYzzGYz/2ZmAGZmM2ZmZmZmmWZmzGZm/2aZAGaZM2aZZmaZmWaZzGaZ/2bMAGbMM2bMZmbMmWbMzGbM/2b/AGb/M2b/Zmb/mWb/zGb//5kAAJkAM5kAZpkAmZkAzJkA/5kzAJkzM5kzZpkzmZkzzJkz/5lmAJlmM5lmZplmmZlmzJlm/5mZAJmZM5mZZpmZmZmZzJmZ/5nMAJnMM5nMZpnMmZnMzJnM/5n/AJn/M5n/Zpn/mZn/zJn//8wAAMwAM8wAZswAmcwAzMwA/8wzAMwzM8wzZswzmcwzzMwz/8xmAMxmM8xmZsxmmcxmzMxm/8yZAMyZM8yZZsyZmcyZzMyZ/8zMAMzMM8zMZszMmczMzMzM/8z/AMz/M8z/Zsz/mcz/zMz///8AAP8AM/8AZv8Amf8AzP8A//8zAP8zM/8zZv8zmf8zzP8z//9mAP9mM/9mZv9mmf9mzP9m//+ZAP+ZM/+ZZv+Zmf+ZzP+Z///MAP/MM//MZv/Mmf/MzP/M////AP//M///Zv//mf//zP///87OzgAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAACH5BAMAANgALAAAAAAQABAAAAheALEJHMhioMGDAq8URIiQhaCFDAleeRhR4kQWGDMeZHGl48OOICEK5HgxI0aFGy9eW7nSoUhsLq8ZjLmRhUyCD2/O1AkzJ0OeNE0KPWlzJMijIXUOFcoTG8unLA0GBAA7";
